/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.console;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ConsoleSaveAction {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/console/ConsoleSaveAction.java";
    public static final String ALL_TEXT_FILES = "*.txt";
    public static final String TEXT_FILE_EXTENSION = ".txt";
    public static final String DEFAULT_SAVE_FILE_NAME = "print.txt";
    private Console console;

    public ConsoleSaveAction(Console aConsole) {
        this.console = aConsole;
    }

    public boolean showDialog(Trace t, Shell shell) {
        boolean result = false;
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Command Dialog");
        String textFilesName = msgFile.getMessage(t, "UI.CMD.TextFilesName.Text");
        String dialogTitle = msgFile.getMessage(t, "UI.CMD.SaveFileName.Title");
        String overwriteTitle = msgFile.getMessage(t, "UI.CMD.OverwriteFileTitle.Text");
        String overwriteDesc = msgFile.getMessage(t, "UI.CMD.OverwriteFileDesc.Text");
        FileDialog saveDialog = new FileDialog(shell, 8192);
        saveDialog.setText(dialogTitle);
        saveDialog.setFileName(DEFAULT_SAVE_FILE_NAME);
        saveDialog.setFilterExtensions(new String[]{ALL_TEXT_FILES});
        saveDialog.setFilterNames(new String[]{textFilesName});
        String path = saveDialog.open();
        String name = saveDialog.getFileName();
        if (path != null && name.length() > 0) {
            File file;
            int index = name.lastIndexOf(TEXT_FILE_EXTENSION);
            if (index < 0 || index != name.length() - 4) {
                name = String.valueOf(name) + TEXT_FILE_EXTENSION;
            }
            if ((file = new File(saveDialog.getFilterPath(), name)).exists()) {
                MessageBox box = new MessageBox(shell, 200);
                box.setText(overwriteTitle);
                String overwriteDesc2 = Message.format((String)overwriteDesc, (String)file.getName());
                box.setMessage(overwriteDesc2);
                if (box.open() == 64) {
                    result = this.save(t, shell, file);
                }
            } else {
                result = this.save(t, shell, file);
            }
        }
        return result;
    }

    private boolean save(Trace t, Shell shell, File file) {
        boolean result = false;
        if (file == null) {
            result = this.showDialog(t, shell);
        } else {
            Cursor waitCursor = new Cursor((Device)shell.getDisplay(), 1);
            shell.setCursor(waitCursor);
            FileWriter fileWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(file.getAbsolutePath(), false);
                    fileWriter.write(this.console.toString());
                }
                catch (FileNotFoundException e) {
                    t.FFST(67, "ConsoleSaveAction.save", 10, 0, 0, 0, "File not found", file.getName(), e.toString());
                    result = false;
                    shell.setCursor(null);
                    waitCursor.dispose();
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (IOException e2) {
                            t.FFST(67, "ConsoleSaveAction.save", 30, 0, 0, 0, "IOError close", file.getName(), e2.toString());
                            result = false;
                        }
                    }
                }
                catch (IOException e) {
                    t.FFST(67, "ConsoleSaveAction.save", 20, 0, 0, 0, "IOError write", file.getName(), e.toString());
                    result = false;
                    shell.setCursor(null);
                    waitCursor.dispose();
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (IOException e3) {
                            t.FFST(67, "ConsoleSaveAction.save", 30, 0, 0, 0, "IOError close", file.getName(), e3.toString());
                            result = false;
                        }
                    }
                }
            }
            finally {
                shell.setCursor(null);
                waitCursor.dispose();
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        t.FFST(67, "ConsoleSaveAction.save", 30, 0, 0, 0, "IOError close", file.getName(), e.toString());
                        result = false;
                    }
                }
            }
        }
        return result;
    }
}

