/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.console;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.Console;
import java.io.File;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ConsolePrintAction {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/console/ConsolePrintAction.java";
    public static final String POSTSCRIPT_FILES = "*.ps";
    public static final String POSTSCRIPT_FILE_EXTENSION = ".ps";
    public static final String DEFAULT_PRINT_FILE_NAME = "print.ps";
    private static final String THREAD_NAME = "Printing";
    private Shell shell;
    private Printer printer;
    private Console console;

    public ConsolePrintAction(Shell aShell, Console aConsole) {
        this.shell = aShell;
        this.console = aConsole;
    }

    public boolean showDialog(Trace t) {
        boolean result = false;
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Command Dialog");
        String textFilesName = msgFile.getMessage(t, "UI.CMD.TextFilesName.Text");
        String dialogTitle = msgFile.getMessage(t, "UI.CMD.PrintFileName.Title");
        String overwriteTitle = msgFile.getMessage(t, "UI.CMD.OverwriteFileTitle.Text");
        String overwriteDesc = msgFile.getMessage(t, "UI.CMD.OverwriteFileDesc.Text");
        PrintDialog dialog = new PrintDialog(this.shell, 0);
        PrinterData data = dialog.open();
        if (data != null) {
            if (data.printToFile) {
                FileDialog saveDialog = new FileDialog(this.shell, 8192);
                saveDialog.setText(dialogTitle);
                saveDialog.setFileName(DEFAULT_PRINT_FILE_NAME);
                saveDialog.setFilterExtensions(new String[]{POSTSCRIPT_FILES});
                saveDialog.setFilterNames(new String[]{textFilesName});
                saveDialog.open();
                String name = saveDialog.getFileName();
                if (name.length() > 0) {
                    File file;
                    int index = name.lastIndexOf(POSTSCRIPT_FILE_EXTENSION);
                    if (index < 0 || index != name.length() - 3) {
                        name = String.valueOf(name) + POSTSCRIPT_FILE_EXTENSION;
                    }
                    if ((file = new File(saveDialog.getFilterPath(), name)).exists()) {
                        MessageBox box = new MessageBox(this.shell, 200);
                        box.setText(overwriteTitle);
                        String overwriteDesc2 = Message.format((String)overwriteDesc, (String)file.getName());
                        box.setMessage(overwriteDesc2);
                        if (box.open() == 64) {
                            data.fileName = file.toString();
                            result = this.startPrintJob(t, data);
                        }
                    } else {
                        data.fileName = file.toString();
                        result = this.startPrintJob(t, data);
                    }
                }
            } else {
                result = this.startPrintJob(t, data);
            }
        }
        return result;
    }

    private boolean startPrintJob(Trace t, PrinterData data) {
        this.printer = new Printer(data);
        Thread printingThread = new Thread(THREAD_NAME){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                ConsolePrintAction.this.print(tr);
                ConsolePrintAction.this.printer.dispose();
            }
        };
        printingThread.start();
        return true;
    }

    private void print(Trace t) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Command Dialog");
        String printJobName = msgFile.getMessage(t, "UI.CMD.PrintJobName.Text");
        boolean result = this.printer.startJob(printJobName);
        if (result) {
            Rectangle clientArea = this.printer.getClientArea();
            Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
            Point dpi = this.printer.getDPI();
            int leftMargin = dpi.x + trim.x;
            int rightMargin = clientArea.width - dpi.x + trim.x + trim.width;
            int topMargin = dpi.y + trim.y;
            int bottomMargin = clientArea.height - dpi.y + trim.y + trim.height;
            GC gc = new GC((Drawable)this.printer);
            this.console.draw(t, gc, this.printer, leftMargin, rightMargin, topMargin, bottomMargin);
            this.printer.endJob();
            gc.dispose();
        } else {
            t.data(67, "ConsolePrintAction.print", "failed to start print job");
        }
    }
}

