/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.console;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.AbstractConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.Console;
import com.ibm.mq.explorer.ui.internal.console.ConsoleAnimation;
import com.ibm.mq.explorer.ui.internal.console.ConsolePrintAction;
import com.ibm.mq.explorer.ui.internal.console.ConsoleSaveAction;
import com.ibm.mq.explorer.ui.internal.console.IConsoleDialogUser;
import com.ibm.mq.explorer.ui.internal.console.IConsoleUser;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConsoleDialog
implements IConsoleUser,
Runnable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/console/ConsoleDialog.java";
    private static final int DEFAULT_CANVAS_HEIGHT = 100;
    private static final int DEFAULT_CANVAS_WIDTH = 100;
    private static final int DEFAULT_MAIN_SHELL_WIDTH = 400;
    private static final int DEFAULT_DETAILS_SHELL_WIDTH = 400;
    private static final int DEFAULT_DETAILS_SHELL_HEIGHT = 250;
    private static final int DEFAULT_PAUSE_TIME = 1000;
    private static final String SYSTEM_MESSAGE_UNEXPECTED_ERROR = "AMQ4048";
    private Shell parent;
    private Display display;
    private Text description;
    private Console console;
    private Label execTextLabel;
    private Composite mainButtonPanel;
    private Canvas canvas;
    private StackLayout mainButtonPanelLayout;
    private Button mainShowButton;
    private Button mainHideButton;
    private Button mainCloseButton;
    private Composite detailButtonPanel;
    private StackLayout detailButtonPanelLayout;
    private Button detailHideButton;
    private Button detailCloseButton;
    private IConsoleDialogUser caller;
    private ArrayList commandList;
    private int commandIndex;
    private StringBuffer descriptionText;
    private Shell mainShell;
    private Shell detailsShell;
    private boolean commandSucceeded;
    private boolean commandFailed;
    private ConsoleAnimation animation = null;
    private ImageLoader loader;
    private Image image = null;
    private static String showText = null;
    private static String closeText = null;
    private static String hideText = null;
    private static String executingText = null;
    private static String completedText = null;
    private static String detailsTitle = null;
    private static String printButtonText = null;
    private static String saveAsButtonText = null;
    private static String finishedText = null;
    private static String failedText = null;
    private String execText = null;
    private int id = 0;
    private int pauseTime = 1000;
    private int canvasHeight = 100;
    private int canvasWidth = 100;
    private boolean isShowCloseButton;
    private GC gc = null;

    public ConsoleDialog(Trace t, Shell aParent, IConsoleDialogUser aCaller) {
        this.parent = aParent;
        this.caller = aCaller;
        this.display = this.parent.getDisplay();
        if (showText == null) {
            Message msgFile = UiPlugin.getUIMessages(t, "KEY_Command Dialog");
            showText = msgFile.getMessage(t, "UI.CMD.ShowDetails.Text");
            closeText = msgFile.getMessage(t, "UI.CMD.Close.Text");
            hideText = msgFile.getMessage(t, "UI.CMD.Hide.Text");
            executingText = msgFile.getMessage(t, "UI.CMD.Executing.Text");
            detailsTitle = msgFile.getMessage(t, "UI.CMD.Details.Title");
            printButtonText = msgFile.getMessage(t, "UI.CMD.PrintButton.Text");
            saveAsButtonText = msgFile.getMessage(t, "UI.CMD.SaveAsButton.Text");
            finishedText = msgFile.getMessage(t, "UI.CMD.Finished.Text");
            completedText = msgFile.getMessage(t, "UI.CMD.Completed.Text");
            failedText = msgFile.getMessage(t, "UI.CMD.Failed.Text");
        }
        this.execText = executingText;
        this.createMainShell(t);
        this.createDetailsShell(t);
    }

    private void createMainShell(Trace t) {
        this.mainShell = new Shell(this.parent, 2096);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.mainShell.setLayout((Layout)gridLayout);
        this.mainShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
            }
        });
        Composite lhs = this.getLeftHandSide(t, (Composite)this.mainShell);
        this.getRightHandSide(t, (Composite)this.mainShell);
        this.gc = new GC((Drawable)this.image);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                try {
                    event.gc.drawImage(ConsoleDialog.this.image, 0, 0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (NullPointerException nullPointerException) {}
            }
        });
        if (UiPlugin.isShowAnimations()) {
            this.animation = new ConsoleAnimation(this.display, this.canvas, this.loader, this.gc);
        }
        this.mainShell.pack();
        Point p1 = this.mainShell.getSize();
        Point p2 = lhs.getSize();
        Point p3 = this.canvas.getSize();
        int width = p2.x + 400 - p3.x;
        if (width < p1.x) {
            width = p1.x;
        }
        this.mainShell.setSize(width, p1.y);
    }

    private Composite getLeftHandSide(Trace t, Composite parentComp) {
        Composite leftHandSidePanel = new Composite(parentComp, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        leftHandSidePanel.setLayout((Layout)gridLayout);
        this.getAnimationCanvas(t, leftHandSidePanel);
        Label label = new Label(leftHandSidePanel, 0);
        GridData data = new GridData(1040);
        data.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)data);
        this.getMainButtonPanel(t, leftHandSidePanel);
        data = new GridData(272);
        leftHandSidePanel.setLayoutData((Object)data);
        return leftHandSidePanel;
    }

    private Composite getRightHandSide(Trace t, Composite parentComp) {
        Composite rightHandSidePanel = new Composite(parentComp, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        rightHandSidePanel.setLayout((Layout)gridLayout);
        this.execTextLabel = new Label(rightHandSidePanel, 2048);
        this.execTextLabel.setText(this.execText);
        GridData data = new GridData(768);
        this.execTextLabel.setLayoutData((Object)data);
        int options = 2826;
        this.description = new Text(rightHandSidePanel, options);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.description.setLayoutData((Object)data);
        this.getMainCloseButton(t, rightHandSidePanel);
        data = new GridData();
        data.horizontalAlignment = 3;
        this.mainCloseButton.setLayoutData((Object)data);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        rightHandSidePanel.setLayoutData((Object)data);
        return rightHandSidePanel;
    }

    private Composite getAnimationCanvas(Trace t, Composite parentComp) {
        String gif = "amqiin8n.gif";
        this.loader = new ImageLoader();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(gif);
            if (is == null) {
                t.FFST(67, "ConsoleDialog.getAnimationCanvas", 1, 0, 0, 0, gif, null, null);
                String messageText = CommonServices.getSystemMessage((Trace)t, (String)SYSTEM_MESSAGE_UNEXPECTED_ERROR);
                MessageBox.showMessageFailure(t, UiPlugin.getShell(), messageText, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            } else {
                this.loader.load(is);
                this.canvasHeight = this.loader.logicalScreenHeight;
                this.canvasWidth = this.loader.logicalScreenWidth;
                this.image = new Image((Device)this.display, this.loader.data[0]);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                t.data(67, "ConsoleDialog.getAnimationCanvas", e.toString());
            }
        }
        this.canvas = new Canvas(parentComp, 262144);
        GridData data = new GridData(64);
        data.heightHint = this.canvasHeight;
        data.widthHint = this.canvasWidth;
        this.canvas.setLayoutData((Object)data);
        return this.canvas;
    }

    private Composite getMainButtonPanel(Trace t, Composite parentComp) {
        this.mainButtonPanel = new Composite(parentComp, 0);
        this.mainButtonPanelLayout = new StackLayout();
        this.mainButtonPanel.setLayout((Layout)this.mainButtonPanelLayout);
        this.getMainShowButton(t, this.mainButtonPanel);
        this.getMainHideButton(t, this.mainButtonPanel);
        this.mainButtonPanelLayout.topControl = this.mainShowButton;
        this.mainButtonPanel.layout();
        GridData data = new GridData(272);
        this.mainButtonPanel.setLayoutData((Object)data);
        return this.mainButtonPanel;
    }

    private Button getMainShowButton(Trace t, Composite parentComp) {
        this.mainShowButton = new Button(parentComp, 8);
        this.mainShowButton.setText(showText);
        this.mainShowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ConsoleDialog)ConsoleDialog.this).mainButtonPanelLayout.topControl = ConsoleDialog.this.mainHideButton;
                ConsoleDialog.this.mainButtonPanel.layout();
                ConsoleDialog.this.detailsShell.setVisible(true);
                ConsoleDialog.this.detailsShell.setActive();
            }
        });
        return this.mainShowButton;
    }

    private Button getMainHideButton(Trace t, Composite parentComp) {
        this.mainHideButton = new Button(parentComp, 8);
        this.mainHideButton.setText(hideText);
        this.mainHideButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ConsoleDialog)ConsoleDialog.this).mainButtonPanelLayout.topControl = ConsoleDialog.this.mainShowButton;
                ConsoleDialog.this.mainButtonPanel.layout();
                ConsoleDialog.this.detailsShell.setVisible(false);
                ConsoleDialog.this.mainShell.setActive();
            }
        });
        return this.mainHideButton;
    }

    private Button getMainCloseButton(Trace t, Composite parentComp) {
        this.mainCloseButton = new Button(parentComp, 8);
        this.mainCloseButton.setText(closeText);
        this.mainCloseButton.setVisible(false);
        this.mainCloseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                ConsoleDialog.this.closeMainShell(tr);
            }
        });
        return this.mainCloseButton;
    }

    private void createDetailsShell(Trace t) {
        this.detailsShell = new Shell(this.mainShell, 2096);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.detailsShell.setLayout((Layout)gridLayout);
        this.detailsShell.setVisible(false);
        this.detailsShell.setText(detailsTitle);
        this.detailsShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
            }
        });
        this.console = new Console((Composite)this.detailsShell, 0, this);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.console.setLayoutData(data);
        if (CommonServices.PLATFORM_ID == 1) {
            Button button2 = new Button((Composite)this.detailsShell, 8);
            button2.setText(printButtonText);
            data = new GridData(64);
            data.grabExcessHorizontalSpace = true;
            button2.setLayoutData((Object)data);
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Trace tr = Trace.getDefault();
                    ConsolePrintAction action = new ConsolePrintAction(ConsoleDialog.this.detailsShell, ConsoleDialog.this.console);
                    action.showDialog(tr);
                }
            });
        }
        Button button3 = new Button((Composite)this.detailsShell, 8);
        button3.setText(saveAsButtonText);
        data = new GridData(64);
        data.grabExcessHorizontalSpace = true;
        button3.setLayoutData((Object)data);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                ConsoleSaveAction action = new ConsoleSaveAction(ConsoleDialog.this.console);
                action.showDialog(tr, ConsoleDialog.this.detailsShell);
            }
        });
        this.detailButtonPanel = this.getDetailButtonPanel(t, (Composite)this.detailsShell);
        data = new GridData(64);
        data.grabExcessHorizontalSpace = true;
        this.detailButtonPanel.setLayoutData((Object)data);
        this.detailsShell.pack();
        Rectangle r1 = this.mainShell.computeTrim(0, 0, 400, 250);
        this.detailsShell.setSize(r1.width, r1.height);
    }

    private Composite getDetailButtonPanel(Trace t, Composite parentComp) {
        this.detailButtonPanel = new Composite(parentComp, 0);
        this.detailButtonPanelLayout = new StackLayout();
        this.detailButtonPanel.setLayout((Layout)this.detailButtonPanelLayout);
        this.getDetailHideButton(t, this.detailButtonPanel);
        this.getDetailCloseButton(t, this.detailButtonPanel);
        this.detailButtonPanelLayout.topControl = this.detailHideButton;
        this.detailButtonPanel.layout();
        GridData data = new GridData(272);
        data.verticalSpan = 2;
        this.mainButtonPanel.setLayoutData((Object)data);
        return this.detailButtonPanel;
    }

    private Button getDetailHideButton(Trace t, Composite parentComp) {
        this.detailHideButton = new Button(parentComp, 8);
        this.detailHideButton.setText(hideText);
        this.detailHideButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ConsoleDialog)ConsoleDialog.this).mainButtonPanelLayout.topControl = ConsoleDialog.this.mainShowButton;
                ConsoleDialog.this.mainButtonPanel.layout();
                ConsoleDialog.this.detailsShell.setVisible(false);
                ConsoleDialog.this.mainShell.setActive();
            }
        });
        return this.mainHideButton;
    }

    private Button getDetailCloseButton(Trace t, Composite parentComp) {
        this.detailCloseButton = new Button(parentComp, 8);
        this.detailCloseButton.setText(closeText);
        this.detailCloseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                ConsoleDialog.this.closeMainShell(tr);
            }
        });
        return this.detailCloseButton;
    }

    public void setTitle(String title) {
        this.mainShell.setText(title);
    }

    public void setId(int value) {
        this.id = value;
    }

    public void execute(Trace t, ArrayList aList) {
        this.commandList = aList;
        this.commandIndex = 0;
        this.commandSucceeded = false;
        this.descriptionText = new StringBuffer();
        if (this.animation != null) {
            this.animation.setName("WMQ - animation");
            this.animation.start();
        }
        this.mainShell.open();
        this.detailsShell.setActive();
        this.mainShell.setFocus();
        this.executeCommand(t);
    }

    public void executeCommand(Trace t) {
        if (this.commandIndex < this.commandList.size()) {
            AbstractConsoleCommand c = (AbstractConsoleCommand)this.commandList.get(this.commandIndex);
            this.appendToDescription(t, String.valueOf(c.getDescription()) + "\n");
            this.console.exec(t, c);
        } else {
            try {
                Thread.sleep(this.pauseTime);
            }
            catch (InterruptedException e1) {
                t.data(67, "ConsoleDialog.executeCommand", e1.getMessage());
            }
            this.commandSucceeded = true;
            if (this.animation != null) {
                this.animation.quit(t);
            }
            this.execText = completedText;
            this.appendToDescription(t, String.valueOf(finishedText) + "\n");
            try {
                this.caller.finished(t, this.id, true);
            }
            catch (SWTException e) {
                t.FFST(67, "ConsoleDialog.executeCommand", 1, 0, 0, 0, e.toString(), null, null);
            }
        }
    }

    private void appendToDescription(Trace t, String text) {
        this.descriptionText.append(text);
        try {
            this.display.asyncExec((Runnable)this);
        }
        catch (SWTException e) {
            t.data(67, "ConsoleDialog.appendToDescription", e.toString());
        }
    }

    @Override
    public void finished(Trace t, int exitvalue) {
        AbstractConsoleCommand c = (AbstractConsoleCommand)this.commandList.get(this.commandIndex);
        boolean expected = c.isExitValueExpected(t, exitvalue);
        if (expected) {
            ++this.commandIndex;
            this.executeCommand(t);
        } else {
            this.commandFailed = true;
            if (this.animation != null) {
                this.animation.quit(t);
            }
            this.execText = completedText;
            this.appendToDescription(t, String.valueOf(failedText) + "\n");
            try {
                this.caller.finished(t, this.id, false);
            }
            catch (SWTException e) {
                t.FFST(67, "ConsoleDialog.finished", 2, 0, 0, 0, e.toString(), null, null);
                String messageText = CommonServices.getSystemMessage((Trace)t, (String)SYSTEM_MESSAGE_UNEXPECTED_ERROR);
                MessageBox.showMessageFailure(t, UiPlugin.getShell(), messageText, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            }
        }
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        try {
            int length = this.descriptionText.length();
            this.execTextLabel.setText(this.execText);
            this.description.setText(this.descriptionText.toString());
            this.description.setSelection(length);
            if (this.commandSucceeded) {
                this.mainCloseButton.setVisible(true);
                this.mainHideButton.setVisible(false);
                this.mainShowButton.setVisible(false);
                this.mainButtonPanel.layout();
                this.detailButtonPanelLayout.topControl = this.detailCloseButton;
                this.detailButtonPanel.layout();
                if (!this.detailsShell.getVisible() && !this.isShowCloseButton) {
                    this.closeMainShell(t);
                    this.detailsShell.dispose();
                }
            } else if (this.commandFailed) {
                this.mainCloseButton.setVisible(true);
                this.mainHideButton.setVisible(false);
                this.mainShowButton.setVisible(false);
                this.mainButtonPanel.layout();
                this.detailButtonPanelLayout.topControl = this.detailCloseButton;
                this.detailButtonPanel.layout();
                this.detailsShell.setVisible(true);
            }
        }
        catch (SWTException e) {
            t.data(67, "ConsoleDialog.run", e.toString());
        }
    }

    private void closeMainShell(Trace t) {
        if (this.gc != null) {
            this.gc.dispose();
            this.image.dispose();
        }
        this.mainShell.dispose();
    }

    public void setHelp(String string) {
        UiPlugin.getHelpSystem().setHelp((Control)this.mainShell, string);
        UiPlugin.getHelpSystem().setHelp((Control)this.detailsShell, string);
    }

    public void setPauseTime(int i) {
        this.pauseTime = i;
    }
}

