/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.console;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.console.ConsoleCommandParser;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.AbstractConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.Console;
import com.ibm.mq.explorer.ui.internal.console.ConsoleStderrReader;
import com.ibm.mq.explorer.ui.internal.console.ConsoleStdinWriter;
import com.ibm.mq.explorer.ui.internal.console.ConsoleStdoutReader;
import java.io.IOException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ConsoleCommand
extends AbstractConsoleCommand {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/console/ConsoleCommand.java";
    private String commandline;
    private String input;
    private Process process;
    private String commandText;
    private String inputText;
    private String exitvalueText;

    private void init(String aDescription, String aCommandline, String anInput) {
        String installDir;
        block8: {
            Trace t = Trace.getDefault();
            this.description = aDescription;
            this.commandline = aCommandline;
            this.input = anInput;
            installDir = null;
            try {
                installDir = QueryValue.queryInstallDir((Trace)t);
            }
            catch (CommonServicesException e) {
                if (!Trace.isTracing) break block8;
                t.data(64, "ConsoleCommand.init", e.toString());
            }
        }
        switch (CommonServices.PLATFORM_ID) {
            case 1: {
                if (installDir == null || installDir.length() <= 0) break;
                String baseCmd = this.commandline;
                String args = "";
                int ind = this.commandline.indexOf(32);
                if (ind > 0 && ind < this.commandline.length() - 1) {
                    baseCmd = this.commandline.substring(0, ind);
                    args = this.commandline.substring(ind + 1);
                }
                this.commandline = "\"" + installDir + "\\bin\\" + baseCmd + "\" " + args;
                break;
            }
            case 3: 
            case 5: {
                if (installDir != null && installDir.length() > 0) {
                    this.commandline = String.valueOf(installDir) + "/bin/" + this.commandline;
                    break;
                }
                this.commandline = "/usr/bin/" + this.commandline;
                break;
            }
        }
    }

    public ConsoleCommand(String aDescription, String aCommandLine, String anInput) {
        this.init(aDescription, aCommandLine, anInput);
    }

    public ConsoleCommand(String aDescription, String aCommandLine) {
        this.init(aDescription, aCommandLine, "");
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected Process getProcess() {
        return this.process;
    }

    protected Console getConsole() {
        return this.console;
    }

    @Override
    public void run() {
        this.setName("WMQ - console command " + this.commandline);
        int exitvalue = 0;
        Trace t = Trace.getDefault();
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Command Dialog");
        this.commandText = msgFile.getMessage(t, "UI.CMD.JobCommand.Text");
        this.inputText = msgFile.getMessage(t, "UI.CMD.JobInput.Text");
        this.exitvalueText = msgFile.getMessage(t, "UI.CMD.ExitValue.Text");
        try {
            Display display = this.console.getDisplay();
            display.asyncExec((Runnable)this.console);
            Color fg = UiPlugin.getConsoleCommandColor();
            Color bg = UiPlugin.getConsoleBackgroundColor();
            this.console.display(t, fg, bg, "****************************************");
            this.console.display(t, fg, bg, "* " + this.commandText + ": " + this.commandline);
            if (this.input.length() > 0) {
                this.console.display(t, fg, bg, "* " + this.inputText + ": " + this.input);
            }
            this.console.display(t, fg, bg, "****************************************");
            ConsoleCommandParser ccp = new ConsoleCommandParser(t, this.commandline);
            String[] cmdLine = ccp.getParsedCommand();
            this.process = Runtime.getRuntime().exec(cmdLine);
            ConsoleStdoutReader outputReaderThread = new ConsoleStdoutReader(this);
            outputReaderThread.start();
            ConsoleStderrReader errorReaderThread = new ConsoleStderrReader(this);
            errorReaderThread.start();
            ConsoleStdinWriter inputWriterThread = new ConsoleStdinWriter(this, this.input);
            inputWriterThread.start();
            exitvalue = this.process.waitFor();
            String string = String.valueOf(this.exitvalueText) + " = " + exitvalue;
            Thread.yield();
            fg = UiPlugin.getConsoleResultColor();
            bg = UiPlugin.getConsoleBackgroundColor();
            this.console.display(t, fg, bg, string);
            outputReaderThread.interrupt();
            errorReaderThread.interrupt();
            inputWriterThread.interrupt();
        }
        catch (SWTException e) {
            t.data(67, "ConsoleCommand.run", e.toString());
        }
        catch (IOException e) {
            exitvalue = 1;
            if (!NativeCalls.isUserAuthorized((Trace)t)) {
                Color fg = UiPlugin.getConsoleStderrColor();
                Color bg = UiPlugin.getConsoleBackgroundColor();
                String msgText = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4036");
                this.console.display(t, fg, bg, msgText);
            } else {
                t.FFST(67, "ConsoleCommand.run", 10, 0, "IO Exception Occured executing command: " + this.commandline + "\n" + "IO Exception: " + e.toString());
                t.data(67, "ConsoleCommand.run", e.toString());
            }
        }
        catch (InterruptedException e) {
            t.data(67, "ConsoleCommand.run", e.toString());
        }
        this.console.getController().finished(t, exitvalue);
    }
}

