/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.console;

import com.ibm.mq.commonservices.internal.trace.Trace;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;

public class ConsoleAnimation
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/console/ConsoleAnimation.java";
    private Display display;
    private ImageLoader loader;
    private int imageNumber;
    private GC gc;
    private Canvas canvas;
    private boolean quit;
    private boolean stopAtEnd = false;

    public ConsoleAnimation(Display aDisplay, Canvas aCanvas, ImageLoader aloader, GC aGc) {
        this.display = aDisplay;
        this.canvas = aCanvas;
        this.loader = aloader;
        this.gc = aGc;
        this.setName("WMQ - console animation");
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        while (!this.quit) {
            try {
                Thread.sleep(this.loader.data[0].delayTime * 10);
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ConsoleAnimation.this.stopAtEnd && ConsoleAnimation.this.imageNumber == ((ConsoleAnimation)ConsoleAnimation.this).loader.data.length - 1 || ConsoleAnimation.this.gc.isDisposed()) {
                            ConsoleAnimation.this.quit = true;
                        } else {
                            ConsoleAnimation.this.imageNumber = ConsoleAnimation.this.imageNumber == ((ConsoleAnimation)ConsoleAnimation.this).loader.data.length - 1 ? 0 : ConsoleAnimation.this.imageNumber + 1;
                            ImageData nextFrameData = ((ConsoleAnimation)ConsoleAnimation.this).loader.data[ConsoleAnimation.this.imageNumber];
                            Image frameImage = new Image((Device)ConsoleAnimation.this.display, nextFrameData);
                            ConsoleAnimation.this.gc.drawImage(frameImage, nextFrameData.x, nextFrameData.y);
                            frameImage.dispose();
                            try {
                                ConsoleAnimation.this.canvas.redraw();
                            }
                            catch (SWTException sWTException) {
                                ConsoleAnimation.this.quit = true;
                            }
                        }
                    }
                });
            }
            catch (SWTException e) {
                t.data(67, "ConsoleAnimation.run", e.toString());
                this.quit = true;
            }
            catch (InterruptedException e) {
                t.FFST(67, "ConsoleAnimation.run", 1, 0, 0, 0, e.toString(), null, null);
                this.quit = true;
            }
        }
    }

    public void quit(Trace t) {
        this.quit = true;
        try {
            this.join();
        }
        catch (InterruptedException e) {
            t.FFST(67, "ConsoleAnimation.quit", 1, 0, 0, 0, e.toString(), null, null);
        }
    }

    public void stopAtEnd(Trace t) {
        this.stopAtEnd = true;
    }
}

