/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.console;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.AbstractConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.ConsoleItem;
import com.ibm.mq.explorer.ui.internal.console.IConsoleUser;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class Console
extends Composite
implements Runnable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/console/Console.java";
    private static final int ONE_HUNDRED_PERCENT = 100;
    private StyledText output;
    private Vector<ConsoleItem> items = new Vector();
    private IConsoleUser controller;
    private Display display;

    public Console(Composite parent, int options, IConsoleUser aController) {
        super(parent, options);
        this.controller = aController;
        this.display = this.getDisplay();
        this.setLayout((Layout)new FillLayout());
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.output = new StyledText((Composite)this, 2824);
        this.output.setBackground(UiPlugin.getConsoleBackgroundColor());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.output.setLayoutData((Object)data);
    }

    public IConsoleUser getController() {
        return this.controller;
    }

    public void exec(Trace t, AbstractConsoleCommand c) {
        c.setConsole(this);
        Thread thread = new Thread(c);
        thread.setName("WMQ - console");
        thread.start();
    }

    public void clear() {
        this.items.clear();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.items.size()) {
            ConsoleItem item = this.items.get(i);
            buffer.append(item.toString());
            if (item.toString().length() > 0) {
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    public void display(Trace t, Color fg, Color bg, String text) {
        ConsoleItem item = new ConsoleItem(t, fg, bg, text);
        this.items.add(item);
        try {
            this.display.asyncExec((Runnable)this);
        }
        catch (SWTException e) {
            t.data(67, "Console.display", e.toString());
        }
    }

    private static void addItem(Trace t, ConsoleItem item, int offset, StringBuffer buffer, ArrayList<StyleRange> ranges) {
        String text = item.toString();
        Color fg = item.getForeground();
        Color bg = item.getBackground();
        int startPos = buffer.length() + offset;
        buffer.append(text);
        if (text.length() > 0) {
            buffer.append("\n");
        }
        StyleRange sr = new StyleRange(startPos, text.length(), fg, bg);
        ranges.add(sr);
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        try {
            this.output.setText("");
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.items.size()) {
                ConsoleItem item = this.items.get(i);
                Console.addItem(t, item, 0, buffer, ranges);
                ++i;
            }
            this.output.setText(buffer.toString());
            this.output.setStyleRanges(ranges.toArray(new StyleRange[ranges.size()]));
            this.output.setSelection(this.output.getOffsetAtLine(this.output.getLineCount() - 1));
        }
        catch (SWTException e) {
            t.data(67, "Console.run", e.toString());
        }
    }

    public void draw(Trace t, GC gc, Printer printer, int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
        int x = leftMargin;
        int y = topMargin;
        int lineHeight = gc.getFontMetrics().getHeight();
        int i = 0;
        while (i < this.items.size()) {
            ConsoleItem item = this.items.get(i);
            item.draw(t, gc, (Device)printer, x, y);
            if ((y += lineHeight) > bottomMargin) {
                y = topMargin;
                printer.endPage();
            }
            ++i;
        }
    }
}

