/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.comparewith;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrBoolean;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

public class ObjectDifferenceTableLabelProvider
extends ExtTableLabelProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/comparewith/ObjectDifferenceTableLabelProvider.java";
    private boolean isTickCrossMode = false;
    private Image imageTick = Icons.get(Icons.iconkeyTick);
    private Image imageCross = Icons.get(Icons.iconkeyCross);

    @Override
    public Image getImageForColumn(Object element, int columnIndex) {
        Object object;
        Trace t = Trace.getDefault();
        Image image = null;
        boolean showTickCrossImage = false;
        int attrId = 0;
        UiMQObject uiMQObject = null;
        if (this.table != null && element instanceof MQExtObject && (object = ((MQExtObject)element).getInternalObject()) instanceof AttributeOrderItem) {
            AttributeOrderItem attrOrderItem = (AttributeOrderItem)object;
            TableColumn tabcol = this.table.getColumn(columnIndex);
            Object tabcolObject = tabcol.getData();
            if (tabcolObject instanceof UiMQObject) {
                uiMQObject = (UiMQObject)tabcolObject;
            }
            if (uiMQObject != null) {
                attrId = attrOrderItem.getAttributeId();
                if (this.isTickCrossMode && uiMQObject.isAttributeTypeBoolean(t, attrId)) {
                    showTickCrossImage = true;
                }
            }
        }
        if (uiMQObject != null && showTickCrossImage) {
            Attr attr = uiMQObject.getDmObject().getAttribute(t, attrId, 0);
            AttrBoolean attrBoolean = (AttrBoolean)attr;
            Boolean value = (Boolean)attrBoolean.getValue(t);
            image = value != false ? this.imageTick : this.imageCross;
        }
        return image;
    }

    @Override
    public String getTextForColumn(Object element, int columnIndex) {
        Object object;
        Trace t = Trace.getDefault();
        String colText = null;
        UiMQObject uiMQObject = null;
        if (element instanceof MQExtObject && (object = ((MQExtObject)element).getInternalObject()) instanceof AttributeOrderItem) {
            TableColumn tabcol;
            Object tabcolObject;
            AttributeOrderItem attrOrderItem = (AttributeOrderItem)object;
            if (this.table != null && (tabcolObject = (tabcol = this.table.getColumn(columnIndex)).getData()) instanceof UiMQObject) {
                uiMQObject = (UiMQObject)tabcolObject;
            }
            if (uiMQObject != null) {
                if (this.isTickCrossMode && uiMQObject.isAttributeTypeBoolean(t, attrOrderItem.getAttributeId())) {
                    colText = "";
                } else {
                    Attr attr = uiMQObject.getDmObject().getAttribute(t, attrOrderItem.getAttributeId(), 0);
                    if (attr != null) {
                        colText = attr.toString(t);
                        if (colText.equals("[not_found]")) {
                            Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
                            colText = msgFile != null ? msgFile.getMessage(t, "UI.GENERAL.NOT.FOUND") : "";
                            if (Trace.isTracing) {
                                t.data(67, "ObjectDifferenceTableLabelProvider.getTextForColumn", 900, "no valid string for enum value found for attr: " + attr);
                            }
                        }
                    } else {
                        colText = uiMQObject.getAttributeValue(t, attrOrderItem.getAttributeId());
                    }
                }
            } else if (columnIndex == 0) {
                colText = attrOrderItem.getAttributeName();
            }
        }
        if (Trace.isTracing) {
            if (colText != null) {
                t.data(67, "ObjectDifferenceTableLabelProvider.getTextForColumn", 300, "Text for cell in column " + columnIndex + ": " + colText);
            } else {
                t.data(67, "ObjectDifferenceTableLabelProvider.getTextForColumn", 300, "No text for cell in column " + columnIndex);
            }
        }
        return colText;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setTickCrossMode(boolean isTickCross, Image imgTick, Image imgCross) {
        this.isTickCrossMode = isTickCross;
        if (imgTick != null) {
            this.imageTick = imgTick;
        }
        if (imgCross != null) {
            this.imageCross = imgCross;
        }
    }
}

