/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.comparewith;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.comparewith.ObjectDifferenceTableContentProvider;
import com.ibm.mq.explorer.ui.internal.comparewith.ObjectDifferenceTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ObjectDifferenceTable
extends Composite
implements IPropertyChangeListener,
DisposeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/comparewith/ObjectDifferenceTable.java";
    private static final int TABLE_WIDTH_HINT = 500;
    private static final int TABLE_HEIGHT_HINT = 150;
    private Table table = null;
    private UiMQObject uiMQObject1 = null;
    private UiMQObject uiMQObject2 = null;
    private String title1 = null;
    private String title2 = null;
    protected TableColumn tabcolName = null;
    protected TableColumn tabcolValue1 = null;
    protected TableColumn tabcolValue2 = null;
    private AttributeOrder attrOrder = null;
    private boolean showOnlyDifferences = false;
    private TableViewer tableViewer = null;
    private ObjectDifferenceTableContentProvider contentProvider = null;
    private ObjectDifferenceTableLabelProvider labelProvider = null;
    private boolean isTickCrossMode = false;

    public ObjectDifferenceTable(Composite parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.title1 = "";
        this.title2 = "";
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Tables");
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.table = new Table((Composite)this, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tabcolName = new TableColumn(this.table, 0);
        this.tabcolName.setText(msgFile.getMessage(t, "UI.TABLES.Attribute.Label"));
        this.tabcolValue1 = new TableColumn(this.table, 0);
        this.tabcolValue2 = new TableColumn(this.table, 0);
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point pt = ObjectDifferenceTable.this.table.getSize();
                int colWidth = (pt.x - UiUtils.getVScrollBarWidth(Trace.getDefault(), ObjectDifferenceTable.this.table)) / 3;
                ObjectDifferenceTable.this.tabcolName.setWidth(colWidth);
                ObjectDifferenceTable.this.tabcolValue1.setWidth(colWidth);
                ObjectDifferenceTable.this.tabcolValue2.setWidth(colWidth);
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.heightHint = 150;
        gridData.widthHint = 500;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(this.table);
        this.contentProvider = new ObjectDifferenceTableContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ObjectDifferenceTableLabelProvider();
        this.labelProvider.setTable(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        UiPlugin.getPrefStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.table.addDisposeListener((DisposeListener)this);
    }

    public void removeAll(Trace t) {
        this.table.removeAll();
        this.tabcolValue1.setText("");
        this.tabcolValue1.setData(null);
        this.tabcolValue2.setText("");
        this.tabcolValue2.setData(null);
        this.uiMQObject1 = null;
        this.uiMQObject2 = null;
    }

    public void setAttributeOrder(Trace t, AttributeOrder order) {
        this.attrOrder = order;
    }

    private void addItemsToTable(Trace t) {
        this.tabcolValue1.setText(this.title1);
        this.tabcolValue1.setData((Object)this.uiMQObject1);
        this.tabcolValue2.setText(this.title2);
        this.tabcolValue2.setData((Object)this.uiMQObject2);
        IDmObject dmObject1 = this.uiMQObject1.getDmObject();
        IDmObject dmObject2 = this.uiMQObject2.getDmObject();
        this.table.removeAll();
        ArrayList<AttributeOrderItem> attrOrderItems = this.attrOrder.getAttributeOrderItems(t);
        ArrayList<AttributeOrderItem> showItems = new ArrayList<AttributeOrderItem>();
        int iconAttrId = this.attrOrder.getIconAttrId(t);
        int i = 0;
        while (i < attrOrderItems.size()) {
            AttributeOrderItem attrOrderItem = attrOrderItems.get(i);
            if (attrOrderItem.getAttributePosition(false) != -2 && attrOrderItem.getAttributeId() != iconAttrId) {
                String attrValue1 = null;
                String attrValue2 = null;
                boolean attrPresent1 = true;
                boolean attrPresent2 = true;
                boolean repeating = false;
                Attr attr1 = dmObject1.getAttribute(t, attrOrderItem.getAttributeId(), 0);
                if (attr1 != null) {
                    attrValue1 = attr1.toString(t);
                    repeating = attr1.getAttrType().isRepeating();
                } else {
                    attrPresent1 = false;
                }
                Attr attr2 = dmObject2.getAttribute(t, attrOrderItem.getAttributeId(), 0);
                if (attr2 != null) {
                    attrValue2 = attr2.toString(t);
                    repeating |= attr2.getAttrType().isRepeating();
                } else {
                    attrPresent2 = false;
                }
                if (!repeating && (!this.showOnlyDifferences || attrPresent1 != attrPresent2 || attrPresent1 && attrPresent2 && attrValue1 != null && attrValue2 != null && attrValue1.compareTo(attrValue2) != 0)) {
                    showItems.add(attrOrderItem);
                }
            }
            ++i;
        }
        this.tableViewer.setInput(showItems);
        this.tableViewer.refresh();
        ExplorerTable.paintGreyCells(t, this.table, this.labelProvider);
    }

    public void addTableItems(Trace t, UiMQObject object1, String colTitle1, UiMQObject object2, String colTitle2) {
        this.removeAll(t);
        this.uiMQObject1 = object1;
        this.uiMQObject2 = object2;
        this.title1 = colTitle1;
        this.title2 = colTitle2;
        this.addItemsToTable(t);
    }

    public void showOnlyDifferences(Trace t, boolean onlyDifferences) {
        this.showOnlyDifferences = onlyDifferences;
        if (this.uiMQObject1 != null && this.uiMQObject2 != null) {
            this.addItemsToTable(t);
        }
    }

    public void setTickCrossMode(boolean isTickCross, Image imgTick, Image imgCross) {
        this.isTickCrossMode = isTickCross;
        if (this.labelProvider != null) {
            this.labelProvider.setTickCrossMode(this.isTickCrossMode, imgTick, imgCross);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace t = Trace.getDefault();
        String strProperty = event.getProperty();
        if (strProperty.compareTo("InvalidCellColorChanged") == 0) {
            ExplorerTable.paintGreyCells(t, this.table, this.labelProvider);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        UiPlugin.getPrefStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

