/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.comparewith;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.comparewith.CompareWithProvider;
import com.ibm.mq.explorer.ui.internal.comparewith.ObjectDifferenceTable;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.SelectUiMQObjectDialog;
import com.ibm.mq.explorer.ui.internal.objects.SelectUiMQObjectLinkDialog;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectLink;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.splittreetable.ISplitTreeTableContentListener;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableContentProvider;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ObjectDifferenceDialog
extends TrayDialog
implements ISplitTreeTableContentListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/comparewith/ObjectDifferenceDialog.java";
    private Shell shellDlg = null;
    private UiMQObject uiMQObject1 = null;
    private UiMQObject uiMQObject2 = null;
    private String title1 = "";
    private String title2 = "";
    private UiQueueManager refQueueManager = null;
    private Button checkOnlyDiff = null;
    private ObjectDifferenceTable table = null;
    private CompareWithProvider uiCompareWithProvider = null;
    private boolean isChoiceMode = false;
    private boolean isCategoryMode = false;
    private Object thisCategory = null;
    private Text labelOnSrc;
    private Text labelOnRef;
    private Text labelCompareObj = null;
    private AttributeOrder attrOrder = null;
    private Message msgFile = null;
    private boolean isTickCrossMode = false;
    private Image imageTick = null;
    private Image imageCross = null;
    private UiMQObject parentObjectForFactory = null;
    private SelectUiMQObjectLinkDialog selUiMQObjectLinkDlg = null;

    public ObjectDifferenceDialog(Shell parent) {
        super(parent);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Tables");
        this.imageTick = Icons.get(Icons.iconkeyTick);
        this.imageCross = Icons.get(Icons.iconkeyCross);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = Message.format((String)this.msgFile.getMessage(Trace.getDefault(), "UI.TABLES.CompareWith.Title"), (String)this.uiMQObject1.toFormattedString());
        newShell.setText(title);
        Image image = this.getImage(Trace.getDefault());
        if (image != null) {
            newShell.setImage(image);
        }
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.ui.infopop.UI_CompareDialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button close = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        close.setFocus();
    }

    protected void buttonPressed(int buttonId) {
        this.okPressed();
    }

    public void setObjects(Trace t, UiMQObject uiMQObj1, String objTitle1, UiMQObject uiMQObj2, String objTitle2) {
        this.uiMQObject1 = uiMQObj1;
        this.uiMQObject2 = uiMQObj2;
        this.title1 = objTitle1;
        this.title2 = objTitle2;
        this.isChoiceMode = false;
        this.isCategoryMode = false;
        this.uiCompareWithProvider = uiMQObj1.getCompareWithProvider(t);
    }

    public void multiSelectCompareWithChoice(Trace t, UiMQObject uiMQObj1, String objTitle1, UiMQObject uiMQObj2, String objTitle2) {
        this.uiMQObject1 = uiMQObj1;
        this.uiMQObject2 = uiMQObj2;
        this.title1 = objTitle1;
        this.title2 = objTitle2;
        this.isChoiceMode = true;
        this.isCategoryMode = true;
        this.uiCompareWithProvider = uiMQObj1.getCompareWithProvider(t);
        this.thisCategory = this.uiCompareWithProvider.getThisCategory(t);
    }

    public void setObjectWithChoice(Trace t, UiMQObject uiMQObj1, Filter f, UiMQObject parentToNewObjects) {
        this.uiMQObject1 = uiMQObj1;
        this.isChoiceMode = true;
        this.uiCompareWithProvider = uiMQObj1.getCompareWithProvider(t);
        this.isCategoryMode = this.uiCompareWithProvider.isSupportCompareWithOtherInstances();
        this.thisCategory = this.uiCompareWithProvider.getThisCategory(t);
        this.parentObjectForFactory = parentToNewObjects;
    }

    public void setAttributeOrder(AttributeOrder order) {
        this.attrOrder = order;
    }

    private void addChoiceControls(Trace t, Composite composite) {
        Label label;
        GridData gridData;
        String colon;
        String objName = this.uiCompareWithProvider.getGenericObjectName(t);
        if (!objName.endsWith(colon = this.msgFile.getMessage("UI.PROP.Colon.Suffix"))) {
            objName = String.valueOf(objName) + colon;
        }
        if (this.isCategoryMode) {
            Text textlabel = new Text(composite, 0);
            UiUtils.makeTextControlReadOnly(t, textlabel, true);
            String text = "";
            text = this.uiCompareWithProvider.getCompareWithAString(t);
            if (text == null || text.length() == 0) {
                text = this.msgFile.getMessage(t, "UI.GENERAL.NOT.FOUND");
            }
            textlabel.setText(text);
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            textlabel.setLayoutData((Object)gridData);
        }
        Group compareGroup = new Group(composite, 0);
        compareGroup.setLayout((Layout)new GridLayout(2, false));
        compareGroup.setText(this.msgFile.getMessage(t, "UI.TABLES.Label.Compare"));
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        compareGroup.setLayoutData((Object)gridData);
        if (this.isCategoryMode) {
            label = new Label((Composite)compareGroup, 0);
            label.setText(this.uiCompareWithProvider.getCategoryType());
            this.labelOnSrc = new Text((Composite)compareGroup, 2048);
            gridData = new GridData(4, 128, true, false);
            gridData.grabExcessHorizontalSpace = true;
            this.labelOnSrc.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly(t, this.labelOnSrc, true);
        }
        label = new Label((Composite)compareGroup, 0);
        label.setText(objName);
        Text t2 = new Text((Composite)compareGroup, 2048);
        gridData = new GridData(4, 128, true, false);
        gridData.grabExcessHorizontalSpace = true;
        t2.setLayoutData((Object)gridData);
        t2.setText(this.uiMQObject1.toFormattedString());
        UiUtils.makeTextControlReadOnly(t, t2, true);
        Group withGroup = new Group(composite, 0);
        withGroup.setLayout((Layout)new GridLayout(3, false));
        withGroup.setText(this.msgFile.getMessage(t, "UI.TABLES.Label.With"));
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        withGroup.setLayoutData((Object)gridData);
        if (this.isCategoryMode) {
            label = new Label((Composite)withGroup, 0);
            label.setText(this.uiCompareWithProvider.getCategoryType());
            this.labelOnRef = new Text((Composite)withGroup, 2048);
            gridData = new GridData(4, 128, true, false);
            gridData.grabExcessHorizontalSpace = true;
            this.labelOnRef.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly(t, this.labelOnRef, true);
            Button browse = new Button((Composite)withGroup, 8);
            browse.setText(this.msgFile.getMessage(t, "UI.TABLES.Button.Browse"));
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    ObjectDifferenceDialog.this.selectQueueManager(tr);
                }
            });
        }
        label = new Label((Composite)withGroup, 0);
        label.setText(objName);
        this.labelCompareObj = new Text((Composite)withGroup, 2048);
        gridData = new GridData(4, 128, true, false);
        gridData.grabExcessHorizontalSpace = true;
        this.labelCompareObj.setLayoutData((Object)gridData);
        if (this.uiMQObject2 != null) {
            this.labelCompareObj.setText(this.uiMQObject2.toFormattedString());
        }
        UiUtils.makeTextControlReadOnly(t, this.labelCompareObj, true);
        Button browse2 = new Button((Composite)withGroup, 8);
        browse2.setText(this.msgFile.getMessage(t, "UI.TABLES.Button.Browse"));
        browse2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ObjectDifferenceDialog.this.selectOtherObject(tr);
            }
        });
    }

    private void checkOnlyDiffSelected(Trace t) {
        this.table.showOnlyDifferences(t, this.checkOnlyDiff.getSelection());
    }

    private void otherObjectSelectionChanged(Trace t) {
        this.table.removeAll(t);
        if (this.uiMQObject2 != null) {
            String obj1 = null;
            String obj2 = null;
            if (this.isCategoryMode) {
                obj1 = this.msgFile.getMessage(t, "UI.TABLES.Label.Compare.Object.Column.title", this.uiMQObject1.toString(), ((UiMQObject)this.thisCategory).toFormattedString());
                obj2 = this.msgFile.getMessage(t, "UI.TABLES.Label.Compare.Object.Column.title", this.uiMQObject2.toString(), this.refQueueManager.toFormattedString());
            } else {
                obj1 = this.uiMQObject1.toFormattedString();
                obj2 = this.uiMQObject2.toFormattedString();
            }
            this.table.addTableItems(t, this.uiMQObject1, obj1, this.uiMQObject2, obj2);
        } else {
            this.table.removeAll(t);
        }
    }

    private void setOnSrcText(Trace t, String categoryName) {
        this.labelOnSrc.setText(categoryName);
    }

    private void setOnRefText(Trace t, String categoryName) {
        this.labelOnRef.setText(categoryName);
    }

    private void selectOtherObject(Trace t) {
        SplitTreeTableContentProvider contentProvider = null;
        if (this.uiMQObject1 instanceof UiMQObjectLink) {
            contentProvider = this.uiCompareWithProvider.getSplitTreeTableContentProvider(this);
        }
        if (contentProvider != null) {
            UiQueueManager uiQm = null;
            DmQueueManager dmQm = null;
            if (this.refQueueManager != null) {
                uiQm = this.refQueueManager;
                dmQm = uiQm.getDmQueueManagerObject();
            } else {
                dmQm = this.uiCompareWithProvider.getDmQueueManagerObject(t);
                uiQm = UiPlugin.getQueueManagerList().getKnownUiQueueManager(t, dmQm);
            }
            String genericObjectName = this.uiCompareWithProvider.getGenericObjectName(t);
            String attrOrderId = this.uiCompareWithProvider.getAttributeOrderId();
            this.selUiMQObjectLinkDlg = new SelectUiMQObjectLinkDialog(t, this.shellDlg, 0);
            boolean isSecondaryOrder = false;
            if (dmQm != null) {
                isSecondaryOrder = dmQm.isZos();
            }
            this.selUiMQObjectLinkDlg.create(t, Message.format((String)this.msgFile.getMessage(t, "UI.TABLES.Title.Select"), (String)this.uiCompareWithProvider.getGenericObjectName(t)), null, this.uiCompareWithProvider.getObjectId(), genericObjectName, attrOrderId, isSecondaryOrder, false, true, "com.ibm.mq.explorer.ui.infopop.UI_SelectCompareWithObject", contentProvider, uiQm);
            if (this.selUiMQObjectLinkDlg.open(t)) {
                this.uiMQObject2 = this.selUiMQObjectLinkDlg.getSelectedObject();
                if (this.uiMQObject2 != null) {
                    this.labelCompareObj.setText(this.uiMQObject2.toString());
                    this.otherObjectSelectionChanged(t);
                }
            }
        } else {
            SelectUiMQObjectDialog selDlg = new SelectUiMQObjectDialog(this.shellDlg);
            selDlg.setTickCrossMode(t, this.isTickCrossMode, this.imageTick, this.imageCross);
            UiQueueManager uiQm = null;
            DmQueueManager dmQm = null;
            IUiMQObjectFactory uiFactory = null;
            if (this.refQueueManager != null) {
                uiQm = this.refQueueManager;
                dmQm = uiQm.getDmQueueManagerObject();
                uiFactory = uiQm.getFactoryClass(t, this.uiCompareWithProvider.getObjectId());
            } else {
                dmQm = this.uiCompareWithProvider.getDmQueueManagerObject(t);
                uiFactory = this.uiCompareWithProvider.getUiMQObjectFactory(t);
            }
            DmObjectFilter dmFilter = this.uiCompareWithProvider.getSelectDmObjectFilter(t, this.uiMQObject1);
            if (dmFilter != null) {
                selDlg.setExplicitFilter(t, dmFilter);
            }
            if (dmQm != null && uiFactory != null && this.uiCompareWithProvider.supportsDataModelListen(t)) {
                selDlg.listenToDataModel(t, (IDmObservable)dmQm, this.uiCompareWithProvider.getDataModelObjectType(t), uiFactory, this.parentObjectForFactory);
            } else {
                UiMQObject[] objects = this.uiCompareWithProvider.getObjectsForCategory(t, this.thisCategory, null);
                if (objects != null) {
                    selDlg.setObjects(t, objects);
                }
            }
            boolean isSecondaryOrder = false;
            if (dmQm != null) {
                isSecondaryOrder = dmQm.isZos();
            }
            if (selDlg.open(t, Message.format((String)this.msgFile.getMessage(t, "UI.TABLES.Title.Select"), (String)this.uiCompareWithProvider.getGenericObjectName(t)), null, this.uiCompareWithProvider.getObjectId(), this.uiCompareWithProvider.getGenericObjectName(t), this.uiCompareWithProvider.getAttributeOrderId(), isSecondaryOrder, this.uiCompareWithProvider.getFilterId(), this.uiCompareWithProvider.getFilterProvider(t), this.uiCompareWithProvider.getQSGDisposition(), this.uiCompareWithProvider.getViewerFilter(t), true, true, "com.ibm.mq.explorer.ui.infopop.UI_SelectCompareWithObject")) {
                this.uiMQObject2 = selDlg.getSelectedObject();
                if (this.uiMQObject2 != null) {
                    this.labelCompareObj.setText(this.uiMQObject2.toString());
                    this.otherObjectSelectionChanged(t);
                }
            }
        }
    }

    private void selectQueueManager(Trace t) {
        SelectUiMQObjectDialog selDlg = new SelectUiMQObjectDialog(this.getShell());
        ViewerFilter queueManagerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof MQExtObject) {
                    MQExtObject mqExtObject = (MQExtObject)element;
                    UiMQObject uiMQ = (UiMQObject)mqExtObject.getInternalObject();
                    return uiMQ.getDmObject().getQueueManager().isConnected();
                }
                return true;
            }
        };
        String title = Message.format((String)this.msgFile.getMessage(t, "UI.TABLES.Title.Select"), (String)this.uiCompareWithProvider.getCategoryType());
        boolean result = selDlg.openToSelectQueueManagerHandle(t, title, null, queueManagerFilter, "com.ibm.mq.explorer.ui.infopop.UI_SelectCompareWithObject");
        UiMQObject selectedQMH = selDlg.getSelectedObject();
        if (result && selectedQMH != null) {
            this.refQueueManager = UiPlugin.getQueueManagerList().getKnownUiQueueManager(t, selectedQMH.getDmObject().getQueueManager());
            this.uiMQObject2 = null;
            this.labelCompareObj.setText("");
            String queueManagerString = this.refQueueManager.toFormattedString();
            this.setOnRefText(t, queueManagerString);
            this.otherObjectSelectionChanged(t);
        }
    }

    public Image getImage(Trace t) {
        Image image = null;
        image = this.uiMQObject1 != null ? this.uiMQObject1.getImage() : Icons.get(Icons.iconkeyExplorerSmall);
        return image;
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.shellDlg = composite.getShell();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)gridLayout);
        if (this.isChoiceMode) {
            this.addChoiceControls(t, composite);
        }
        this.checkOnlyDiff = new Button(composite, 32);
        this.checkOnlyDiff.setText(this.msgFile.getMessage(t, "UI.TABLES.DifferencesOnly.Title"));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.checkOnlyDiff.setLayoutData((Object)gridData);
        this.checkOnlyDiff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ObjectDifferenceDialog.this.checkOnlyDiffSelected(tr);
            }
        });
        this.table = new ObjectDifferenceTable(composite, 0);
        this.table.setAttributeOrder(t, this.attrOrder);
        this.table.setTickCrossMode(this.isTickCrossMode, this.imageTick, this.imageCross);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 4;
        this.table.setLayoutData(gridData);
        if (this.isChoiceMode) {
            if (this.isCategoryMode) {
                Object cat = this.uiCompareWithProvider.getThisCategory(t);
                this.setOnSrcText(t, ((UiMQObject)cat).toFormattedString());
                if (cat instanceof UiQueueManager) {
                    this.refQueueManager = (UiQueueManager)cat;
                }
                this.otherObjectSelectionChanged(t);
                this.checkOnlyDiff.setSelection(true);
                if (this.refQueueManager != null) {
                    this.setOnRefText(t, this.refQueueManager.toFormattedString());
                }
            }
        } else {
            this.table.addTableItems(t, this.uiMQObject1, this.title1, this.uiMQObject2, this.title2);
            this.checkOnlyDiff.setSelection(true);
        }
        this.checkOnlyDiffSelected(t);
        composite.pack();
        return composite;
    }

    public void setTickCrossMode(boolean isTickCross, Image imgTick, Image imgCross) {
        this.isTickCrossMode = isTickCross;
        if (imgTick != null) {
            this.imageTick = imgTick;
        }
        if (imgCross != null) {
            this.imageCross = imgCross;
        }
    }

    @Override
    public void showObjects(Trace t, UiMQObject parentObject, ArrayList<UiMQObject> objects) {
        if (this.selUiMQObjectLinkDlg != null) {
            this.selUiMQObjectLinkDlg.showObjects(t, parentObject, objects);
        }
    }

    @Override
    public void refreshObjects(Trace t, UiMQObject parentObject, UiMQObject refreshObject, ArrayList<UiMQObject> objects) {
        if (this.selUiMQObjectLinkDlg != null) {
            this.selUiMQObjectLinkDlg.refreshObjects(t, parentObject, refreshObject, objects);
        }
    }

    @Override
    public void dmCoreExceptionReceived(Trace t, UiMQObject parentObject, DmCoreException dmCoreException) {
        if (Trace.isTracing) {
            t.data(67, "ObjectDifferenceDialog.dmCoreExceptionReceived", 900, "DmCoreException received: cc=" + dmCoreException.getCompCode() + " rc=" + dmCoreException.getReasonCode());
        }
        MessageBox.showExceptionMessage(t, UiPlugin.getShell(), dmCoreException);
    }
}

