/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.clipboard;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.clipboard.ITabularTextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class TablularCopyAction
extends Action {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/clipboard/TablularCopyAction.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private ITabularTextProvider fTabluarTextProvider;
    private Clipboard fClipboard;

    public TablularCopyAction(ITabularTextProvider tablularTextProvider, Clipboard clipboard) {
        this.fClipboard = clipboard;
        this.fTabluarTextProvider = tablularTextProvider;
        Message msgFile = UiPlugin.getUIMessages(Trace.getDefault(), null);
        String text = msgFile.getMessage(Trace.getDefault(), "UI.GENERAL.COPY");
        this.setText(text);
        this.setToolTipText(text);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
    }

    public void run() {
        this.fClipboard.setContents(new Object[]{this.getContentsAsText()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public String getContentsAsText() {
        String newLine = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        int numCols = this.fTabluarTextProvider.getColumnCount();
        int c = 0;
        while (c < numCols) {
            String colText = this.fTabluarTextProvider.getColumnTitle(c);
            buf.append(colText);
            if (c < numCols - 1) {
                buf.append('\t');
            }
            ++c;
        }
        buf.append(newLine);
        int selectedRowCount = this.fTabluarTextProvider.getSelection();
        int i = 0;
        while (i < selectedRowCount) {
            int c2 = 0;
            while (c2 < numCols) {
                buf.append(this.fTabluarTextProvider.getSelectedCellText(i, c2));
                if (c2 < numCols - 1) {
                    buf.append('\t');
                }
                ++c2;
            }
            buf.append(newLine);
            ++i;
        }
        return buf.toString();
    }
}

