/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.queuesharinggroup.UiQueueSharingGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class ZosQueueManagerList {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/ZosQueueManagerList.java";
    private static Hashtable<String, ArrayList<UiQueueManager>> knownUiQueueSharingGroups = null;
    private static Integer lock = 0;

    public ZosQueueManagerList() {
        knownUiQueueSharingGroups = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void qmgrAdded(Trace t, UiQueueManager uiQm) {
        if (uiQm != null) {
            UiQueueSharingGroup uiQSG = uiQm.getUiQueueSharingGroup(t);
            if (!uiQm.isVisible(t)) {
                uiQSG = null;
            }
            if (uiQSG != null) {
                String qsgName = uiQSG.getTreeName().trim();
                if (knownUiQueueSharingGroups.containsKey(qsgName)) {
                    ArrayList<UiQueueManager> list = knownUiQueueSharingGroups.get(qsgName);
                    boolean exists = false;
                    for (UiQueueManager qm : list) {
                        if (!qm.toString().equals(uiQm.toString())) continue;
                        exists = true;
                    }
                    if (!exists) {
                        Integer n = lock;
                        synchronized (n) {
                            list.add(uiQm);
                        }
                        if (Trace.isTracing) {
                            t.data(67, "ZosQueueManagerList.qmgrAdded", 300, "Qmgr " + uiQm + " added as new source for qsg: " + qsgName);
                        }
                    }
                } else {
                    ArrayList<UiQueueManager> list = new ArrayList<UiQueueManager>();
                    Integer n = lock;
                    synchronized (n) {
                        list.add(uiQm);
                        knownUiQueueSharingGroups.put(qsgName, list);
                    }
                    if (!UiPlugin.isShutdownInProgress()) {
                        UiPlugin.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ZosQueueManagerList.refreshQSGTreeNode();
                            }
                        });
                    } else if (Trace.isTracing) {
                        t.data(67, "ZosQueueManagerList.qmgrAdded", 300, "ignored, shutdown in progress");
                    }
                    if (Trace.isTracing) {
                        t.data(67, "ZosQueueManagerList.qmgrAdded", 300, "Qmgr " + uiQm + " added as source for qsg: " + qsgName);
                    }
                }
            }
        }
    }

    private static void refreshQSGTreeNode() {
        Trace t = Trace.getDefault();
        if (!UiPlugin.isShutdownInProgress()) {
            TreeNode node;
            UiMQObject qsgs = UiPlugin.getUiMachineObject().getUiQSGsObject();
            if (qsgs != null && (node = qsgs.getTreeNode()) != null) {
                node.refresh();
            }
        } else if (Trace.isTracing) {
            t.data(67, "ZosQueueManagerList.refreshQSGTreeNode", 300, "ignored, shutdown in progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void qmgrRemoved(Trace t, UiQueueManager uiQm) {
        UiQueueSharingGroup uiQSG;
        TreeNode tn = null;
        if (uiQm != null && (uiQSG = uiQm.getUiQueueSharingGroup(t)) != null) {
            String qsgName = uiQSG.getTreeName().trim();
            Integer n = lock;
            synchronized (n) {
                if (knownUiQueueSharingGroups.containsKey(qsgName)) {
                    ArrayList<UiQueueManager> list = knownUiQueueSharingGroups.get(qsgName);
                    Iterator<UiQueueManager> i = list.iterator();
                    while (i.hasNext()) {
                        UiQueueManager qm = i.next();
                        if (!qm.toString().equals(uiQm.toString())) continue;
                        i.remove();
                        tn = uiQSG.getTreeNode();
                    }
                    if (list.size() == 0) {
                        list.clear();
                        knownUiQueueSharingGroups.remove(qsgName);
                    }
                    if (tn != null) {
                        final TreeNode node = tn;
                        if (!UiPlugin.isShutdownInProgress()) {
                            UiPlugin.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ZosQueueManagerList.removeTreeNode(uiQSG, node);
                                }
                            });
                        } else if (Trace.isTracing) {
                            t.data(67, "ZosQueueManagerList.qmgrRemoved", 300, "ignored, shutdown in progress");
                        }
                    }
                }
            }
        }
    }

    private static void removeTreeNode(UiQueueSharingGroup uiQSG, TreeNode node) {
        Trace t = Trace.getDefault();
        if (!UiPlugin.isShutdownInProgress()) {
            node.removeFromNavigatorView();
            TreeNode parent = node.getParent();
            if (parent != null) {
                parent.refresh();
            }
            uiQSG.setTreeNode(null);
        } else if (Trace.isTracing) {
            t.data(67, "ZosQueueManagerList.removeTreeNode", 300, "ignored, shutdown in progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UiQueueSharingGroup[] getKnownUiQueueSharingGoups(Trace t) {
        ArrayList<UiQueueSharingGroup> array = new ArrayList<UiQueueSharingGroup>();
        UiQueueSharingGroup[] qsgArray = new UiQueueSharingGroup[]{};
        Integer n = lock;
        synchronized (n) {
            int size = knownUiQueueSharingGroups.size();
            if (size > 0) {
                Collection<ArrayList<UiQueueManager>> lists = knownUiQueueSharingGroups.values();
                for (ArrayList<UiQueueManager> list : lists) {
                    if (list.size() < 1) continue;
                    UiQueueManager qm = list.get(0);
                    UiQueueSharingGroup qsg = qm.getUiQueueSharingGroup(t);
                    array.add(qsg);
                }
            }
            qsgArray = array.toArray(new UiQueueSharingGroup[size]);
            if (Trace.isTracing) {
                String txt = "";
                int k = 0;
                while (k < qsgArray.length) {
                    if (qsgArray[k] != null) {
                        txt = txt.concat(qsgArray[k].toString());
                        txt = txt.concat(" ");
                    }
                    ++k;
                }
                t.data(67, "ZosQueueManagerList.getKnownUiQueueSharingGoups", 500, "requested qsgs, know: " + txt);
            }
        }
        return qsgArray;
    }

    public static Hashtable getKnownUiQueueSharingGroups() {
        return knownUiQueueSharingGroups;
    }
}

