/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.base.WorkspaceDescriptor;
import com.ibm.mq.explorer.ui.internal.dialogs.WorkspaceMigrationDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class WorkspaceManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/WorkspaceManager.java";
    public WorkspaceDescriptor migratedWorkspace;
    private static int CURRENT_VERSION_NUMBER = -1;
    private static int CURRENT_RELEASE_NUMBER = -1;
    private static final String OLD_ENV_VAR_WIN = "APPDATA";
    private static final String WORKSPACE_PATH_OLD_LINUX = "/.mqdata";
    private static final String WORKSPACE_PATH_OLD_WIN = "/IBM/MQ Explorer";
    private static final String WORKSPACE_HOME_PREFIX = "user.home";
    private static final String WORKSPACE_PATH = "/IBM/WebSphereMQ";
    private static final String PLUGIN_DIRECTORY = "/.metadata/.plugins";
    private static final String PREFERENCE_DIRECTORY = "org.eclipse.core.runtime/.settings";
    private static final String LAUNCHES_DIRECTORY = "org.eclipse.debug.core/.launches";
    private static final String UIPLUGIN_METADATA = "/com.ibm.mq.explorer.ui";
    private static final String SERVICE_DEF_DIRECTORY = "com.ibm.mq.explorer.servicedef";
    private static final String SERVICE_DEF_METADATA = "ServiceDefinition.xml";
    private static final String[] FOLDER_REGEX = new String[]{"^com\\.ibm\\.mq\\.explorer\\..*$", "^com\\.ibm\\.wmqfte\\.explorer\\..*$", "^com\\.ibm\\.etools\\..*$"};
    private static final String[] PREFERENCE_REGEX = new String[]{"^com\\.ibm\\.mq\\.explorer\\.ui\\.prefs$", "^com\\.ibm\\.mq\\.explorer\\.tests\\.prefs$", "^com\\.ibm\\.wmqfte\\.explorer\\.prefs$", "^com\\.ibm\\.etools\\.wmadmin\\.broker\\.explorer\\.prefs$", "^com\\.ibm\\.explorer\\.ms0p\\.events\\.prefs$", "^com\\.ibm\\.explorer\\.remote\\.admin\\.prefs$"};
    private static final String[] LAUNCH_REGEX = new String[]{"^.*\\.launch$"};
    private static final String[] WORKSPACE_REGEX = new String[]{"^workspace-.*$"};
    private static final String[] STANDALONE_WORKSPACE_REGEX = new String[]{"^workspace$"};
    private static final String MARKER_FILE_REGEX = "^WMQ_[0-9]+\\.[0-9]+.*txt$";

    public WorkspaceManager(Trace t) {
        try {
            String pluginVersion = UiPlugin.getDefault().getBundle().getVersion().toString();
            String[] digits = pluginVersion.split("\\.");
            CURRENT_VERSION_NUMBER = Integer.valueOf(digits[0]);
            CURRENT_RELEASE_NUMBER = Integer.valueOf(digits[1]);
            t.data(67, "WorkspaceManager.WorkspaceManager", 300, "Version Identified as " + CURRENT_VERSION_NUMBER);
            t.data(67, "WorkspaceManager.WorkspaceManager", 300, "Release Identified as " + CURRENT_RELEASE_NUMBER);
        }
        catch (NumberFormatException nfe) {
            t.FFST(66, "WorkspaceManager.WorkspaceManager", 10, -1, 0, 0, nfe.getMessage(), null, null);
        }
    }

    public boolean isNewWorkspace(Trace t) {
        File directory = new File(UiPlugin.getDefault().getStateLocation().toOSString());
        if (UiPlugin.WMQ_VERSION_MARKER != null && new File(directory, UiPlugin.WMQ_VERSION_MARKER).exists()) {
            return false;
        }
        File[] contents = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().matches(WorkspaceManager.MARKER_FILE_REGEX);
            }
        });
        return contents.length <= 0;
    }

    public boolean checkWorkspace(Trace t) {
        String msg;
        Message msgFile;
        boolean success = true;
        String workspaceLocation = null;
        try {
            workspaceLocation = UiPlugin.getDefault().getStateLocation().toString();
        }
        catch (IllegalStateException illegalStateException) {
            Message msgFile2 = null;
            try {
                msgFile2 = CommonServices.loadSystemMessages((Trace)t);
            }
            catch (CommonServicesException e1) {
                MessageBox.showExceptionMessage(t, UiPlugin.getShell(), e1);
                success = false;
            }
            if (msgFile2 != null) {
                String msg2 = msgFile2.getMessage(t, "AMQ4146");
                MessageBox.showMessageFailure(t, UiPlugin.getShell(), msg2, "AMQ4146");
                success = false;
            }
            success = false;
        }
        boolean writeable = true;
        if (success) {
            FileWriter file = null;
            try {
                file = new FileWriter(String.valueOf(workspaceLocation) + File.separator + "testFile.txt");
                file.close();
            }
            catch (IOException iOException) {
                writeable = false;
            }
        }
        if (success && !writeable) {
            msgFile = null;
            try {
                msgFile = CommonServices.loadSystemMessages((Trace)t);
            }
            catch (CommonServicesException e1) {
                MessageBox.showExceptionMessage(t, UiPlugin.getShell(), e1);
                success = false;
            }
            if (msgFile != null) {
                msg = msgFile.getMessage(t, "AMQ4147", workspaceLocation);
                MessageBox.showMessageFailure(t, UiPlugin.getShell(), msg, "AMQ4147");
                success = false;
            } else {
                success = false;
            }
        }
        if (success && writeable && !UiPlugin.isOnlyExplorerInstance(t)) {
            msgFile = null;
            try {
                msgFile = CommonServices.loadSystemMessages((Trace)t);
            }
            catch (CommonServicesException e1) {
                MessageBox.showExceptionMessage(t, UiPlugin.getShell(), e1);
                success = false;
            }
            if (msgFile != null) {
                msg = msgFile.getMessage(t, "AMQ4574");
                MessageBox.showMessageFailure(t, UiPlugin.getShell(), msg, "AMQ4574");
                success = false;
            } else {
                success = false;
            }
            if (Trace.isTracing) {
                t.data(67, "WorkspaceManager.checkWorkspace", 900, "unable to claim lock, Explorer already running");
            }
        }
        return success;
    }

    public void checkAndPeformMigration(Trace t) {
        List<WorkspaceDescriptor> workspaces = this.findWorkspaces(t);
        if (!workspaces.isEmpty()) {
            if (workspaces.size() == 1 && workspaces.get(0).canMigrateSilently()) {
                this.migrateWorkspace(t, workspaces.get(0));
            } else {
                WorkspaceDescriptor selectedWorkspace;
                WorkspaceMigrationDialog woMiDlg = new WorkspaceMigrationDialog(t, null, workspaces);
                if (woMiDlg.open() == 0 && (selectedWorkspace = woMiDlg.getSelectedWorkspace()) != null) {
                    this.migrateWorkspace(t, selectedWorkspace);
                }
            }
        }
    }

    private void migrateWorkspace(Trace t, WorkspaceDescriptor workspaceDescriptor) {
        String oldPluginsDirectory = String.valueOf(workspaceDescriptor.getLocation()) + PLUGIN_DIRECTORY;
        Path oldPluginsPath = new Path(oldPluginsDirectory);
        Path newPluginsPath = new Path(UiPlugin.getDefault().getStateLocation().toOSString());
        newPluginsPath = newPluginsPath.removeLastSegments(1);
        Path oldWorkspacePath = new Path(workspaceDescriptor.getLocation());
        IPath newWorkspacePath = newPluginsPath.removeLastSegments(2);
        IPath oldLaunchPath = oldPluginsPath.append(LAUNCHES_DIRECTORY);
        IPath newLaunchPath = newPluginsPath.append(LAUNCHES_DIRECTORY);
        File oldLaunchFolder = new File(oldLaunchPath.toString());
        IPath oldPrefPath = oldPluginsPath.append(PREFERENCE_DIRECTORY);
        IPath newPrefPath = newPluginsPath.append(PREFERENCE_DIRECTORY);
        File oldPrefFile = new File(oldPrefPath.toString());
        List<String> pluginFolders = this.findPluginFoldersToMigrate(t, workspaceDescriptor);
        List<String> projectFolders = this.findProjectFoldersToMigrate(t, workspaceDescriptor);
        List<String> launchFiles = this.findFilesToMigrate(t, oldLaunchFolder, LAUNCH_REGEX);
        List<String> prefFiles = this.findFilesToMigrate(t, oldPrefFile, PREFERENCE_REGEX);
        boolean result = true;
        t.data(67, "WorkspaceManager.migrateWorkspace", 300, "Migrating User Workspace: " + workspaceDescriptor.getLocation());
        result = this.copyFromPath(t, (IPath)oldPluginsPath, (IPath)newPluginsPath, pluginFolders);
        result = result && this.copyFromPath(t, (IPath)oldWorkspacePath, newWorkspacePath, projectFolders);
        result = result && this.copyFromPath(t, oldLaunchPath, newLaunchPath, launchFiles);
        result = result && this.copyFromPath(t, oldPrefPath, newPrefPath, prefFiles);
        t.data(67, "WorkspaceManager.migrateWorkspace", 300, "Migration Successful: " + result);
        if (result) {
            System.out.println("Migrated workspace at \"" + oldWorkspacePath + "\" to \"" + newWorkspacePath + "\"");
        } else {
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4549", (String)oldPluginsDirectory);
            MessageBox.showMessageFailure(t, UiPlugin.getShell(), msg, "AMQ4549");
        }
        PersistQueueManagerHandles.invalidateHandles();
        this.migratedWorkspace = workspaceDescriptor;
    }

    private boolean copyFromPath(Trace t, IPath fromPath, IPath toPath, List<String> toCopy) {
        IFileSystem userFileSys = EFS.getLocalFileSystem();
        boolean result = true;
        for (String file : toCopy) {
            try {
                IPath oldPath = fromPath.append(file);
                IPath newPath = toPath.append(file);
                IFileStore oldFolder = userFileSys.getStore(oldPath);
                if (oldFolder.fetchInfo().isDirectory()) {
                    String[] files = oldFolder.childNames(0, null);
                    ArrayList<String> listFiles = new ArrayList<String>();
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String curFile = stringArray[n2];
                        listFiles.add(curFile);
                        ++n2;
                    }
                    result = this.copyFromPath(t, oldPath, newPath, listFiles);
                    continue;
                }
                if (file.endsWith(".lck")) continue;
                newPath = newPath.removeLastSegments(1);
                IFileStore newFolder = userFileSys.getStore(newPath);
                if (!oldFolder.fetchInfo().exists()) continue;
                newFolder.mkdir(2, null);
                newFolder = userFileSys.getStore(toPath.append(file));
                oldFolder.copy(newFolder, 2, null);
            }
            catch (CoreException e) {
                t.FFST(66, "WorkspaceManager.copyFromPath", 10, -1, 0, 0, e.getMessage(), null, null);
                result = false;
            }
        }
        return result;
    }

    private List<String> findPluginFoldersToMigrate(Trace t, WorkspaceDescriptor workspaceDesc) {
        String workspacePluginPath = String.valueOf(workspaceDesc.getLocation()) + PLUGIN_DIRECTORY;
        File searchFolder = new File(workspacePluginPath);
        List<String> foundFolders = this.findFilesToMigrate(t, searchFolder, FOLDER_REGEX);
        if (foundFolders.contains(SERVICE_DEF_DIRECTORY)) {
            workspaceDesc.setHasServiceDef(true);
        }
        return foundFolders;
    }

    private List<String> findProjectFoldersToMigrate(Trace t, WorkspaceDescriptor workspaceDesc) {
        File searchFolder = new File(workspaceDesc.getLocation());
        ArrayList<String> projectsToFind = new ArrayList<String>();
        if (workspaceDesc.hasServiceDef()) {
            projectsToFind.addAll(this.findServiceDefProjectFolders(t, workspaceDesc));
        }
        List<String> foundFolders = this.findFilesToMigrate(t, searchFolder, projectsToFind.toArray(new String[0]));
        return foundFolders;
    }

    private List<String> findFilesToMigrate(Trace t, File searchFolder, String[] regex) {
        ArrayList<String> foundFolders = new ArrayList<String>();
        String[] stringArray = regex;
        int n = regex.length;
        int n2 = 0;
        while (n2 < n) {
            String projectMatcher = stringArray[n2];
            final String currentMatcher = projectMatcher;
            File[] matchingFolders = searchFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().matches(currentMatcher);
                }
            });
            if (matchingFolders != null) {
                File[] fileArray = matchingFolders;
                int n3 = matchingFolders.length;
                int n4 = 0;
                while (n4 < n3) {
                    File matchingFile = fileArray[n4];
                    foundFolders.add(matchingFile.getName());
                    ++n4;
                }
            }
            ++n2;
        }
        return foundFolders;
    }

    private List<String> findServiceDefProjectFolders(Trace t, WorkspaceDescriptor workspaceDesc) {
        ArrayList<String> foundFolders = new ArrayList<String>();
        try {
            String pathToService = String.valueOf(workspaceDesc.getLocation()) + PLUGIN_DIRECTORY + "/" + SERVICE_DEF_DIRECTORY + "/" + SERVICE_DEF_METADATA;
            if (new File(pathToService).exists()) {
                IMemento[] serviceDefRepos;
                FileInputStream fileStream = new FileInputStream(pathToService);
                InputStreamReader inputStreamReader = new InputStreamReader(fileStream);
                BufferedReader inputStringReader = new BufferedReader(inputStreamReader);
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = inputStringReader.readLine()) != null) {
                    if (line.contains("ServiceDefinitionRepositories.dtd")) continue;
                    sb.append(String.valueOf(line) + "\n");
                }
                inputStringReader.close();
                StringReader inputReader = new StringReader(sb.toString());
                XMLMemento readRoot = XMLMemento.createReadRoot((Reader)inputReader);
                IMemento[] iMementoArray = serviceDefRepos = readRoot.getChildren("SeviceDefinitionRepository");
                int n = serviceDefRepos.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento repo = iMementoArray[n2];
                    String repoFolder = repo.getString("name");
                    foundFolders.add(repoFolder);
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            t.FFST(66, "WorkspaceManager.findServiceDefProjectFolders", 10, -1, 0, 0, e.getMessage(), null, null);
        }
        catch (WorkbenchException e) {
            t.FFST(66, "WorkspaceManager.findServiceDefProjectFolders", 10, -1, 0, 0, e.getMessage(), null, null);
        }
        return foundFolders;
    }

    private List<WorkspaceDescriptor> findWorkspaces(Trace t) {
        WorkspaceDescriptor workspace;
        ArrayList<WorkspaceDescriptor> workspaces = new ArrayList<WorkspaceDescriptor>();
        ArrayList<WorkspaceDescriptor> foundWorkspaces = new ArrayList<WorkspaceDescriptor>();
        String oldWorkspacePath = null;
        oldWorkspacePath = CommonServices.PLATFORM_ID == 1 ? String.valueOf(System.getenv().get(OLD_ENV_VAR_WIN)) + WORKSPACE_PATH_OLD_WIN : String.valueOf(System.getProperty(WORKSPACE_HOME_PREFIX)) + WORKSPACE_PATH_OLD_LINUX;
        WorkspaceDescriptor desc = this.getDescriptorFromDir(t, oldWorkspacePath);
        if (desc != null) {
            foundWorkspaces.add(desc);
        }
        String newWorkspacePath = String.valueOf(System.getProperty(WORKSPACE_HOME_PREFIX)) + WORKSPACE_PATH;
        File searchFolder = new File(newWorkspacePath);
        List<String> potentialWorkspaces = this.findFilesToMigrate(t, searchFolder, WORKSPACE_REGEX);
        for (String workspaceName : potentialWorkspaces) {
            WorkspaceDescriptor workspace2 = this.getDescriptorFromDir(t, String.valueOf(newWorkspacePath) + File.separator + workspaceName);
            if (workspace2 == null) continue;
            foundWorkspaces.add(workspace2);
        }
        List<String> standaloneWorkspaces = this.findFilesToMigrate(t, searchFolder, STANDALONE_WORKSPACE_REGEX);
        if (standaloneWorkspaces.size() == 1 && (workspace = this.getDescriptorFromDir(t, String.valueOf(newWorkspacePath) + File.separator + standaloneWorkspaces.get(0))) != null) {
            workspace.setStandalone(t);
            foundWorkspaces.add(workspace);
        }
        for (WorkspaceDescriptor descriptor : foundWorkspaces) {
            if (descriptor.getWorkspaceVersion() >= CURRENT_VERSION_NUMBER && (descriptor.getWorkspaceVersion() != CURRENT_VERSION_NUMBER || descriptor.getWorkspaceRelease() > CURRENT_RELEASE_NUMBER)) continue;
            workspaces.add(descriptor);
        }
        return workspaces;
    }

    private WorkspaceDescriptor getDescriptorFromDir(Trace t, String workspacePath) {
        File directory = new File(String.valueOf(workspacePath) + PLUGIN_DIRECTORY + UIPLUGIN_METADATA);
        WorkspaceDescriptor workspaceDesc = null;
        if (directory.exists()) {
            int mqVer = -1;
            int mqRel = -1;
            File[] contents = directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().matches(WorkspaceManager.MARKER_FILE_REGEX);
                }
            });
            if (contents.length > 0) {
                File versionMarkerFile = this.getLatestVersionMarker(t, contents);
                String versionMarker = versionMarkerFile.getName().substring(4);
                String[] digits = versionMarker.split("\\.");
                try {
                    mqVer = Integer.valueOf(digits[0]);
                    mqRel = Integer.valueOf(digits[1]);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                File handlesFile = new File(directory, "WMQ_Handles.xml");
                if (handlesFile.exists()) {
                    mqVer = 6;
                    mqRel = 0;
                }
            }
            if (mqVer > -1 && mqRel > -1) {
                IPath workspaceIPath = Path.fromOSString((String)workspacePath);
                workspaceDesc = new WorkspaceDescriptor(t, workspaceIPath.toOSString(), mqVer, mqRel);
            }
        }
        return workspaceDesc;
    }

    private File getLatestVersionMarker(Trace t, File[] markers) {
        File versionMarker = markers[0];
        int highestVer = -1;
        int highestRel = -1;
        File[] fileArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            File currentMarker = fileArray[n2];
            String versionString = currentMarker.getName().substring(4);
            String[] digits = versionString.split("\\.");
            try {
                int mqVer = Integer.valueOf(digits[0]);
                int mqRel = Integer.valueOf(digits[1]);
                if (mqVer > highestVer || mqVer == highestVer && mqRel > highestRel) {
                    versionMarker = currentMarker;
                    highestVer = mqVer;
                    highestRel = mqRel;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        return versionMarker;
    }

    public WorkspaceDescriptor getMigratedWorkspace() {
        return this.migratedWorkspace;
    }
}

