/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.BaseMQInstallationDetails;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.io.File;

public class WorkspaceDescriptor {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/WorkspaceDescriptor.java";
    private String location;
    private String installationName;
    private static String DEFAULT_INSTALL_NAME = null;
    private String installationDesc;
    private int workspaceVersion;
    private int workspaceRelease;
    private String vrmfString;
    private int installationState;
    private boolean hasServiceDef;
    private static final String WORKSPACE_PREFIX = "workspace-";
    public static final int INSTALLED = 1;
    public static final int NOT_INSTALLED = 0;
    public static final int UNKNOWN_INSTALL = -1;

    public WorkspaceDescriptor(Trace t, String path, int version, int release) {
        BaseMQInstallationDetails details;
        if (DEFAULT_INSTALL_NAME == null) {
            Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
            DEFAULT_INSTALL_NAME = msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.DefaultInstall.Name");
        }
        this.location = path;
        this.workspaceVersion = version;
        this.workspaceRelease = release;
        this.hasServiceDef = false;
        this.installationState = 0;
        this.installationName = this.getInstallationName(t, path);
        String lookupName = this.installationName;
        if (lookupName.equals(DEFAULT_INSTALL_NAME)) {
            lookupName = "Installation0";
        }
        if ((details = this.getInstallationDetails(t, lookupName)) != null) {
            this.installationDesc = details.description;
            this.vrmfString = details.VRMF;
            this.installationState = details.valid ? 1 : 0;
        }
        if (this.vrmfString == null || this.vrmfString.equals("")) {
            this.vrmfString = String.valueOf(this.workspaceVersion) + "." + this.workspaceRelease;
        }
        if (this.installationDesc == null) {
            this.installationDesc = "";
        }
    }

    private String getInstallationName(Trace t, String path) {
        String lastSegment;
        String installName = DEFAULT_INSTALL_NAME;
        if (path.lastIndexOf(File.separator) + 1 <= path.length() && (lastSegment = path.substring(path.lastIndexOf(File.separator) + 1)).startsWith(WORKSPACE_PREFIX)) {
            installName = lastSegment.replaceFirst(WORKSPACE_PREFIX, "");
        }
        return installName;
    }

    private BaseMQInstallationDetails getInstallationDetails(Trace t, String installName) {
        BaseMQInstallationDetails detail;
        block4: {
            detail = null;
            try {
                BaseMQInstallationDetails[] details;
                BaseMQInstallationDetails[] baseMQInstallationDetailsArray = details = NativeCalls.getInstallationDetails((Trace)t);
                int n = details.length;
                int n2 = 0;
                while (n2 < n) {
                    BaseMQInstallationDetails install = baseMQInstallationDetailsArray[n2];
                    if (install.name.equalsIgnoreCase(installName)) {
                        detail = install;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CommonServicesException e) {
                if (!Trace.isTracing) break block4;
                t.data(64, "WorkspaceDescriptor.getInstallationDetails", 900, "Error getting installation details\n" + (Object)((Object)e));
            }
        }
        return detail;
    }

    public boolean canMigrateSilently() {
        return this.installationState == 0 && (this.workspaceVersion < 7 || this.workspaceVersion == 7 && this.workspaceRelease == 0);
    }

    public String getLocation() {
        return this.location;
    }

    public int getWorkspaceVersion() {
        return this.workspaceVersion;
    }

    public String getWorkspaceVersionString() {
        return this.vrmfString;
    }

    public int getWorkspaceRelease() {
        return this.workspaceRelease;
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public String getInstallationDesc() {
        return this.installationDesc;
    }

    public int getInstallationState() {
        return this.installationState;
    }

    public void setHasServiceDef(boolean serviceDef) {
        this.hasServiceDef = serviceDef;
    }

    public boolean hasServiceDef() {
        return this.hasServiceDef;
    }

    public void setStandalone(Trace t) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        this.installationName = msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.SupportPac.Name.Title");
        this.installationDesc = msgFile.getMessage(t, "UI.WorkspaceMigration.Dialog.SupportPac.Desc.Title");
        this.installationState = -1;
        this.vrmfString = String.valueOf(this.workspaceVersion) + "." + this.workspaceRelease;
    }

    public String toString() {
        String toString = this.installationName;
        toString = String.valueOf(toString) + " (V" + this.getWorkspaceVersionString() + ")";
        return toString;
    }
}

