/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.commonservices.internal.utils.UiDisplayData;
import com.ibm.mq.explorer.core.internal.base.DataModel;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmErrorEvent;
import com.ibm.mq.explorer.core.internal.event.DmErrorListener;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.plugins.internal.trace.Names;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.IContentPageFactory;
import com.ibm.mq.explorer.ui.extensions.IExplorerNotify;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.QueueManagerConnectionException;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.base.ActionFilterManager;
import com.ibm.mq.explorer.ui.internal.base.ContentPageFactoryManager;
import com.ibm.mq.explorer.ui.internal.base.IRemoteQmgrConnection;
import com.ibm.mq.explorer.ui.internal.base.IRemoteQmgrConnectionFactory;
import com.ibm.mq.explorer.ui.internal.base.InitialiseExplorer;
import com.ibm.mq.explorer.ui.internal.base.NotificationManager;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.PropertyTabFactoryManager;
import com.ibm.mq.explorer.ui.internal.base.QueueManagerList;
import com.ibm.mq.explorer.ui.internal.base.TreeNodeDeletedEvent;
import com.ibm.mq.explorer.ui.internal.base.TreeNodeDeletedListener;
import com.ibm.mq.explorer.ui.internal.base.TreeNodeFactoryManager;
import com.ibm.mq.explorer.ui.internal.base.WorkspaceDescriptor;
import com.ibm.mq.explorer.ui.internal.base.WorkspaceManager;
import com.ibm.mq.explorer.ui.internal.base.ZosQueueManagerList;
import com.ibm.mq.explorer.ui.internal.dragdrop.DragDropManager;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.importexport.ExplorerImportExportFilters;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportCategory;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportCategoryManager;
import com.ibm.mq.explorer.ui.internal.machine.UiMachine;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.navigator.NavigatorContentProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.passwords.PwStoreManager;
import com.ibm.mq.explorer.ui.internal.plugins.PluginRegistrationManager;
import com.ibm.mq.explorer.ui.internal.plugins.PluginsChangedEvent;
import com.ibm.mq.explorer.ui.internal.plugins.PluginsChangedListener;
import com.ibm.mq.explorer.ui.internal.plugins.RegisteredPlugin;
import com.ibm.mq.explorer.ui.internal.preferences.ImportExportPreferences;
import com.ibm.mq.explorer.ui.internal.queuemanager.IQueueManagerDisconnectActionListener;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerDisconnectActionEvent;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.views.ExplorerViewPart;
import com.ibm.mq.explorer.ui.internal.views.MQContentView;
import com.ibm.mq.explorer.ui.internal.views.MQNavigatorView;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UiPlugin
extends AbstractUIPlugin
implements DmErrorListener,
IPropertyChangeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/UiPlugin.java";
    public static final String UI_EXPLORER_DOCUMENT_ROOT = "/com.ibm.mq.explorer.doc/";
    public static final String UI_REFRESH_TIMER_DELAY = "UI.RefreshTimerDelay";
    public static final int UI_DEFAULT_REFRESH_TIMER_DELAY = 1000;
    public static final String UI_RESIZE_COLUMNS_TIMER_DELAY = "UI.ResizeColumnsTimerDelay";
    public static final int UI_DEFAULT_RESIZE_COLUMNS_TIMER_DELAY = 1000;
    public static final String UI_EXPLORERTABLE_UPDATE_BATCH_SIZE = "UI.ExplorerTableUpdateBatchSize";
    public static final int UI_DEFAULT_EXPLORERTABLE_UPDATE_BATCH_SIZE = 100;
    public static final int UI_PROGRESS_DIALOG_MINTIME_MAX_VALUE = 60;
    public static final int UI_PROGRESS_DIALOG_MINTIME_MIN_VALUE = 0;
    private static UiPlugin plugin = null;
    private static Message uiGeneralMessages = null;
    protected static Trace trace = null;
    private static File persistentFileLocation = null;
    private static String stateLocation = null;
    private static AttributeOrderManager attrOrderManager = null;
    private static FilterManager filterManager = null;
    private static PluginRegistrationManager pluginRegistrationManager = null;
    private static TreeNodeFactoryManager treeNodeFactoryManager = null;
    private static PropertyTabFactoryManager propertyTabFactoryManager = null;
    private static ContentPageFactoryManager contentPageFactoryManager = null;
    protected static NotificationManager notificationManager = null;
    private static ImportExportCategoryManager catManager = null;
    private static ActionFilterManager actionFilterManager = null;
    private static DragDropManager dragDropManager = null;
    private static UiMachine uiMachine = null;
    private static Color colorDisabled = null;
    private static Color colorConsoleBackground = null;
    private static Color colorConsoleCommand = null;
    private static Color colorConsoleStdout = null;
    private static Color colorConsoleStderr = null;
    private static Color colorConsoleResult = null;
    private static List<MQNavigatorView> navigatorViews;
    private static Vector<ExplorerViewPart> contentViews;
    private static Icons icons;
    private static QueueManagerList queueManagerList;
    private static ZosQueueManagerList zosQueueManagerList;
    private static boolean mqNavigatorViewInit;
    private static boolean mqContentViewInit;
    protected static MQExtObject dummyExtObject;
    private static int refreshTimerDelay;
    private static int resizeColumnsTimerDelay;
    protected static boolean isRefreshTimerRunning;
    private static String refreshObjectId;
    private static boolean refreshIsRebuildTree;
    private static Vector<TreeNodeDeletedListener> treeNodeDeletedListeners;
    protected static boolean isShutdownInProgress;
    private static boolean isAbnormalShutdownPending;
    private static boolean isPersistOnShutdown;
    private static int explorerTableUpdateBatchSize;
    private static FileLock fileLock;
    private static Vector<IQueueManagerDisconnectActionListener> disconnectActionListeners;
    private static boolean isRCPMode;
    private static ExplorerImportExportFilters expImportExport;
    private static ObjectRegistrationManager objectRegManager;
    private static DataModel theDataModel;
    private static PwStoreManager passwordStoreManager;
    private static boolean isShowSystemObjects;
    private static IRemoteQmgrConnectionFactory remoteQmgrConnectionFactory;
    IPerspectiveListener perspectiveListener;
    private static WorkspaceManager workspaceManager;
    static String WMQ_VERSION_MARKER;
    private static boolean hasInitialized;

    static {
        contentViews = null;
        icons = null;
        queueManagerList = null;
        zosQueueManagerList = null;
        mqNavigatorViewInit = false;
        mqContentViewInit = false;
        dummyExtObject = null;
        refreshTimerDelay = 1000;
        resizeColumnsTimerDelay = 1000;
        isRefreshTimerRunning = false;
        refreshObjectId = null;
        refreshIsRebuildTree = false;
        treeNodeDeletedListeners = null;
        isShutdownInProgress = false;
        isAbnormalShutdownPending = false;
        isPersistOnShutdown = true;
        explorerTableUpdateBatchSize = 100;
        fileLock = null;
        disconnectActionListeners = null;
        isRCPMode = false;
        expImportExport = null;
        objectRegManager = null;
        theDataModel = null;
        passwordStoreManager = null;
        isShowSystemObjects = false;
        remoteQmgrConnectionFactory = null;
        workspaceManager = null;
        WMQ_VERSION_MARKER = null;
        hasInitialized = false;
        CommonServices.registerTraceNames((int)67, com.ibm.mq.explorer.ui.internal.trace.Names.getMethodNames());
        CommonServices.registerTraceNames((int)66, (HashMap)Names.getMethodNames());
    }

    public UiPlugin() {
        plugin = this;
        dummyExtObject = new MQExtObject(null, null, "", "", "");
    }

    private boolean startupCheck() {
        boolean success = true;
        Trace t = Trace.getDefault();
        if (!workspaceManager.checkWorkspace(t) && success) {
            success = false;
        }
        return success;
    }

    public void startup() {
        Shell shell;
        this.setEnvironment();
        CommonServicesException csException = null;
        try {
            CommonServices.setWMQJavaTraceClass(MQEnvironment.class);
            CommonServices.processInitialize((Trace)Trace.getDefault(), (boolean)true);
        }
        catch (CommonServicesException cse) {
            cse.printStackTrace();
            csException = cse;
        }
        stateLocation = this.getStateLocation().toOSString();
        String version = this.getBundle().getVersion().toString();
        WMQ_VERSION_MARKER = "WMQ_" + version + ".txt";
        CommonServices.setWorkingDir((File)new File(stateLocation));
        trace = InitialiseExplorer.initialise(this);
        uiGeneralMessages = new Message(trace, "com.ibm.mq.explorer.ui.internal.base.UIStrings", ((Object)((Object)plugin)).getClass().getClassLoader());
        icons = new Icons(trace);
        if (csException != null) {
            trace.data(67, "UiPlugin.startup", 300, "Error initializing common services");
            trace.FFST(67, "UiPlugin.startup", 10, 50018, 0, 0);
            Message msgfile = UiPlugin.getUIMessages(trace, "KEY_General");
            String msg = msgfile.getMessage(trace, "UI.GENERAL.UIPLUGIN.STARTUP.ERROR");
            MessageBox.showMessageFailure(trace, UiPlugin.getShell(), msg, (Exception)((Object)csException), csException.getMessageID());
        }
        workspaceManager = new WorkspaceManager(trace);
        if (!this.startupCheck()) {
            trace.data(67, "UiPlugin.startup", 300, "Error performing startup check.  Closing the workbench.");
            PlatformUI.getWorkbench().close();
            return;
        }
        if (workspaceManager.isNewWorkspace(trace)) {
            workspaceManager.checkAndPeformMigration(trace);
        }
        UiPlugin.logStartupData(Trace.getDefault(), 67, "UiPlugin.startup", this.getBundle());
        String productID = System.getProperty("eclipse.product");
        trace.data(67, "UiPlugin.startup", "eclipse.product=" + productID);
        String installName = CommonServices.getInstallationName((Trace)trace);
        if (installName != null && installName.length() > 0 && (shell = UiPlugin.getShell()) != null && !shell.isDisposed()) {
            String txt = shell.getText();
            shell.setText(String.valueOf(txt) + " (" + installName + ")");
        }
        navigatorViews = new ArrayList<MQNavigatorView>();
        contentViews = new Vector();
        treeNodeDeletedListeners = new Vector();
        disconnectActionListeners = new Vector();
        persistentFileLocation = this.getStateLocation().toFile();
        expImportExport = new ExplorerImportExportFilters();
        theDataModel = new DataModel();
        if (!CommonServices.isMqjbnd() && CommonServices.getMqInstallType() == 1) {
            trace.data(67, "UiPlugin.startup", "Failed to load MQJBND! - and we are a server box!");
        }
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        UiPlugin.setDefaultPreferences(trace, store);
        this.notifyDataModelWithLocalQmgrRefreshRate(trace);
        pluginRegistrationManager = new PluginRegistrationManager(trace);
        pluginRegistrationManager.loadPluginRegistrations(trace);
        icons.loadIconRegistrations(trace);
        notificationManager = new NotificationManager(trace);
        notificationManager.loadExplorerNotificationClasses(trace);
        dragDropManager = new DragDropManager(trace);
        contentPageFactoryManager = new ContentPageFactoryManager(trace);
        contentPageFactoryManager.loadContentPageFactories(trace);
        actionFilterManager = new ActionFilterManager();
        actionFilterManager.loadActionFilterClasses(trace);
        UiPlugin.getPrefStore().addPropertyChangeListener((IPropertyChangeListener)this);
        IPartListener2 partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                int numEditors = partRef.getPage().getEditorReferences().length;
                if (numEditors == 0) {
                    partRef.getPage().setEditorAreaVisible(false);
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null) {
            window.getActivePage().addPartListener(partListener);
        }
        Job job = new Job(uiGeneralMessages.getMessage(trace, "UI.Job.Initialization")){

            protected IStatus run(IProgressMonitor monitor) {
                UiPlugin.this.delayedStartup(Trace.getDefault());
                return Status.OK_STATUS;
            }
        };
        job.schedule(100L);
    }

    private void delayedStartup(Trace t) {
        block5: {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            boolean b = store.getBoolean("UseridEnabled");
            int tmpState = b ? 1 : 0;
            b = store.getBoolean("UseridCompatibilityMode");
            int tmpCompat = b ? 1 : 0;
            int tmpPasswordMode = store.getInt("UseridPasswordMode");
            String tmpUserid = store.getString("UseridName");
            String tmpPassword = store.getString("UseridPassword");
            QueueManagerHandle.setDefaultUseridState((int)tmpState);
            QueueManagerHandle.setDefaultUserid((String)tmpUserid);
            QueueManagerHandle.setDefaultPassword((String)tmpPassword);
            QueueManagerHandle.setDefaultCompatMode((int)tmpCompat);
            QueueManagerHandle.setDefaultPasswordMode((int)tmpPasswordMode);
            this.loadPendingPersistentFiles(trace);
            try {
                theDataModel.init(trace, stateLocation);
            }
            catch (DmCoreException ce) {
                ce.printStackTrace();
                trace.data(67, "UiPlugin.delayedStartup", 300, "Error initializing data model");
                trace.FFST(67, "UiPlugin.delayedStartup", 20, 50018, 0, 0);
            }
            theDataModel.addSystemErrorListener(trace, new DmErrorListener(){

                public void dmOnError(final DmErrorEvent event) {
                    if (event.getException() != null) {
                        switch (event.getException().getReasonCode()) {
                            case 50018: 
                            case 50042: {
                                UiPlugin.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageBox.showExceptionMessage(trace, UiPlugin.getShell(), event.getException());
                                    }
                                });
                                break;
                            }
                            default: {
                                String msg = "unhandled central exception caught - msg: " + event.getException().getMessage() + " rc: " + event.getException().getReasonCode() + " cc: " + event.getException().getCompCode();
                                trace.data(67, "UiPlugin.delayedStartup", msg);
                            }
                        }
                    }
                }
            });
            objectRegManager = new ObjectRegistrationManager(trace);
            objectRegManager.loadObjectRegistrations(trace);
            objectRegManager.loadAssociatedProviders(trace);
            zosQueueManagerList = new ZosQueueManagerList();
            queueManagerList = new QueueManagerList();
            queueManagerList.open(trace);
            IUiMQObjectFactory uiMachineFactory = ObjectRegistrationManager.getUiMQObjectFactory(trace, "com.ibm.mq.explorer.wmq");
            uiMachine = (UiMachine)uiMachineFactory.create(trace, (IDmObject)theDataModel.getMachine(trace), null);
            attrOrderManager = new AttributeOrderManager(trace, persistentFileLocation);
            filterManager = new FilterManager(trace, persistentFileLocation);
            treeNodeFactoryManager = new TreeNodeFactoryManager(trace);
            treeNodeFactoryManager.loadTreeNodeFactories(trace);
            propertyTabFactoryManager = new PropertyTabFactoryManager(trace);
            propertyTabFactoryManager.loadPropertyTabFactories(trace);
            catManager = new ImportExportCategoryManager(trace);
            catManager.loadImportExportCategories(trace);
            pluginRegistrationManager.addChangeListener(trace, new PluginsChangedListener(){

                @Override
                public void pluginsChanged(PluginsChangedEvent event) {
                    ArrayList<RegisteredPlugin> plugins = event.getChangedRegisteredPlugins();
                    int k = 0;
                    while (k < plugins.size()) {
                        RegisteredPlugin regPlugin = plugins.get(k);
                        ExplorerNotifyEvent explorerNotifyEvent = new ExplorerNotifyEvent(dummyExtObject, regPlugin.getPlugin_id());
                        if (regPlugin.isEnabled()) {
                            notificationManager.notifyPluginEnabled(trace, explorerNotifyEvent);
                        } else {
                            notificationManager.notifyPluginDisabled(trace, explorerNotifyEvent);
                        }
                        ++k;
                    }
                }
            });
            this.loadDisabledColor(trace);
            this.loadConsoleResultColor(trace);
            this.loadConsoleBackgroundColor(trace);
            this.loadConsoleCommandColor(trace);
            this.loadConsoleStdoutColor(trace);
            this.loadConsoleStderrColor(trace);
            this.loadConsoleResultColor(trace);
            this.initialisePasswordManager(trace);
            if (WMQ_VERSION_MARKER != null) {
                try {
                    new File(stateLocation, WMQ_VERSION_MARKER).createNewFile();
                }
                catch (IOException e) {
                    if (!Trace.isTracing) break block5;
                    trace.data(67, "UiPlugin.delayedStartup", 900, "IOException writing version marker file: " + e.getMessage());
                }
            }
        }
        hasInitialized = true;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                UiPlugin.refreshNavigatorViews(trace, true);
            }
        });
    }

    public static void sendInitialization(Trace t, NavigatorContentProvider provider) {
        for (MQNavigatorView view : navigatorViews) {
            view.setNavigatorProvider(provider);
        }
        UiPlugin.sendPluginEnablementEvents(t);
        UiPlugin.sendInitialisationCompleteNotifications(t);
        if (!queueManagerList.isListening()) {
            queueManagerList.startListeningForChanges(t);
        }
    }

    private void setEnvironment() {
        IPath eclipsePath;
        String installLocation;
        URL url;
        Location location;
        int bitMode = 64;
        String bitModeProp = System.getProperty("com.ibm.vm.bitmode");
        if (bitModeProp != null && bitModeProp.equals("32")) {
            bitMode = 32;
        }
        if ((location = Platform.getInstallLocation()) != null && (url = location.getURL()) != null && (installLocation = url.getPath()).length() > 0 && (eclipsePath = new Path(installLocation).removeTrailingSeparator()).segmentCount() >= 2) {
            IPath mqPath = eclipsePath.removeLastSegments(2);
            this.setEnvironment(mqPath, bitMode);
        }
    }

    private void setEnvironment(IPath mqPath, int bitMode) {
        IPath mqJavaLibPath = null;
        IPath mqLibPath = null;
        String mqjbnd = null;
        switch (CommonServices.PLATFORM_ID) {
            case 1: {
                if (bitMode == 64) {
                    mqJavaLibPath = mqPath.append(String.valueOf(File.separator) + "java" + File.separator + "lib64");
                    mqLibPath = mqPath.append(String.valueOf(File.separator) + "bin64");
                } else {
                    mqJavaLibPath = mqPath.append(String.valueOf(File.separator) + "java" + File.separator + "lib");
                    mqLibPath = mqPath.append(String.valueOf(File.separator) + "bin");
                }
                mqjbnd = String.valueOf(mqJavaLibPath.toOSString()) + File.separator + "mqjbnd" + ".dll";
                break;
            }
            case 3: 
            case 5: {
                if (bitMode == 64) {
                    mqJavaLibPath = mqPath.append(String.valueOf(File.separator) + "java" + File.separator + "lib64");
                    mqLibPath = mqPath.append(String.valueOf(File.separator) + "lib64");
                } else {
                    mqJavaLibPath = mqPath.append(String.valueOf(File.separator) + "java" + File.separator + "lib");
                    mqLibPath = mqPath.append(String.valueOf(File.separator) + "lib");
                }
                mqjbnd = CommonServices.PLATFORM_ID == 3 ? String.valueOf(mqJavaLibPath.toOSString()) + File.separator + "lib" + "mqjbnd" + ".a" : (CommonServices.PLATFORM_ID == 28 ? String.valueOf(mqJavaLibPath.toOSString()) + File.separator + "lib" + "mqjbnd" + ".dylib" : String.valueOf(mqJavaLibPath.toOSString()) + File.separator + "lib" + "mqjbnd" + ".so");
            }
        }
        if (mqjbnd != null) {
            String libPath = String.valueOf(mqJavaLibPath.toOSString()) + File.pathSeparator + mqLibPath.toOSString();
            File mqjbndFile = new File(mqjbnd);
            if (mqjbndFile.exists()) {
                System.setProperty("java.library.path", libPath);
            } else {
                File mqJavaLibPathDir = new File(mqJavaLibPath.toOSString());
                if (mqJavaLibPathDir.exists()) {
                    String existingPath = System.getProperty("java.library.path");
                    System.setProperty("java.library.path", String.valueOf(existingPath) + File.pathSeparator + libPath);
                }
            }
        }
    }

    private void loadDisabledColor(Trace t) {
        if (colorDisabled != null) {
            colorDisabled.dispose();
        }
        String string = UiPlugin.getPrefStore().getString("InvalidCellColorRed");
        Integer red = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("InvalidCellColorGreen");
        Integer green = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("InvalidCellColorBlue");
        Integer blue = Integer.valueOf(string);
        colorDisabled = new Color((Device)UiPlugin.getDisplay(), red.intValue(), green.intValue(), blue.intValue());
    }

    private void loadConsoleResultColor(Trace t) {
        if (colorConsoleResult != null) {
            colorConsoleResult.dispose();
        }
        String string = UiPlugin.getPrefStore().getString("ConsoleResultColorRed");
        Integer red = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleResultColorGreen");
        Integer green = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleResultColorBlue");
        Integer blue = Integer.valueOf(string);
        colorConsoleResult = new Color((Device)UiPlugin.getDisplay(), red.intValue(), green.intValue(), blue.intValue());
    }

    private void loadConsoleBackgroundColor(Trace t) {
        if (colorConsoleBackground != null) {
            colorConsoleBackground.dispose();
        }
        String string = UiPlugin.getPrefStore().getString("ConsoleBackgroundColorRed");
        Integer red = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleBackgroundColorGreen");
        Integer green = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleBackgroundColorBlue");
        Integer blue = Integer.valueOf(string);
        colorConsoleBackground = new Color((Device)UiPlugin.getDisplay(), red.intValue(), green.intValue(), blue.intValue());
    }

    private void loadConsoleCommandColor(Trace t) {
        if (colorConsoleCommand != null) {
            colorConsoleCommand.dispose();
        }
        String string = UiPlugin.getPrefStore().getString("ConsoleCommandColorRed");
        Integer red = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleCommandColorGreen");
        Integer green = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleCommandColorBlue");
        Integer blue = Integer.valueOf(string);
        colorConsoleCommand = new Color((Device)UiPlugin.getDisplay(), red.intValue(), green.intValue(), blue.intValue());
    }

    private void loadConsoleStdoutColor(Trace t) {
        if (colorConsoleStdout != null) {
            colorConsoleStdout.dispose();
        }
        String string = UiPlugin.getPrefStore().getString("ConsoleStdoutColorRed");
        Integer red = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleStdoutColorGreen");
        Integer green = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleStdoutColorBlue");
        Integer blue = Integer.valueOf(string);
        colorConsoleStdout = new Color((Device)UiPlugin.getDisplay(), red.intValue(), green.intValue(), blue.intValue());
    }

    private void loadConsoleStderrColor(Trace t) {
        if (colorConsoleStderr != null) {
            colorConsoleStderr.dispose();
        }
        String string = UiPlugin.getPrefStore().getString("ConsoleStderrColorRed");
        Integer red = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleStderrColorGreen");
        Integer green = Integer.valueOf(string);
        string = UiPlugin.getPrefStore().getString("ConsoleStderrColorBlue");
        Integer blue = Integer.valueOf(string);
        colorConsoleStderr = new Color((Device)UiPlugin.getDisplay(), red.intValue(), green.intValue(), blue.intValue());
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static ArrayList<ITreeNodeFactory> getTreeNodeFactoriesArray() {
        return treeNodeFactoryManager.getTreeNodeFactoryArray();
    }

    public static boolean isPluginEnabledForTreeNodeFactory(Trace t, ITreeNodeFactory treeNodeFactory) {
        return treeNodeFactoryManager.isPluginEnabledForTreeNodeFactory(t, treeNodeFactory);
    }

    public static Hashtable<String, IContentPageFactory> getContentPageFactoriesTable() {
        return contentPageFactoryManager.getContentPageFactoryTable();
    }

    public static boolean isPluginEnabledForContentPageFactory(Trace t, IContentPageFactory contentPageFactory) {
        return contentPageFactoryManager.isPluginEnabledForContentPageFactory(t, contentPageFactory);
    }

    public static UiMachine getUiMachineObject() {
        return uiMachine;
    }

    public static Shell getShell() {
        IWorkbench wkbench = UiPlugin.getDefault().getWorkbench();
        IWorkbenchWindow win = wkbench.getActiveWorkbenchWindow();
        if (win != null) {
            return win.getShell();
        }
        IWorkbenchWindow[] wins = wkbench.getWorkbenchWindows();
        if (wins.length > 0) {
            return wins[0].getShell();
        }
        return null;
    }

    public static Display getDisplay() {
        Shell shell = UiPlugin.getShell();
        if (shell != null && !shell.isDisposed()) {
            return shell.getDisplay();
        }
        return Display.getCurrent();
    }

    public static void showBusyCursor(Trace t, boolean isBusy) {
        if (Trace.isTracing) {
            t.data(67, "UiPlugin.showBusyCursor", 300, "isBusy = " + isBusy);
        }
        Cursor busyCursor = null;
        if (isBusy) {
            busyCursor = UiPlugin.getDisplay().getSystemCursor(1);
        }
        UiPlugin.getShell().setCursor(busyCursor);
    }

    public static void showBusyCursor(Trace t, Shell shell, boolean isBusy) {
        if (Trace.isTracing) {
            t.data(67, "UiPlugin.showBusyCursor", 300, "isBusy = " + isBusy);
        }
        Cursor busyCursor = null;
        if (isBusy) {
            busyCursor = UiPlugin.getDisplay().getSystemCursor(1);
        }
        shell.setCursor(busyCursor);
    }

    public static Color getDisabledColor() {
        return colorDisabled;
    }

    public static Color getConsoleBackgroundColor() {
        return colorConsoleBackground;
    }

    public static Color getConsoleCommandColor() {
        return colorConsoleCommand;
    }

    public static Color getConsoleStdoutColor() {
        return colorConsoleStdout;
    }

    public static Color getConsoleStderrColor() {
        return colorConsoleStderr;
    }

    public static Color getConsoleResultColor() {
        return colorConsoleResult;
    }

    public static Color getReadonlyTextCtrlBackColor() {
        return UiPlugin.getDisplay().getSystemColor(22);
    }

    public static Message getUIMessages(Trace t, String msgResourceId) {
        Message message = null;
        message = uiGeneralMessages;
        if (Trace.isTracing) {
            t.data(67, "UiPlugin.getUIMessages", 300, "returning General Messages");
        }
        return message;
    }

    public static String getNLSString(Trace t, String fileKey, String textKey) {
        Message message = UiPlugin.getUIMessages(t, fileKey);
        String text = message.getMessage(textKey);
        return text;
    }

    public static PluginRegistrationManager getPluginRegistrationManager() {
        return pluginRegistrationManager;
    }

    public static boolean isPluginEnabled(String plugin_id) {
        boolean enabled = false;
        enabled = plugin_id.compareTo("com.ibm.mq.explorer.ui") == 0 ? true : (plugin_id.compareTo("com.ibm.mq.explorer.ui.zos") == 0 ? UiPlugin.isAnyKnownZOSQueueManagers(Trace.getDefault()) && pluginRegistrationManager.isPluginEnabled("com.ibm.mq.explorer.qmgradmin") : pluginRegistrationManager.isPluginEnabled(plugin_id));
        return enabled;
    }

    public static IPreferenceStore getPrefStore() {
        return UiPlugin.getDefault().getPreferenceStore();
    }

    private static void setDefaultPreferences(Trace t, IPreferenceStore store) {
        block2: {
            store.setDefault("ShowObjectStatus", false);
            store.setDefault("SuppressSuccessDialog", false);
            store.setDefault("RemoveAuthorityRecord", true);
            store.setDefault("SuppressManageAuthorityRecordDialog", true);
            store.setDefault("SortTables", true);
            int localRate = theDataModel.getQueueManagerRefreshInterval(t);
            String value = "" + localRate;
            store.setDefault("LocalDefaultRefreshRate", value);
            int remoteRate = theDataModel.getRemoteQueueManagerRefreshInterval(t);
            value = "" + remoteRate;
            store.setDefault("RemoteDefaultRefreshRate", value);
            value = "60";
            store.setDefault("MonitorRefreshRate", value);
            Color color = UiPlugin.getDisplay().getSystemColor(19);
            String text = "" + color.getRed();
            store.setDefault("InvalidCellColorRed", text);
            text = "" + color.getGreen();
            store.setDefault("InvalidCellColorGreen", text);
            text = "" + color.getBlue();
            store.setDefault("InvalidCellColorBlue", text);
            store.setDefault("InvalidCellColorChanged", "0");
            color = UiPlugin.getDisplay().getSystemColor(1);
            text = "" + color.getRed();
            store.setDefault("ConsoleBackgroundColorRed", text);
            text = "" + color.getGreen();
            store.setDefault("ConsoleBackgroundColorGreen", text);
            text = "" + color.getBlue();
            store.setDefault("ConsoleBackgroundColorBlue", text);
            store.setDefault("ConsoleBackgroundColorChanged", "0");
            color = UiPlugin.getDisplay().getSystemColor(2);
            text = "" + color.getRed();
            store.setDefault("ConsoleCommandColorRed", text);
            text = "" + color.getGreen();
            store.setDefault("ConsoleCommandColorGreen", text);
            text = "" + color.getBlue();
            store.setDefault("ConsoleCommandColorBlue", text);
            store.setDefault("ConsoleCommandColorChanged", "0");
            color = UiPlugin.getDisplay().getSystemColor(10);
            text = "" + color.getRed();
            store.setDefault("ConsoleStdoutColorRed", text);
            text = "" + color.getGreen();
            store.setDefault("ConsoleStdoutColorGreen", text);
            text = "" + color.getBlue();
            store.setDefault("ConsoleStdoutColorBlue", text);
            store.setDefault("ConsoleStdoutColorChanged", "0");
            color = UiPlugin.getDisplay().getSystemColor(3);
            text = "" + color.getRed();
            store.setDefault("ConsoleStderrColorRed", text);
            text = "" + color.getGreen();
            store.setDefault("ConsoleStderrColorGreen", text);
            text = "" + color.getBlue();
            store.setDefault("ConsoleStderrColorBlue", text);
            store.setDefault("ConsoleStderrColorChanged", "0");
            color = UiPlugin.getDisplay().getSystemColor(2);
            text = "" + color.getRed();
            store.setDefault("ConsoleResultColorRed", text);
            text = "" + color.getGreen();
            store.setDefault("ConsoleResultColorGreen", text);
            text = "" + color.getBlue();
            store.setDefault("ConsoleResultColorBlue", text);
            store.setDefault("ConsoleResultColorChanged", "0");
            store.setDefault("SecurityExitEnabled", false);
            store.setDefault("SecurityExitName", "");
            store.setDefault("SecurityExitData", "");
            store.setDefault("SecurityExitJarName", "");
            store.setDefault("SecurityExitDirEnabled", true);
            store.setDefault("SecurityExitJarEnabled", false);
            try {
                store.setDefault("SecurityExitDirName", QueryValue.queryExitsDir((Trace)t));
            }
            catch (CommonServicesException commonServicesException) {
                if (!Trace.isTracing) break block2;
                t.data(67, "UiPlugin.setDefaultPreferences", 900, "Error getting exits directory name");
            }
        }
        store.setDefault("RemoteQmgrUseEnv", false);
        store.setDefault("RemoteQmgrPort", 1414);
        store.setDefault("RemoteQmgrSvrConn", "SYSTEM.ADMIN.SVRCONN");
        store.setDefault("UseridEnabled", false);
        store.setDefault("UseridCompatibilityMode", false);
        store.setDefault("UseridPasswordMode", 1);
        store.setDefault("UseridName", "");
        store.setDefault("UseridPassword", "");
        store.setDefault("SSLStoresEnabled", false);
        store.setDefault("TrustedStoreName", "");
        store.setDefault("PersonalStoreName", "");
        store.setDefault("SSLOptionsEnabled", false);
        store.setDefault("SSLCipherSuite", "");
        store.setDefault("SSLFIPSRequired", 0);
        store.setDefault("SSLResetCount", 0);
        store.setDefault("SSLPeerName", "");
    }

    public static boolean isShowObjectStatus() {
        return UiPlugin.getPrefStore().getBoolean("ShowObjectStatus");
    }

    public static boolean isShowAnimations() {
        return true;
    }

    public static int getLocalDefaultRefreshRate() {
        String string = UiPlugin.getPrefStore().getString("LocalDefaultRefreshRate");
        Integer rate = Integer.valueOf(string);
        return rate;
    }

    public static int getRemoteDefaultRefreshRate() {
        String string = UiPlugin.getPrefStore().getString("RemoteDefaultRefreshRate");
        Integer rate = Integer.valueOf(string);
        return rate;
    }

    public static int getMonitorRefreshRate() {
        String string = UiPlugin.getPrefStore().getString("MonitorRefreshRate");
        Integer rate = Integer.valueOf(string);
        return rate;
    }

    public static int getDefaultConnectionTimeout() {
        return 0;
    }

    public static void addNavigatorView(Trace t, MQNavigatorView view) {
        navigatorViews.add(view);
        ExplorerNotifyEvent event = new ExplorerNotifyEvent(dummyExtObject, view.getViewSite().getId());
        notificationManager.notifyViewOpened(t, event);
        mqNavigatorViewInit = true;
    }

    private static void sendInitialisationCompleteNotifications(Trace t) {
        notificationManager.notifyExplorerInitialised(trace);
        int i = 0;
        while (i < contentViews.size()) {
            ExplorerViewPart explorerViewPart = contentViews.get(i);
            explorerViewPart.initialisationComplete(t);
            ++i;
        }
    }

    public static void addContentView(Trace t, ExplorerViewPart explorerViewPart) {
        contentViews.add(explorerViewPart);
        ExplorerNotifyEvent event = new ExplorerNotifyEvent(dummyExtObject, explorerViewPart.getId());
        notificationManager.notifyViewOpened(t, event);
        if (explorerViewPart instanceof MQContentView) {
            mqContentViewInit = true;
        }
        if (mqContentViewInit && explorerViewPart instanceof MQContentView && mqNavigatorViewInit) {
            explorerViewPart.initialisationComplete(t);
        }
    }

    public static void removeNavigatorView(Trace t, MQNavigatorView view) {
        navigatorViews.remove(view);
        ExplorerNotifyEvent event = new ExplorerNotifyEvent(dummyExtObject, view.getViewSite().getId());
        notificationManager.notifyViewClosed(t, event);
    }

    public static void removeContentView(Trace t, ExplorerViewPart explorerViewPart) {
        contentViews.remove((Object)explorerViewPart);
        ExplorerNotifyEvent event = new ExplorerNotifyEvent(dummyExtObject, explorerViewPart.getId());
        notificationManager.notifyViewClosed(t, event);
    }

    public static void refreshContentViews(Trace t, String objectId) {
        int i = 0;
        while (i < contentViews.size()) {
            ExplorerViewPart explorerViewPart = contentViews.get(i);
            explorerViewPart.refresh(t, objectId, false, false);
            ++i;
        }
    }

    public static void refreshNavigatorViews(Trace t, boolean isRebuildTree) {
        UiPlugin.refreshNavigatorViews(t, null, isRebuildTree);
    }

    public static void refreshNavigatorViews(Trace t, TreeNode initialTreeNode, boolean isRebuildTree) {
        UiPlugin.getTheDataModel().refreshDmMonitor(t);
        for (MQNavigatorView view : navigatorViews) {
            view.refreshNavigationTree(t, initialTreeNode, false, isRebuildTree);
        }
    }

    public static void asyncRefreshAllViews(final Trace t, String objectId, final boolean isRebuildTree) {
        final String objId = objectId;
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!isShutdownInProgress) {
                    UiPlugin.refreshAllViews(t, objId, isRebuildTree);
                }
            }
        });
    }

    public static synchronized void refreshAllViews(Trace t, String objectId, boolean isRebuildTree) {
        if (Trace.isTracing) {
            Date date = new Date();
            t.data(67, "UiPlugin.refreshAllViews", 300, "refreshAllViews at " + date.toString());
        }
        if (isRefreshTimerRunning) {
            if (Trace.isTracing) {
                t.data(67, "UiPlugin.refreshAllViews", 300, "refresh timer running - suppressing refresh");
            }
            if (objectId != null && refreshObjectId != null && objectId.compareTo(refreshObjectId) != 0) {
                refreshObjectId = null;
            }
            if (isRebuildTree) {
                refreshIsRebuildTree = true;
            }
        } else if (refreshTimerDelay > 0) {
            UiPlugin.getDisplay().timerExec(refreshTimerDelay, new Runnable(){

                @Override
                public void run() {
                    Trace t2 = Trace.getDefault();
                    if (Trace.isTracing) {
                        t2.data(67, "UiPlugin.refreshAllViews", 300, "refresh timer popped - doing refresh");
                    }
                    if (!isShutdownInProgress) {
                        UiPlugin.doRefreshAllViews(t2);
                    }
                    isRefreshTimerRunning = false;
                }
            });
            refreshObjectId = objectId;
            refreshIsRebuildTree = isRebuildTree;
            isRefreshTimerRunning = true;
            if (Trace.isTracing) {
                t.data(67, "UiPlugin.refreshAllViews", 300, "starting refresh timer");
            }
        } else {
            if (!isShutdownInProgress) {
                UiPlugin.doRefreshAllViews(t);
            }
            if (Trace.isTracing) {
                t.data(67, "UiPlugin.refreshAllViews", 300, "no refresh timer delay - doing refresh immediately");
            }
        }
    }

    public static UiQueueManager[] getKnownUiQueueManagers(Trace t, boolean incHidden) {
        return queueManagerList.getKnownUiQueueManagers(t, incHidden);
    }

    public static UiQueueManager[] getHiddenUiQueueManagers(Trace t) {
        return queueManagerList.getHiddenUiQueueManagers(t);
    }

    private static boolean isAnyKnownZOSQueueManagers(Trace t) {
        boolean knownZOS = false;
        UiQueueManager[] uiQmgrs = UiPlugin.getKnownUiQueueManagers(t, false);
        int i = 0;
        while (i < uiQmgrs.length) {
            if (uiQmgrs[i].isZOS(t) && uiQmgrs[i].isVisible(t)) {
                knownZOS = true;
                break;
            }
            ++i;
        }
        return knownZOS;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.startup();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            isShutdownInProgress = true;
            try {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (this.perspectiveListener != null && window != null) {
                    window.removePerspectiveListener(this.perspectiveListener);
                }
            }
            catch (SWTException sWTException) {}
            queueManagerList.close(trace);
            if (isPersistOnShutdown) {
                attrOrderManager.saveAttributeOrders(trace, true);
            }
            notificationManager.notifyExplorerClosing(trace);
            theDataModel.close(trace, isAbnormalShutdownPending);
            colorConsoleBackground.dispose();
            colorConsoleCommand.dispose();
            colorConsoleResult.dispose();
            colorConsoleStderr.dispose();
            colorConsoleStdout.dispose();
            colorDisabled.dispose();
            if (UiPlugin.isRCPMode()) {
                UiPlugin.getWorkspace().save(true, null);
            }
        }
        finally {
            UiPlugin.releaseSingleInstanceLock(trace);
            super.stop(context);
        }
    }

    public static String stripTrailingSpaces(Trace t, String content) {
        String ret = content;
        int length = 0;
        int originalLength = length = ret.length();
        while (ret.charAt(length - 1) == ' ') {
            --length;
        }
        if (originalLength != length) {
            ret = ret.substring(0, length);
        }
        return ret;
    }

    public static AttributeOrderManager getAttributeOrderManager() {
        return attrOrderManager;
    }

    public static FilterManager getFilterManager() {
        return filterManager;
    }

    public static PropertyTabFactoryManager getPropertyTabFactoryManager() {
        return propertyTabFactoryManager;
    }

    public static ISelection getMQNavigatorViewSelection(Trace t) {
        ISelection selection = null;
        MQNavigatorView view = UiPlugin.getMQNavigatorView();
        if (view != null) {
            selection = view.getCommonViewer().getSelection();
        }
        return selection;
    }

    public static NotificationManager getNotificationManager() {
        return notificationManager;
    }

    public static void addNotificationListener(Trace t, IExplorerNotify listener) {
        notificationManager.addListener(t, listener, "com.ibm.mq.explorer.wmq");
    }

    public static void removeNotificationListener(Trace t, IExplorerNotify listener) {
        notificationManager.removeListener(t, listener, "com.ibm.mq.explorer.wmq");
    }

    public void dmOnError(DmErrorEvent event) {
        Trace t = Trace.getDefault();
        if (event.getException() != null) {
            MessageBox.showExceptionMessage(t, Display.getCurrent().getActiveShell(), event.getException());
        }
    }

    public static File getPersistentFileLocation() {
        return persistentFileLocation;
    }

    public static QueueManagerList getQueueManagerList() {
        return queueManagerList;
    }

    public static ZosQueueManagerList getZosQueueManagerList() {
        return zosQueueManagerList;
    }

    public static void setRefreshTimerDelay(int delay) {
        refreshTimerDelay = delay;
    }

    public static int getRefreshTimerDelay() {
        return refreshTimerDelay;
    }

    protected static void doRefreshAllViews(Trace t) {
        UiPlugin.refreshNavigatorViews(t, refreshIsRebuildTree);
        UiPlugin.refreshContentViews(t, refreshObjectId);
    }

    public static boolean exportPreferencesToXmlFile(Trace t, String fname) {
        boolean result = false;
        String filename = fname;
        if (filename == null) {
            filename = persistentFileLocation + File.separator + "WMQ_Preferences.xml";
        }
        ImportExportPreferences iePrefs = new ImportExportPreferences(t, UiPlugin.getPrefStore(), UiPlugin.getPluginRegistrationManager());
        result = iePrefs.exportPreferences(t, filename);
        return result;
    }

    public static boolean importPreferencesFromXmlFile(Trace t, String fname) {
        boolean result = false;
        String filename = fname;
        if (filename == null) {
            filename = persistentFileLocation + File.separator + "WMQ_Preferences.xml";
        }
        ImportExportPreferences iePrefs = new ImportExportPreferences(t, UiPlugin.getPrefStore(), UiPlugin.getPluginRegistrationManager());
        result = iePrefs.importPreferences(t, filename);
        return result;
    }

    public static void addITreeNodeDeletedListener(Trace t, TreeNodeDeletedListener listener) {
        treeNodeDeletedListeners.addElement(listener);
    }

    public static void removeTreeNodeDeletedListener(Trace t, TreeNodeDeletedListener listener) {
        treeNodeDeletedListeners.removeElement(listener);
    }

    public static void treeNodeDeleted(Trace t, TreeNode treeNode) {
        TreeNodeDeletedEvent treeNodeDeletedEvent = new TreeNodeDeletedEvent(t, treeNode);
        int size = treeNodeDeletedListeners.size();
        int i = size - 1;
        while (i >= 0) {
            TreeNodeDeletedListener listener = treeNodeDeletedListeners.elementAt(i);
            listener.treeNodeDeleted(treeNodeDeletedEvent);
            --i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace t = Trace.getDefault();
        String strProperty = event.getProperty();
        if (strProperty.compareTo("MonitorRefreshRate") == 0) {
            int rate = UiPlugin.getMonitorRefreshRate();
            DmMonitor.setRefreshInterval((Trace)t, (int)rate);
        } else if (strProperty.compareTo("InvalidCellColorChanged") == 0) {
            this.loadDisabledColor(t);
        } else if (strProperty.compareTo("ConsoleBackgroundColorChanged") == 0) {
            this.loadConsoleBackgroundColor(t);
        } else if (strProperty.compareTo("ConsoleCommandColorChanged") == 0) {
            this.loadConsoleCommandColor(t);
        } else if (strProperty.compareTo("ConsoleStdoutColorChanged") == 0) {
            this.loadConsoleStdoutColor(t);
        } else if (strProperty.compareTo("ConsoleStderrColorChanged") == 0) {
            this.loadConsoleStderrColor(t);
        } else if (strProperty.compareTo("ConsoleResultColorChanged") == 0) {
            this.loadConsoleResultColor(t);
        } else if (strProperty.compareTo("ShowObjectStatus") == 0) {
            ExplorerNotifyEvent enEvent = new ExplorerNotifyEvent(event.getNewValue(), "com.ibm.mq.explorer.showobjectstatus");
            notificationManager.notifyExplorerPreferenceChanged(t, enEvent);
        } else if (strProperty.compareTo("LocalDefaultRefreshRate") == 0) {
            this.notifyDataModelWithLocalQmgrRefreshRate(t);
        }
    }

    private void notifyDataModelWithLocalQmgrRefreshRate(Trace t) {
        IPreferenceStore prefStore = UiPlugin.getPrefStore();
        int rate = prefStore.getInt("LocalDefaultRefreshRate");
        theDataModel.setQueueManagerRefreshInterval(t, rate);
    }

    public static Icons getIcons() {
        return icons;
    }

    public static boolean isExpandTreeNodeByDefault(Trace t, String treeNodeId) {
        boolean expand = false;
        if (treeNodeId.compareTo("com.ibm.mq.explorer.treenode.wmq") == 0 || treeNodeId.compareTo("com.ibm.mq.explorer.treenode.qmgrs") == 0 || treeNodeId.compareTo("com.ibm.mq.explorer.treenode.qsgs") == 0) {
            expand = true;
        }
        return expand;
    }

    public static boolean isShutdownInProgress() {
        return isShutdownInProgress;
    }

    public static boolean isInitialized() {
        return hasInitialized;
    }

    private static void sendPluginEnablementEvents(Trace t) {
        ArrayList<RegisteredPlugin> plugins = pluginRegistrationManager.getRegisteredPlugins();
        int k = 0;
        while (k < plugins.size()) {
            RegisteredPlugin regPlugin = plugins.get(k);
            ExplorerNotifyEvent explorerNotifyEvent = new ExplorerNotifyEvent(dummyExtObject, regPlugin.getPlugin_id());
            if (regPlugin.isEnabled()) {
                notificationManager.notifyPluginEnabled(trace, explorerNotifyEvent);
            } else {
                notificationManager.notifyPluginDisabled(trace, explorerNotifyEvent);
            }
            ++k;
        }
    }

    public static void setAbnormalShutdownPending(boolean abnormal) {
        isAbnormalShutdownPending = abnormal;
    }

    public static void setPersistOnShutdown(boolean persistOnShutdown) {
        isPersistOnShutdown = persistOnShutdown;
    }

    public static int getResizeColumnsTimerDelay() {
        return resizeColumnsTimerDelay;
    }

    public static void setResizeColumnsTimerDelay(int delay) {
        resizeColumnsTimerDelay = delay;
    }

    public static int getMonitorRefreshRateMaxValue(Trace t) {
        return theDataModel.getMaxMonitorRefreshInterval(t);
    }

    public static int getMonitorRefreshRateMinValue(Trace t) {
        return theDataModel.getMinMonitorRefreshInterval(t);
    }

    public static int getRemoteRefreshRateMaxValue(Trace t) {
        return theDataModel.getMaxRemoteQueueManagerRefreshInterval(t);
    }

    public static int getRemoteRefreshRateMinValue(Trace t) {
        return theDataModel.getMinRemoteQueueManagerRefreshInterval(t);
    }

    public static int getLocalRefreshRateMaxValue(Trace t) {
        return theDataModel.getMaxQueueManagerRefreshInterval(t);
    }

    public static int getLocalRefreshRateMinValue(Trace t) {
        return theDataModel.getMinQueueManagerRefreshInterval(t);
    }

    public static int getProgressDialogMinimumDisplayTimeMaxValue() {
        return 60;
    }

    public static int getProgressDialogMinimumDisplayTimeMinValue() {
        return 0;
    }

    public static int getExplorerTableUpdateBatchSize() {
        return explorerTableUpdateBatchSize;
    }

    public static void setExplorerTableUpdateBatchSize(int size) {
        explorerTableUpdateBatchSize = size;
    }

    public static void setStartupModeIsEclipseWorkbench(Trace t, boolean isWorkbench) {
        block15: {
            String filename = persistentFileLocation + File.separator + "WMQ_Workbench.dat";
            File file = new File(filename);
            if (isWorkbench) {
                try {
                    if (file.createNewFile()) {
                        if (Trace.isTracing) {
                            t.data(67, "UiPlugin.setStartupModeIsEclipseWorkbench", 300, "file created");
                        }
                    } else if (Trace.isTracing) {
                        t.data(67, "UiPlugin.setStartupModeIsEclipseWorkbench", 300, "file already exists");
                    }
                    break block15;
                }
                catch (IOException e) {
                    if (Trace.isTracing) {
                        t.data(67, "UiPlugin.setStartupModeIsEclipseWorkbench", 900, "IOException creating file " + filename);
                        t.data(67, "UiPlugin.setStartupModeIsEclipseWorkbench", 900, "exception is:  " + e.getLocalizedMessage());
                    }
                    break block15;
                }
            }
            if (file.exists()) {
                if (file.delete()) {
                    if (Trace.isTracing) {
                        t.data(67, "UiPlugin.setStartupModeIsEclipseWorkbench", 300, "file deleted");
                    }
                } else if (Trace.isTracing) {
                    t.data(67, "UiPlugin.setStartupModeIsEclipseWorkbench", 900, "failed to delete file " + filename);
                }
            } else if (Trace.isTracing) {
                t.data(67, "UiPlugin.setStartupModeIsEclipseWorkbench", 300, "file did not exist");
            }
        }
    }

    public static boolean isOnlyExplorerInstance(Trace t) {
        boolean result = false;
        IWorkbench workbench = plugin.getWorkbench();
        Display display = workbench.getDisplay();
        Object displayData = display.getData();
        if (displayData != null && displayData instanceof UiDisplayData) {
            boolean bl = isRCPMode = ((UiDisplayData)displayData).getExplorerMode() == 1;
        }
        if (isRCPMode) {
            if (displayData != null) {
                result = ((UiDisplayData)displayData).getFileLock() != null;
            }
        } else {
            result = UiPlugin.claimSingleInstanceLock(t);
        }
        return result;
    }

    public static boolean claimSingleInstanceLock(Trace t) {
        boolean result;
        block5: {
            result = false;
            String workspaceLocation = plugin.getStateLocation().toString();
            String filename = String.valueOf(workspaceLocation) + File.separator + "Explorer.lck";
            if (Trace.isTracing) {
                t.data(67, "UiPlugin.claimSingleInstanceLock", 300, "trying to claim lock from file " + filename);
            }
            try {
                File file = new File(filename);
                FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                fileLock = channel.tryLock();
                if (fileLock != null) {
                    result = true;
                    if (Trace.isTracing) {
                        t.data(67, "UiPlugin.claimSingleInstanceLock", 300, "lock claimed");
                    }
                }
            }
            catch (IOException ioe) {
                if (!Trace.isTracing) break block5;
                t.data(67, "UiPlugin.claimSingleInstanceLock", 900, "IOException claiming lock using file " + filename + Common.LINE_SEPARATOR + ioe);
            }
        }
        return result;
    }

    public static void releaseSingleInstanceLock(Trace t) {
        block4: {
            if (fileLock != null) {
                try {
                    fileLock.release();
                    if (Trace.isTracing) {
                        t.data(67, "UiPlugin.releaseSingleInstanceLock", 300, "lock released");
                    }
                }
                catch (IOException ioe) {
                    if (!Trace.isTracing) break block4;
                    t.data(67, "UiPlugin.releaseSingleInstanceLock", 900, "IOException releasing lock" + Common.LINE_SEPARATOR + ioe);
                }
            }
        }
    }

    public static void addQueueManagerDisconnectActionListener(Trace t, IQueueManagerDisconnectActionListener listener) {
        disconnectActionListeners.addElement(listener);
    }

    public static void removeQueueManagerDisconnectActionListener(Trace t, IQueueManagerDisconnectActionListener listener) {
        disconnectActionListeners.removeElement(listener);
    }

    public static void triggerDisconnectActionListeners(Trace t, DmQueueManager dmQmgr) {
        QueueManagerDisconnectActionEvent discActionEvent = new QueueManagerDisconnectActionEvent(dmQmgr);
        int i = 0;
        while (i < disconnectActionListeners.size()) {
            IQueueManagerDisconnectActionListener listener = disconnectActionListeners.elementAt(i);
            listener.queueManagerBeingDisconnected(discActionEvent);
            ++i;
        }
    }

    public static boolean isRCPMode() {
        return isRCPMode;
    }

    public static IExplorerRuntimeImportExport getExplorerImportExport() {
        return expImportExport;
    }

    public static String getPluginId() {
        return "com.ibm.mq.explorer.ui";
    }

    public static ImportExportCategory[] getImportExportCategories(Trace t) {
        if (catManager != null) {
            return catManager.getImportExportCategories(t);
        }
        return new ImportExportCategory[0];
    }

    public static void restartExplorer(Trace t) {
        plugin.getWorkbench().restart();
    }

    private void loadPendingPersistentFiles(Trace t) {
        this.loadPendingPersistentFile(t, "WMQ_Schemes.xml");
        this.loadPendingPersistentFile(t, "WMQ_Filters.xml");
        if (this.loadPendingPersistentFile(t, "WMQ_Preferences.xml")) {
            UiPlugin.importPreferencesFromXmlFile(t, persistentFileLocation + File.separator + "WMQ_Preferences.xml");
        }
        this.loadPendingPersistentFile(t, "WMQ_Handles.xml");
    }

    private boolean loadPendingPersistentFile(Trace t, String filename) {
        String pendingFilename;
        File pendingFile;
        boolean result = false;
        if (Trace.isTracing) {
            t.data(67, "UiPlugin.loadPendingPersistentFile", 300, "checking for pending file for:" + filename);
        }
        if ((pendingFile = new File(pendingFilename = persistentFileLocation + File.separator + "pending_" + filename)).exists() && pendingFile.canRead()) {
            String persistFilename = persistentFileLocation + File.separator + filename;
            File persistFile = new File(persistFilename);
            if (persistFile.exists()) {
                try {
                    persistFile.delete();
                }
                catch (SecurityException e) {
                    if (Trace.isTracing) {
                        t.data(67, "UiPlugin.loadPendingPersistentFile", 900, "Security exception trying to delete existing persistent file");
                        t.FFST(67, "UiPlugin.loadPendingPersistentFile", 10, 50999, 0, 0, "Security exception trying to delete existing persistent file", "file = '" + persistFile.toString() + "'", e.getLocalizedMessage());
                    }
                }
                catch (Throwable e) {
                    t.data(67, "UiPlugin.loadPendingPersistentFile", 900, "throwable trying to delete existing persistent file");
                    t.FFST(67, "UiPlugin.loadPendingPersistentFile", 20, 50999, 0, 0, "Throwable trying to delete existing persistent file", "file = '" + persistFile.toString() + "'", e.getLocalizedMessage());
                }
            }
            try {
                pendingFile.renameTo(persistFile);
                result = true;
            }
            catch (SecurityException e) {
                if (Trace.isTracing) {
                    t.data(67, "UiPlugin.loadPendingPersistentFile", 900, "Security exception trying to rename pending persistent file");
                    t.FFST(67, "UiPlugin.loadPendingPersistentFile", 30, 50999, 0, 0, "Security exception trying to delete existing persistent file", "file = '" + pendingFile.toString() + "'", e.getLocalizedMessage());
                }
            }
            catch (Throwable e) {
                t.data(67, "UiPlugin.loadPendingPersistentFile", 900, "throwable trying to rename pending persistent file");
                t.FFST(67, "UiPlugin.loadPendingPersistentFile", 40, 50999, 0, 0, "Throwable trying to delete existing persistent file", "file = '" + pendingFile.toString() + "'", e.getLocalizedMessage());
            }
        }
        return result;
    }

    public static void logStartupData(Trace t, int component, String fid, Bundle bund) {
        if (bund != null) {
            String pluginName = bund.getSymbolicName();
            Object ver = bund.getHeaders().get("Bundle-Version");
            String version = null;
            if (ver != null) {
                version = ver.toString();
            }
            String location = bund.getLocation();
            Object dep = bund.getHeaders().get("Require-Bundle");
            String dependencies = null;
            if (dep != null) {
                dependencies = dep.toString();
            }
            Object cp = bund.getHeaders().get("Bundle-ClassPath");
            String classPath = null;
            if (cp != null) {
                classPath = cp.toString();
            }
            t.dataBox(component, fid, pluginName, version, location);
            t.data(component, fid, 300, "classpath: " + classPath);
            t.data(component, fid, 300, "dependencies: " + dependencies);
        }
    }

    public static ActionFilterManager getActionFilterManager() {
        return actionFilterManager;
    }

    public static DragDropManager getDragDropManager() {
        return dragDropManager;
    }

    public static DataModel getTheDataModel() {
        return theDataModel;
    }

    public static MQNavigatorView getMQNavigatorView() {
        if (navigatorViews.size() == 0) {
            return null;
        }
        if (navigatorViews.size() == 1) {
            return navigatorViews.get(0);
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        for (MQNavigatorView view : navigatorViews) {
            if (!view.getSite().getPage().equals(activePage)) continue;
            return view;
        }
        return navigatorViews.get(0);
    }

    public static IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    private void initialisePasswordManager(Trace t) {
        passwordStoreManager = PwStoreManager.getStoreManager(t);
        if (Trace.isTracing) {
            t.data(67, "UiPlugin.initialisePasswordManager", 300, "Password store manager is " + passwordStoreManager);
        }
    }

    public static void setShowSystemObjects(boolean showSystemObjects) {
        isShowSystemObjects = showSystemObjects;
    }

    public static boolean isShowSystemObjects() {
        return isShowSystemObjects;
    }

    public static IRemoteQmgrConnection getRemoteQmgrConnection() {
        return remoteQmgrConnectionFactory.create();
    }

    public static void setRemoteQmgrConnectionFactory(IRemoteQmgrConnectionFactory remoteQmgrConnFactory) {
        remoteQmgrConnectionFactory = remoteQmgrConnFactory;
    }

    public static MQQmgrExtObject[] getKnownQueueManagers(Trace t) {
        MQQmgrExtObject[] qmgrs = null;
        UiQueueManager[] uiQmgrs = UiPlugin.getKnownUiQueueManagers(t, true);
        if (uiQmgrs != null) {
            qmgrs = new MQQmgrExtObject[uiQmgrs.length];
            int i = 0;
            while (i < uiQmgrs.length) {
                qmgrs[i] = (MQQmgrExtObject)uiQmgrs[i].getExternalObject();
                ++i;
            }
        }
        return qmgrs;
    }

    public static boolean isFIPSEnabled() {
        int setting = UiPlugin.getPrefStore().getInt("SSLFIPSRequired");
        return setting > 0;
    }

    public static boolean isQueueManagerVisible(Trace t, MQQmgrExtObject mqQmgrExtObject) {
        return ((UiQueueManager)mqQmgrExtObject.getInternalObject()).getDmQueueManagerObject().isVisible(t);
    }

    public static boolean isQueueManagerConnected(Trace t, MQQmgrExtObject mqQmgrExtObject) {
        return ((UiQueueManager)mqQmgrExtObject.getInternalObject()).getDmQueueManagerObject().isConnected();
    }

    public static boolean isQueueManagerLocal(Trace t, MQQmgrExtObject mqQmgrExtObject) {
        return ((UiQueueManager)mqQmgrExtObject.getInternalObject()).getDmQueueManagerObject().isLocal(t);
    }

    public static boolean removeRemoteQueueManager(Trace t, MQQmgrExtObject mqQmgrExtObject) throws QueueManagerConnectionException {
        boolean result = false;
        IRemoteQmgrConnection remoteQmgrConnection = UiPlugin.getRemoteQmgrConnection();
        if (remoteQmgrConnection == null) {
            String msgId = "AMQ4859";
            String msgText = CommonServices.getSystemMessage((String)msgId);
            QueueManagerConnectionException e = new QueueManagerConnectionException(msgText, msgId, 2, 50053);
            if (Trace.isTracing) {
                t.data(67, "UiPlugin.removeRemoteQueueManager", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
                t.data(67, "UiPlugin.removeRemoteQueueManager", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
            }
            throw e;
        }
        result = remoteQmgrConnection.removeRemoteQueueManager(t, mqQmgrExtObject);
        return result;
    }

    public static boolean isPersistOnShutdown() {
        return isPersistOnShutdown;
    }

    public static void reloadCurrentContentPage(Trace t) {
        for (ExplorerViewPart view : contentViews) {
            if (!(view instanceof MQContentView)) continue;
            ((MQContentView)view).reloadCurrentPage(t);
        }
    }

    public static void logMessage(String pluginId, String message) {
        Status status = new Status(2, pluginId, message);
        UiPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void logException(Exception e) {
        String pluginId = UiPlugin.getPluginId();
        String message = e.getMessage();
        Status status = new Status(4, pluginId, message, (Throwable)e);
        UiPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static WorkspaceDescriptor getMigrationInfo() {
        return workspaceManager.getMigratedWorkspace();
    }
}

