/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.machine.MachineTreeNodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class TreeNodeFactoryManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/TreeNodeFactoryManager.java";
    private ArrayList<ITreeNodeFactory> treeNodeFactories = new ArrayList();
    private Map<ITreeNodeFactory, String> mapPluginIds = new HashMap<ITreeNodeFactory, String>();

    public TreeNodeFactoryManager(Trace t) {
    }

    public void loadTreeNodeFactories(Trace t) {
        this.loadInternalTreeNodeFactories(t);
        this.loadExternalTreeNodeFactories(t);
    }

    private void loadInternalTreeNodeFactories(Trace t) {
        this.addTreeNodeFactory(t, new MachineTreeNodeFactory(), "com.ibm.mq.explorer.ui");
    }

    private void loadExternalTreeNodeFactories(Trace t) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", "addtreenode");
        if (extensionPoint != null) {
            TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "    label = " + extensionPoint.getLabel());
            TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "    schemaReference = " + extensionPoint.getSchemaReference());
            TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IConfigurationElement[] configArray = extensionPoint.getConfigurationElements();
            TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "    Number of ConfigurationElements = " + configArray.length);
            int i = 0;
            while (i < configArray.length) {
                IConfigurationElement element = configArray[i];
                TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "        name  = " + element.getName());
                TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "        value = " + element.getValue());
                TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "");
                ++i;
            }
            IExtension[] extensionArray = extensionPoint.getExtensions();
            TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "    Number of Extensions = " + extensionArray.length);
            int i2 = 0;
            while (i2 < extensionArray.length) {
                IExtension extension = extensionArray[i2];
                TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "        label = " + extension.getLabel());
                TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "        Number of ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    block25: {
                        IConfigurationElement element = configArray2[j];
                        TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "            element.name  = " + element.getName());
                        TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "            element.value = " + element.getValue());
                        String plugin_id = element.getAttribute("pluginId");
                        TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "            pluginId     = " + plugin_id);
                        if (UiPlugin.getPluginRegistrationManager().isPluginRegistered(plugin_id)) {
                            int indexOfForwardSlash;
                            int index;
                            String className = null;
                            String extensionValue = element.getAttribute("class");
                            String pluginID = element.getAttribute("pluginId");
                            if (pluginID == null && (index = extensionValue.indexOf(":")) != -1) {
                                pluginID = extensionValue.substring(index);
                            }
                            className = (indexOfForwardSlash = extensionValue.indexOf("/")) == -1 ? extensionValue : extensionValue.substring(indexOfForwardSlash + 1, extensionValue.length());
                            try {
                                Bundle classBundle = Platform.getBundle((String)pluginID);
                                if (classBundle != null) {
                                    ITreeNodeFactory factory = (ITreeNodeFactory)classBundle.loadClass(className).newInstance();
                                    if (factory != null) {
                                        this.addTreeNodeFactory(t, factory, plugin_id);
                                    } else {
                                        if (Trace.isTracing) {
                                            t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "Unable to load the class '" + className + "' for pluginId '" + pluginID + "'");
                                        }
                                        t.FFST(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 10, 50999, 0, 0, "Unable to load class specified in addTreeNode extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                                    }
                                    break block25;
                                }
                                if (Trace.isTracing) {
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "Unable to get the bundle for plug-in id '" + pluginID + "'");
                                }
                                t.FFST(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 20, 50999, 0, 0, "Invalid pluginId specified in addTreeNode extension point", "pluginId = '" + pluginID + "'", "");
                            }
                            catch (NullPointerException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "NullPointerException loading addTreeNode extension point:");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 30, 50999, 0, 0, "NullPointerException loading addTreeNode extension point", "pluginId = '" + pluginID + "'", "");
                            }
                            catch (InstantiationException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "InstantiationException loading addTreeNode extension point:");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 40, 50999, 0, 0, "InstantiationException loading addTreeNode extension point", "pluginId = '" + pluginID + "'", "");
                            }
                            catch (IllegalAccessException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "IllegalAccessException loading addTreeNode extension point:");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 50, 50999, 0, 0, "IllegalAccessException loading addTreeNode extension point", "pluginId = '" + pluginID + "'", "");
                            }
                            catch (ClassNotFoundException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "ClassNotFoundException loading addTreeNode extension point:");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 60, 50999, 0, 0, "ClassNotFoundException loading addTreeNode extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                            }
                            catch (ClassCastException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "ClassCastException loading addTreeNode extension point:");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 65, 50999, 0, 0, "ClassCastException loading addTreeNode extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                            }
                            catch (Throwable e) {
                                if (Trace.isTracing) {
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "Throwable loading addTreeNode extension point:");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 70, 50999, 0, 0, "Throwable loading addTreeNode extension point", "pluginId = '" + pluginID + "'", "");
                            }
                        } else {
                            TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", ">> ignoring - plug-in not registered");
                            t.FFST(67, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", 80, 50999, 0, 0, "Ignoring addTreeNode extension point, plug-in not registered", "pluginId = '" + plugin_id + "'", "");
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
        TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "");
        TreeNodeFactoryManager.trace(t, "TreeNodeFactoryManager.loadExternalTreeNodeFactories", "");
    }

    public ArrayList<ITreeNodeFactory> getTreeNodeFactoryArray() {
        return this.treeNodeFactories;
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    private void addTreeNodeFactory(Trace t, ITreeNodeFactory treeNodeFactory, String pluginId) {
        this.treeNodeFactories.add(treeNodeFactory);
        this.mapPluginIds.put(treeNodeFactory, pluginId);
    }

    public boolean isPluginEnabledForTreeNodeFactory(Trace t, ITreeNodeFactory treeNodeFactory) {
        boolean enabled = false;
        String pluginId = this.mapPluginIds.get(treeNodeFactory);
        if (pluginId != null) {
            enabled = UiPlugin.isPluginEnabled(pluginId);
        }
        return enabled;
    }
}

