/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.base.ZosQueueManagerList;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;

public class QueueManagerList
implements DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/QueueManagerList.java";
    private Map<DmQueueManager, UiQueueManager> knownUiQueueManagers = null;
    private boolean listenerActive = false;
    private IUiMQObjectFactory uiQmgrFactory = null;

    public QueueManagerList() {
        Trace t = Trace.getDefault();
        this.uiQmgrFactory = ObjectRegistrationManager.getUiMQObjectFactory(t, "com.ibm.mq.explorer.queuemanager");
        this.knownUiQueueManagers = new HashMap<DmQueueManager, UiQueueManager>();
    }

    public void open(Trace t) {
        ArrayList qms = UiPlugin.getTheDataModel().getQueueManagers(t);
        int i = 0;
        while (i < qms.size()) {
            DmQueueManager dmQueueManager = (DmQueueManager)qms.get(i);
            this.addDmQueueManager(t, dmQueueManager, false);
            ++i;
        }
    }

    public void startListeningForChanges(Trace t) {
        if (!this.listenerActive) {
            this.listenerActive = true;
            boolean res = UiPlugin.getTheDataModel().addObserver(t, (DmObjectListener)this, null);
            if (!res) {
                this.listenerActive = false;
                if (Trace.isTracing) {
                    t.data(67, "QueueManagerList.startListeningForChanges", 900, "DataModel.addQueueManagerListener failed");
                }
            }
        }
    }

    public void close(Trace t) {
        this.listenerActive = false;
        UiPlugin.getTheDataModel().deleteObserver(t, (DmObjectListener)this);
    }

    private synchronized void addDmQueueManager(Trace t, DmQueueManager dmQueueManager, boolean switchThread) {
        if (Trace.isTracing) {
            t.data(67, "QueueManagerList.addDmQueueManager", 300, "add queue manager " + dmQueueManager.getTitle() + " @ " + dmQueueManager.toString());
        }
        if (Trace.isTracing) {
            t.data(67, "QueueManagerList.addDmQueueManager", 300, dmQueueManager.getTitle());
        }
        if (this.knownUiQueueManagers.containsKey(dmQueueManager)) {
            if (Trace.isTracing) {
                t.data(67, "QueueManagerList.addDmQueueManager", 300, "already in list, ignoring");
            }
        } else {
            final UiQueueManager uiQmgr = (UiQueueManager)this.uiQmgrFactory.create(t, (IDmObject)dmQueueManager, null);
            this.knownUiQueueManagers.put(dmQueueManager, uiQmgr);
            if (switchThread) {
                if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                    Display display = UiPlugin.getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            QueueManagerList.this.queueManagerAdded(uiQmgr);
                        }
                    });
                } else if (Trace.isTracing) {
                    t.data(67, "QueueManagerList.addDmQueueManager", 300, "ignored, shutdown in progress");
                }
            } else {
                this.queueManagerAdded(uiQmgr);
            }
        }
    }

    private void queueManagerAdded(UiQueueManager uiQmgr) {
        Trace t = Trace.getDefault();
        if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
            uiQmgr.updateIcon();
            UiPlugin.getNotificationManager().notifyQueueManagerAdded(t, new ExplorerNotifyEvent(uiQmgr.getExternalObject(), null));
            UiPlugin.refreshAllViews(t, uiQmgr.getId(), true);
        } else if (Trace.isTracing) {
            t.data(67, "QueueManagerList.queueManagerAdded", 300, "ignored, shutdown in progress");
        }
    }

    private synchronized void removeDmQueueManager(Trace t, DmQueueManager dmQueueManager) {
        if (Trace.isTracing) {
            t.data(67, "QueueManagerList.removeDmQueueManager", 300, "remove queue manager " + dmQueueManager.getTitle());
        }
        if (Trace.isTracing) {
            t.data(67, "QueueManagerList.removeDmQueueManager", 300, dmQueueManager.getTitle());
        }
        UiQueueManager uiQmgr = null;
        UiQueueManager obj = null;
        obj = this.knownUiQueueManagers.get(dmQueueManager);
        if (obj != null) {
            uiQmgr = obj;
            if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                ZosQueueManagerList.qmgrRemoved(t, uiQmgr);
                ExplorerNotifyEvent event = new ExplorerNotifyEvent(uiQmgr.getExternalObject(), null);
                UiPlugin.getNotificationManager().notifyQueueManagerRemoved(t, event);
                TreeNode treeNode = uiQmgr.getTreeNode();
                if (treeNode != null) {
                    treeNode.removeFromNavigatorView();
                }
                this.knownUiQueueManagers.remove(dmQueueManager);
                UiPlugin.refreshAllViews(t, uiQmgr.getId(), true);
            }
        }
    }

    public UiQueueManager[] getKnownUiQueueManagers(Trace t, boolean isHidden) {
        UiQueueManager[] uiQmgrs = null;
        if (isHidden) {
            int size = this.knownUiQueueManagers.size();
            uiQmgrs = this.knownUiQueueManagers.values().toArray(new UiQueueManager[size]);
        } else {
            ArrayList<UiQueueManager> visibleUiQueueManagers = new ArrayList<UiQueueManager>();
            for (UiQueueManager uiQueueManager : this.knownUiQueueManagers.values()) {
                if (!uiQueueManager.isVisible(t)) continue;
                visibleUiQueueManagers.add(uiQueueManager);
            }
            int size = visibleUiQueueManagers.size();
            uiQmgrs = visibleUiQueueManagers.toArray(new UiQueueManager[size]);
        }
        return uiQmgrs;
    }

    public UiQueueManager[] getHiddenUiQueueManagers(Trace t) {
        UiQueueManager[] uiQmgrs = null;
        ArrayList<UiQueueManager> hiddenUiQueueManagers = new ArrayList<UiQueueManager>();
        for (UiQueueManager uiQueueManager : this.knownUiQueueManagers.values()) {
            if (uiQueueManager.isVisible(t)) continue;
            hiddenUiQueueManagers.add(uiQueueManager);
        }
        int size = hiddenUiQueueManagers.size();
        uiQmgrs = hiddenUiQueueManagers.toArray(new UiQueueManager[size]);
        return uiQmgrs;
    }

    public void dmObjectAdded(DmObjectEvent event) {
        final Trace t = Trace.getDefault();
        if (event.getObjectType() == 2) {
            final DmQueueManager dmQueueManager = (DmQueueManager)event.getSource();
            if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueueManagerList.this.addDmQueueManager(t, dmQueueManager, false);
                    }
                });
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.dmObjectAdded", 300, "ignored, shutdown in progress");
            }
        }
    }

    public void dmObjectChanged(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        if (event.getSource() instanceof DmQueueManager) {
            DmQueueManager dmQm = (DmQueueManager)event.getSource();
            MQQmgrExtObject extObj = null;
            final UiQueueManager uiQm = this.getKnownUiQmgr(t, dmQm, true);
            if (uiQm != null) {
                extObj = (MQQmgrExtObject)uiQm.getExternalObject();
                if (Trace.isTracing) {
                    t.data(67, "QueueManagerList.dmObjectChanged", 300, "QMGR '" + extObj.getName() + "' changed");
                }
                if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                    Display display = UiPlugin.getDisplay();
                    if (display != null && !display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                QueueManagerList.this.refreshAllViews(uiQm.getId(), false);
                            }
                        });
                    }
                } else if (Trace.isTracing) {
                    t.data(67, "QueueManagerList.dmObjectChanged", 300, "ignored, shutdown in progress");
                }
            }
        } else if (Trace.isTracing) {
            t.data(67, "QueueManagerList.dmObjectChanged", 300, "ignored, not a DmQueueManager event");
        }
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        final Trace t = Trace.getDefault();
        if (event.getObjectType() == 2) {
            final DmQueueManager dmQueueManager = (DmQueueManager)event.getSource();
            if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueueManagerList.this.removeDmQueueManager(t, dmQueueManager);
                    }
                });
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.dmObjectDeleted", 300, "ignored, shutdown in progress");
            }
        }
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQm = (DmQueueManager)event.getSource();
        MQQmgrExtObject extObj = null;
        final UiQueueManager uiQm = this.getKnownUiQmgr(t, dmQm, true);
        if (uiQm != null) {
            extObj = (MQQmgrExtObject)uiQm.getExternalObject();
            if (Trace.isTracing) {
                t.data(67, "QueueManagerList.dmQueueManagerShown", 300, "QMGR '" + extObj.getName() + "' shown");
            }
            ZosQueueManagerList.qmgrAdded(t, uiQm);
            ExplorerNotifyEvent notifyEvent = new ExplorerNotifyEvent(extObj, null);
            UiPlugin.getNotificationManager().notifyQueueManagerShown(t, notifyEvent);
            if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                Display display = UiPlugin.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueueManagerList.this.refreshAllViews(uiQm.getId(), true);
                    }
                });
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.dmQueueManagerShown", 300, "ignored, shutdown in progress");
            }
        }
    }

    private void refreshAllViews(String objectId, boolean isRebuildTree) {
        Trace t = Trace.getDefault();
        if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
            UiPlugin.refreshAllViews(t, objectId, isRebuildTree);
        } else if (Trace.isTracing) {
            t.data(67, "QueueManagerList.refreshAllViews", 300, "ignored, shutdown in progress");
        }
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQm = (DmQueueManager)event.getSource();
        MQQmgrExtObject extObj = null;
        final UiQueueManager uiQm = this.getKnownUiQmgr(t, dmQm, true);
        if (uiQm != null) {
            extObj = (MQQmgrExtObject)uiQm.getExternalObject();
            if (Trace.isTracing) {
                t.data(67, "QueueManagerList.dmQueueManagerHidden", 300, "QMGR '" + extObj.getName() + "' hidden");
            }
            ZosQueueManagerList.qmgrRemoved(t, uiQm);
            ExplorerNotifyEvent notifyEvent = new ExplorerNotifyEvent(extObj, null);
            UiPlugin.getNotificationManager().notifyQueueManagerHidden(t, notifyEvent);
            if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                Display display = UiPlugin.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueueManagerList.this.refreshAllViews(uiQm.getId(), true);
                    }
                });
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.dmQueueManagerHidden", 300, "ignored, shutdown in progress");
            }
        }
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        DmQueueManager dmQm;
        Trace t = Trace.getDefault();
        final UiQueueManager uiQm = this.getKnownUiQmgr(t, dmQm = (DmQueueManager)event.getSource(), true);
        if (uiQm != null) {
            if (Trace.isTracing) {
                MQQmgrExtObject extObj = (MQQmgrExtObject)uiQm.getExternalObject();
                t.data(67, "QueueManagerList.dmQueueManagerConnected", 300, "QMGR '" + extObj.getName() + "' connected");
            }
            ZosQueueManagerList.qmgrAdded(t, uiQm);
            if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                Display display = UiPlugin.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueueManagerList.this.queueManagerConnected(uiQm);
                    }
                });
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.dmQueueManagerConnected", 300, "ignored, shutdown in progress");
            }
        }
    }

    private void queueManagerConnected(UiQueueManager uiQm) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "QueueManagerList.queueManagerConnected", 300, "queueManagerConnected for queue manager " + uiQm.getTreeName());
        }
        if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
            if (uiQm.isVisible(t)) {
                uiQm.updateIcon();
                UiPlugin.refreshAllViews(t, uiQm.getId(), true);
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.queueManagerConnected", 300, "connected event suppressed for hidden queue manager '" + uiQm.getTreeName() + "'");
            }
        } else if (Trace.isTracing) {
            t.data(67, "QueueManagerList.queueManagerConnected", 300, "ignored, shutdown in progress");
        }
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        DmQueueManager dmQm;
        Trace t = Trace.getDefault();
        final UiQueueManager uiQm = this.getKnownUiQmgr(t, dmQm = (DmQueueManager)event.getSource(), false);
        if (uiQm != null) {
            if (Trace.isTracing) {
                MQQmgrExtObject extObj = (MQQmgrExtObject)uiQm.getExternalObject();
                t.data(67, "QueueManagerList.dmQueueManagerDisconnected", 300, "QMGR '" + extObj.getName() + "' disconnected");
            }
            ZosQueueManagerList.qmgrRemoved(t, uiQm);
            if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                Display display = UiPlugin.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueueManagerList.this.queueManagerDisconnected(uiQm);
                    }
                });
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.dmQueueManagerDisconnected", 300, "ignored, shutdown in progress");
            }
        }
    }

    private void queueManagerDisconnected(UiQueueManager uiQm) {
        Trace t = Trace.getDefault();
        if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
            if (uiQm.isVisible(t)) {
                uiQm.updateIcon();
                UiPlugin.refreshAllViews(t, uiQm.getId(), true);
                UiPlugin.triggerDisconnectActionListeners(t, uiQm.getDmQueueManagerObject());
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.queueManagerDisconnected", 300, "disconnected event suppressed for hidden queue manager '" + uiQm.getTreeName() + "'");
            }
        } else if (Trace.isTracing) {
            t.data(67, "QueueManagerList.queueManagerDisconnected", 300, "ignored, shutdown in progress");
        }
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    private UiQueueManager getKnownUiQmgr(Trace t, DmQueueManager dmQmgr, boolean addIfNotFound) {
        UiQueueManager uiQmgr = this.knownUiQueueManagers.get(dmQmgr);
        if (uiQmgr == null && addIfNotFound) {
            this.addDmQueueManager(t, dmQmgr, true);
            uiQmgr = this.knownUiQueueManagers.get(dmQmgr);
        }
        return uiQmgr;
    }

    public UiQueueManager getKnownUiQueueManager(Trace t, DmQueueManager dmQmgr) {
        UiQueueManager uiQmgr = this.knownUiQueueManagers.get(dmQmgr);
        if (uiQmgr == null) {
            this.addDmQueueManager(t, dmQmgr, false);
            uiQmgr = this.knownUiQueueManagers.get(dmQmgr);
        }
        return uiQmgr;
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
        DmQueueManager dmQm;
        Trace t = Trace.getDefault();
        final UiQueueManager uiQm = this.getKnownUiQmgr(t, dmQm = (DmQueueManager)event.getSource(), true);
        if (uiQm != null) {
            if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
                try {
                    Display display = UiPlugin.getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            QueueManagerList.this.queueManagerConnecting(uiQm);
                        }
                    });
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (Trace.isTracing) {
                        t.data(67, "QueueManagerList.dmQueueManagerConnecting", 300, "ignored, display has gone away, shutdown probably in progress");
                    }
                }
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.dmQueueManagerConnecting", 300, "ignored, shutdown in progress");
            }
        }
    }

    private void queueManagerConnecting(UiQueueManager uiQm) {
        Trace t = Trace.getDefault();
        if (this.listenerActive && !UiPlugin.isShutdownInProgress()) {
            if (uiQm.isVisible(t)) {
                uiQm.updateIcon();
                UiPlugin.refreshAllViews(t, uiQm.getId(), true);
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerList.queueManagerConnecting", 300, "connecting event suppressed for hidden queue manager '" + uiQm.getTreeName() + "'");
            }
        } else if (Trace.isTracing) {
            t.data(67, "QueueManagerList.queueManagerConnecting", 300, "ignored, shutdown in progress");
        }
    }

    public boolean isListening() {
        return this.listenerActive;
    }
}

