/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.IPropertyTabFactory;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PropertyTabFactoryManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/PropertyTabFactoryManager.java";
    private ArrayList<IPropertyTabFactory> propertyTabFactories = new ArrayList();
    private Hashtable<String, String> hashtablePluginIds = new Hashtable();
    private Hashtable<String, String> hashtableObjectIds = new Hashtable();
    private Hashtable<String, String> hashtablePropertyTabNames = new Hashtable();
    private Hashtable<String, IPropertyTabFactory> hashtablePropertyTabFactories = new Hashtable();

    public PropertyTabFactoryManager(Trace t) {
    }

    public void loadPropertyTabFactories(Trace t) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", "addpropertytab");
        if (extensionPoint != null) {
            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "    label = " + extensionPoint.getLabel());
            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "    schemaReference = " + extensionPoint.getSchemaReference());
            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IConfigurationElement[] configArray = extensionPoint.getConfigurationElements();
            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "    Number of ConfigurationElements = " + configArray.length);
            int i = 0;
            while (i < configArray.length) {
                IConfigurationElement element = configArray[i];
                PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "        name  = " + element.getName());
                PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "        value = " + element.getValue());
                PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "");
                ++i;
            }
            IExtension[] extensionArray = extensionPoint.getExtensions();
            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "    Number of Extensions = " + extensionArray.length);
            int i2 = 0;
            while (i2 < extensionArray.length) {
                IExtension extension = extensionArray[i2];
                PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "        label = " + extension.getLabel());
                PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "        Number of ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    block28: {
                        IConfigurationElement element = configArray2[j];
                        PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "            element.name  = " + element.getName());
                        PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "            element.value = " + element.getValue());
                        String plugin_id = element.getAttribute("pluginId");
                        PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "            pluginId     = " + plugin_id);
                        if (UiPlugin.getPluginRegistrationManager().isPluginRegistered(plugin_id)) {
                            String className = null;
                            String propertyTabId = element.getAttribute("propertyTabId");
                            String extensionValue = element.getAttribute("class");
                            String objectId = element.getAttribute("objectId");
                            String pluginID = element.getAttribute("pluginId");
                            String propertyTabName = element.getAttribute("propertyTabName");
                            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "            propertyTabId     = " + propertyTabId);
                            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "            objectId     = " + objectId);
                            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "            pluginID     = " + pluginID);
                            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "            propertyTabName     = " + propertyTabName);
                            if (this.hashtablePluginIds.containsKey(propertyTabId)) {
                                if (Trace.isTracing) {
                                    t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "The propertyTabId '" + propertyTabId + "' for pluginId '" + pluginID + "' is not unique");
                                }
                                t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 10, 50999, 0, 0, "The propertyTabId specified in the extension point is not unique", "pluginId = '" + pluginID + "'", "propertyTabId = '" + propertyTabId + "'");
                            } else {
                                int indexOfForwardSlash;
                                int index;
                                if (pluginID == null && (index = extensionValue.indexOf(":")) != -1) {
                                    pluginID = extensionValue.substring(index);
                                }
                                className = (indexOfForwardSlash = extensionValue.indexOf("/")) == -1 ? extensionValue : extensionValue.substring(indexOfForwardSlash + 1, extensionValue.length());
                                try {
                                    Bundle classBundle = Platform.getBundle((String)pluginID);
                                    if (classBundle != null) {
                                        IPropertyTabFactory factory = (IPropertyTabFactory)classBundle.loadClass(className).newInstance();
                                        if (factory != null) {
                                            this.addPropertyTabFactory(t, propertyTabId, factory, plugin_id, objectId, propertyTabName);
                                        } else {
                                            if (Trace.isTracing) {
                                                t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "Unable to load the class '" + className + "' for pluginId '" + pluginID + "'");
                                            }
                                            t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 10, 50999, 0, 0, "Unable to load class specified in  extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                                        }
                                        break block28;
                                    }
                                    if (Trace.isTracing) {
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "Unable to get the bundle for plug-in id '" + pluginID + "'");
                                    }
                                    t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 20, 50999, 0, 0, "Invalid pluginId specified in  extension point", "pluginId = '" + pluginID + "'", "");
                                }
                                catch (NullPointerException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "NullPointerException loading  extension point:");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, e.getLocalizedMessage());
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 30, 50999, 0, 0, "NullPointerException loading  extension point", "pluginId = '" + pluginID + "'", "");
                                }
                                catch (InstantiationException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "InstantiationException loading  extension point:");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, e.getLocalizedMessage());
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 40, 50999, 0, 0, "InstantiationException loading  extension point", "pluginId = '" + pluginID + "'", "");
                                }
                                catch (IllegalAccessException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "IllegalAccessException loading  extension point:");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, e.getLocalizedMessage());
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 50, 50999, 0, 0, "IllegalAccessException loading  extension point", "pluginId = '" + pluginID + "'", "");
                                }
                                catch (ClassNotFoundException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "ClassNotFoundException loading  extension point:");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, e.getLocalizedMessage());
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 60, 50999, 0, 0, "ClassNotFoundException loading  extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                                }
                                catch (ClassCastException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "ClassCastException loading  extension point:");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, e.getLocalizedMessage());
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 65, 50999, 0, 0, "ClassCastException loading  extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                                }
                                catch (Throwable e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "Throwable loading  extension point:");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, e.getLocalizedMessage());
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 70, 50999, 0, 0, "Throwable loading  extension point", "pluginId = '" + pluginID + "'", "");
                                }
                            }
                        } else {
                            PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", ">> ignoring - plug-in not registered");
                            t.FFST(67, "PropertyTabFactoryManager.loadPropertyTabFactories", 80, 50999, 0, 0, "Ignoring  extension point, plug-in not registered", "pluginId = '" + plugin_id + "'", "");
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
        PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "");
        PropertyTabFactoryManager.trace(t, "PropertyTabFactoryManager.loadPropertyTabFactories", "");
    }

    public ArrayList<IPropertyTabFactory> getPropertyTabFactoryArray() {
        return this.propertyTabFactories;
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    private void addPropertyTabFactory(Trace t, String propertyTabId, IPropertyTabFactory propertyTabFactory, String pluginId, String objectId, String propertyTabName) {
        this.hashtablePluginIds.put(propertyTabId, pluginId);
        this.propertyTabFactories.add(propertyTabFactory);
        this.hashtableObjectIds.put(propertyTabId, objectId);
        this.hashtablePropertyTabFactories.put(propertyTabName, propertyTabFactory);
        this.hashtablePropertyTabNames.put(propertyTabId, propertyTabName);
    }

    private boolean isPluginEnabledForPropertyTabFactory(Trace t, String propertyTabId) {
        boolean enabled = false;
        String pluginId = this.hashtablePluginIds.get(propertyTabId);
        if (pluginId != null) {
            enabled = UiPlugin.isPluginEnabled(pluginId);
        }
        return enabled;
    }

    public ArrayList<String> getPropertyTabNames(Trace t, String objectType) {
        ArrayList<String> propertyTabNames = new ArrayList<String>(0);
        Enumeration<String> propertyTabIds = this.hashtableObjectIds.keys();
        while (propertyTabIds.hasMoreElements()) {
            String propertyTabId = propertyTabIds.nextElement();
            if (!this.hashtableObjectIds.get(propertyTabId).equals(objectType) || !this.isPluginEnabledForPropertyTabFactory(t, propertyTabId)) continue;
            String propertyTabName = this.hashtablePropertyTabNames.get(propertyTabId);
            propertyTabNames.add(propertyTabName);
        }
        return propertyTabNames;
    }

    public IPropertyTabFactory getPropertyTabFactory(Trace t, String propertyTabName) {
        IPropertyTabFactory propertyTabFactory = this.hashtablePropertyTabFactories.get(propertyTabName);
        return propertyTabFactory;
    }
}

