/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistration;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.ExplorerProviderFactory;
import com.ibm.mq.explorer.ui.internal.objects.IExplorerProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ObjectRegistrationManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/ObjectRegistrationManager.java";
    public static final String PROVIDER_ID_COMPARE_WITH = "com.ibm.mq.explorer.provider.compare.with";
    public static final String PROVIDER_ID_FILTER = "com.ibm.mq.explorer.provider.filter";
    public static final String PROVIDER_ID_STATUS = "com.ibm.mq.explorer.provider.status";
    public static final String PROVIDER_ID_GENERIC_STATUS = "com.ibm.mq.explorer.provider.generic.status";
    public static final String PROVIDER_ID_ZOS_STATUS = "com.ibm.mq.explorer.provider.zos.status";
    public static final String PROVIDER_ID_NEW_OBJECT = "com.ibm.mq.explorer.provider.new.object";
    public static final String PROVIDER_ID_CONFIGURATION = "com.ibm.mq.explorer.provider.configuration";
    private static Hashtable<String, ObjectRegistration> objectRegistrations = null;
    private static Hashtable<String, RegisteredObjectFactory> objectFactories = null;
    private static Hashtable<String, String> objectIds = null;

    public ObjectRegistrationManager(Trace t) {
        objectRegistrations = new Hashtable();
        objectFactories = new Hashtable();
        objectIds = new Hashtable();
    }

    public void loadObjectRegistrations(Trace t) {
        ObjectRegistration objectReg = null;
        Integer datamodel_type = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", "internal_registerObject");
        if (extensionPoint != null) {
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "    label = " + extensionPoint.getLabel());
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "    schemaReference = " + extensionPoint.getSchemaReference());
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IConfigurationElement[] configArray = extensionPoint.getConfigurationElements();
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "    Number of ConfigurationElements = " + configArray.length);
            int i = 0;
            while (i < configArray.length) {
                IConfigurationElement element = configArray[i];
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "        name  = " + element.getName());
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "        value = " + element.getValue());
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "");
                ++i;
            }
            IExtension[] extensionArray = extensionPoint.getExtensions();
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "    Number of Extensions = " + extensionArray.length);
            int i2 = 0;
            while (i2 < extensionArray.length) {
                IExtension extension = extensionArray[i2];
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "        label = " + extension.getLabel());
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "        Number of ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    IConfigurationElement element = configArray2[j];
                    ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "            element.name  = " + element.getName());
                    ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "            element.value = " + element.getValue());
                    String plugin_id = element.getDeclaringExtension().getNamespaceIdentifier();
                    if (UiPlugin.getPluginRegistrationManager().isPluginRegistered(plugin_id)) {
                        String object_id = element.getAttribute("objectId");
                        ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "              objectId            = " + object_id);
                        String dm_type = element.getAttribute("datamodelObjectType");
                        try {
                            datamodel_type = Integer.valueOf(dm_type);
                            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "              datamodelObjectType = " + datamodel_type);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (Trace.isTracing) {
                                t.data(67, "ObjectRegistrationManager.loadObjectRegistrations", 900, "NumberFormatException loading datamodelObjectType for objectId '" + object_id + "' on pluginId '" + plugin_id + "'");
                            }
                            t.FFST(67, "ObjectRegistrationManager.loadObjectRegistrations", 10, 50999, 0, 0, "Invalid datamodelObjectType specified in internal_registerObject extension point", "pluginId = '" + plugin_id + "'", "datamodelObjectType = '" + datamodel_type + "'");
                            datamodel_type = 0;
                        }
                        String objectClass = element.getAttribute("objectClass");
                        ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "              objectClass         = " + objectClass);
                        String externalObjectClass = element.getAttribute("externalObjectClass");
                        ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "      externalObjectClass         = " + externalObjectClass);
                        try {
                            Object obj = element.createExecutableExtension("objectClass");
                            if (obj instanceof UiMQObject) {
                                Object externalObj;
                                MQExtObject mqExtObj = null;
                                if (externalObjectClass != null && (externalObj = element.createExecutableExtension("externalObjectClass")) instanceof MQExtObject) {
                                    mqExtObj = (MQExtObject)externalObj;
                                }
                                objectReg = new ObjectRegistration(t, object_id, datamodel_type, obj.getClass(), plugin_id, mqExtObj);
                                objectRegistrations.put(object_id, objectReg);
                                objectIds.put(dm_type, object_id);
                                RegisteredObjectFactory objFactory = new RegisteredObjectFactory(objectReg);
                                objectFactories.put(object_id, objFactory);
                            }
                        }
                        catch (CoreException coreException) {
                            if (Trace.isTracing) {
                                t.data(67, "ObjectRegistrationManager.loadObjectRegistrations", 900, "CoreException loading the objectClass '" + objectClass + "' for pluginId '" + plugin_id + "'");
                            }
                            t.FFST(67, "ObjectRegistrationManager.loadObjectRegistrations", 20, 50999, 0, 0, "CoreException loading objectClass specified in internal_registerObject extension point", "pluginId = '" + plugin_id + "'", "objectClass = '" + objectClass + "'");
                        }
                        if (objectReg != null) {
                            IConfigurationElement[] configArray3 = element.getChildren();
                            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "            Number of Provider ConfigurationElements = " + configArray3.length);
                            int k = 0;
                            while (k < configArray3.length) {
                                IConfigurationElement subElement = configArray3[k];
                                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "                element.name  = " + subElement.getName());
                                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "                element.value = " + subElement.getValue());
                                String providerId = subElement.getAttribute("providerId");
                                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "                providerId    = " + providerId);
                                String providerClass = subElement.getAttribute("providerClass");
                                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadObjectRegistrations", "                providerClass = " + providerClass);
                                try {
                                    Object obj = subElement.createExecutableExtension("providerClass");
                                    if (obj != null) {
                                        objectReg.addProviderClass(t, providerId, obj.getClass());
                                    } else {
                                        if (Trace.isTracing) {
                                            t.data(67, "ObjectRegistrationManager.loadObjectRegistrations", 900, "Unable to load the providerClass '" + providerClass + "' for pluginId '" + plugin_id + "'");
                                        }
                                        t.FFST(67, "ObjectRegistrationManager.loadObjectRegistrations", 30, 50999, 0, 0, "Unable to load providerClass specified in internal_registerObject extension point", "pluginId = '" + plugin_id + "'", "providerClass = '" + providerClass + "'");
                                    }
                                }
                                catch (CoreException coreException) {
                                    if (Trace.isTracing) {
                                        t.data(67, "ObjectRegistrationManager.loadObjectRegistrations", 900, "CoreException loading the providerClass '" + providerClass + "' for pluginId '" + plugin_id + "'");
                                    }
                                    t.FFST(67, "ObjectRegistrationManager.loadObjectRegistrations", 40, 50999, 0, 0, "CoreException loading the providerClass specified in internal_registerObject extension point", "pluginId = '" + plugin_id + "'", "providerClass = '" + providerClass + "'");
                                }
                                ++k;
                            }
                        } else {
                            if (Trace.isTracing) {
                                t.data(67, "ObjectRegistrationManager.loadObjectRegistrations", 900, "internal_registerObject extension point ignored, pluginId '" + plugin_id + "' not registered");
                            }
                            t.FFST(67, "ObjectRegistrationManager.loadObjectRegistrations", 50, 50999, 0, 0, "internal_registerObject extension point ignored, plug-in not registered", "pluginId = '" + plugin_id + "'", "");
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
    }

    public void loadAssociatedProviders(Trace t) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", "internal_associateProvider");
        if (extensionPoint != null) {
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "    label = " + extensionPoint.getLabel());
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "    schemaReference = " + extensionPoint.getSchemaReference());
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IConfigurationElement[] configArray = extensionPoint.getConfigurationElements();
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "    Number of ConfigurationElements = " + configArray.length);
            int i = 0;
            while (i < configArray.length) {
                IConfigurationElement element = configArray[i];
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "        name  = " + element.getName());
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "        value = " + element.getValue());
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "");
                ++i;
            }
            IExtension[] extensionArray = extensionPoint.getExtensions();
            ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "    Number of Extensions = " + extensionArray.length);
            int i2 = 0;
            while (i2 < extensionArray.length) {
                IExtension extension = extensionArray[i2];
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "        label = " + extension.getLabel());
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "        Number of ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    block18: {
                        IConfigurationElement element = configArray2[j];
                        ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "            element.name  = " + element.getName());
                        ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "            element.value = " + element.getValue());
                        String plugin_id = element.getDeclaringExtension().getNamespaceIdentifier();
                        if (UiPlugin.getPluginRegistrationManager().isPluginRegistered(plugin_id)) {
                            String object_id = element.getAttribute("objectId");
                            if (object_id != null && object_id.length() > 0) {
                                ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "              objectId            = " + object_id);
                                if (objectRegistrations.containsKey(object_id)) {
                                    ObjectRegistration objectReg = objectRegistrations.get(object_id);
                                    String providerId = element.getAttribute("providerId");
                                    ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "                providerId    = " + providerId);
                                    String providerClass = element.getAttribute("providerClass");
                                    ObjectRegistrationManager.trace(t, "ObjectRegistrationManager.loadAssociatedProviders", "                providerClass = " + providerClass);
                                    try {
                                        Object obj = element.createExecutableExtension("providerClass");
                                        if (obj != null) {
                                            objectReg.addProviderClass(t, providerId, obj.getClass());
                                            break block18;
                                        }
                                        if (Trace.isTracing) {
                                            t.data(67, "ObjectRegistrationManager.loadAssociatedProviders", 900, "Unable to load the providerClass '" + providerClass + "' for pluginId '" + plugin_id + "'");
                                        }
                                        t.FFST(67, "ObjectRegistrationManager.loadAssociatedProviders", 60, 50999, 0, 0, "Unable to load providerClass specified in internal_associateProvider extension point", "pluginId = '" + plugin_id + "'", "providerClass = '" + providerClass + "'");
                                    }
                                    catch (CoreException coreException) {
                                        if (Trace.isTracing) {
                                            t.data(67, "ObjectRegistrationManager.loadAssociatedProviders", 900, "CoreException loading the providerClass '" + providerClass + "' for pluginId '" + plugin_id + "'");
                                        }
                                        t.FFST(67, "ObjectRegistrationManager.loadAssociatedProviders", 70, 50999, 0, 0, "CoreException loading providerClass specified in internal_associateProvider extension point", "pluginId = '" + plugin_id + "'", "providerClass = '" + providerClass + "'");
                                    }
                                } else {
                                    if (Trace.isTracing) {
                                        t.data(67, "ObjectRegistrationManager.loadAssociatedProviders", 900, "internal_associateProvider extension point ignored, objectId '" + object_id + "' is not registered for pluginId '" + plugin_id + "'");
                                    }
                                    t.FFST(67, "ObjectRegistrationManager.loadAssociatedProviders", 80, 50999, 0, 0, "internal_associateProvider extension point ignored, objectId is not registered", "pluginId = '" + plugin_id + "'", "objectId = '" + object_id + "'");
                                }
                            } else {
                                if (Trace.isTracing) {
                                    t.data(67, "ObjectRegistrationManager.loadAssociatedProviders", 900, "internal_associateProvider extension point ignored, objectId not specified for pluginId '" + plugin_id + "'");
                                }
                                t.FFST(67, "ObjectRegistrationManager.loadAssociatedProviders", 90, 50999, 0, 0, "internal_associateProvider extension point ignored, objectId not specified", "pluginId = '" + plugin_id + "'", " ");
                            }
                        } else {
                            if (Trace.isTracing) {
                                t.data(67, "ObjectRegistrationManager.loadAssociatedProviders", 900, "internal_associateProvider extension point ignored, pluginId '" + plugin_id + "' not registered");
                            }
                            t.FFST(67, "ObjectRegistrationManager.loadAssociatedProviders", 100, 50999, 0, 0, "internal_associateProvider extension point ignored, plug-in not registered", "pluginId = '" + plugin_id + "'", "");
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
    }

    public static IUiMQObjectFactory getUiMQObjectFactory(Trace t, String objectId) {
        IUiMQObjectFactory uiMQObjectFactory = objectFactories.get(objectId);
        return uiMQObjectFactory;
    }

    public static IExplorerProvider getExplorerProvider(Trace t, String objectId, String providerId, UiMQObject parent) {
        ExplorerProviderFactory explorerProviderFactory;
        IExplorerProvider explorerProvider = null;
        ObjectRegistration objectReg = objectRegistrations.get(objectId);
        if (objectReg != null && (explorerProvider = objectReg.getProviderObject(t, providerId, parent)) == null && (explorerProvider = (explorerProviderFactory = new ExplorerProviderFactory(objectReg)).create(t, providerId, parent)) != null) {
            objectReg.addProviderObject(t, providerId, parent, explorerProvider);
        }
        return explorerProvider;
    }

    public static IExplorerProvider getExplorerProvider(Trace t, int datamodelType, String providerId, UiMQObject parent) {
        IExplorerProvider explorerProvider = null;
        String key = Integer.valueOf(datamodelType).toString();
        String objectId = objectIds.get(key);
        if (objectId != null) {
            explorerProvider = ObjectRegistrationManager.getExplorerProvider(t, objectId, providerId, parent);
        }
        return explorerProvider;
    }

    public static boolean isObjectIdRegistered(Trace t, String objectId) {
        boolean result = objectRegistrations.containsKey(objectId);
        return result;
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    class RegisteredObjectFactory
    implements IUiMQObjectFactory {
        private ObjectRegistration objectRegistration = null;

        public RegisteredObjectFactory(ObjectRegistration objectReg) {
            this.objectRegistration = objectReg;
        }

        @Override
        public UiMQObject create(Trace t, IDmObject dmObject, UiMQObject parent) {
            UiMQObject uiMQObject = null;
            uiMQObject = this.objectRegistration.createObject(t, dmObject, parent);
            return uiMQObject;
        }
    }
}

