/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.comparewith.CompareWithProvider;
import com.ibm.mq.explorer.ui.internal.objects.IExplorerProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.status.UiStatusProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public class ObjectRegistration {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/ObjectRegistration.java";
    private String objectId = null;
    private int datamodelType = -1;
    private String pluginId = null;
    private static Class[] constructorParms = null;
    private Constructor constructor = null;
    private static Class[] externalConstructorParms = null;
    private Constructor externalConstructor = null;
    private Hashtable<Object, Class> providerClasses = null;
    private Hashtable<Object, Hashtable<Object, Object>> providerHashtables = null;
    private static String NULL_KEY = "com.ibm.mq.explorer.ui.ObjectRegistrationManager.nullkey";

    public ObjectRegistration(Trace t, String objectId, int datamodelType, Class objectClass, String pluginId, MQExtObject mqExtObject) {
        this.objectId = objectId;
        this.datamodelType = datamodelType;
        this.pluginId = pluginId;
        this.providerClasses = new Hashtable();
        this.providerHashtables = new Hashtable();
        if (constructorParms == null) {
            constructorParms = new Class[]{Trace.class, IDmObject.class, UiMQObject.class};
        }
        try {
            this.constructor = objectClass.getConstructor(constructorParms);
        }
        catch (SecurityException securityException) {
            if (Trace.isTracing) {
                t.data(67, "ObjectRegistration.ObjectRegistration", 900, "SecurityException loading the constructor for objectClass '" + objectClass + "' for pluginId '" + pluginId + "'");
            }
            t.FFST(67, "ObjectRegistration.ObjectRegistration", 10, 50999, 0, 0, "SecurityException loading the constructor for objectClass specified in internal_registerObject extension point", "pluginId = '" + pluginId + "'", "objectClass = '" + objectClass + "'");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Trace.isTracing) {
                t.data(67, "ObjectRegistration.ObjectRegistration", 900, "NoSuchMethodException loading the constructor for objectClass '" + objectClass + "' for pluginId '" + pluginId + "'");
            }
            t.FFST(67, "ObjectRegistration.ObjectRegistration", 20, 50999, 0, 0, "NoSuchMethodException loading the constructor for objectClass specified in internal_registerObject extension point", "pluginId = '" + pluginId + "'", "objectClass = '" + objectClass + "'");
        }
        if (mqExtObject != null) {
            if (externalConstructorParms == null) {
                externalConstructorParms = new Class[]{MQExtObject.class, Object.class, String.class, String.class, String.class};
            }
            try {
                this.externalConstructor = mqExtObject.getClass().getConstructor(externalConstructorParms);
            }
            catch (SecurityException securityException) {
                if (Trace.isTracing) {
                    t.data(67, "ObjectRegistration.ObjectRegistration", 900, "SecurityException loading the constructor for externalObject class '" + mqExtObject.getClass() + "' for pluginId '" + pluginId + "'");
                }
                t.FFST(67, "ObjectRegistration.ObjectRegistration", 30, 50999, 0, 0, "SecurityException loading the constructor for externalObjectClass specified in internal_registerObject extension point", "pluginId = '" + pluginId + "'", "externalObjectClass = '" + mqExtObject.getClass() + "'");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (Trace.isTracing) {
                    t.data(67, "ObjectRegistration.ObjectRegistration", 900, "NoSuchMethodException loading the constructor for externalObjectClass '" + mqExtObject.getClass() + "' for pluginId '" + pluginId + "'");
                }
                t.FFST(67, "ObjectRegistration.ObjectRegistration", 40, 50999, 0, 0, "NoSuchMethodException loading the constructor for externalObjectClass specified in internal_registerObject extension point", "pluginId = '" + pluginId + "'", "externalObjectClass = '" + mqExtObject.getClass() + "'");
            }
        }
    }

    public UiMQObject createObject(Trace t, IDmObject dmObject, UiMQObject parent) {
        UiMQObject uiMQObject = null;
        if (this.constructor != null) {
            try {
                Object[] parms = new Object[]{t, dmObject, parent};
                uiMQObject = (UiMQObject)this.constructor.newInstance(parms);
                uiMQObject.setUiStatusProvider((UiStatusProvider)ObjectRegistrationManager.getExplorerProvider(t, this.objectId, "com.ibm.mq.explorer.provider.status", parent));
                uiMQObject.setCompareWithProvider((CompareWithProvider)ObjectRegistrationManager.getExplorerProvider(t, this.objectId, "com.ibm.mq.explorer.provider.compare.with", parent));
                if (this.externalConstructor != null) {
                    try {
                        Object[] externalParms = new Object[]{parent == null ? null : parent.getExternalObject(), uiMQObject, this.objectId, this.objectId, uiMQObject.toString()};
                        MQExtObject extObject = (MQExtObject)this.externalConstructor.newInstance(externalParms);
                        uiMQObject.setExternalObject(extObject);
                        t.data(67, "ObjectRegistration.createObject", 300, "Successfully created an external object from class specified in internal_registerObject extension point");
                    }
                    catch (InstantiationException instantiationException) {
                        if (Trace.isTracing) {
                            t.data(67, "ObjectRegistration.createObject", 900, "InstantiationException creating an external object for objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                        }
                        t.FFST(67, "ObjectRegistration.createObject", 2, 50999, 0, 0, "InstantiationException creating an external object specified in internal_registerObject extension point", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (Trace.isTracing) {
                            t.data(67, "ObjectRegistration.createObject", 900, "IllegalAccessException creating an external object for objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                        }
                        t.FFST(67, "ObjectRegistration.createObject", 4, 50999, 0, 0, "IllegalAccessException creating an external object specified in internal_registerObject extension point", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (Trace.isTracing) {
                            t.data(67, "ObjectRegistration.createObject", 900, "IllegalArgumentException creating an external object for objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                        }
                        t.FFST(67, "ObjectRegistration.createObject", 6, 50999, 0, 0, "IllegalArgumentException creating an external object specified in internal_registerObject extension point", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (Trace.isTracing) {
                            t.data(67, "ObjectRegistration.createObject", 900, "InvocationTargetException creating an external object for objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                        }
                        t.FFST(67, "ObjectRegistration.createObject", 8, 50999, 0, 0, "InvocationTargetException creating an external object specified in internal_registerObject extension point", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
                    }
                } else {
                    MQExtObject extObject = new MQExtObject(parent == null ? null : parent.getExternalObject(), uiMQObject, this.objectId, this.objectId, uiMQObject.toString());
                    uiMQObject.setExternalObject(extObject);
                    t.data(67, "ObjectRegistration.createObject", 300, "successfully created the standard external object 'MQExtObject'");
                }
            }
            catch (InstantiationException instantiationException) {
                if (Trace.isTracing) {
                    t.data(67, "ObjectRegistration.createObject", 900, "InstantiationException creating an object for objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                }
                t.FFST(67, "ObjectRegistration.createObject", 30, 50999, 0, 0, "InstantiationException creating an object specified in internal_registerObject extension point", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
            }
            catch (IllegalAccessException illegalAccessException) {
                if (Trace.isTracing) {
                    t.data(67, "ObjectRegistration.createObject", 900, "IllegalAccessException creating an object for objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                }
                t.FFST(67, "ObjectRegistration.createObject", 40, 50999, 0, 0, "IllegalAccessException creating an object specified in internal_registerObject extension point", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (Trace.isTracing) {
                    t.data(67, "ObjectRegistration.createObject", 900, "IllegalArgumentException creating an object for objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                }
                t.FFST(67, "ObjectRegistration.createObject", 50, 50999, 0, 0, "IllegalArgumentException creating an object specified in internal_registerObject extension point", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
            }
            catch (InvocationTargetException invocationTargetException) {
                if (Trace.isTracing) {
                    t.data(67, "ObjectRegistration.createObject", 900, "InvocationTargetException creating an object for objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                }
                t.FFST(67, "ObjectRegistration.createObject", 60, 50999, 0, 0, "InvocationTargetException creating an object specified in internal_registerObject extension point", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
            }
        }
        return uiMQObject;
    }

    public int getDatamodelType() {
        return this.datamodelType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void addProviderClass(Trace t, String providerId, Class providerClass) {
        this.providerClasses.put(this.makeValidKey(providerId), providerClass);
    }

    public IExplorerProvider createProvider(Trace t, String providerId, UiMQObject parent) {
        IExplorerProvider explorerProvider = null;
        Constructor cons = null;
        Class[] consParms = null;
        Class providerClass = this.providerClasses.get(this.makeValidKey(providerId));
        if (providerClass != null) {
            consParms = new Class[]{Trace.class, UiMQObject.class};
            try {
                cons = providerClass.getConstructor(consParms);
            }
            catch (SecurityException securityException) {
                if (Trace.isTracing) {
                    t.data(67, "ObjectRegistration.createProvider", 900, "SecurityException loading the constructor for providerClass '" + providerClass + "' for pluginId '" + this.pluginId + "'");
                }
                t.FFST(67, "ObjectRegistration.createProvider", 70, 50999, 0, 0, "SecurityException loading the constructor for providerClass", "pluginId = '" + this.pluginId + "'", "providerClass = '" + providerClass + "'");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (Trace.isTracing) {
                    t.data(67, "ObjectRegistration.createProvider", 900, "NoSuchMethodException loading the constructor for providerClass '" + providerClass + "' for pluginId '" + this.pluginId + "'");
                }
                t.FFST(67, "ObjectRegistration.createProvider", 80, 50999, 0, 0, "NoSuchMethodException loading the constructor for providerClass", "pluginId = '" + this.pluginId + "'", "providerClass = '" + providerClass + "'");
            }
            if (cons != null) {
                try {
                    Object[] parms = new Object[]{t, parent};
                    explorerProvider = (IExplorerProvider)cons.newInstance(parms);
                }
                catch (InstantiationException instantiationException) {
                    if (Trace.isTracing) {
                        t.data(67, "ObjectRegistration.createProvider", 900, "InstantiationException creating a provider for providerId '" + providerId + "' and objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                    }
                    t.FFST(67, "ObjectRegistration.createProvider", 90, 50999, 0, 0, "InstantiationException creating a provider with id '" + providerId + "'", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (Trace.isTracing) {
                        t.data(67, "ObjectRegistration.createProvider", 900, "IllegalAccessException creating a provider for providerId '" + providerId + "' and objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                    }
                    t.FFST(67, "ObjectRegistration.createProvider", 100, 50999, 0, 0, "IllegatAccessException creating a provider with id '" + providerId + "'", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (Trace.isTracing) {
                        t.data(67, "ObjectRegistration.createProvider", 900, "IllegalArgumentException creating a provider for providerId '" + providerId + "' and objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                    }
                    t.FFST(67, "ObjectRegistration.createProvider", 110, 50999, 0, 0, "IllegalArgementException creating a provider with id '" + providerId + "'", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (Trace.isTracing) {
                        t.data(67, "ObjectRegistration.createProvider", 900, "InvocationTargetException creating a provider for providerId '" + providerId + "' and objectId '" + this.objectId + "' for pluginId '" + this.pluginId + "'");
                    }
                    t.FFST(67, "ObjectRegistration.createProvider", 120, 50999, 0, 0, "InvocationTargetException creating a provider with id '" + providerId + "'", "pluginId = '" + this.pluginId + "'", "objectId = '" + this.objectId + "'");
                }
            }
        }
        return explorerProvider;
    }

    public void addProviderObject(Trace t, String providerId, UiMQObject parent, Object providerObject) {
        Hashtable<Object, Object> hashtable;
        if (!this.providerHashtables.containsKey(providerId)) {
            hashtable = new Hashtable();
            this.providerHashtables.put(this.makeValidKey(providerId), hashtable);
        }
        hashtable = this.providerHashtables.get(this.makeValidKey(providerId));
        hashtable.put(this.makeValidKey(parent), providerObject);
    }

    public IExplorerProvider getProviderObject(Trace t, String providerId, UiMQObject parent) {
        IExplorerProvider providerObject = null;
        Hashtable<Object, Object> hashtable = this.providerHashtables.get(this.makeValidKey(providerId));
        if (hashtable != null) {
            providerObject = (IExplorerProvider)hashtable.get(this.makeValidKey(parent));
        }
        return providerObject;
    }

    private Object makeValidKey(Object inputKey) {
        return inputKey == null ? NULL_KEY : inputKey;
    }
}

