/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.IExplorerNotify;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.NotificationKey;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class NotificationManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/NotificationManager.java";
    private ArrayList<NotificationKey> explorerNotifyClasses = new ArrayList();

    public NotificationManager(Trace t) {
    }

    public void loadExplorerNotificationClasses(Trace t) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", "registerplugin");
        if (extensionPoint != null) {
            NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "    label = " + extensionPoint.getLabel());
            NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "    schemaReference = " + extensionPoint.getSchemaReference());
            NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IConfigurationElement[] configArray = extensionPoint.getConfigurationElements();
            NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "    Number of ConfigurationElements = " + configArray.length);
            int i = 0;
            while (i < configArray.length) {
                IConfigurationElement element = configArray[i];
                NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "        name  = " + element.getName());
                NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "        value = " + element.getValue());
                NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "");
                ++i;
            }
            IExtension[] extensionArray = extensionPoint.getExtensions();
            NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "    Number of Extensions = " + extensionArray.length);
            int i2 = 0;
            while (i2 < extensionArray.length) {
                IExtension extension = extensionArray[i2];
                NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "        label = " + extension.getLabel());
                NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "        Number of ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    block26: {
                        IConfigurationElement element = configArray2[j];
                        NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "            element.name  = " + element.getName());
                        NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "            element.value = " + element.getValue());
                        String class_name = element.getAttribute("class");
                        if (class_name != null && class_name.length() > 0) {
                            NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "            class        = " + class_name);
                            String plugin_id = element.getAttribute("pluginId");
                            NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "            pluginId     = " + plugin_id);
                            if (UiPlugin.getPluginRegistrationManager().isPluginRegistered(plugin_id)) {
                                int indexOfForwardSlash;
                                int index;
                                String className = null;
                                String extensionValue = element.getAttribute("class");
                                String pluginID = element.getAttribute("pluginId");
                                if (pluginID == null && (index = extensionValue.indexOf(":")) != -1) {
                                    pluginID = extensionValue.substring(index);
                                }
                                className = (indexOfForwardSlash = extensionValue.indexOf("/")) == -1 ? extensionValue : extensionValue.substring(indexOfForwardSlash + 1, extensionValue.length());
                                try {
                                    Bundle classBundle = Platform.getBundle((String)pluginID);
                                    if (classBundle != null) {
                                        IExplorerNotify explorerNotify = (IExplorerNotify)classBundle.loadClass(className).newInstance();
                                        if (explorerNotify != null) {
                                            NotificationKey key = new NotificationKey(explorerNotify, className, pluginID);
                                            this.explorerNotifyClasses.add(key);
                                        } else {
                                            if (Trace.isTracing) {
                                                t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "Unable to load the class '" + className + "' for pluginId '" + pluginID + "'");
                                            }
                                            t.FFST(67, "NotificationManager.loadExplorerNotificationClasses", 5, 50999, 0, 0, "Unable to load class specified in registerPlugin extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                                        }
                                        break block26;
                                    }
                                    if (Trace.isTracing) {
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "Unable to get the bundle for plug-in id '" + pluginID + "'");
                                    }
                                    t.FFST(67, "NotificationManager.loadExplorerNotificationClasses", 10, 50999, 0, 0, "Invalid pluginId specified in registerPlugin extension point", "pluginId = '" + pluginID + "'", "");
                                }
                                catch (NullPointerException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "NullPointerException loading registerPlugin extension point:");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, e.getLocalizedMessage());
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "NotificationManager.loadExplorerNotificationClasses", 20, 50999, 0, 0, "NullPointerException loading registerPlugin extension point", "pluginId = '" + pluginID + "'", "");
                                }
                                catch (InstantiationException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "InstantiationException loading registerPlugin extension point:");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, e.getLocalizedMessage());
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "NotificationManager.loadExplorerNotificationClasses", 30, 50999, 0, 0, "InstantiationException loading registerPlugin extension point", "pluginId = '" + pluginID + "'", "");
                                }
                                catch (IllegalAccessException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "IllegalAccessException loading registerPlugin extension point:");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, e.getLocalizedMessage());
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "NotificationManager.loadExplorerNotificationClasses", 40, 50999, 0, 0, "IllegalAccessException loading registerPlugin extension point", "pluginId = '" + pluginID + "'", "");
                                }
                                catch (ClassNotFoundException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "ClassNotFoundException loading registerPlugin extension point:");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, e.getLocalizedMessage());
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "NotificationManager.loadExplorerNotificationClasses", 50, 50999, 0, 0, "ClassNotFoundException loading registerPlugin extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                                }
                                catch (ClassCastException e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "ClassCastException loading registerPlugin extension point:");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, e.getLocalizedMessage());
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "NotificationManager.loadExplorerNotificationClasses", 60, 50999, 0, 0, "ClassCastException loading registerPlugin extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                                }
                                catch (Throwable e) {
                                    if (Trace.isTracing) {
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "Throwable loading registerPlugin extension point:");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, e.getLocalizedMessage());
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "pluginId = '" + pluginID + "'");
                                        t.data(67, "NotificationManager.loadExplorerNotificationClasses", 900, "className = '" + className + "'");
                                    }
                                    t.FFST(67, "NotificationManager.loadExplorerNotificationClasses", 70, 50999, 0, 0, "Throwable loading registerPlugin extension point", "pluginId = '" + pluginID + "'", e.getLocalizedMessage());
                                }
                            } else {
                                NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", ">> ignoring - plug-in not registered");
                            }
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
        NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "");
        NotificationManager.trace(t, "NotificationManager.loadExplorerNotificationClasses", "");
    }

    public void notifyExplorerInitialised(Trace t) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            String pluginId = nk.getPluginId();
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(pluginId)) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                try {
                    explorerNotifyClass.explorerInitialised();
                }
                catch (Exception e) {
                    this.notificationError(t, "NotificationManager.notifyExplorerInitialised", e, pluginId);
                }
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyExplorerInitialised", 500, "Class '" + explorerNotifyClass.toString() + "' sent explorer initialised event");
                }
            }
            ++i;
        }
    }

    public void notifyQueueManagerAdded(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.queueManagerAdded(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyQueueManagerAdded", 500, "Class '" + explorerNotifyClass.toString() + "' sent QM added event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
    }

    public boolean notifyIsPreventRemoveQueueManager(Trace t, ExplorerNotifyEvent event) {
        boolean removeQM = false;
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyIsPreventRemoveQueueManager", 500, "Class '" + explorerNotifyClass.toString() + "' sent isPreventRemoveQM event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
                if (explorerNotifyClass.isPreventRemoveQueueManager(event)) {
                    removeQM = true;
                    if (Trace.isTracing) {
                        t.data(67, "NotificationManager.notifyIsPreventRemoveQueueManager", 500, "Class '" + explorerNotifyClass.toString() + "' veto'd queue manager removal of QM " + ((MQQmgrExtObject)event.getObject()).getName());
                    }
                } else if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyIsPreventRemoveQueueManager", 500, "Class '" + explorerNotifyClass.toString() + "' did not veto queue manager removal of QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
        return removeQM;
    }

    public boolean notifyIsPreventDeleteQueueManager(Trace t, ExplorerNotifyEvent event) {
        boolean removeQM = false;
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyIsPreventDeleteQueueManager", 500, "Class '" + explorerNotifyClass.toString() + "' sent isPreventDeleteQM event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
                if (explorerNotifyClass.isPreventDeleteQueueManager(event)) {
                    removeQM = true;
                    if (Trace.isTracing) {
                        t.data(67, "NotificationManager.notifyIsPreventDeleteQueueManager", 500, "Class '" + explorerNotifyClass.toString() + "' veto'd queue manager deletion of QM " + ((MQQmgrExtObject)event.getObject()).getName());
                    }
                } else if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyIsPreventDeleteQueueManager", 500, "Class '" + explorerNotifyClass.toString() + "' did not veto queue manager deletion of QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
        return removeQM;
    }

    public boolean notifyIsPreventStopQueueManager(Trace t, ExplorerNotifyEvent event) {
        boolean stopQM = false;
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyIsPreventStopQueueManager", 500, "Class '" + explorerNotifyClass.toString() + "' sent isPreventStopQueueManager event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
                if (explorerNotifyClass.isPreventStopQueueManager(event)) {
                    stopQM = true;
                    if (Trace.isTracing) {
                        t.data(67, "NotificationManager.notifyIsPreventStopQueueManager", 500, "Class '" + explorerNotifyClass.toString() + "' veto'd queue manager stopping of QM " + ((MQQmgrExtObject)event.getObject()).getName());
                    }
                } else if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyIsPreventStopQueueManager", 500, "Class '" + explorerNotifyClass.toString() + "' did not veto queue manager stopping of QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
        return stopQM;
    }

    public void notifyQueueManagerRemoved(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.queueManagerRemoved(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyQueueManagerRemoved", 500, "Class '" + explorerNotifyClass.toString() + "' sent QM removed event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
    }

    public void notifyQueueManagerDeleted(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.queueManagerDeleted(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyQueueManagerDeleted", 500, "Class '" + explorerNotifyClass.toString() + "' sent QM deleted event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
    }

    public void notifyQueueManagerStopped(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.queueManagerStopped(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyQueueManagerStopped", 500, "Class '" + explorerNotifyClass.toString() + "' sent QM stopped event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
    }

    public void notifyQueueManagerStarted(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.queueManagerStarted(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyQueueManagerStarted", 500, "Class '" + explorerNotifyClass.toString() + "' sent QM started event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
    }

    public void notifyQueueManagerShown(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.queueManagerShown(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyQueueManagerShown", 500, "Class '" + explorerNotifyClass.toString() + "' sent QM shown event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
    }

    public void notifyQueueManagerHidden(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.queueManagerHidden(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyQueueManagerHidden", 500, "Class '" + explorerNotifyClass.toString() + "' sent QM hidden event for QM " + ((MQQmgrExtObject)event.getObject()).getName());
                }
            }
            ++i;
        }
    }

    public void notifyViewOpened(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.viewOpened(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyViewOpened", 500, "Class '" + explorerNotifyClass.toString() + "' sent view opened event for view " + event.getId());
                }
            }
            ++i;
        }
    }

    public void notifyViewClosed(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.viewClosed(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyViewClosed", 500, "Class '" + explorerNotifyClass.toString() + "' sent view closed event for view " + event.getId());
                }
            }
            ++i;
        }
    }

    public void notifyPluginEnabled(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            String pluginId = nk.getPluginId();
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(pluginId)) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                try {
                    explorerNotifyClass.pluginEnabled(event);
                }
                catch (Exception e) {
                    this.notificationError(t, "NotificationManager.notifyPluginEnabled", e, pluginId);
                }
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyPluginEnabled", 500, "Class '" + explorerNotifyClass.toString() + "' sent plugin enabled event for plugin " + event.getId());
                }
            }
            ++i;
        }
    }

    private void notificationError(Trace t, String fid, Exception e, String pluginId) {
        t.FFST(67, fid, 0, 50018, 0, 0, pluginId, "Notification failed with an exception", e.toString());
        UiPlugin.logException(e);
        String name = UiPlugin.getPluginRegistrationManager().getPluginName(pluginId);
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4560", (String[])new String[]{name, e.toString()});
        MessageBox.showMessageFailure(t, UiPlugin.getShell(), msg, "AMQ4560");
        UiPlugin.getPluginRegistrationManager().enablePlugin(pluginId, false);
    }

    public void notifyPluginDisabled(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId()) || nk.getPluginId().equals(event.getId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.pluginDisabled(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyPluginDisabled", 500, "Class '" + explorerNotifyClass.toString() + "' sent plugin disabled event for plugin " + event.getId());
                }
            }
            ++i;
        }
    }

    public void notifyExplorerPreferenceChanged(Trace t, ExplorerNotifyEvent event) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.explorerPreferenceChanged(event);
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyExplorerPreferenceChanged", 500, "Class '" + explorerNotifyClass.toString() + "' sent explorer preference changed event for plugin " + event.getId());
                }
            }
            ++i;
        }
    }

    public void notifyExplorerClosing(Trace t) {
        int i = 0;
        while (i < this.explorerNotifyClasses.size()) {
            NotificationKey nk = this.explorerNotifyClasses.get(i);
            if (UiPlugin.getPluginRegistrationManager().isPluginEnabled(nk.getPluginId())) {
                IExplorerNotify explorerNotifyClass = nk.getNotifyClass();
                explorerNotifyClass.explorerClosing();
                if (Trace.isTracing) {
                    t.data(67, "NotificationManager.notifyExplorerClosing", 500, "Class '" + explorerNotifyClass.toString() + "' sent explorer closing event");
                }
            }
            ++i;
        }
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    public void addListener(Trace t, IExplorerNotify listener, String id) {
        NotificationKey nk = new NotificationKey(listener, listener.toString(), id);
        this.explorerNotifyClasses.add(nk);
    }

    public void removeListener(Trace t, IExplorerNotify listener, String id) {
        NotificationKey nk = new NotificationKey(listener, listener.toString(), id);
        this.explorerNotifyClasses.remove(nk);
    }
}

