/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.EventLogger;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.UiDisplayData;
import com.ibm.mq.explorer.core.internal.base.CorePlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.Properties;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class InitialiseExplorer {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/InitialiseExplorer.java";
    private static final String MQ_CONNECT_OPTIONS_KEY = "MQ.ConnectOptions";
    private static final String MQ_CCSID = "MQ.CCSID";

    public static Trace initialise(AbstractUIPlugin plugin) {
        Trace t = null;
        t = new Trace("com.ibm.mq.explorer.ui");
        Properties properties = CommonServices.getRASProperties().getProperties();
        if (properties == null) {
            return t;
        }
        int defaultValue = 512;
        String value = properties.getProperty(MQ_CONNECT_OPTIONS_KEY, String.valueOf(defaultValue));
        try {
            CorePlugin.setMQConnectOptions((int)Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            CorePlugin.setMQConnectOptions((int)defaultValue);
        }
        defaultValue = 1208;
        value = properties.getProperty(MQ_CCSID, String.valueOf(defaultValue));
        try {
            CorePlugin.setCCSID((int)Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            CorePlugin.setCCSID((int)defaultValue);
        }
        defaultValue = 1000;
        value = properties.getProperty("UI.RefreshTimerDelay", String.valueOf(defaultValue));
        try {
            UiPlugin.setRefreshTimerDelay(Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            UiPlugin.setRefreshTimerDelay(defaultValue);
        }
        defaultValue = 1000;
        value = properties.getProperty("UI.ResizeColumnsTimerDelay", String.valueOf(defaultValue));
        try {
            UiPlugin.setResizeColumnsTimerDelay(Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            UiPlugin.setResizeColumnsTimerDelay(defaultValue);
        }
        defaultValue = 100;
        value = properties.getProperty("UI.ExplorerTableUpdateBatchSize", String.valueOf(defaultValue));
        try {
            UiPlugin.setExplorerTableUpdateBatchSize(Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            UiPlugin.setExplorerTableUpdateBatchSize(defaultValue);
        }
        value = properties.getProperty("Trace.JLog.EventLogging", "no");
        if (value.compareToIgnoreCase("yes") == 0 && CommonServices.createEventLogger((Trace)t, (String)"com.ibm.mq.explorer.ui.event", (String)EventLogger.UI_EVENT_FILENAME, (int)2)) {
            Trace.setEventLogging((boolean)true);
        }
        if (Display.getCurrent() != null) {
            UiDisplayData.setUiThread((Thread)Display.getCurrent().getThread());
        }
        return t;
    }

    private InitialiseExplorer() {
        System.out.println("*** You should not be using this constructor ***");
    }
}

