/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.IContentPageFactory;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.machine.WelcomeContentPageFactory;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ContentPageFactoryManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/ContentPageFactoryManager.java";
    private Hashtable<String, IContentPageFactory> contentPageFactories = new Hashtable();
    private Hashtable<IContentPageFactory, String> hashtablePluginIds = new Hashtable();

    public ContentPageFactoryManager(Trace t) {
    }

    public void loadContentPageFactories(Trace t) {
        this.loadInternalContentPageFactories(t);
        this.loadExternalContentPageFactories(t);
    }

    private void loadInternalContentPageFactories(Trace t) {
        WelcomeContentPageFactory contentPageFactory = new WelcomeContentPageFactory();
        this.addContentPageFactory(t, contentPageFactory.getPageId(), contentPageFactory, "com.ibm.mq.explorer.ui");
    }

    private void loadExternalContentPageFactories(Trace t) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", "addcontentpage");
        if (extensionPoint != null) {
            ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "    label = " + extensionPoint.getLabel());
            ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "    schemaReference = " + extensionPoint.getSchemaReference());
            ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IConfigurationElement[] configArray = extensionPoint.getConfigurationElements();
            ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "    Number of ConfigurationElements = " + configArray.length);
            int i = 0;
            while (i < configArray.length) {
                IConfigurationElement element = configArray[i];
                ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "        name  = " + element.getName());
                ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "        value = " + element.getValue());
                ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "");
                ++i;
            }
            IExtension[] extensionArray = extensionPoint.getExtensions();
            ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "    Number of Extensions = " + extensionArray.length);
            int i2 = 0;
            while (i2 < extensionArray.length) {
                IExtension extension = extensionArray[i2];
                ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "        label = " + extension.getLabel());
                ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "        Number of ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    block28: {
                        IConfigurationElement element = configArray2[j];
                        ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "            element.name  = " + element.getName());
                        ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "            element.value = " + element.getValue());
                        String plugin_id = element.getAttribute("pluginId");
                        ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "            pluginId     = " + plugin_id);
                        if (UiPlugin.getPluginRegistrationManager().isPluginRegistered(plugin_id)) {
                            int indexOfForwardSlash;
                            int index;
                            String content_page_id = element.getAttribute("contentPageId");
                            ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "            contentPageId = " + content_page_id);
                            String className = null;
                            String extensionValue = element.getAttribute("class");
                            String pluginID = element.getAttribute("pluginId");
                            if (pluginID == null && (index = extensionValue.indexOf(":")) != -1) {
                                pluginID = extensionValue.substring(index);
                            }
                            className = (indexOfForwardSlash = extensionValue.indexOf("/")) == -1 ? extensionValue : extensionValue.substring(indexOfForwardSlash + 1, extensionValue.length());
                            try {
                                Bundle classBundle = Platform.getBundle((String)pluginID);
                                if (classBundle != null) {
                                    IContentPageFactory factory = (IContentPageFactory)classBundle.loadClass(className).newInstance();
                                    if (factory != null) {
                                        String factoryPageId = factory.getPageId();
                                        if (factoryPageId == null || factoryPageId.compareTo(content_page_id) != 0) {
                                            if (Trace.isTracing) {
                                                t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "Page ids for the class '" + className + "' for pluginId '" + pluginID + "' do not match");
                                            }
                                            t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 5, 50999, 0, 0, "Non-matching page ids for class specified in addContentPage extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                                        } else {
                                            this.addContentPageFactory(t, content_page_id, factory, plugin_id);
                                        }
                                    } else {
                                        if (Trace.isTracing) {
                                            t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "Unable to load the class '" + className + "' for pluginId '" + pluginID + "'");
                                        }
                                        t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 10, 50999, 0, 0, "Unable to load class specified in addContentPage extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                                    }
                                    break block28;
                                }
                                if (Trace.isTracing) {
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "Unable to get the bundle for plug-in id '" + pluginID + "'");
                                }
                                t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 20, 50999, 0, 0, "Invalid pluginId specified in addContentPage extension point", "pluginId = '" + pluginID + "'", "");
                            }
                            catch (NullPointerException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "NullPointerException loading addContentPage extension point:");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 30, 50999, 0, 0, "NullPointerException loading addContentPage extension point", "pluginId = '" + pluginID + "'", "");
                            }
                            catch (InstantiationException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "InstantiationException loading addContentPage extension point:");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 40, 50999, 0, 0, "InstantiationException loading addContentPage extension point", "pluginId = '" + pluginID + "'", "");
                            }
                            catch (IllegalAccessException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "IllegalAccessException loading addContentPage extension point:");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 50, 50999, 0, 0, "IllegalAccessException loading addContentPage extension point", "pluginId = '" + pluginID + "'", "");
                            }
                            catch (ClassNotFoundException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "ClassNotFoundException loading addContentPage extension point:");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 60, 50999, 0, 0, "ClassNotFoundException loading addContentPage extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                            }
                            catch (ClassCastException e) {
                                if (Trace.isTracing) {
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "ClassCastException loading addContentPage extension point:");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 65, 50999, 0, 0, "ClassCastException loading addContentPage extension point", "pluginId = '" + pluginID + "'", "class = '" + className + "'");
                            }
                            catch (Throwable e) {
                                if (Trace.isTracing) {
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "Throwable loading addContentPage extension point:");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, e.getLocalizedMessage());
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "pluginId = '" + pluginID + "'");
                                    t.data(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 900, "className = '" + className + "'");
                                }
                                t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 70, 50999, 0, 0, "Throwable loading addContentPage extension point", "pluginId = '" + pluginID + "'", "");
                            }
                        } else {
                            ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", ">> ignoring - plug-in not registered");
                            t.FFST(67, "ContentPageFactoryManager.loadExternalContentPageFactories", 80, 50999, 0, 0, "Ignoring addContentPage extension point, plug-in not registered", "pluginId = '" + plugin_id + "'", "");
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
        ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "");
        ContentPageFactoryManager.trace(t, "ContentPageFactoryManager.loadExternalContentPageFactories", "");
    }

    public Hashtable<String, IContentPageFactory> getContentPageFactoryTable() {
        return this.contentPageFactories;
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    private void addContentPageFactory(Trace t, String contentPageId, IContentPageFactory contentPageFactory, String pluginId) {
        this.contentPageFactories.put(contentPageId, contentPageFactory);
        this.hashtablePluginIds.put(contentPageFactory, pluginId);
    }

    public boolean isPluginEnabledForContentPageFactory(Trace t, IContentPageFactory contentPageFactory) {
        boolean enabled = false;
        String pluginId = this.hashtablePluginIds.get(contentPageFactory);
        if (pluginId != null) {
            enabled = UiPlugin.isPluginEnabled(pluginId);
        }
        return enabled;
    }
}

