/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IActionFilter;

public class ActionFilterManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String MQEXTOBJECT_ACTIONFILTER_EXTENSION_POINT = "com.ibm.mq.explorer.ui.internal_addMQExtObjectActionFilter";
    public static final String TREENODE_ACTIONFILTER_EXTENSION_POINT = "com.ibm.mq.explorer.ui.internal_addTreeNodeActionFilter";
    public static final String FILTER_CLASS = "filterClass";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/base/ActionFilterManager.java";
    private ArrayList<IActionFilter> extObjectFilters = new ArrayList();
    private ArrayList<IActionFilter> treeNodeFilters = new ArrayList();

    public void loadActionFilterClasses(Trace t) {
        this.loadMQExtObjectFilters(t);
        this.loadTreeNodeFilters(t);
    }

    private void loadMQExtObjectFilters(Trace t) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(MQEXTOBJECT_ACTIONFILTER_EXTENSION_POINT);
        IConfigurationElement[] filters = extensionPoint.getConfigurationElements();
        if (Trace.isTracing) {
            t.data(67, "ActionFilterManager.loadMQExtObjectFilters", 300, "Processing extension point: com.ibm.mq.explorer.ui.internal_addMQExtObjectActionFilter");
        }
        int k = 0;
        while (k < filters.length) {
            IConfigurationElement filterElement = filters[k];
            String pluginID = filterElement.getDeclaringExtension().getNamespaceIdentifier();
            try {
                String classname = filterElement.getAttribute(FILTER_CLASS);
                if (classname.equals("")) {
                    t.FFST(67, "ActionFilterManager.loadMQExtObjectFilters", 0, 50046, 0, 0, pluginID, "Extension point specified an empty class name", "");
                } else {
                    Object filterObject = filterElement.createExecutableExtension(FILTER_CLASS);
                    if (!(filterObject instanceof IActionFilter)) {
                        t.FFST(67, "ActionFilterManager.loadMQExtObjectFilters", 1, 50046, 0, 0, pluginID, "Extension point specified a class that is not an instance of IActionFilter", "");
                    } else {
                        this.extObjectFilters.add((IActionFilter)filterObject);
                    }
                }
            }
            catch (CoreException ex) {
                t.FFST(67, "ActionFilterManager.loadMQExtObjectFilters", 2, 50046, 0, 0, pluginID, "Extension point processing failed with an exception", ex.getMessage());
            }
            catch (Exception classexc) {
                t.FFST(67, "ActionFilterManager.loadMQExtObjectFilters", 3, 50046, 0, 0, pluginID, "Extension point processing failed with an exception", classexc.getMessage());
            }
            catch (Error err) {
                t.FFST(67, "ActionFilterManager.loadMQExtObjectFilters", 4, 50046, 0, 0, pluginID, "Extension point processing failed with an exception", err.getMessage());
            }
            ++k;
        }
    }

    private void loadTreeNodeFilters(Trace t) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(TREENODE_ACTIONFILTER_EXTENSION_POINT);
        IConfigurationElement[] filters = extensionPoint.getConfigurationElements();
        if (Trace.isTracing) {
            t.data(67, "ActionFilterManager.loadTreeNodeFilters", 300, "Processing extension point: com.ibm.mq.explorer.ui.internal_addTreeNodeActionFilter");
        }
        int k = 0;
        while (k < filters.length) {
            IConfigurationElement filterElement = filters[k];
            String pluginID = filterElement.getDeclaringExtension().getNamespaceIdentifier();
            try {
                String classname = filterElement.getAttribute(FILTER_CLASS);
                if (classname.equals("")) {
                    t.FFST(67, "ActionFilterManager.loadTreeNodeFilters", 0, 50046, 0, 0, pluginID, "Extension point specified an empty class name", "");
                } else {
                    Object filterObject = filterElement.createExecutableExtension(FILTER_CLASS);
                    if (!(filterObject instanceof IActionFilter)) {
                        t.FFST(67, "ActionFilterManager.loadTreeNodeFilters", 1, 50046, 0, 0, pluginID, "Extension point specified a class that is not an instance of IActionFilter", "");
                    } else {
                        this.treeNodeFilters.add((IActionFilter)filterObject);
                    }
                }
            }
            catch (CoreException ex) {
                t.FFST(67, "ActionFilterManager.loadTreeNodeFilters", 2, 50046, 0, 0, pluginID, "Extension point processing failed with an exception", ex.getMessage());
            }
            catch (Exception classexc) {
                t.FFST(67, "ActionFilterManager.loadTreeNodeFilters", 3, 50046, 0, 0, pluginID, "Extension point processing failed with an exception", classexc.getMessage());
            }
            catch (Error err) {
                t.FFST(67, "ActionFilterManager.loadTreeNodeFilters", 4, 50046, 0, 0, pluginID, "Extension point processing failed with an exception", err.getMessage());
            }
            ++k;
        }
    }

    public ArrayList getMQExtObjectFilters(Trace t) {
        return this.extObjectFilters;
    }

    public ArrayList getTreeNodeFilters(Trace t) {
        return this.treeNodeFilters;
    }
}

