/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.ManageAttributeOrdersDialog;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.controls.ExtList;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectAttributeOrderDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/SelectAttributeOrderDialog.java";
    private static final int LIST_WIDTH_HINT = 400;
    private static final int LIST_HEIGHT_HINT = 250;
    private String attrOrderId = null;
    private String instanceId = null;
    private boolean isSecondaryOrder = false;
    private static final int NUM_COLS = 6;
    private ExtList listOrders = null;
    private Label labelApply = null;
    private Label labelSelOrder = null;
    private Text textSelOrder = null;
    private AttributeOrderManager attrOrderManager = null;
    private ArrayList attrOrdersArray = null;
    private AttributeOrder selectedAttrOrder = null;
    private Button buttonManage = null;
    private Message msgFile = null;
    private Composite compositeControls = null;
    private Point preferredSize = null;

    public SelectAttributeOrderDialog(Shell parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Schemes");
    }

    public void setValues(Trace t, String orderId, String instId, boolean isSecondary) {
        this.attrOrderId = orderId;
        this.instanceId = instId;
        this.isSecondaryOrder = isSecondary;
        this.attrOrderManager = UiPlugin.getAttributeOrderManager();
        this.getAvailableAttributeOrders(t, orderId);
        this.selectedAttrOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, orderId, this.instanceId);
    }

    private void getAvailableAttributeOrders(Trace t, String orderId) {
        this.attrOrdersArray = this.attrOrderManager.getAvailableAttributeOrders(t, orderId);
    }

    private void manageOrders(Trace t) {
        ManageAttributeOrdersDialog manageOrdersDlg = new ManageAttributeOrdersDialog(this.getShell(), 0);
        manageOrdersDlg.setValues(t, this.attrOrderId, this.instanceId);
        manageOrdersDlg.setSelectedAttrOrder(this.selectedAttrOrder);
        manageOrdersDlg.setSecondaryOrder(this.isSecondaryOrder);
        manageOrdersDlg.create(t);
        if (manageOrdersDlg.open(t)) {
            this.getAvailableAttributeOrders(t, this.attrOrderId);
            this.populateOrderList(t);
            AttributeOrder selAttrOrder = manageOrdersDlg.getSelectedAttrOrder();
            if (selAttrOrder == null) {
                this.listOrders.select(0);
            } else {
                int index = this.listOrders.indexOfObject(selAttrOrder);
                this.listOrders.select(index);
            }
            this.listOrders.showSelection();
            this.orderSelectionChanged(t);
        }
    }

    private void orderSelectionChanged(Trace t) {
        String text = "";
        if (this.textSelOrder != null) {
            this.textSelOrder.setText("");
            int selectedIndex = this.listOrders.getSelectionIndex();
            if (selectedIndex != -1) {
                this.selectedAttrOrder = (AttributeOrder)this.listOrders.getObject(selectedIndex);
                int i = 0;
                while (i < this.selectedAttrOrder.size()) {
                    AttributeOrderItem attrOrderItem = this.selectedAttrOrder.getAttributeOrderItemFromPosition(t, i, this.isSecondaryOrder);
                    if (attrOrderItem != null) {
                        text = String.valueOf(text) + attrOrderItem.getAttributeName();
                        text = String.valueOf(text) + "\n";
                    }
                    ++i;
                }
            }
            this.textSelOrder.setText(text);
        }
    }

    private void populateOrderList(Trace t) {
        this.listOrders.removeAll();
        int i = 0;
        while (i < this.attrOrdersArray.size()) {
            AttributeOrder attrOrder = (AttributeOrder)this.attrOrdersArray.get(i);
            this.listOrders.add(attrOrder);
            if (attrOrder.compareTo(this.selectedAttrOrder) == 0) {
                this.selectedAttrOrder = attrOrder;
            }
            ++i;
        }
        this.listOrders.sort();
        if (this.selectedAttrOrder != null) {
            this.listOrders.select(this.listOrders.indexOfObject(this.selectedAttrOrder));
        } else {
            this.listOrders.select(0);
        }
        this.listOrders.showSelection();
        this.orderSelectionChanged(t);
    }

    @Override
    public String getTitle(Trace t) {
        return this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.SelectScheme");
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_SchemeSelectDialog";
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return true;
    }

    @Override
    public void packDialog(Trace t) {
        this.preferredSize = this.compositeControls.computeSize(-1, -1);
        this.populateOrderList(t);
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        this.compositeControls = composite;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.labelApply = new Label(composite, 0);
        this.labelApply.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.ApplyScheme"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.labelApply.setLayoutData((Object)gridData);
        this.listOrders = new ExtList(composite, 2816);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 400;
        gridData.heightHint = 250;
        gridData.verticalSpan = 2;
        this.listOrders.setLayoutData(gridData);
        this.listOrders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                SelectAttributeOrderDialog.this.orderSelectionChanged(tr);
            }
        });
        this.labelSelOrder = new Label(composite, 0);
        this.labelSelOrder.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.SelectedScheme"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 10;
        this.labelSelOrder.setLayoutData((Object)gridData);
        this.textSelOrder = new Text(composite, 2818);
        UiUtils.makeTextControlReadOnly(t, this.textSelOrder, true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 10;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 400;
        this.textSelOrder.setLayoutData((Object)gridData);
        this.buttonManage = new Button(composite, 8);
        this.buttonManage.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.ManageSchemes"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.buttonManage.setLayoutData((Object)gridData);
        this.buttonManage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                SelectAttributeOrderDialog.this.manageOrders(tr);
            }
        });
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public boolean okPressed(Trace t) {
        this.attrOrderManager.setSelectedAttrOrder(t, this.attrOrderId, this.instanceId, this.selectedAttrOrder, true, true);
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        return true;
    }
}

