/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderRegistration;
import com.ibm.mq.explorer.ui.internal.attributeorder.EditAttributeOrderDialog;
import com.ibm.mq.explorer.ui.internal.attributeorder.NameAttributeOrderDialog;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.controls.ExtList;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ManageAttributeOrdersDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/ManageAttributeOrdersDialog.java";
    private Composite compositeACERButtons = null;
    private static final int NUM_COLS = 4;
    private static final int LIST_WIDTH_HINT = 400;
    private static final int LIST_HEIGHT_HINT = 300;
    private ExtList listOrders = null;
    private Button buttonAdd = null;
    private Button buttonCopyAs = null;
    private Button buttonEdit = null;
    private Button buttonRemove = null;
    private GridData gridDataAdd = null;
    private GridData gridDataCopyAs = null;
    private GridData gridDataEdit = null;
    private GridData gridDataRemove = null;
    private ArrayList<AttributeOrder> attrOrdersArray = null;
    private ArrayList<AttributeOrder> tempOrdersArray = null;
    private AttributeOrder selectedAttrOrder = null;
    private Message msgFile = null;
    boolean isChanged = false;
    private String attrOrderId = null;
    private AttributeOrderManager attrOrderManager = null;
    private Composite compositeControls = null;
    private Point preferredSize = null;
    private AttributeOrder lastChangedAttributeOrder = null;
    private AttributeOrder currentAttributeOrder = null;
    private boolean isSecondaryOrder = false;

    public ManageAttributeOrdersDialog(Shell parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Schemes");
    }

    public void setValues(Trace t, String orderId, String instanceId) {
        this.attrOrderId = orderId;
        this.attrOrderManager = UiPlugin.getAttributeOrderManager();
        this.attrOrdersArray = this.attrOrderManager.getAvailableAttributeOrders(t, orderId);
        this.tempOrdersArray = this.attrOrderManager.getAvailableAttributeOrders(t, orderId);
        if (this.selectedAttrOrder == null) {
            this.currentAttributeOrder = this.selectedAttrOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, orderId, instanceId);
        }
    }

    private void orderSelectionChanged(Trace t) {
        boolean enableEditButton = false;
        boolean enableRemoveButton = false;
        int selectedIndex = this.listOrders.getSelectionIndex();
        if (selectedIndex != -1) {
            this.selectedAttrOrder = (AttributeOrder)this.listOrders.getObject(selectedIndex);
        }
        enableEditButton = !this.selectedAttrOrder.isFullOrder();
        enableRemoveButton = !this.selectedAttrOrder.isDefaultOrder() && !this.selectedAttrOrder.isFullOrder() && this.currentAttributeOrder.getOrderUniversalId().compareTo(this.selectedAttrOrder.getOrderUniversalId()) != 0 && this.listOrders.getItemCount() > 1;
        this.buttonEdit.setEnabled(enableEditButton);
        this.buttonRemove.setEnabled(enableRemoveButton);
    }

    private void populateOrderList(Trace t) {
        this.listOrders.removeAll();
        int i = 0;
        while (i < this.attrOrdersArray.size()) {
            AttributeOrder attrOrder = this.attrOrdersArray.get(i);
            this.listOrders.add(attrOrder);
            if (attrOrder.compareTo(this.selectedAttrOrder) == 0) {
                this.listOrders.select(this.listOrders.indexOf(attrOrder.getOrderName(t)));
            }
            ++i;
        }
        this.listOrders.sort();
        this.listOrders.showSelection();
        if (this.listOrders.getSelectionIndex() == -1 && this.listOrders.getItemCount() > 0) {
            this.listOrders.select(0);
        }
        this.orderSelectionChanged(t);
    }

    private void addOrder(Trace t) {
        AttributeOrderRegistration attrOrderReg = this.attrOrderManager.getOrderRegistration(t, this.attrOrderId);
        AttributeOrder order = attrOrderReg.makeNewOrder(t, false);
        this.attrOrderManager.ensureAttributeNamesLoaded(t, order);
        AttributeOrder defaultAttrOrder = this.attrOrderManager.getDefaultAttributeOrder(t, this.attrOrderId);
        EditAttributeOrderDialog editOrderDlg = new EditAttributeOrderDialog(this.getShell(), 0);
        editOrderDlg.setValues(t, order, defaultAttrOrder, true, true, this.attrOrdersArray);
        editOrderDlg.create(t);
        if (this.isSecondaryOrder()) {
            editOrderDlg.selectSecondaryOrder(t);
        }
        if (editOrderDlg.open(t)) {
            order.resetOrderUniversalId(t);
            this.attrOrdersArray.add(order);
            this.tempOrdersArray.add(order);
            this.populateOrderList(t);
            this.listOrders.select(this.listOrders.indexOfObject(order));
            this.listOrders.showSelection();
            this.orderSelectionChanged(t);
            this.isChanged = true;
            this.lastChangedAttributeOrder = order;
        }
    }

    private void editOrder(Trace t) {
        int index = this.listOrders.getSelectionIndex();
        AttributeOrder order = (AttributeOrder)this.listOrders.getObject(index);
        int arrayIndex = this.attrOrdersArray.indexOf(order);
        AttributeOrder editOrder = new AttributeOrder(t, order);
        AttributeOrder defaultAttrOrder = null;
        if (!editOrder.isDefaultOrder()) {
            defaultAttrOrder = this.attrOrderManager.getDefaultAttributeOrder(t, this.attrOrderId);
        }
        EditAttributeOrderDialog editOrderDlg = new EditAttributeOrderDialog(this.getShell(), 0);
        boolean editName = !order.isDefaultOrder();
        editOrderDlg.setValues(t, editOrder, defaultAttrOrder, editName, false, this.attrOrdersArray);
        editOrderDlg.create(t);
        if (this.isSecondaryOrder()) {
            editOrderDlg.selectSecondaryOrder(t);
        }
        if (editOrderDlg.open(t)) {
            order.clear(t);
            order.setOrderName(t, editOrder.getOrderName(t));
            int i = 0;
            while (i < editOrder.size()) {
                order.add(t, editOrder.get(t, i));
                ++i;
            }
            this.attrOrdersArray.set(arrayIndex, order);
            this.tempOrdersArray.set(arrayIndex, order);
            this.populateOrderList(t);
            this.listOrders.select(this.listOrders.indexOfObject(order));
            this.listOrders.showSelection();
            this.orderSelectionChanged(t);
            this.isChanged = true;
            this.lastChangedAttributeOrder = order;
        }
    }

    private void removeOrder(Trace t) {
        int index = this.listOrders.getSelectionIndex();
        AttributeOrder order = (AttributeOrder)this.listOrders.getObject(index);
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4002", (String)order.getOrderName(t));
        int rc = MessageBox.showDeleteCancelMessage(t, this.getShell(), msg, 1, "AMQ4002");
        if (rc == 0) {
            this.attrOrdersArray.remove(this.attrOrdersArray.indexOf(order));
            this.populateOrderList(t);
            this.listOrders.select(0);
            this.listOrders.showSelection();
            this.orderSelectionChanged(t);
            this.isChanged = true;
        }
    }

    private void copyOrder(Trace t) {
        int index = this.listOrders.getSelectionIndex();
        AttributeOrder order = (AttributeOrder)this.listOrders.getObject(index);
        String dlgTitle = this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.CopySchemeTitle");
        NameAttributeOrderDialog nameAttrOrderDlg = new NameAttributeOrderDialog(this.getShell(), 0);
        nameAttrOrderDlg.setValues(t, dlgTitle, this.listOrders.getItems());
        nameAttrOrderDlg.create(t);
        if (nameAttrOrderDlg.open(t)) {
            AttributeOrder newOrder = new AttributeOrder(t, order);
            newOrder.setDefaultOrder(t, false);
            newOrder.setFullOrder(t, false);
            String newName = nameAttrOrderDlg.getSchemeName();
            newOrder.setOrderName(t, newName);
            newOrder.resetOrderUniversalId(t);
            this.attrOrdersArray.add(newOrder);
            this.tempOrdersArray.add(newOrder);
            this.populateOrderList(t);
            this.listOrders.select(this.listOrders.indexOfObject(newOrder));
            this.listOrders.showSelection();
            this.orderSelectionChanged(t);
            this.isChanged = true;
            this.lastChangedAttributeOrder = newOrder;
        }
    }

    private void saveUserDefinedAttributeOrders(Trace t) {
        ArrayList<AttributeOrder> userAttrOrders = new ArrayList<AttributeOrder>();
        int i = 0;
        while (i < this.attrOrdersArray.size()) {
            AttributeOrder attrOrder = this.attrOrdersArray.get(i);
            if (!attrOrder.isDefaultOrder() && !attrOrder.isFullOrder()) {
                userAttrOrders.add(attrOrder);
            }
            ++i;
        }
        this.attrOrderManager.setUserDefinedOrders(t, this.attrOrderId, userAttrOrders);
        UiPlugin.showBusyCursor(t, this.getShell(), true);
        this.attrOrderManager.saveAttributeOrders(t, false);
        UiPlugin.showBusyCursor(t, this.getShell(), false);
    }

    public AttributeOrder getSelectedAttrOrder() {
        return this.selectedAttrOrder;
    }

    public void setSelectedAttrOrder(AttributeOrder selAttrOrder) {
        this.selectedAttrOrder = selAttrOrder;
    }

    @Override
    public String getTitle(Trace t) {
        return this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.ManageSchemesTitle");
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_SchemeManageDialog";
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return true;
    }

    @Override
    public void packDialog(Trace t) {
        this.preferredSize = this.compositeControls.computeSize(-1, -1);
        this.populateOrderList(t);
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        this.compositeControls = composite;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.Scheme"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.listOrders = new ExtList(composite, 2816);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.listOrders.setLayoutData(gridData);
        this.listOrders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageAttributeOrdersDialog.this.orderSelectionChanged(tr);
            }
        });
        this.compositeACERButtons = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeACERButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeACERButtons.setLayoutData((Object)gridData);
        this.buttonAdd = new Button(this.compositeACERButtons, 8);
        this.buttonAdd.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.AddSchemeButton"));
        this.gridDataAdd = new GridData();
        this.buttonAdd.setLayoutData((Object)this.gridDataAdd);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageAttributeOrdersDialog.this.addOrder(tr);
            }
        });
        this.buttonCopyAs = new Button(this.compositeACERButtons, 8);
        this.buttonCopyAs.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.CopySchemeButton"));
        this.gridDataCopyAs = new GridData();
        this.buttonCopyAs.setLayoutData((Object)this.gridDataCopyAs);
        this.buttonCopyAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageAttributeOrdersDialog.this.copyOrder(tr);
            }
        });
        this.buttonEdit = new Button(this.compositeACERButtons, 8);
        this.buttonEdit.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.EditSchemeButton"));
        this.gridDataEdit = new GridData();
        this.buttonEdit.setLayoutData((Object)this.gridDataEdit);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageAttributeOrdersDialog.this.editOrder(tr);
            }
        });
        this.buttonRemove = new Button(this.compositeACERButtons, 8);
        this.buttonRemove.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.RemoveSchemeButton"));
        this.gridDataRemove = new GridData();
        this.buttonRemove.setLayoutData((Object)this.gridDataRemove);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ManageAttributeOrdersDialog.this.removeOrder(tr);
            }
        });
        label = new Label(this.compositeACERButtons, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        int maxWidth = 0;
        Point sizeAdd = this.buttonAdd.computeSize(-1, -1);
        Point sizeCopyAs = this.buttonCopyAs.computeSize(-1, -1);
        Point sizeEdit = this.buttonEdit.computeSize(-1, -1);
        Point sizeRemove = this.buttonRemove.computeSize(-1, -1);
        if (sizeAdd.x > maxWidth) {
            maxWidth = sizeAdd.x;
        }
        if (sizeCopyAs.x > maxWidth) {
            maxWidth = sizeCopyAs.x;
        }
        if (sizeEdit.x > maxWidth) {
            maxWidth = sizeEdit.x;
        }
        if (sizeRemove.x > maxWidth) {
            maxWidth = sizeRemove.x;
        }
        this.gridDataAdd.widthHint = maxWidth;
        this.gridDataCopyAs.widthHint = maxWidth;
        this.gridDataEdit.widthHint = maxWidth;
        this.gridDataRemove.widthHint = maxWidth;
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public boolean okPressed(Trace t) {
        if (this.isChanged) {
            this.saveUserDefinedAttributeOrders(t);
        }
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
        if (this.isChanged) {
            ArrayList<AttributeOrder> userAttrOrders = new ArrayList<AttributeOrder>();
            int i = 0;
            while (i < this.tempOrdersArray.size()) {
                AttributeOrder attrOrder = this.tempOrdersArray.get(i);
                if (!attrOrder.isDefaultOrder() && !attrOrder.isFullOrder()) {
                    userAttrOrders.add(attrOrder);
                }
                ++i;
            }
            this.attrOrderManager.setUserDefinedOrders(t, this.attrOrderId, userAttrOrders);
        }
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        return true;
    }

    public AttributeOrder getLastChangedAttributeOrder() {
        return this.lastChangedAttributeOrder;
    }

    public boolean isSecondaryOrder() {
        return this.isSecondaryOrder;
    }

    public void setSecondaryOrder(boolean isSecondaryOrder) {
        this.isSecondaryOrder = isSecondaryOrder;
    }
}

