/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeTableItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.EditAttributeOrderComposite;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class EditAttributeOrderDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/EditAttributeOrderDialog.java";
    private static final int NUM_COLS = 6;
    private Composite compMsg = null;
    private Label labelIcon = null;
    private Label labelMsg = null;
    private Label labelOrderName = null;
    private Text textOrderName = null;
    private TabFolder tabFolder = null;
    private TabItem[] tabItems = new TabItem[2];
    private EditAttributeOrderComposite[] editComposites = new EditAttributeOrderComposite[2];
    private Composite compositeGlobalButtons = null;
    private Button buttonRestore = null;
    private Button buttonCopyPtoS = null;
    private Button buttonCopyStoP = null;
    private GridData gridDataRestore = null;
    private GridData gridDataCopyPtoS = null;
    private GridData gridDataCopyStoP = null;
    private Message msgFile = null;
    private AttributeOrder editAttrOrder = null;
    private AttributeOrder tempAttrOrder = null;
    private boolean isEditName = false;
    private boolean isAddOp = false;
    private String originalName = null;
    private ArrayList<AttributeOrder> allAttributeOrders = null;
    private ArrayList<AttributeTableItem> attributeTableItems = null;
    private boolean isManagerSaveOnOKMode = false;
    private AttributeOrderManager attrOrderManager = null;
    private String attrOrderId = null;

    public EditAttributeOrderDialog(Shell parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Schemes");
    }

    public void setValues(Trace t, AttributeOrder attrOrder, AttributeOrder defaultAttrOrder, boolean editName, boolean isAdd, ArrayList<AttributeOrder> allAttrOrders) {
        this.editAttrOrder = attrOrder;
        this.isEditName = editName;
        this.allAttributeOrders = allAttrOrders;
        this.isAddOp = isAdd;
        this.tempAttrOrder = new AttributeOrder(t, this.editAttrOrder);
        this.originalName = new String(attrOrder.getOrderName(t));
        this.attributeTableItems = new ArrayList();
        ArrayList<AttributeOrderItem> attrOrderItems = this.editAttrOrder.getAttributeOrderItems(t);
        if (defaultAttrOrder != null) {
            int i = 0;
            while (i < attrOrderItems.size()) {
                AttributeOrderItem editAttrOrderItem = attrOrderItems.get(i);
                AttributeOrderItem dfltAttrOrderItem = defaultAttrOrder.getAttributeOrderItemFromId(t, editAttrOrderItem.getAttributeId());
                AttributeTableItem attrTableItem = new AttributeTableItem(t, editAttrOrderItem, dfltAttrOrderItem);
                this.attributeTableItems.add(attrTableItem);
                ++i;
            }
        } else {
            int i = 0;
            while (i < attrOrderItems.size()) {
                AttributeOrderItem editAttrOrderItem = attrOrderItems.get(i);
                AttributeTableItem attrTableItem = new AttributeTableItem(t, editAttrOrderItem, editAttrOrderItem);
                this.attributeTableItems.add(attrTableItem);
                ++i;
            }
        }
    }

    private void checkIfEnableOK(Trace t) {
        this.enableOK(t, this.isEnableOK(t));
    }

    private void saveName(Trace t) {
        if (this.isEditName) {
            this.editAttrOrder.setOrderName(t, this.textOrderName.getText());
        }
    }

    private void restore(Trace t) {
        String orderId = this.editAttrOrder.getOrderId();
        AttributeOrder dfltAttrOrder = this.attrOrderManager == null ? UiPlugin.getAttributeOrderManager().getRegisteredDefaultAttributeOrder(t, orderId) : this.attrOrderManager.getRegisteredDefaultAttributeOrder(t, orderId);
        if (dfltAttrOrder != null) {
            ArrayList<AttributeOrderItem> items = this.editAttrOrder.getAttributeOrderItems(t);
            int i = 0;
            while (i < items.size()) {
                AttributeOrderItem attrOrderItem = items.get(i);
                int attrId = attrOrderItem.getAttributeId();
                int pos = dfltAttrOrder.getPosition(t, attrId, false);
                attrOrderItem.setAttributePosition(pos, false);
                if (this.editAttrOrder.isDualOrder()) {
                    pos = dfltAttrOrder.getPosition(t, attrId, true);
                    attrOrderItem.setAttributePosition(pos, true);
                }
                ++i;
            }
        }
        this.editComposites[0].setChanged(true);
        this.editComposites[0].populateTables(t);
        this.editComposites[0].enableButtons(t);
        if (this.editAttrOrder.isDualOrder()) {
            this.editComposites[1].setChanged(true);
            this.editComposites[1].populateTables(t);
            this.editComposites[1].enableButtons(t);
        }
    }

    private void copyPrimaryToSecondary(Trace t) {
        ArrayList<AttributeOrderItem> items = this.editAttrOrder.getAttributeOrderItems(t);
        int i = 0;
        while (i < items.size()) {
            AttributeOrderItem attrOrderItem = items.get(i);
            int pos = attrOrderItem.getAttributePosition(false);
            attrOrderItem.setAttributePosition(pos, true);
            ++i;
        }
        this.editComposites[1].setChanged(true);
        this.editComposites[1].populateTables(t);
        this.editComposites[1].enableButtons(t);
    }

    private void copySecondaryToPrimary(Trace t) {
        ArrayList<AttributeOrderItem> items = this.editAttrOrder.getAttributeOrderItems(t);
        int i = 0;
        while (i < items.size()) {
            AttributeOrderItem attrOrderItem = items.get(i);
            int pos = attrOrderItem.getAttributePosition(true);
            attrOrderItem.setAttributePosition(pos, false);
            ++i;
        }
        this.editComposites[0].setChanged(true);
        this.editComposites[0].populateTables(t);
        this.editComposites[0].enableButtons(t);
    }

    @Override
    public String getTitle(Trace t) {
        String title = this.isAddOp ? this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.AddSchemeTitle") : this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.EditSchemeTitle");
        return title;
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public String getHelpId(Trace t) {
        String helpId = this.isAddOp ? "com.ibm.mq.explorer.ui.infopop.UI_SchemeAddDialog" : "com.ibm.mq.explorer.ui.infopop.UI_SchemeEditDialog";
        return helpId;
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return true;
    }

    @Override
    public void packDialog(Trace t) {
        this.editComposites[0].packDialog(t);
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        GridData gridData;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        if (this.isEditName) {
            this.compMsg = new Composite(composite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.makeColumnsEqualWidth = false;
            this.compMsg.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 6;
            this.compMsg.setLayoutData((Object)gridData);
            this.labelIcon = new Label(this.compMsg, 1);
            this.labelIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            this.labelIcon.setLayoutData((Object)gridData);
            this.labelMsg = new Label(this.compMsg, 0);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 1;
            this.labelMsg.setLayoutData((Object)gridData);
        }
        this.labelOrderName = new Label(composite, 0);
        this.labelOrderName.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.SchemeName"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.labelOrderName.setLayoutData((Object)gridData);
        this.textOrderName = new Text(composite, 2048);
        this.textOrderName.setText(this.editAttrOrder.getOrderName(t));
        this.textOrderName.setTextLimit(48);
        if (!this.isEditName) {
            UiUtils.makeTextControlReadOnly(t, this.textOrderName, true);
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textOrderName.setLayoutData((Object)gridData);
        this.textOrderName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderDialog.this.checkIfEnableOK(tr);
            }
        });
        Label label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        if (this.editAttrOrder.isDualOrder()) {
            this.tabFolder = new TabFolder(composite, 128);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 6;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            this.tabFolder.setLayoutData((Object)gridData);
            this.tabItems[0] = new TabItem(this.tabFolder, 0, 0);
            this.tabItems[0].setText("  " + this.editAttrOrder.getDualOrderName(t, false) + "  ");
            this.editComposites[0] = new EditAttributeOrderComposite((Composite)this.tabFolder, 0, this.editAttrOrder, this.attributeTableItems, false);
            this.editComposites[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    EditAttributeOrderDialog.this.checkIfEnableOK(tr);
                }
            });
            this.tabItems[0].setControl((Control)this.editComposites[0]);
            this.tabItems[1] = new TabItem(this.tabFolder, 0, 1);
            this.tabItems[1].setText("  " + this.editAttrOrder.getDualOrderName(t, true) + "  ");
            this.editComposites[1] = new EditAttributeOrderComposite((Composite)this.tabFolder, 0, this.editAttrOrder, this.attributeTableItems, true);
            this.editComposites[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    EditAttributeOrderDialog.this.checkIfEnableOK(tr);
                }
            });
            this.tabItems[1].setControl((Control)this.editComposites[1]);
        } else {
            this.editComposites[0] = new EditAttributeOrderComposite(composite, 0, this.editAttrOrder, this.attributeTableItems, false);
            this.editComposites[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    EditAttributeOrderDialog.this.checkIfEnableOK(tr);
                }
            });
            gridData = new GridData(1808);
            gridData.horizontalSpan = 6;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            this.editComposites[0].setLayoutData(gridData);
        }
        label = new Label(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.compositeGlobalButtons = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeGlobalButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeGlobalButtons.setLayoutData((Object)gridData);
        this.buttonRestore = new Button(this.compositeGlobalButtons, 8);
        this.buttonRestore.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.RestoreDefaultOrder"));
        this.buttonRestore.setEnabled(!this.editAttrOrder.isDefaultOrder());
        this.gridDataRestore = new GridData();
        this.gridDataRestore.horizontalSpan = 1;
        this.buttonRestore.setLayoutData((Object)this.gridDataRestore);
        this.buttonRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderDialog.this.restore(tr);
                EditAttributeOrderDialog.this.checkIfEnableOK(tr);
            }
        });
        if (this.editAttrOrder.isDualOrder()) {
            this.buttonCopyPtoS = new Button(this.compositeGlobalButtons, 8);
            String text = this.editAttrOrder.getCopyButtonName(t, false);
            this.buttonCopyPtoS.setText(text);
            this.gridDataCopyPtoS = new GridData();
            this.gridDataCopyPtoS.horizontalSpan = 1;
            this.buttonCopyPtoS.setLayoutData((Object)this.gridDataCopyPtoS);
            this.buttonCopyPtoS.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    EditAttributeOrderDialog.this.copyPrimaryToSecondary(tr);
                    EditAttributeOrderDialog.this.checkIfEnableOK(tr);
                }
            });
            this.buttonCopyStoP = new Button(this.compositeGlobalButtons, 8);
            text = this.editAttrOrder.getCopyButtonName(t, true);
            this.buttonCopyStoP.setText(text);
            this.gridDataCopyStoP = new GridData();
            this.gridDataCopyStoP.horizontalSpan = 1;
            this.buttonCopyStoP.setLayoutData((Object)this.gridDataCopyStoP);
            this.buttonCopyStoP.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    EditAttributeOrderDialog.this.copySecondaryToPrimary(tr);
                    EditAttributeOrderDialog.this.checkIfEnableOK(tr);
                }
            });
        } else {
            label = new Label(this.compositeGlobalButtons, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
        }
        int maxWidth = 0;
        Point sizeRestore = this.buttonRestore.computeSize(-1, -1);
        Point sizeCopyPtoS = null;
        if (this.buttonCopyPtoS != null) {
            sizeCopyPtoS = this.buttonCopyPtoS.computeSize(-1, -1);
        }
        Point sizeCopyStoP = null;
        if (this.buttonCopyStoP != null) {
            sizeCopyStoP = this.buttonCopyStoP.computeSize(-1, -1);
        }
        if (sizeRestore.x > maxWidth) {
            maxWidth = sizeRestore.x;
        }
        if (sizeCopyPtoS != null && sizeCopyPtoS.x > maxWidth) {
            maxWidth = sizeCopyPtoS.x;
        }
        if (sizeCopyStoP != null && sizeCopyStoP.x > maxWidth) {
            maxWidth = sizeCopyStoP.x;
        }
        this.gridDataRestore.widthHint = maxWidth;
        if (this.gridDataCopyPtoS != null) {
            this.gridDataCopyPtoS.widthHint = maxWidth;
        }
        if (this.gridDataCopyStoP != null) {
            this.gridDataCopyStoP.widthHint = maxWidth;
        }
        this.editComposites[0].populateTables(t);
        if (this.editAttrOrder.isDualOrder()) {
            this.editComposites[1].populateTables(t);
        }
        this.editComposites[0].enableButtons(t);
        if (this.editAttrOrder.isDualOrder()) {
            this.editComposites[1].enableButtons(t);
        }
        this.checkIfEnableOK(t);
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public boolean okPressed(Trace t) {
        this.saveName(t);
        this.editComposites[0].saveNewOrder(t);
        if (this.isManagerSaveOnOKMode && this.attrOrderManager != null && this.attrOrderId != null) {
            UiPlugin.showBusyCursor(t, this.getShell(), true);
            this.attrOrderManager.saveAttributeOrders(t, false);
            this.attrOrderManager.triggerChangedListeners(t, this.attrOrderId);
            UiPlugin.showBusyCursor(t, this.getShell(), false);
        }
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
        ArrayList<AttributeOrderItem> tempOrderItems = this.tempAttrOrder.getAttributeOrderItems(t);
        ArrayList<AttributeOrderItem> editOrderItems = this.editAttrOrder.getAttributeOrderItems(t);
        int i = 0;
        while (i < editOrderItems.size()) {
            AttributeOrderItem editOrderItem = editOrderItems.get(i);
            AttributeOrderItem tempOrderItem = tempOrderItems.get(i);
            editOrderItem.setAttributePosition(tempOrderItem.getAttributePosition(false), false);
            ++i;
        }
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.editComposites[0].getPreferredSize(t);
    }

    @Override
    public boolean isEnableOK(Trace t) {
        boolean enableOK = false;
        boolean lengthOK = false;
        boolean countOK = true;
        boolean nameOK = true;
        if (this.isEditName) {
            String orderName = AttributeOrder.processOrderName(this.textOrderName.getText());
            boolean bl = lengthOK = orderName.length() > 0;
            if (lengthOK && orderName.compareTo(this.originalName) != 0) {
                int i = 0;
                while (i < this.allAttributeOrders.size()) {
                    AttributeOrder attOrder = this.allAttributeOrders.get(i);
                    if (AttributeOrder.processOrderName(attOrder.getOrderName(t)).compareTo(orderName) == 0) {
                        nameOK = false;
                    }
                    ++i;
                }
            }
            if (!nameOK) {
                this.labelIcon.setVisible(true);
                this.labelMsg.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.NameInUseMsg"));
                this.labelMsg.setVisible(true);
            } else if (!lengthOK) {
                this.labelIcon.setVisible(true);
                this.labelMsg.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.NoNameMsg"));
                this.labelMsg.setVisible(true);
            } else {
                this.labelIcon.setVisible(false);
                this.labelMsg.setVisible(false);
            }
            enableOK = lengthOK && nameOK;
        } else {
            enableOK = true;
        }
        EditAttributeOrderComposite[] editAttributeOrderCompositeArray = this.editComposites;
        int n = this.editComposites.length;
        int n2 = 0;
        while (n2 < n) {
            EditAttributeOrderComposite composite = editAttributeOrderCompositeArray[n2];
            if (composite != null && composite.getNewAttributeOrderSize() == 0) {
                countOK = false;
            }
            ++n2;
        }
        enableOK = enableOK && countOK;
        return enableOK;
    }

    public void selectSecondaryOrder(Trace t) {
        if (this.tabFolder != null && this.tabFolder.getItemCount() > 1) {
            this.tabFolder.setSelection(1);
        }
    }

    public void setManagerSaveOnOKMode(Trace t, AttributeOrderManager attrOrderMgr, String orderId) {
        this.isManagerSaveOnOKMode = true;
        this.attrOrderManager = attrOrderMgr;
        this.attrOrderId = orderId;
    }
}

