/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeTableItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributesTableCompareColumnItems;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributesTableContentProvider;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributesTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableColumnManager;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableViewer;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class EditAttributeOrderComposite
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/EditAttributeOrderComposite.java";
    private static final int TABLE_WIDTH_HINT = 250;
    private static final int TABLE_HEIGHT_HINT = 150;
    public static final Integer TABLE_TYPE_AVAIL = 1;
    public static final Integer TABLE_TYPE_DISPLAYED = 2;
    public static final Integer COLUMN_TYPE_NAME = 1;
    public static final Integer COLUMN_TYPE_DFLT_POS = 2;
    public static final Integer COLUMN_TYPE_ACT_POS = 3;
    private Composite compositeAddRemoveButtons = null;
    private Composite compositeMoveButtons = null;
    private static final int NUM_COLS = 6;
    private Table tableAvailable = null;
    private ExtTableViewer tableviewerAvailable = null;
    private TableColumn[] tableColumnsAvailable = new TableColumn[2];
    private AttributesTableContentProvider contentProviderAvailable = null;
    private AttributesTableLabelProvider labelProviderAvailable = null;
    private AttributesTableCompareColumnItems compareItemsAvailable = null;
    private ExtTableColumnManager columnManagerAvailable = null;
    private Table tableDisplayed = null;
    private ExtTableViewer tableviewerDisplayed = null;
    private TableColumn[] tableColumnsDisplayed = new TableColumn[2];
    private AttributesTableContentProvider contentProviderDisplayed = null;
    private AttributesTableLabelProvider labelProviderDisplayed = null;
    private AttributesTableCompareColumnItems compareItemsDisplayed = null;
    private ExtTableColumnManager columnManagerDisplayed = null;
    private Button buttonAddAll = null;
    private Button buttonAdd = null;
    private Button buttonRemove = null;
    private Button buttonRemoveAll = null;
    private Button buttonMoveTop = null;
    private Button buttonMoveUp = null;
    private Button buttonMoveDown = null;
    private Button buttonMoveBottom = null;
    private Message msgFile = null;
    private boolean isChanged = false;
    private AttributeOrder editAttrOrder = null;
    private ArrayList attributeTableItems = null;
    private boolean isEditSecondary = false;
    private boolean firstAvailableTableLoad = true;
    private Point preferredSize = null;

    public EditAttributeOrderComposite(Composite parent, int style, AttributeOrder attrOrder, ArrayList attrTableItems, boolean isSecondary) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.editAttrOrder = attrOrder;
        this.attributeTableItems = attrTableItems;
        this.isEditSecondary = isSecondary;
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Schemes");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.AvailableAttributes"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        label.setVisible(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        label.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.DisplayedAttributes"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        label.setVisible(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.tableviewerAvailable = new ExtTableViewer(this, 67588);
        this.tableAvailable = this.tableviewerAvailable.getTable();
        this.tableAvailable.setHeaderVisible(true);
        this.tableAvailable.setLinesVisible(true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.tableAvailable.setLayoutData((Object)gridData);
        if (this.editAttrOrder.isDefaultOrder()) {
            this.tableColumnsAvailable[0] = new TableColumn(this.tableAvailable, 16384);
            this.tableColumnsAvailable[0].setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.Name"));
            this.tableColumnsAvailable[0].setData((Object)COLUMN_TYPE_NAME);
            this.tableColumnsAvailable[0].setWidth(100);
        } else {
            this.tableColumnsAvailable[0] = new TableColumn(this.tableAvailable, 16384);
            this.tableColumnsAvailable[0].setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.DefaultPosition"));
            this.tableColumnsAvailable[0].setData((Object)COLUMN_TYPE_DFLT_POS);
            this.tableColumnsAvailable[0].setWidth(100);
            this.tableColumnsAvailable[1] = new TableColumn(this.tableAvailable, 16384);
            this.tableColumnsAvailable[1].setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.Name"));
            this.tableColumnsAvailable[1].setData((Object)COLUMN_TYPE_NAME);
            this.tableColumnsAvailable[1].setWidth(100);
        }
        this.contentProviderAvailable = new AttributesTableContentProvider(t, TABLE_TYPE_AVAIL, this.attributeTableItems, isSecondary);
        this.tableviewerAvailable.setContentProvider((IContentProvider)this.contentProviderAvailable);
        this.labelProviderAvailable = new AttributesTableLabelProvider(t, this.tableAvailable, isSecondary);
        this.tableviewerAvailable.setLabelProvider((IBaseLabelProvider)this.labelProviderAvailable);
        this.compareItemsAvailable = new AttributesTableCompareColumnItems(this.tableAvailable, isSecondary);
        this.columnManagerAvailable = new ExtTableColumnManager(t, this.tableviewerAvailable, this.labelProviderAvailable, true);
        this.columnManagerAvailable.setViewerSorter(t, this.compareItemsAvailable, true);
        this.columnManagerAvailable.addColumnSortListeners(t);
        this.columnManagerAvailable.setExcessWidthColumnIndex(t, 1);
        this.tableviewerAvailable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.enableButtons(tr);
            }
        });
        this.compositeAddRemoveButtons = new Composite((Composite)this, 0);
        gridData = new GridData(1040);
        gridData.horizontalSpan = 1;
        gridData.grabExcessVerticalSpace = true;
        this.compositeAddRemoveButtons.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.compositeAddRemoveButtons.setLayout((Layout)gridLayout);
        label = new Label(this.compositeAddRemoveButtons, 0);
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonAddAll = new Button(this.compositeAddRemoveButtons, 8);
        this.buttonAddAll.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.AddAll"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonAddAll.setLayoutData((Object)gridData);
        this.buttonAddAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.addAll(tr);
            }
        });
        label = new Label(this.compositeAddRemoveButtons, 0);
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonAdd = new Button(this.compositeAddRemoveButtons, 8);
        this.buttonAdd.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.Add"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonAdd.setLayoutData((Object)gridData);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.add(tr);
            }
        });
        label = new Label(this.compositeAddRemoveButtons, 0);
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(this.compositeAddRemoveButtons, 0);
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonRemove = new Button(this.compositeAddRemoveButtons, 8);
        this.buttonRemove.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.Remove"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonRemove.setLayoutData((Object)gridData);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.remove(tr);
            }
        });
        label = new Label(this.compositeAddRemoveButtons, 0);
        gridData = new GridData(1040);
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonRemoveAll = new Button(this.compositeAddRemoveButtons, 8);
        this.buttonRemoveAll.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.RemoveAll"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonRemoveAll.setLayoutData((Object)gridData);
        this.buttonRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.removeAll(tr);
            }
        });
        label = new Label(this.compositeAddRemoveButtons, 0);
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.tableviewerDisplayed = new ExtTableViewer(this, 67588);
        this.tableDisplayed = this.tableviewerDisplayed.getTable();
        this.tableDisplayed.setHeaderVisible(true);
        this.tableDisplayed.setLinesVisible(true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.tableDisplayed.setLayoutData((Object)gridData);
        this.tableColumnsDisplayed[0] = new TableColumn(this.tableDisplayed, 16384);
        this.tableColumnsDisplayed[0].setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.Position"));
        this.tableColumnsDisplayed[0].setData((Object)COLUMN_TYPE_ACT_POS);
        this.tableColumnsDisplayed[0].setWidth(100);
        this.tableColumnsDisplayed[1] = new TableColumn(this.tableDisplayed, 16384);
        this.tableColumnsDisplayed[1].setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.Name"));
        this.tableColumnsDisplayed[1].setData((Object)COLUMN_TYPE_NAME);
        this.tableColumnsDisplayed[1].setWidth(100);
        this.tableColumnsDisplayed[0].setImage(Icons.get(Icons.iconkeyAPIXEBlank));
        this.contentProviderDisplayed = new AttributesTableContentProvider(t, TABLE_TYPE_DISPLAYED, this.attributeTableItems, isSecondary);
        this.tableviewerDisplayed.setContentProvider((IContentProvider)this.contentProviderDisplayed);
        this.labelProviderDisplayed = new AttributesTableLabelProvider(t, this.tableDisplayed, isSecondary);
        this.tableviewerDisplayed.setLabelProvider((IBaseLabelProvider)this.labelProviderDisplayed);
        this.compareItemsDisplayed = new AttributesTableCompareColumnItems(this.tableDisplayed, isSecondary);
        this.columnManagerDisplayed = new ExtTableColumnManager(t, this.tableviewerDisplayed, this.labelProviderDisplayed, true);
        this.columnManagerDisplayed.setViewerSorter(t, this.compareItemsDisplayed, true);
        this.columnManagerDisplayed.setExcessWidthColumnIndex(t, 1);
        this.tableviewerDisplayed.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.enableButtons(tr);
            }
        });
        this.compositeMoveButtons = new Composite((Composite)this, 0);
        gridData = new GridData(1040);
        gridData.horizontalSpan = 1;
        gridData.grabExcessVerticalSpace = true;
        this.compositeMoveButtons.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.compositeMoveButtons.setLayout((Layout)gridLayout);
        this.buttonMoveTop = new Button(this.compositeMoveButtons, 8);
        this.buttonMoveTop.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.MoveTop"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonMoveTop.setLayoutData((Object)gridData);
        this.buttonMoveTop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.moveTop(tr);
            }
        });
        label = new Label(this.compositeMoveButtons, 0);
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonMoveUp = new Button(this.compositeMoveButtons, 8);
        this.buttonMoveUp.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.MoveUp"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonMoveUp.setLayoutData((Object)gridData);
        this.buttonMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.moveUp(tr);
            }
        });
        this.buttonMoveDown = new Button(this.compositeMoveButtons, 8);
        this.buttonMoveDown.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.MoveDown"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonMoveDown.setLayoutData((Object)gridData);
        this.buttonMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.moveDown(tr);
            }
        });
        label = new Label(this.compositeMoveButtons, 0);
        gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonMoveBottom = new Button(this.compositeMoveButtons, 8);
        this.buttonMoveBottom.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.MoveBottom"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonMoveBottom.setLayoutData((Object)gridData);
        this.buttonMoveBottom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditAttributeOrderComposite.this.moveBottom(tr);
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.buttonAddAll.addSelectionListener(listener);
        this.buttonAdd.addSelectionListener(listener);
        this.buttonRemove.addSelectionListener(listener);
        this.buttonRemoveAll.addSelectionListener(listener);
        this.buttonMoveTop.addSelectionListener(listener);
        this.buttonMoveUp.addSelectionListener(listener);
        this.buttonMoveDown.addSelectionListener(listener);
        this.buttonMoveBottom.addSelectionListener(listener);
    }

    public void populateTables(Trace t) {
        int count;
        this.tableAvailable.removeAll();
        this.tableDisplayed.removeAll();
        this.tableviewerAvailable.setInput(this.attributeTableItems);
        this.refreshAvailableTable(t);
        this.tableviewerDisplayed.setInput(this.attributeTableItems);
        this.refreshDisplayedTable(t);
        this.resizeColumns(t);
        if (this.firstAvailableTableLoad) {
            this.columnManagerAvailable.sortOnColumn(t, 0);
            this.firstAvailableTableLoad = false;
        }
        if ((count = this.tableAvailable.getItemCount()) > 0) {
            this.tableAvailable.select(0);
        }
        this.tableAvailable.showSelection();
        count = this.tableDisplayed.getItemCount();
        if (count > 0) {
            this.tableDisplayed.select(0);
        }
        this.tableDisplayed.showSelection();
    }

    private void addAll(Trace t) {
        this.tableAvailable.setRedraw(false);
        this.tableDisplayed.setRedraw(false);
        int highestPos = this.tableDisplayed.getItemCount() - 1;
        int i = 0;
        while (i < this.tableAvailable.getItemCount()) {
            MQExtObject mqExtObject = (MQExtObject)this.tableAvailable.getItem(i).getData();
            AttributeTableItem tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
            AttributeOrderItem moveItem = tableItem.getEditAttrOrderItem();
            moveItem.setAttributePosition(++highestPos, this.isEditSecondary);
            ++i;
        }
        this.refreshAvailableTable(t);
        this.refreshDisplayedTable(t);
        int count = this.tableDisplayed.getItemCount();
        if (count > 0) {
            this.tableDisplayed.select(0);
            this.tableDisplayed.showSelection();
        }
        this.tableAvailable.setRedraw(true);
        this.tableDisplayed.setRedraw(true);
        this.resizeColumns(t);
        this.tableAvailable.redraw();
        this.tableAvailable.update();
        this.tableDisplayed.redraw();
        this.tableDisplayed.update();
        this.isChanged = true;
        this.enableButtons(t);
    }

    private void add(Trace t) {
        int highestPos = this.tableDisplayed.getItemCount() - 1;
        int indexAvailable = this.tableAvailable.getSelectionIndex();
        MQExtObject mqExtObject = (MQExtObject)this.tableAvailable.getItem(indexAvailable).getData();
        AttributeTableItem tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
        AttributeOrderItem moveItem = tableItem.getEditAttrOrderItem();
        int topIndex = 0;
        if (this.tableDisplayed.getItemCount() > 0) {
            topIndex = this.tableDisplayed.getTopIndex();
            moveItem.setAttributePosition(++highestPos, this.isEditSecondary);
        } else {
            moveItem.setAttributePosition(0, this.isEditSecondary);
        }
        this.refreshAvailableTable(t);
        this.refreshDisplayedTable(t);
        int count = this.tableAvailable.getItemCount();
        if (indexAvailable >= count) {
            indexAvailable = count - 1;
        }
        this.tableAvailable.select(indexAvailable);
        this.tableAvailable.showSelection();
        this.tableDisplayed.select(this.tableDisplayed.getItemCount() - 1);
        this.tableDisplayed.setTopIndex(topIndex + 1);
        this.tableDisplayed.showSelection();
        this.resizeColumns(t);
        this.tableAvailable.redraw();
        this.tableAvailable.update();
        this.tableDisplayed.redraw();
        this.tableDisplayed.update();
        this.isChanged = true;
        this.enableButtons(t);
    }

    private void remove(Trace t) {
        AttributeOrderItem item;
        int indexDisplayed = this.tableDisplayed.getSelectionIndex();
        MQExtObject mqExtObject = (MQExtObject)this.tableDisplayed.getItem(indexDisplayed).getData();
        AttributeTableItem tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
        AttributeOrderItem moveItem = tableItem.getEditAttrOrderItem();
        moveItem.setAttributePosition(-1, this.isEditSecondary);
        this.refreshAvailableTable(t);
        int i = 0;
        while (i < this.tableAvailable.getItemCount()) {
            mqExtObject = (MQExtObject)this.tableAvailable.getItem(i).getData();
            tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
            item = tableItem.getEditAttrOrderItem();
            if (item == moveItem) {
                this.tableAvailable.select(i);
                break;
            }
            ++i;
        }
        i = indexDisplayed + 1;
        while (i < this.tableDisplayed.getItemCount()) {
            mqExtObject = (MQExtObject)this.tableDisplayed.getItem(i).getData();
            tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
            item = tableItem.getEditAttrOrderItem();
            item.setAttributePosition(item.getAttributePosition(this.isEditSecondary) - 1, this.isEditSecondary);
            ++i;
        }
        int topIndex = this.tableDisplayed.getTopIndex();
        this.refreshDisplayedTable(t);
        int count = this.tableDisplayed.getItemCount();
        if (count > 0) {
            if (indexDisplayed >= count) {
                indexDisplayed = count - 1;
            }
            this.tableDisplayed.select(indexDisplayed);
        }
        if (topIndex > 0) {
            this.tableDisplayed.setTopIndex(topIndex - 1);
        }
        this.tableDisplayed.showSelection();
        this.resizeColumns(t);
        this.tableAvailable.redraw();
        this.tableAvailable.update();
        this.tableDisplayed.redraw();
        this.tableDisplayed.update();
        this.isChanged = true;
        this.enableButtons(t);
    }

    private void removeAll(Trace t) {
        this.tableAvailable.setRedraw(false);
        this.tableDisplayed.setRedraw(false);
        int i = 0;
        while (i < this.tableDisplayed.getItemCount()) {
            MQExtObject mqExtObject = (MQExtObject)this.tableDisplayed.getItem(i).getData();
            AttributeTableItem tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
            AttributeOrderItem moveItem = tableItem.getEditAttrOrderItem();
            moveItem.setAttributePosition(-1, this.isEditSecondary);
            ++i;
        }
        this.refreshAvailableTable(t);
        this.refreshDisplayedTable(t);
        this.tableAvailable.setRedraw(true);
        this.tableDisplayed.setRedraw(true);
        this.resizeColumns(t);
        this.tableAvailable.redraw();
        this.tableAvailable.update();
        this.tableDisplayed.redraw();
        this.tableDisplayed.update();
        this.tableAvailable.select(0);
        this.tableAvailable.showSelection();
        this.isChanged = true;
        this.enableButtons(t);
    }

    private void moveTop(Trace t) {
        int index = this.tableDisplayed.getSelectionIndex();
        MQExtObject mqExtObject = (MQExtObject)this.tableDisplayed.getItem(index).getData();
        AttributeTableItem tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
        AttributeOrderItem moveItem = tableItem.getEditAttrOrderItem();
        int moveItemPos = moveItem.getAttributePosition(this.isEditSecondary);
        TableItem[] tableItems = this.tableDisplayed.getItems();
        int i = 0;
        while (i < tableItems.length) {
            mqExtObject = (MQExtObject)tableItems[i].getData();
            tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
            AttributeOrderItem item = tableItem.getEditAttrOrderItem();
            int pos = item.getAttributePosition(this.isEditSecondary);
            if (pos < moveItemPos) {
                item.setAttributePosition(pos + 1, this.isEditSecondary);
            }
            ++i;
        }
        moveItem.setAttributePosition(0, this.isEditSecondary);
        this.refreshDisplayedTable(t);
        this.tableDisplayed.select(0);
        this.tableDisplayed.showSelection();
        this.isChanged = true;
        this.enableButtons(t);
    }

    private void moveUp(Trace t) {
        int index = this.tableDisplayed.getSelectionIndex();
        MQExtObject mqExtObject = (MQExtObject)this.tableDisplayed.getItem(index).getData();
        AttributeTableItem tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
        AttributeOrderItem moveItem = tableItem.getEditAttrOrderItem();
        mqExtObject = (MQExtObject)this.tableDisplayed.getItem(index - 1).getData();
        tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
        AttributeOrderItem preceedingItem = tableItem.getEditAttrOrderItem();
        int pos = moveItem.getAttributePosition(this.isEditSecondary);
        moveItem.setAttributePosition(preceedingItem.getAttributePosition(this.isEditSecondary), this.isEditSecondary);
        preceedingItem.setAttributePosition(pos, this.isEditSecondary);
        this.refreshDisplayedTable(t);
        this.tableDisplayed.select(index - 1);
        this.tableDisplayed.showSelection();
        this.isChanged = true;
        this.enableButtons(t);
    }

    private void moveDown(Trace t) {
        int index = this.tableDisplayed.getSelectionIndex();
        MQExtObject mqExtObject = (MQExtObject)this.tableDisplayed.getItem(index).getData();
        AttributeTableItem tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
        AttributeOrderItem moveItem = tableItem.getEditAttrOrderItem();
        mqExtObject = (MQExtObject)this.tableDisplayed.getItem(index + 1).getData();
        tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
        AttributeOrderItem nextItem = tableItem.getEditAttrOrderItem();
        int pos = moveItem.getAttributePosition(this.isEditSecondary);
        moveItem.setAttributePosition(nextItem.getAttributePosition(this.isEditSecondary), this.isEditSecondary);
        nextItem.setAttributePosition(pos, this.isEditSecondary);
        this.refreshDisplayedTable(t);
        this.tableDisplayed.select(index + 1);
        this.tableDisplayed.showSelection();
        this.isChanged = true;
        this.enableButtons(t);
    }

    private void moveBottom(Trace t) {
        int index = this.tableDisplayed.getSelectionIndex();
        MQExtObject mqExtObject = (MQExtObject)this.tableDisplayed.getItem(index).getData();
        AttributeTableItem tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
        AttributeOrderItem moveItem = tableItem.getEditAttrOrderItem();
        int moveItemPos = moveItem.getAttributePosition(this.isEditSecondary);
        TableItem[] tableItems = this.tableDisplayed.getItems();
        int i = 0;
        while (i < tableItems.length) {
            mqExtObject = (MQExtObject)tableItems[i].getData();
            tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
            AttributeOrderItem item = tableItem.getEditAttrOrderItem();
            int pos = item.getAttributePosition(this.isEditSecondary);
            if (pos > moveItemPos) {
                item.setAttributePosition(pos - 1, this.isEditSecondary);
            }
            ++i;
        }
        int lastIndex = this.tableDisplayed.getItemCount() - 1;
        moveItem.setAttributePosition(lastIndex, this.isEditSecondary);
        this.refreshDisplayedTable(t);
        this.tableDisplayed.select(lastIndex);
        this.tableDisplayed.showSelection();
        this.isChanged = true;
        this.enableButtons(t);
    }

    public void enableButtons(Trace t) {
        this.tableAvailable.update();
        this.tableDisplayed.update();
        int index = this.tableDisplayed.getSelectionIndex();
        int count = this.tableDisplayed.getItemCount();
        boolean enableAddAll = this.tableviewerAvailable.getTable().getItemCount() > 0;
        boolean enableAdd = this.tableviewerAvailable.getTable().getItemCount() > 0;
        boolean enableRemove = count > 0;
        boolean enableRemoveAll = count > 0;
        boolean enableMoveTop = index > 0;
        boolean enableMoveUp = index > 0;
        boolean enableMoveDown = index < count - 1;
        boolean enableMoveBottom = index < count - 1;
        this.buttonAddAll.setEnabled(enableAddAll);
        this.buttonAdd.setEnabled(enableAdd);
        this.buttonRemove.setEnabled(enableRemove);
        this.buttonRemoveAll.setEnabled(enableRemoveAll);
        this.buttonMoveTop.setEnabled(enableMoveTop);
        this.buttonMoveUp.setEnabled(enableMoveUp);
        this.buttonMoveDown.setEnabled(enableMoveDown);
        this.buttonMoveBottom.setEnabled(enableMoveBottom);
        this.update();
    }

    public void saveNewOrder(Trace t) {
        if (this.isChanged) {
            int i = 0;
            while (i < this.editAttrOrder.size()) {
                AttributeOrderItem attrOrderItem = this.editAttrOrder.get(t, i);
                if (attrOrderItem.getAttributePosition(this.isEditSecondary) != -2) {
                    attrOrderItem.setAttributePosition(-1, this.isEditSecondary);
                }
                ++i;
            }
            i = 0;
            while (i < this.tableDisplayed.getItemCount()) {
                MQExtObject mqExtObject = (MQExtObject)this.tableDisplayed.getItem(i).getData();
                AttributeTableItem tableItem = (AttributeTableItem)mqExtObject.getInternalObject();
                AttributeOrderItem attrOrderItem = tableItem.getEditAttrOrderItem();
                attrOrderItem.setAttributePosition(i, this.isEditSecondary);
                ++i;
            }
            this.editAttrOrder.setStandardOrderState(1);
        }
    }

    public void setChanged(boolean changed) {
        this.isChanged = changed;
    }

    private void resizeColumns(Trace t) {
        this.columnManagerAvailable.resizeTableColumns(t, false);
        this.columnManagerDisplayed.resizeTableColumns(t, false);
    }

    private void refreshAvailableTable(Trace t) {
        this.tableviewerAvailable.refresh();
        this.tableviewerAvailable.getControl().redraw();
        ExplorerTable.paintGreyCells(t, this.tableAvailable, this.labelProviderAvailable);
    }

    private void refreshDisplayedTable(Trace t) {
        this.tableviewerDisplayed.refresh();
        this.tableviewerDisplayed.getControl().redraw();
        ExplorerTable.paintGreyCells(t, this.tableDisplayed, this.labelProviderDisplayed);
    }

    public void packDialog(Trace t) {
        int itemHeight = this.tableDisplayed.getItemHeight();
        int numItems = 150 / itemHeight;
        int i = 0;
        while (i < numItems) {
            new TableItem(this.tableDisplayed, 0, i);
            ++i;
        }
        this.preferredSize = this.computeSize(-1, -1);
        this.getShell().pack();
        this.tableDisplayed.removeAll();
        this.populateTables(t);
    }

    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    public int getNewAttributeOrderSize() {
        return this.tableDisplayed.getItemCount();
    }
}

