/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmChannelAuthenticationRecord;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.ArrayList;
import java.util.Collections;

public class DefineExampleAttributeOrders {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/DefineExampleAttributeOrders.java";

    public static void create(Trace t, AttributeOrderManager attributeOrderManager) {
        Message msgFileSchemes = UiPlugin.getUIMessages(t, "KEY_Schemes");
        DefineExampleAttributeOrders.createExamplesForChannelAuthenticationRecords(t, attributeOrderManager, msgFileSchemes);
    }

    private static void createValidAttributeOrder(Trace t, int[] validAttrs, boolean fHidden, AttributeOrder attributeOrder) {
        AttributeOrderItem item;
        int[] allAttrs = DmChannelAuthenticationRecord.getAllAttributesByType((Trace)t);
        int[] columnSeq = DmChannelAuthenticationRecord.getDisplayColumnSequence((Trace)t, (int[])allAttrs, (boolean)false);
        ArrayList<AttributeOrderItem> attrOrderItemList = new ArrayList<AttributeOrderItem>();
        int nx = 0;
        while (nx < columnSeq.length) {
            if (columnSeq[nx] >= 0) {
                boolean fFound = false;
                int ny = 0;
                while (ny < validAttrs.length && !fFound) {
                    if (allAttrs[nx] == validAttrs[ny]) {
                        fFound = true;
                    }
                    ++ny;
                }
                if (!fFound) {
                    columnSeq[nx] = fHidden ? -2 : -1;
                }
            }
            String attrName = DmChannelAuthenticationRecord.getAttributeTitle((Trace)t, (int)allAttrs[nx]);
            item = new AttributeOrderItem(t, allAttrs[nx], attrName, columnSeq[nx]);
            attrOrderItemList.add(item);
            ++nx;
        }
        Collections.sort(attrOrderItemList);
        nx = 0;
        int ny = 0;
        while (nx < attrOrderItemList.size()) {
            item = (AttributeOrderItem)attrOrderItemList.get(nx);
            if (item.getAttributePosition(false) > 0) {
                item.setAttributePosition(ny++, false);
            }
            attributeOrder.add(t, item);
            ++nx;
        }
    }

    private static void createExamplesForChannelAuthenticationRecords(Trace t, AttributeOrderManager attributeOrderManager, Message msgFileSchemes) {
        int[] addressMapAttrs = new int[]{3501, 1352, 3506, 1638, 3527, 1639, 258, 2118, 2119, 2027, 2028};
        String attributeOrderName = msgFileSchemes.getMessage(t, "UI.SCHEMES.Examples.ChlAuth.AddressMap");
        AttributeOrder attributeOrder = new AttributeOrder(t, "com.ibm.mq.explorer.orderid.chlauth", attributeOrderName, "com.ibm.mq.explorer.chlauth", false, false);
        DefineExampleAttributeOrders.createValidAttributeOrder(t, addressMapAttrs, true, attributeOrder);
        if (!attributeOrderManager.addExampleAttributeOrder(t, "com.ibm.mq.explorer.schemes.example.chlauth.addressmap", attributeOrder) && Trace.isTracing) {
            t.data(67, "DefineExampleAttributeOrders.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example scheme for Address Map Channel Authentication Records");
        }
        int[] sslPeerMapAttrs = new int[]{3501, 1352, 3545, 1638, 3527, 3506, 1639, 258, 2130, 2118, 2119, 2027, 2028};
        attributeOrderName = msgFileSchemes.getMessage(t, "UI.SCHEMES.Examples.ChlAuth.SSLPeerMap");
        attributeOrder = new AttributeOrder(t, "com.ibm.mq.explorer.orderid.chlauth", attributeOrderName, "com.ibm.mq.explorer.chlauth", false, false);
        DefineExampleAttributeOrders.createValidAttributeOrder(t, sslPeerMapAttrs, true, attributeOrder);
        if (!attributeOrderManager.addExampleAttributeOrder(t, "com.ibm.mq.explorer.schemes.example.chlauth.sslpeermap", attributeOrder) && Trace.isTracing) {
            t.data(67, "DefineExampleAttributeOrders.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example scheme for SSL Peer Map Channel Authentication Records");
        }
        int[] userMapAttrs = new int[]{3501, 1352, 3567, 1638, 3527, 3506, 1639, 258, 2118, 2119, 2027, 2028};
        attributeOrderName = msgFileSchemes.getMessage(t, "UI.SCHEMES.Examples.ChlAuth.UserMap");
        attributeOrder = new AttributeOrder(t, "com.ibm.mq.explorer.orderid.chlauth", attributeOrderName, "com.ibm.mq.explorer.chlauth", false, false);
        DefineExampleAttributeOrders.createValidAttributeOrder(t, userMapAttrs, true, attributeOrder);
        if (!attributeOrderManager.addExampleAttributeOrder(t, "com.ibm.mq.explorer.schemes.example.chlauth.usermap", attributeOrder) && Trace.isTracing) {
            t.data(67, "DefineExampleAttributeOrders.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example scheme for Client User ID Map Channel Authentication Records");
        }
        int[] qmgrMapAttrs = new int[]{3501, 1352, 2017, 1638, 3527, 3506, 1639, 2118, 2119, 2027, 2028};
        attributeOrderName = msgFileSchemes.getMessage(t, "UI.SCHEMES.Examples.ChlAuth.QmgrMap");
        attributeOrder = new AttributeOrder(t, "com.ibm.mq.explorer.orderid.chlauth", attributeOrderName, "com.ibm.mq.explorer.chlauth", false, false);
        DefineExampleAttributeOrders.createValidAttributeOrder(t, qmgrMapAttrs, true, attributeOrder);
        if (!attributeOrderManager.addExampleAttributeOrder(t, "com.ibm.mq.explorer.schemes.example.chlauth.qmgrmap", attributeOrder) && Trace.isTracing) {
            t.data(67, "DefineExampleAttributeOrders.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example scheme for Remote Queue Manager Name Map Channel Authentication Records");
        }
        int[] blockUserAttrs = new int[]{3501, 1352, 3568, 1639, 2118, 2119, 2027, 2028};
        attributeOrderName = msgFileSchemes.getMessage(t, "UI.SCHEMES.Examples.ChlAuth.BlockUser");
        attributeOrder = new AttributeOrder(t, "com.ibm.mq.explorer.orderid.chlauth", attributeOrderName, "com.ibm.mq.explorer.chlauth", false, false);
        DefineExampleAttributeOrders.createValidAttributeOrder(t, blockUserAttrs, true, attributeOrder);
        if (!attributeOrderManager.addExampleAttributeOrder(t, "com.ibm.mq.explorer.schemes.example.chlauth.blockuser", attributeOrder) && Trace.isTracing) {
            t.data(67, "DefineExampleAttributeOrders.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example scheme for Blocked User ID List Channel Authentication Records");
        }
        int[] blockAddrAttrs = new int[]{3501, 1352, 3566, 1639, 2118, 2119, 2027, 2028};
        attributeOrderName = msgFileSchemes.getMessage(t, "UI.SCHEMES.Examples.ChlAuth.BlockAddr");
        attributeOrder = new AttributeOrder(t, "com.ibm.mq.explorer.orderid.chlauth", attributeOrderName, "com.ibm.mq.explorer.chlauth", false, false);
        DefineExampleAttributeOrders.createValidAttributeOrder(t, blockAddrAttrs, true, attributeOrder);
        if (!attributeOrderManager.addExampleAttributeOrder(t, "com.ibm.mq.explorer.schemes.example.chlauth.blockaddr", attributeOrder) && Trace.isTracing) {
            t.data(67, "DefineExampleAttributeOrders.createExamplesForChannelAuthenticationRecords", 900, "Error: failed to add example scheme for Blocked Address List Channel Authentication Record");
        }
    }
}

