/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeTableItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.EditAttributeOrderComposite;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AttributesTableLabelProvider
extends ExtTableLabelProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/AttributesTableLabelProvider.java";
    private TableColumn[] tableColumns = null;
    private boolean isSecondary = false;

    public AttributesTableLabelProvider(Trace t, Table table, boolean isSec) {
        this.tableColumns = table.getColumns();
        this.isSecondary = isSec;
    }

    @Override
    public Image getImageForColumn(Object element, int columnIndex) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "AttributesTableLabelProvider.getImageForColumn", "columnIndex: " + columnIndex);
        }
        Image image = null;
        return image;
    }

    @Override
    public String getTextForColumn(Object element, int columnIndex) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "AttributesTableLabelProvider.getTextForColumn", "columnIndex: " + columnIndex);
        }
        String text = null;
        if (columnIndex < this.tableColumns.length) {
            TableColumn tabcol = this.tableColumns[columnIndex];
            Integer coltype = (Integer)tabcol.getData();
            if (element instanceof MQExtObject) {
                AttributeTableItem attrTableItem = (AttributeTableItem)((MQExtObject)element).getInternalObject();
                if (coltype == EditAttributeOrderComposite.COLUMN_TYPE_NAME) {
                    AttributeOrderItem attrOrderItem = attrTableItem.getEditAttrOrderItem();
                    text = attrOrderItem.getAttributeName();
                } else if (coltype == EditAttributeOrderComposite.COLUMN_TYPE_DFLT_POS) {
                    int pos;
                    AttributeOrderItem dfltAttrOrderItem = attrTableItem.getDfltAttrOrderItem();
                    if (dfltAttrOrderItem != null && (pos = dfltAttrOrderItem.getAttributePosition(this.isSecondary)) != -1) {
                        text = "" + (pos + 1);
                    }
                } else if (coltype == EditAttributeOrderComposite.COLUMN_TYPE_ACT_POS) {
                    AttributeOrderItem attrOrderItem = attrTableItem.getEditAttrOrderItem();
                    text = "" + (attrOrderItem.getAttributePosition(this.isSecondary) + 1);
                }
            }
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

