/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeTableItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.EditAttributeOrderComposite;
import com.ibm.mq.explorer.ui.internal.controls.ExtViewerSorter;
import java.text.Collator;
import java.util.Locale;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AttributesTableCompareColumnItems
extends ExtViewerSorter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/AttributesTableCompareColumnItems.java";
    private boolean isSortAscending = true;
    private TableColumn sortTableColumn = null;
    private boolean isSecondary = false;
    private Table table = null;

    public AttributesTableCompareColumnItems(Table tab, boolean isSec) {
        this.table = tab;
        this.isSecondary = isSec;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        MQExtObject mqExtObject;
        Trace t = Trace.getDefault();
        int result = 0;
        Collator coll = Collator.getInstance(Locale.getDefault());
        Integer coltype = (Integer)this.sortTableColumn.getData();
        AttributeTableItem attrTableItem1 = null;
        AttributeTableItem attrTableItem2 = null;
        if (o1 instanceof MQExtObject) {
            mqExtObject = (MQExtObject)o1;
            attrTableItem1 = (AttributeTableItem)mqExtObject.getInternalObject();
        } else if (o1 instanceof AttributeTableItem) {
            attrTableItem1 = (AttributeTableItem)o1;
        }
        if (o2 instanceof MQExtObject) {
            mqExtObject = (MQExtObject)o2;
            attrTableItem2 = (AttributeTableItem)mqExtObject.getInternalObject();
        } else if (o2 instanceof AttributeTableItem) {
            attrTableItem2 = (AttributeTableItem)o2;
        }
        if (attrTableItem1 != null && attrTableItem2 != null) {
            AttributeOrderItem editAttrOrderItem1;
            if (coltype == EditAttributeOrderComposite.COLUMN_TYPE_NAME) {
                editAttrOrderItem1 = attrTableItem1.getEditAttrOrderItem();
                AttributeOrderItem editAttrOrderItem2 = attrTableItem2.getEditAttrOrderItem();
                result = this.compareString(t, coll, editAttrOrderItem1.getAttributeName(), editAttrOrderItem2.getAttributeName());
            } else if (coltype == EditAttributeOrderComposite.COLUMN_TYPE_DFLT_POS) {
                int pos1 = -1;
                int pos2 = -1;
                AttributeOrderItem dfltAttrOrderItem1 = attrTableItem1.getDfltAttrOrderItem();
                AttributeOrderItem dfltAttrOrderItem2 = attrTableItem2.getDfltAttrOrderItem();
                if (dfltAttrOrderItem1 != null) {
                    pos1 = dfltAttrOrderItem1.getAttributePosition(this.isSecondary);
                }
                if (dfltAttrOrderItem2 != null) {
                    pos2 = dfltAttrOrderItem2.getAttributePosition(this.isSecondary);
                }
                if (pos1 < 0 && pos2 < 0) {
                    boolean sorted = false;
                    if (dfltAttrOrderItem1 != null && dfltAttrOrderItem2 != null && dfltAttrOrderItem1.isDualOrder() && dfltAttrOrderItem2.isDualOrder()) {
                        pos1 = dfltAttrOrderItem1.getAttributePosition(!this.isSecondary);
                        pos2 = dfltAttrOrderItem2.getAttributePosition(!this.isSecondary);
                        if (pos1 >= 0 && pos2 >= 0) {
                            result = this.compareInt(t, pos1, pos2);
                            sorted = true;
                        }
                    }
                    if (!sorted) {
                        String attrName1 = "";
                        String attrName2 = "";
                        if (dfltAttrOrderItem1 != null) {
                            attrName1 = dfltAttrOrderItem1.getAttributeName();
                        } else if (attrTableItem1.getEditAttrOrderItem() != null) {
                            attrName1 = attrTableItem1.getEditAttrOrderItem().getAttributeName();
                        }
                        if (dfltAttrOrderItem2 != null) {
                            attrName2 = dfltAttrOrderItem2.getAttributeName();
                        } else if (attrTableItem2.getEditAttrOrderItem() != null) {
                            attrName2 = attrTableItem2.getEditAttrOrderItem().getAttributeName();
                        }
                        result = this.compareString(t, coll, attrName1, attrName2);
                    }
                } else {
                    result = pos1 < 0 ? (this.isSortAscending ? 1 : -1) : (pos2 < 0 ? (this.isSortAscending ? -1 : 1) : this.compareInt(t, pos1, pos2));
                }
            } else if (coltype == EditAttributeOrderComposite.COLUMN_TYPE_ACT_POS) {
                editAttrOrderItem1 = attrTableItem1.getEditAttrOrderItem();
                AttributeOrderItem editAttrOrderItem2 = attrTableItem2.getEditAttrOrderItem();
                int pos1 = editAttrOrderItem1.getAttributePosition(this.isSecondary);
                int pos2 = editAttrOrderItem2.getAttributePosition(this.isSecondary);
                result = this.compareInt(t, pos1, pos2);
            }
        }
        return result;
    }

    private int compareString(Trace t, Collator coll, String value1, String value2) {
        int result = 0;
        result = this.isSortAscending ? coll.compare(value1, value2) : coll.compare(value2, value1);
        return result;
    }

    private int compareInt(Trace t, int value1, int value2) {
        int result = 0;
        result = this.isSortAscending ? value1 - value2 : value2 - value1;
        return result;
    }

    @Override
    public void setSortDirection(Trace t, boolean sortAscending) {
        this.isSortAscending = sortAscending;
    }

    @Override
    public void setSortColumnIndex(Trace t, int index) {
        TableColumn[] tabCols = this.table.getColumns();
        this.sortTableColumn = tabCols[index];
    }

    @Override
    public void setSortDirections(Trace t, boolean primarySortAscending, boolean secondarySortAscending) {
        this.setSortDirection(t, primarySortAscending);
    }

    @Override
    public void setSortColumnIndices(Trace t, int primaryIndex, int secondaryIndex) {
        this.setSortColumnIndex(t, primaryIndex);
    }
}

