/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class AttributeOrderRegistration {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/AttributeOrderRegistration.java";
    public static final String KEY_DEFAULT_ORDER = "com.ibm.mq.explorer.ui.internal.order.default";
    public static final String KEY_FULL_ORDER = "com.ibm.mq.explorer.ui.internal.order.full";
    private String objectId = "";
    private String orderId = "";
    private AttributeOrder defaultAttrOrder = null;
    private AttributeOrder fullAttrOrder = null;
    private Hashtable<String, AttributeOrder> userAttrOrders = null;
    private Hashtable<String, AttributeOrder> selectedAttrOrders = null;

    public AttributeOrderRegistration(Trace t, String _objectId, String _orderId, AttributeOrder _fullAttrOrder, AttributeOrder _defaultAttrOrder) {
        this.objectId = _objectId;
        this.orderId = _orderId;
        this.userAttrOrders = new Hashtable();
        this.selectedAttrOrders = new Hashtable();
        this.setDefaultOrder(t, _defaultAttrOrder);
        this.setFullOrder(t, _fullAttrOrder);
        this.checkForNewAttributes(t, _fullAttrOrder, _defaultAttrOrder);
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String id) {
        this.orderId = id;
        if (this.fullAttrOrder != null) {
            this.fullAttrOrder.setOrderId(id);
        }
        if (this.defaultAttrOrder != null) {
            this.defaultAttrOrder.setOrderId(id);
        }
        Enumeration<String> en = this.userAttrOrders.keys();
        while (en.hasMoreElements()) {
            AttributeOrder attrOrder = this.userAttrOrders.get(en.nextElement());
            attrOrder.setOrderId(id);
        }
    }

    public AttributeOrder makeNewOrder(Trace t, boolean populateWithFullOrders) {
        AttributeOrder attrOrder = null;
        attrOrder = populateWithFullOrders ? new AttributeOrder(t, this.fullAttrOrder) : new AttributeOrder(t, this.defaultAttrOrder);
        attrOrder.setOrderName(t, "");
        attrOrder.setDefaultOrder(t, false);
        attrOrder.setFullOrder(t, false);
        return attrOrder;
    }

    public AttributeOrder getFullOrder() {
        return this.fullAttrOrder;
    }

    public AttributeOrder getDefaultOrder() {
        return this.defaultAttrOrder;
    }

    public void setDefaultOrder(Trace t, AttributeOrder attrOrder) {
        this.defaultAttrOrder = attrOrder;
    }

    public void setFullOrder(Trace t, AttributeOrder attrOrder) {
        this.fullAttrOrder = attrOrder;
    }

    public boolean addUserDefinedOrder(Trace t, AttributeOrder userAttrOrder) {
        boolean result = true;
        String key = userAttrOrder.getKey();
        this.userAttrOrders.put(key, userAttrOrder);
        return result;
    }

    public boolean removeUserDefinedOrder(Trace t, String universalId) {
        boolean result = false;
        String key = universalId;
        if (this.userAttrOrders.containsKey(key)) {
            this.userAttrOrders.remove(key);
            result = true;
        }
        return result;
    }

    public Hashtable<String, AttributeOrder> getUserDefinedOrders(Trace t) {
        return this.userAttrOrders;
    }

    public ArrayList<AttributeOrder> getUserDefinedOrdersArray(Trace t) {
        ArrayList<AttributeOrder> userDefinedOrders = new ArrayList<AttributeOrder>();
        Enumeration<AttributeOrder> enumUserOrders = this.userAttrOrders.elements();
        while (enumUserOrders.hasMoreElements()) {
            userDefinedOrders.add(enumUserOrders.nextElement());
        }
        return userDefinedOrders;
    }

    public AttributeOrder getUserDefinedOrder(Trace t, String key) {
        AttributeOrder attrOrder = null;
        if (this.userAttrOrders.containsKey(key)) {
            attrOrder = this.userAttrOrders.get(key);
        }
        return attrOrder;
    }

    public boolean removeAllUserDefinedOrders(Trace t) {
        boolean result = true;
        this.userAttrOrders.clear();
        return result;
    }

    public boolean setUserDefinedOrders(Trace t, ArrayList<AttributeOrder> userOrders) {
        boolean result = true;
        this.removeAllUserDefinedOrders(t);
        int i = 0;
        while (i < userOrders.size()) {
            AttributeOrder attrOrder = userOrders.get(i);
            this.addUserDefinedOrder(t, attrOrder);
            ++i;
        }
        return result;
    }

    public Hashtable<String, AttributeOrder> getSelectedOrders(Trace t) {
        return this.selectedAttrOrders;
    }

    public boolean removeAllSelectedOrders(Trace t) {
        boolean result = true;
        this.selectedAttrOrders.clear();
        return result;
    }

    public AttributeOrder getSelectedAttrOrder(Trace t, String instanceId) {
        AttributeOrder selAttrOrder = this.selectedAttrOrders.get(instanceId);
        return selAttrOrder;
    }

    public String getSelectedAttrOrderKey(Trace t, String instanceId) {
        String key = "";
        AttributeOrder selAttrOrder = this.getSelectedAttrOrder(t, instanceId);
        key = selAttrOrder.compareTo(this.defaultAttrOrder) == 0 ? KEY_DEFAULT_ORDER : selAttrOrder.getKey();
        return key;
    }

    public void setSelectedAttrOrder(Trace t, String instanceId, AttributeOrder attrOrder) {
        this.selectedAttrOrders.put(instanceId, attrOrder);
    }

    public boolean addAttributeOrderSelection(Trace t, String instanceId, String attrOrderKey) {
        boolean result = true;
        AttributeOrder selAttrOrder = this.getDefaultOrder();
        selAttrOrder = attrOrderKey.compareTo(KEY_DEFAULT_ORDER) == 0 ? this.getDefaultOrder() : this.getUserDefinedOrder(t, attrOrderKey);
        if (selAttrOrder == null) {
            selAttrOrder = this.getDefaultOrder();
        }
        this.selectedAttrOrders.put(instanceId, selAttrOrder);
        return result;
    }

    private boolean checkForNewAttributes(Trace t, AttributeOrder fullAttribOrder, AttributeOrder defaultAttribOrder) {
        boolean isNew = false;
        return isNew;
    }

    public AttributeOrder getAttributeOrderFromUID(Trace t, String attrOrderUID) {
        AttributeOrder attrOrder = null;
        if (this.defaultAttrOrder != null && this.defaultAttrOrder.getOrderUniversalId().compareTo(attrOrderUID) == 0) {
            attrOrder = this.defaultAttrOrder;
        }
        if (attrOrder == null) {
            Enumeration<AttributeOrder> en = this.userAttrOrders.elements();
            while (en.hasMoreElements()) {
                AttributeOrder userAttrOrder = en.nextElement();
                if (userAttrOrder.getOrderUniversalId().compareTo(attrOrderUID) != 0) continue;
                attrOrder = userAttrOrder;
                break;
            }
        }
        return attrOrder;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String id) {
        this.objectId = id;
        if (this.fullAttrOrder != null) {
            this.fullAttrOrder.setObjectId(id);
        }
        if (this.defaultAttrOrder != null) {
            this.defaultAttrOrder.setObjectId(id);
        }
        Enumeration<String> en = this.userAttrOrders.keys();
        while (en.hasMoreElements()) {
            AttributeOrder attrOrder = this.userAttrOrders.get(en.nextElement());
            attrOrder.setObjectId(id);
        }
    }

    public void removeInstanceFromSelectedAttributeOrders(Trace t, String instanceId) {
        if (this.selectedAttrOrders.containsKey(instanceId)) {
            this.selectedAttrOrders.remove(instanceId);
        }
    }

    public int getIconAttributeId(Trace t, String explorerTableInstance) {
        int id = -1;
        if (explorerTableInstance == null) {
            if (this.defaultAttrOrder != null) {
                id = this.defaultAttrOrder.getIconAttrId(t);
            }
        } else {
            AttributeOrder attrOrder = this.getSelectedAttrOrder(t, explorerTableInstance);
            if (attrOrder != null) {
                id = attrOrder.getIconAttrId(t);
            }
        }
        return id;
    }
}

