/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderRegistration;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class AttributeOrderPersistence {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/AttributeOrderPersistence.java";
    private static String attrOrdersFilename = "";
    private XMLMemento rootWrite = null;
    private XMLMemento rootRead = null;
    private boolean dataInvalid = false;
    private ArrayList<String> createdExampleAttrOrderIds = null;
    private static final String ROOT_KEY = "Schemes";
    private static final String VERSION_KEY = "FileVersion";
    private static final String THIS_VERSION = "1.0.2";
    private static final String EXAMPLES_CREATED_KEY = "ExamplesCreatedCount";
    private static final String EXAMPLE_ATTR_ORDER_ID_KEY_PREFIX = "CreatedExampleSchemeId_";
    private static final String REG_ATTR_ORDER_ID_COUNT_KEY = "RegisteredSchemeIdCount";
    private static final String REG_ATTR_ORDER_ID_KEY_PREFIX = "RegisteredSchemeId_";
    private static final String REGISTRATION_KEY_PREFIX = "Scheme_";
    private static final String ATTR_ORDER_ITEM_KEY_PREFIX = "SchemeItem_";
    private static final String ATTR_ORDER_ID = "Id";
    private static final String ATTR_ORDER_NAME = "Name";
    private static final String ATTR_ORDER_NAME_PRIMARY = "NamePrimary";
    private static final String ATTR_ORDER_NAME_SECONDARY = "NameSecondary";
    private static final String ATTR_ORDER_COPY_PRIME_TO_SEC = "CopyPrimaryToSecondary";
    private static final String ATTR_ORDER_COPY_SEC_TO_PRIME = "CopySecondaryToPrimary";
    private static final String ATTR_ORDER_UID = "UId";
    private static final String ATTR_ORDER_ISDEFAULT = "IsDefault";
    private static final String ATTR_ORDER_ISDUAL = "IsDual";
    private static final String ATTR_ORDER_ISFULL = "IsFull";
    private static final String ATTR_ORDER_ISSTANDARD = "IsStandard";
    private static final String ATTR_ORDER_STDSTATE = "OrderState";
    private static final String ATTR_ORDER_OBJECT_ID = "ObjectId";
    private static final String ATTR_ORDER_ICON_ATTR_ID = "IconItemId";
    private static final String ATTR_ORDER_LAST_SELECTED = "LastSelected";
    private static final String ATTR_ORDER_USER_DEFINED_COUNT = "UserDefinedCount";
    private static final String USER_DEFINED_KEYNAME_PREFIX = "UserDefined_";
    private static final String ATTR_ORDER_SELECTED_COUNT = "SelectedCount";
    private static final String ATTR_ORDER_SELECTED_INSTANCEID = "SelectedInstanceId";
    private static final String ATTR_ORDER_SELECTED_KEY = "SelectedKey";
    private static final String SELECTED_KEYNAME_PREFIX = "Selected_";
    private static final String ATTR_ORDER_ITEM_COUNT = "ItemCount";
    private static final String ATTR_ORDER_ITEM_POSITION_PRIMARY = "ItemPositionPrimary";
    private static final String ATTR_ORDER_ITEM_POSITION_SECONDARY = "ItemPositionSecondary";
    private static final String ATTR_ORDER_ITEM_ID = "ItemId";
    private static final String ATTR_ORDER_ITEM_WIDTH = "ItemWidth";

    public AttributeOrderPersistence(Trace t, File workingDir) {
        attrOrdersFilename = workingDir + File.separator + "WMQ_Schemes.xml";
        this.readXMLFile(t);
        this.rootWrite = XMLMemento.createWriteRoot((String)ROOT_KEY);
        this.createdExampleAttrOrderIds = new ArrayList();
    }

    public boolean isNewVersion(Trace t) {
        String fileVersion;
        boolean isNewVersion = false;
        if (this.dataInvalid) {
            this.readXMLFile(t);
            if (this.rootRead != null) {
                this.dataInvalid = false;
            }
        }
        if (this.rootRead != null && ((fileVersion = this.rootRead.getString(VERSION_KEY)) == null || fileVersion.compareTo(THIS_VERSION) != 0)) {
            isNewVersion = true;
        }
        return isNewVersion;
    }

    public ArrayList<String> loadAttributeOrderRegistrationIds(Trace t) {
        ArrayList<String> attrOrderRegistrations = new ArrayList<String>();
        if (this.dataInvalid) {
            this.readXMLFile(t);
            if (this.rootRead != null) {
                this.dataInvalid = false;
            }
        }
        if (this.rootRead != null) {
            Integer intCount;
            Integer intCreated = this.rootRead.getInteger(EXAMPLES_CREATED_KEY);
            if (intCreated != null) {
                int i = 0;
                while (i < intCreated) {
                    String exampleAttrOrderId = this.rootRead.getString(EXAMPLE_ATTR_ORDER_ID_KEY_PREFIX + i);
                    if (exampleAttrOrderId != null) {
                        this.createdExampleAttrOrderIds.add(exampleAttrOrderId);
                    }
                    ++i;
                }
            }
            if ((intCount = this.rootRead.getInteger(REG_ATTR_ORDER_ID_COUNT_KEY)) != null) {
                int i = 0;
                while (i < intCount) {
                    String attrOrderRegId = this.rootRead.getString(REG_ATTR_ORDER_ID_KEY_PREFIX + i);
                    if (attrOrderRegId != null && attrOrderRegId.length() > 0) {
                        attrOrderRegistrations.add(attrOrderRegId);
                    }
                    ++i;
                }
            }
        }
        return attrOrderRegistrations;
    }

    public AttributeOrderRegistration loadAttributeOrderRegistration(Trace t, String attrOrderId) {
        IMemento childAttrOrderReg;
        AttributeOrderRegistration attrOrderReg = null;
        if (this.dataInvalid) {
            this.readXMLFile(t);
            if (this.rootRead != null) {
                this.dataInvalid = false;
            }
        }
        if (this.rootRead != null && (childAttrOrderReg = this.rootRead.getChild(REGISTRATION_KEY_PREFIX + attrOrderId)) != null) {
            boolean result;
            AttributeOrder attrOrderFull;
            AttributeOrder attrOrderDefault;
            String objectId = childAttrOrderReg.getString(ATTR_ORDER_OBJECT_ID);
            IMemento child = childAttrOrderReg.getChild("com.ibm.mq.explorer.ui.internal.order.default");
            if (child != null && (attrOrderDefault = this.loadOrder(t, child, objectId)) != null && (child = childAttrOrderReg.getChild("com.ibm.mq.explorer.ui.internal.order.full")) != null && (attrOrderFull = this.loadOrder(t, child, objectId)) != null) {
                attrOrderReg = new AttributeOrderRegistration(t, objectId, attrOrderId, attrOrderFull, attrOrderDefault);
            }
            if (attrOrderReg != null && (result = this.loadUserDefinedOrders(t, attrOrderReg))) {
                result = this.loadSelectedOrders(t, attrOrderReg);
            }
        }
        return attrOrderReg;
    }

    public boolean saveAttributeOrderRegistrationIds(Trace t, ArrayList<String> ids) {
        boolean result = false;
        this.rootWrite.putString(VERSION_KEY, THIS_VERSION);
        int count = this.createdExampleAttrOrderIds.size();
        this.rootWrite.putInteger(EXAMPLES_CREATED_KEY, count);
        int i = 0;
        while (i < count) {
            this.rootWrite.putString(EXAMPLE_ATTR_ORDER_ID_KEY_PREFIX + i, this.createdExampleAttrOrderIds.get(i));
            ++i;
        }
        this.rootWrite.putInteger(REG_ATTR_ORDER_ID_COUNT_KEY, ids.size());
        i = 0;
        while (i < ids.size()) {
            this.rootWrite.putString(REG_ATTR_ORDER_ID_KEY_PREFIX + i, ids.get(i));
            ++i;
        }
        return result;
    }

    public boolean saveAttributeOrderRegistration(Trace t, AttributeOrderRegistration attrOrderReg, boolean isPersist) {
        boolean result = true;
        this.rootWrite.putString(VERSION_KEY, THIS_VERSION);
        IMemento childAttrOrderReg = this.openChild(t, (IMemento)this.rootWrite, REGISTRATION_KEY_PREFIX + attrOrderReg.getOrderId());
        IMemento child = this.openChild(t, childAttrOrderReg, "com.ibm.mq.explorer.ui.internal.order.default");
        result = this.saveOrder(t, attrOrderReg.getDefaultOrder(), child);
        if (result) {
            child = this.openChild(t, childAttrOrderReg, "com.ibm.mq.explorer.ui.internal.order.full");
        }
        if (result = this.saveOrder(t, attrOrderReg.getFullOrder(), child)) {
            result = this.saveUserDefinedOrders(t, attrOrderReg);
        }
        if (result) {
            result = this.saveSelectedOrders(t, attrOrderReg);
        }
        if (isPersist) {
            this.writeAttributeOrderRegistrationInfo(t);
        }
        return result;
    }

    public boolean writeAttributeOrderRegistrationInfo(Trace t) {
        this.dataInvalid = true;
        return this.writeXMLMemento(t);
    }

    private AttributeOrder loadOrder(Trace t, IMemento child, String objectId) {
        AttributeOrder attrOrder = null;
        String name = child.getString(ATTR_ORDER_NAME);
        if (name.length() > 0) {
            Integer standardOrder;
            attrOrder = new AttributeOrder(t);
            attrOrder.setObjectId(objectId);
            attrOrder.setOrderName(t, child.getString(ATTR_ORDER_NAME));
            attrOrder.setOrderId(child.getString(ATTR_ORDER_ID));
            attrOrder.setOrderUniversalId(child.getString(ATTR_ORDER_UID));
            attrOrder.setDefaultOrder(t, child.getInteger(ATTR_ORDER_ISDEFAULT) == 1);
            attrOrder.setFullOrder(t, child.getInteger(ATTR_ORDER_ISFULL) == 1);
            attrOrder.setDualOrder(t, child.getInteger(ATTR_ORDER_ISDUAL) == 1);
            Integer intIconAttrId = child.getInteger(ATTR_ORDER_ICON_ATTR_ID);
            attrOrder.setIconAttrId(t, intIconAttrId);
            Float floatDate = child.getFloat(ATTR_ORDER_LAST_SELECTED);
            if (floatDate != null) {
                attrOrder.setDateLastSelected(floatDate.longValue());
            }
            if ((standardOrder = child.getInteger(ATTR_ORDER_ISSTANDARD)) != null) {
                attrOrder.setStandardOrder(standardOrder == 1);
            } else {
                attrOrder.setStandardOrder(false);
            }
            Integer standardOrderState = child.getInteger(ATTR_ORDER_STDSTATE);
            if (standardOrderState != null) {
                attrOrder.setStandardOrderState(standardOrderState);
            } else {
                attrOrder.setStandardOrderState(-1);
            }
            int count = child.getInteger(ATTR_ORDER_ITEM_COUNT);
            if (attrOrder.isDualOrder()) {
                String namePrimary = child.getString(ATTR_ORDER_NAME_PRIMARY);
                String nameSecondary = child.getString(ATTR_ORDER_NAME_SECONDARY);
                attrOrder.setDualOrderNames(t, namePrimary, nameSecondary);
                String copyPrimaryToSecondary = child.getString(ATTR_ORDER_COPY_PRIME_TO_SEC);
                String copySecondaryToPrimary = child.getString(ATTR_ORDER_COPY_SEC_TO_PRIME);
                attrOrder.setCopyButtonNames(t, copyPrimaryToSecondary, copySecondaryToPrimary);
            }
            int i = 0;
            while (i < count) {
                AttributeOrderItem attrOrderItem = null;
                IMemento childAttrOrderItem = child.getChild(ATTR_ORDER_ITEM_KEY_PREFIX + i);
                if (childAttrOrderItem != null && (attrOrderItem = this.loadAttributeOrderItem(t, childAttrOrderItem, objectId, attrOrder.isDualOrder())) != null) {
                    attrOrder.add(t, attrOrderItem);
                }
                ++i;
            }
            attrOrder.setNamesLoaded(false);
        } else if (Trace.isTracing) {
            t.data(67, "AttributeOrderPersistence.loadOrder", 900, "failed to load name");
        }
        return attrOrder;
    }

    private AttributeOrderItem loadAttributeOrderItem(Trace t, IMemento child, String objectId, boolean isDualOrder) {
        int attrWidth;
        AttributeOrderItem attrOrderItem = null;
        int attrId = child.getInteger(ATTR_ORDER_ITEM_ID);
        String attrName = "" + attrId;
        int attrIndexPrimary = child.getInteger(ATTR_ORDER_ITEM_POSITION_PRIMARY);
        if (isDualOrder) {
            int attrIndexSecondary = child.getInteger(ATTR_ORDER_ITEM_POSITION_SECONDARY);
            attrOrderItem = new AttributeOrderItem(t, attrId, attrName, attrIndexPrimary, attrIndexSecondary);
        } else {
            attrOrderItem = new AttributeOrderItem(t, attrId, attrName, attrIndexPrimary);
        }
        Integer intAttrWidth = child.getInteger(ATTR_ORDER_ITEM_WIDTH);
        if (intAttrWidth != null && (attrWidth = child.getInteger(ATTR_ORDER_ITEM_WIDTH).intValue()) > 0) {
            attrOrderItem.setWidth(attrWidth);
        }
        return attrOrderItem;
    }

    private boolean loadUserDefinedOrders(Trace t, AttributeOrderRegistration attrOrderReg) {
        boolean result = true;
        IMemento childAttrOrderReg = this.rootRead.getChild(REGISTRATION_KEY_PREFIX + attrOrderReg.getOrderId());
        if (childAttrOrderReg != null) {
            int count = childAttrOrderReg.getInteger(ATTR_ORDER_USER_DEFINED_COUNT);
            attrOrderReg.removeAllUserDefinedOrders(t);
            int i = 0;
            while (i < count) {
                IMemento childAttrOrder = childAttrOrderReg.getChild(USER_DEFINED_KEYNAME_PREFIX + i);
                if (childAttrOrder != null) {
                    AttributeOrder attrOrder = this.loadOrder(t, childAttrOrder, attrOrderReg.getObjectId());
                    if (attrOrder != null) {
                        if (!attrOrderReg.addUserDefinedOrder(t, attrOrder)) {
                            if (Trace.isTracing) {
                                t.data(67, "AttributeOrderPersistence.loadUserDefinedOrders", 900, "failed to add user defined attribute order");
                            }
                            result = false;
                        }
                    } else {
                        if (Trace.isTracing) {
                            t.data(67, "AttributeOrderPersistence.loadUserDefinedOrders", 900, "failed to load user defined attribute order");
                        }
                        result = false;
                    }
                } else {
                    if (Trace.isTracing) {
                        t.data(67, "AttributeOrderPersistence.loadUserDefinedOrders", 900, "unable to open child node: 'UserDefined_" + i + "'");
                    }
                    result = false;
                }
                ++i;
            }
        }
        return result;
    }

    private boolean loadSelectedOrders(Trace t, AttributeOrderRegistration attrOrderReg) {
        boolean result = true;
        IMemento childAttrOrderReg = this.rootRead.getChild(REGISTRATION_KEY_PREFIX + attrOrderReg.getOrderId());
        if (childAttrOrderReg != null) {
            int count = childAttrOrderReg.getInteger(ATTR_ORDER_SELECTED_COUNT);
            attrOrderReg.removeAllSelectedOrders(t);
            int i = 0;
            while (i < count) {
                String instanceId;
                String attrOrderKey;
                IMemento childAttrOrder = childAttrOrderReg.getChild(SELECTED_KEYNAME_PREFIX + i);
                if (childAttrOrder != null && (attrOrderKey = childAttrOrder.getString(ATTR_ORDER_SELECTED_KEY)).length() > 0 && (instanceId = childAttrOrder.getString(ATTR_ORDER_SELECTED_INSTANCEID)).length() > 0 && !attrOrderReg.addAttributeOrderSelection(t, instanceId, attrOrderKey)) {
                    if (Trace.isTracing) {
                        t.data(67, "AttributeOrderPersistence.loadSelectedOrders", 900, "failed to add attribute order selection");
                    }
                    result = false;
                }
                ++i;
            }
        }
        return result;
    }

    private boolean saveOrder(Trace t, AttributeOrder attrOrder, IMemento child) {
        boolean result = true;
        child.putString(ATTR_ORDER_NAME, attrOrder.getOrderName(t));
        if (attrOrder.isDualOrder()) {
            child.putString(ATTR_ORDER_NAME_PRIMARY, attrOrder.getDualOrderName(t, false));
            child.putString(ATTR_ORDER_NAME_SECONDARY, attrOrder.getDualOrderName(t, true));
            child.putString(ATTR_ORDER_COPY_PRIME_TO_SEC, attrOrder.getCopyButtonName(t, false));
            child.putString(ATTR_ORDER_COPY_SEC_TO_PRIME, attrOrder.getCopyButtonName(t, true));
        }
        child.putString(ATTR_ORDER_ID, attrOrder.getOrderId());
        child.putString(ATTR_ORDER_UID, attrOrder.getOrderUniversalId());
        int value = attrOrder.isStandardOrder() ? 1 : 0;
        child.putInteger(ATTR_ORDER_ISSTANDARD, value);
        child.putInteger(ATTR_ORDER_STDSTATE, attrOrder.getStandardOrderState());
        value = attrOrder.isDefaultOrder() ? 1 : 0;
        child.putInteger(ATTR_ORDER_ISDEFAULT, value);
        value = attrOrder.isFullOrder() ? 1 : 0;
        child.putInteger(ATTR_ORDER_ISFULL, value);
        value = attrOrder.isDualOrder() ? 1 : 0;
        child.putInteger(ATTR_ORDER_ISDUAL, value);
        child.putInteger(ATTR_ORDER_ICON_ATTR_ID, attrOrder.getIconAttrId(t));
        float floatDate = attrOrder.getDateLastSelected();
        child.putFloat(ATTR_ORDER_LAST_SELECTED, floatDate);
        int count = attrOrder.size();
        child.putInteger(ATTR_ORDER_ITEM_COUNT, count);
        int i = 0;
        while (i < count) {
            AttributeOrderItem attrOrderItem = attrOrder.get(t, i);
            IMemento childAttrOrderItem = this.openChild(t, child, ATTR_ORDER_ITEM_KEY_PREFIX + i);
            if (childAttrOrderItem != null) {
                this.saveAttributeOrderItem(t, attrOrderItem, childAttrOrderItem, attrOrder.isDualOrder());
            }
            ++i;
        }
        return result;
    }

    private boolean saveAttributeOrderItem(Trace t, AttributeOrderItem attrOrderItem, IMemento child, boolean isDualOrder) {
        boolean result = true;
        child.putInteger(ATTR_ORDER_ITEM_ID, attrOrderItem.getAttributeId());
        child.putInteger(ATTR_ORDER_ITEM_POSITION_PRIMARY, attrOrderItem.getAttributePosition(false));
        if (isDualOrder) {
            child.putInteger(ATTR_ORDER_ITEM_POSITION_SECONDARY, attrOrderItem.getAttributePosition(true));
        }
        child.putInteger(ATTR_ORDER_ITEM_WIDTH, attrOrderItem.getWidth());
        return result;
    }

    private boolean saveUserDefinedOrders(Trace t, AttributeOrderRegistration attrOrderReg) {
        boolean result = true;
        IMemento childAttrOrderReg = this.openChild(t, (IMemento)this.rootWrite, REGISTRATION_KEY_PREFIX + attrOrderReg.getOrderId());
        Hashtable<String, AttributeOrder> userOrders = attrOrderReg.getUserDefinedOrders(t);
        childAttrOrderReg.putString(ATTR_ORDER_OBJECT_ID, attrOrderReg.getObjectId());
        int count = userOrders.size();
        childAttrOrderReg.putInteger(ATTR_ORDER_USER_DEFINED_COUNT, count);
        int i = 0;
        Enumeration<AttributeOrder> enumUserOrders = userOrders.elements();
        while (enumUserOrders.hasMoreElements()) {
            IMemento childAttrOrder;
            AttributeOrder attrOrder = enumUserOrders.nextElement();
            if (!this.saveOrder(t, attrOrder, childAttrOrder = this.openChild(t, childAttrOrderReg, USER_DEFINED_KEYNAME_PREFIX + i))) {
                if (Trace.isTracing) {
                    t.data(67, "AttributeOrderPersistence.saveUserDefinedOrders", 900, "failed to save user defined attribute order");
                }
                result = false;
            }
            ++i;
        }
        return result;
    }

    private boolean saveSelectedOrders(Trace t, AttributeOrderRegistration attrOrderReg) {
        boolean result = true;
        IMemento childAttrOrderReg = this.openChild(t, (IMemento)this.rootWrite, REGISTRATION_KEY_PREFIX + attrOrderReg.getOrderId());
        Hashtable<String, AttributeOrder> selOrders = attrOrderReg.getSelectedOrders(t);
        int count = selOrders.size();
        childAttrOrderReg.putInteger(ATTR_ORDER_SELECTED_COUNT, count);
        int i = 0;
        Enumeration<String> enumSelOrderKeys = selOrders.keys();
        while (enumSelOrderKeys.hasMoreElements()) {
            IMemento childAttrOrder = this.openChild(t, childAttrOrderReg, SELECTED_KEYNAME_PREFIX + i);
            String instanceId = enumSelOrderKeys.nextElement();
            childAttrOrder.putString(ATTR_ORDER_SELECTED_INSTANCEID, instanceId);
            AttributeOrder attrOrder = selOrders.get(instanceId);
            String attrOrderKey = attrOrder.getKey();
            childAttrOrder.putString(ATTR_ORDER_SELECTED_KEY, attrOrderKey);
            ++i;
        }
        return result;
    }

    private IMemento openChild(Trace t, IMemento parent, String childName) {
        IMemento child = null;
        child = parent.getChild(childName);
        if (child == null) {
            child = parent.createChild(childName);
        }
        return child;
    }

    public static String getFilename() {
        return attrOrdersFilename;
    }

    public boolean isExampleAttributeOrderCreated(Trace t, String id) {
        boolean result = false;
        int i = 0;
        while (i < this.createdExampleAttrOrderIds.size()) {
            String testId = this.createdExampleAttrOrderIds.get(i);
            if (testId.compareTo(id) == 0) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public void addCreatedExampleAttributeOrderId(Trace t, String id) {
        if (!this.isExampleAttributeOrderCreated(t, id)) {
            this.createdExampleAttrOrderIds.add(id);
        }
    }

    public String createBackupFile(Trace t) {
        String backupFile = UiUtils.createBackupFile(t, attrOrdersFilename);
        return backupFile;
    }

    /*
     * Loose catch block
     */
    public void readXMLFile(Trace t) {
        InputStreamReader reader = null;
        try {
            try {
                File file = new File(attrOrdersFilename);
                FileInputStream input = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)input, "UTF-8");
                this.rootRead = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (FileNotFoundException e) {
                if (Trace.isTracing) {
                    t.data(67, "AttributeOrderPersistence.readXMLFile", 300, e.getMessage());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "AttributeOrderPersistence.readXMLFile", 10, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
            catch (WorkbenchException e) {
                t.FFST(67, "AttributeOrderPersistence.readXMLFile", 0, -1, 0, 0, e.getMessage(), null, null);
                this.showReadError(t);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "AttributeOrderPersistence.readXMLFile", 10, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
            catch (UnsupportedEncodingException e) {
                t.FFST(67, "AttributeOrderPersistence.readXMLFile", 1, -1, 0, 0, e.getMessage(), null, null);
                this.showReadError(t);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "AttributeOrderPersistence.readXMLFile", 10, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                t.FFST(67, "AttributeOrderPersistence.readXMLFile", 10, -1, 0, 0, e1.getMessage(), null, null);
            }
        }
    }

    public boolean writeXMLMemento(Trace t) {
        boolean result = false;
        OutputStreamWriter writer = null;
        try {
            try {
                File file = new File(attrOrdersFilename);
                FileOutputStream output = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
                this.rootWrite.save((Writer)writer);
                result = true;
            }
            catch (IOException e) {
                t.FFST(67, "AttributeOrderPersistence.writeXMLMemento", 10, -1, 0, 0, e.getMessage(), null, null);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "AttributeOrderPersistence.writeXMLMemento", 20, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                t.FFST(67, "AttributeOrderPersistence.writeXMLMemento", 20, -1, 0, 0, e1.getMessage(), null, null);
            }
        }
        return result;
    }

    private void showReadError(Trace t) {
        String backupFile = UiUtils.createBackupFile(t, attrOrdersFilename);
        final String messageWarning = CommonServices.getSystemMessage((String)"AMQ4473", (String)backupFile);
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace t2 = Trace.getInstance();
                MessageBox.showMessage(t2, UiPlugin.getShell(), messageWarning, 4, new String[]{UiPlugin.getNLSString(t2, "KEY_General", "UI.GENERAL.OK")}, 0, "AMQ4473");
            }
        });
    }

    public XMLMemento getRootRead() {
        if (this.rootRead == null) {
            Trace t = Trace.getDefault();
            this.readXMLFile(t);
        }
        return this.rootRead;
    }

    public void setRootWrite(XMLMemento rootWrite) {
        this.rootWrite = rootWrite;
    }
}

