/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderChangedEvent;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderPersistence;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderRegistration;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributePair;
import com.ibm.mq.explorer.ui.internal.attributeorder.CompareAttributeOrderLastSelectedDates;
import com.ibm.mq.explorer.ui.internal.attributeorder.CompareAttributePairs;
import com.ibm.mq.explorer.ui.internal.attributeorder.DefaultObjectAttributeOrderRegistrations;
import com.ibm.mq.explorer.ui.internal.attributeorder.DefineExampleAttributeOrders;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeDetails;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeOrderChangedListener;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.widgets.Display;

public class AttributeOrderManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/AttributeOrderManager.java";
    public static final int INVALID_INDEX = -1;
    private Vector<IAttributeOrderChangedListener> changedListeners = null;
    private Hashtable<String, AttributeOrderRegistration> registrations = null;
    private AttributeOrderPersistence attrOrderPersistence = null;
    private Message msgFile = null;
    private Hashtable<String, IAttributeDetails> attrDetailClasses = null;
    private static Integer lock = 0;
    private File workingDir;

    public AttributeOrderManager(Trace t, File workingDir) {
        this.workingDir = workingDir;
        this.initialise(t);
    }

    public void initialise(Trace t) {
        this.attrOrderPersistence = new AttributeOrderPersistence(t, this.workingDir);
        this.registrations = new Hashtable();
        this.attrDetailClasses = new Hashtable();
        if (this.changedListeners == null) {
            this.changedListeners = new Vector();
        }
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Schemes");
        if (this.attrOrderPersistence.isNewVersion(t)) {
            this.migrateAttributeOrders(t);
        } else {
            boolean foundNullAttrOrderReg = false;
            ArrayList<String> filterRegIds = this.loadAttributeOrderRegistrationIds(t);
            int i = 0;
            while (i < filterRegIds.size()) {
                String regAttrOrderId = filterRegIds.get(i);
                AttributeOrderRegistration attrOrderReg = this.loadAttributeOrderRegistration(t, regAttrOrderId);
                if (attrOrderReg != null) {
                    AttributeOrder dfltAttrOrder;
                    if (regAttrOrderId.compareTo("com.ibm.mq.explorer.orderid.topics") == 0) {
                        dfltAttrOrder = attrOrderReg.getDefaultOrder();
                        if (dfltAttrOrder.getObjectId().compareTo("com.ibm.mq.explorer.topic") != 0) {
                            regAttrOrderId = "com.ibm.mq.explorer.pubsub.orderid.topics";
                            attrOrderReg.setOrderId(regAttrOrderId);
                            attrOrderReg.setObjectId("com.ibm.mq.explorer.pubsub.topic.topic");
                        }
                    } else if (regAttrOrderId.compareTo("com.ibm.mq.explorer.orderid.subscriptions") == 0 && (dfltAttrOrder = attrOrderReg.getDefaultOrder()).getObjectId().compareTo("com.ibm.mq.explorer.subscription") != 0) {
                        regAttrOrderId = "com.ibm.mq.explorer.pubsub.orderid.subscriptions";
                        attrOrderReg.setOrderId(regAttrOrderId);
                        attrOrderReg.setObjectId("com.ibm.mq.explorer.pubsub.topic.subscription");
                    }
                    this.registrations.put(regAttrOrderId, attrOrderReg);
                } else {
                    foundNullAttrOrderReg = true;
                }
                ++i;
            }
            if (foundNullAttrOrderReg) {
                String backupFileName = this.attrOrderPersistence.createBackupFile(t);
                this.displayInvalidAttrOrderFileWarning(t, backupFileName);
            }
            DefaultObjectAttributeOrderRegistrations.register(t, this);
            DefineExampleAttributeOrders.create(t, this);
        }
        this.saveAttributeOrders(t, false);
    }

    private void displayInvalidAttrOrderFileWarning(Trace t, String fileName) {
        final String messageWarning = CommonServices.getSystemMessage((String)"AMQ4472", (String)fileName);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace t2 = Trace.getDefault();
                MessageBox.showMessage(t2, UiPlugin.getShell(), messageWarning, 4, new String[]{UiPlugin.getNLSString(t2, "KEY_General", "UI.GENERAL.OK")}, 0, "AMQ4472");
            }
        });
    }

    public boolean register(Trace t, IAttributeDetails attrDetails, String orderId, String attrOrderNameRoot, String objectId, int[] defaultAttributeOrderIds, String[] defaultAttributeOrderNames, int[] defaultAttributeOrderIndexes) {
        boolean result = this.registerOrder(t, attrDetails, orderId, attrOrderNameRoot, objectId, defaultAttributeOrderIds, defaultAttributeOrderNames, defaultAttributeOrderIndexes, null, null, null, null, null);
        return result;
    }

    public boolean register(Trace t, IAttributeDetails attrDetails, String orderId, String attrOrderNameRoot, String objectId, int[] defaultAttributeOrderIds, String[] defaultAttributeOrderNames, int[] defaultAttributeOrderIndexesPrimary, int[] defaultAttributeOrderIndexesSecondary, String namePrimary, String nameSecondary, String copyPrimaryToSecondary, String copySecondaryToPrimary) {
        boolean result = this.registerOrder(t, attrDetails, orderId, attrOrderNameRoot, objectId, defaultAttributeOrderIds, defaultAttributeOrderNames, defaultAttributeOrderIndexesPrimary, defaultAttributeOrderIndexesSecondary, namePrimary, nameSecondary, copyPrimaryToSecondary, copySecondaryToPrimary);
        return result;
    }

    private boolean registerOrder(Trace t, IAttributeDetails attrDetails, String orderId, String attrOrderNameRoot, String objectId, int[] defaultAttributeOrderIds, String[] defaultAttributeOrderNames, int[] defaultAttributeOrderIndexesPrimary, int[] defaultAttributeOrderIndexesSecondary, String namePrimary, String nameSecondary, String copyPrimaryToSecondary, String copySecondaryToPrimary) {
        boolean result = false;
        this.attrDetailClasses.put(orderId, attrDetails);
        String defaultOrderName = Message.format((String)this.msgFile.getMessage(t, "UI.SCHEMES.Prefix.Default"), (String)attrOrderNameRoot);
        String standardOrderName = Message.format((String)this.msgFile.getMessage(t, "UI.SCHEMES.Prefix.Standard"), (String)attrOrderNameRoot);
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, orderId);
        if (attrOrderReg == null) {
            int[] indexesPrimary = defaultAttributeOrderIndexesPrimary;
            int[] indexesSecondary = defaultAttributeOrderIndexesSecondary;
            if (indexesPrimary == null) {
                indexesPrimary = indexesSecondary;
                indexesSecondary = null;
            }
            AttributeOrder defaultAttrOrder = new AttributeOrder(t, orderId, defaultOrderName, objectId, true, false);
            this.addAttributesToAttributeOrder(t, attrDetails, objectId, defaultAttrOrder, defaultAttributeOrderIds, defaultAttributeOrderNames, indexesPrimary, indexesSecondary);
            defaultAttrOrder.setIconAttrId(t, defaultAttrOrder.getAttributeOrderItemFromPosition(t, 0, false).getAttributeId());
            defaultAttrOrder.setDualOrderNames(t, namePrimary, nameSecondary);
            defaultAttrOrder.setCopyButtonNames(t, copyPrimaryToSecondary, copySecondaryToPrimary);
            defaultAttrOrder.setStandardOrder(true);
            AttributeOrder fullAttrOrder = new AttributeOrder(t, orderId, defaultOrderName, objectId, false, true);
            int[] fullAttributeOrderIndexes = new int[defaultAttributeOrderIds.length];
            int highestIndex = 0;
            int i = 0;
            while (i < defaultAttributeOrderIds.length) {
                if (indexesPrimary[i] > highestIndex) {
                    highestIndex = indexesPrimary[i];
                }
                ++i;
            }
            ++highestIndex;
            i = 0;
            while (i < defaultAttributeOrderIds.length) {
                fullAttributeOrderIndexes[i] = indexesPrimary[i];
                if (fullAttributeOrderIndexes[i] == -1) {
                    fullAttributeOrderIndexes[i] = highestIndex++;
                }
                ++i;
            }
            this.addAttributesToAttributeOrder(t, attrDetails, objectId, fullAttrOrder, defaultAttributeOrderIds, defaultAttributeOrderNames, fullAttributeOrderIndexes, null);
            fullAttrOrder.setIconAttrId(t, fullAttrOrder.getAttributeOrderItemFromPosition(t, 0, false).getAttributeId());
            fullAttrOrder.setStandardOrder(true);
            AttributeOrderRegistration orderRegistration = new AttributeOrderRegistration(t, objectId, orderId, fullAttrOrder, defaultAttrOrder);
            result = this.addOrderRegistration(t, orderId, orderRegistration);
            if (result) {
                this.createStandardAttributeOrder(t, orderId, standardOrderName, true);
            }
        } else {
            ArrayList<AttributeOrder> userDefinedOrders = this.getUserDefinedOrders(t, orderId);
            if (userDefinedOrders.size() == 0) {
                this.createStandardAttributeOrder(t, orderId, standardOrderName, true);
                this.saveAttributeOrders(t, false);
            }
            result = true;
        }
        return result;
    }

    public boolean register(Trace t, IAttributeDetails attrDetails, String objectId, String orderId, String attrOrderNameRoot, AttributeOrderItem[] attrOrderItems) {
        boolean result = false;
        this.attrDetailClasses.put(orderId, attrDetails);
        String defaultOrderName = Message.format((String)this.msgFile.getMessage(t, "UI.SCHEMES.Prefix.Default"), (String)attrOrderNameRoot);
        String standardOrderName = Message.format((String)this.msgFile.getMessage(t, "UI.SCHEMES.Prefix.Standard"), (String)attrOrderNameRoot);
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, orderId);
        if (attrOrderReg == null) {
            AttributeOrderItem attrOrderItem;
            AttributeOrder defaultAttrOrder = new AttributeOrder(t, orderId, defaultOrderName, objectId, true, false);
            int i = 0;
            while (i < attrOrderItems.length) {
                defaultAttrOrder.add(t, attrOrderItems[i]);
                ++i;
            }
            defaultAttrOrder.setIconAttrId(t, defaultAttrOrder.getAttributeOrderItemFromPosition(t, 0, false).getAttributeId());
            AttributeOrder fullAttrOrder = new AttributeOrder(t, orderId, defaultOrderName, objectId, false, true);
            int highestIndex = 0;
            int i2 = 0;
            while (i2 < defaultAttrOrder.size()) {
                attrOrderItem = defaultAttrOrder.get(t, i2);
                int pos = attrOrderItem.getAttributePosition(false);
                if (pos > highestIndex) {
                    highestIndex = pos;
                }
                ++i2;
            }
            ++highestIndex;
            i2 = 0;
            while (i2 < defaultAttrOrder.size()) {
                attrOrderItem = defaultAttrOrder.get(t, i2);
                AttributeOrderItem fullAttrOrderItem = new AttributeOrderItem(t, attrOrderItem);
                if (fullAttrOrderItem.getAttributePosition(false) == -1) {
                    fullAttrOrderItem.setAttributePosition(highestIndex++, false);
                }
                fullAttrOrder.add(t, fullAttrOrderItem);
                ++i2;
            }
            fullAttrOrder.setIconAttrId(t, fullAttrOrder.getAttributeOrderItemFromPosition(t, 0, false).getAttributeId());
            AttributeOrderRegistration orderRegistration = new AttributeOrderRegistration(t, objectId, orderId, fullAttrOrder, defaultAttrOrder);
            result = this.addOrderRegistration(t, orderId, orderRegistration);
            if (result) {
                this.createStandardAttributeOrder(t, orderId, standardOrderName, true);
            }
            this.saveAttributeOrders(t, false);
        } else {
            ArrayList<AttributeOrder> userDefinedOrders = this.getUserDefinedOrders(t, orderId);
            if (userDefinedOrders.size() == 0) {
                this.createStandardAttributeOrder(t, orderId, standardOrderName, true);
                this.saveAttributeOrders(t, false);
            }
            result = true;
        }
        return result;
    }

    public boolean unregister(Trace t, String orderId) {
        boolean result = this.removeOrderRegistration(t, orderId);
        return result;
    }

    public boolean isRegistered(Trace t, String orderId) {
        boolean result = false;
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, orderId);
        if (attrOrderReg != null) {
            result = true;
        }
        return result;
    }

    public AttributeOrder getRegisteredCurrentAttributeOrder(Trace t, String orderId, String instanceId) {
        AttributeOrder attrOrder = null;
        String useInstanceId = AttributeOrderManager.makeValidInstanceId(instanceId);
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, orderId);
        if (attrOrderReg != null && (attrOrder = this.getSelectedAttrOrder(t, orderId, useInstanceId)) == null) {
            attrOrder = this.getSelectedAttrOrder(t, orderId, AttributeOrderManager.makeValidInstanceId(null));
            if (attrOrder == null) {
                attrOrder = this.getDefaultAttributeOrder(t, orderId);
            }
            if (attrOrder != null) {
                this.setSelectedAttrOrder(t, orderId, useInstanceId, attrOrder, false, false);
            }
        }
        if (attrOrder != null) {
            this.ensureAttributeNamesLoaded(t, attrOrder);
        }
        return attrOrder;
    }

    public AttributeOrder getDefaultAttributeOrder(Trace t, String orderId) {
        AttributeOrder attrOrder = null;
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, orderId);
        if (attrOrderReg != null) {
            attrOrder = attrOrderReg.getDefaultOrder();
        }
        if (attrOrder != null) {
            this.ensureAttributeNamesLoaded(t, attrOrder);
        }
        return attrOrder;
    }

    public AttributeOrder getFullAttributeOrder(Trace t, String orderId) {
        AttributeOrder attrOrder = null;
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, orderId);
        if (attrOrderReg != null) {
            attrOrder = attrOrderReg.getFullOrder();
        }
        if (attrOrder != null) {
            this.ensureAttributeNamesLoaded(t, attrOrder);
        }
        return attrOrder;
    }

    private static String makeValidInstanceId(String instanceId) {
        String useInstanceId = instanceId;
        if (useInstanceId == null) {
            useInstanceId = "com.ibm.mq.explorer.instanceid.common";
        }
        return useInstanceId;
    }

    public AttributeOrder getRegisteredDefaultAttributeOrder(Trace t, String orderId) {
        AttributeOrder attrOrder = null;
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, orderId);
        if (attrOrderReg != null) {
            attrOrder = attrOrderReg.getDefaultOrder();
        }
        if (attrOrder != null) {
            this.ensureAttributeNamesLoaded(t, attrOrder);
        }
        return attrOrder;
    }

    public void addAttributesToAttributeOrder(Trace t, IAttributeDetails attrDetails, String objectId, AttributeOrder attrOrder, int[] allAttrIds, String[] names, int[] allAttrPosPrimary, int[] allAttrPosSecondary) {
        int attrId;
        int attrPos;
        AttributePair attrPair;
        ArrayList<AttributePair> attrPairs = new ArrayList<AttributePair>();
        int index = 0;
        while (index < allAttrIds.length) {
            if (Trace.isTracing) {
                if (allAttrPosSecondary != null) {
                    t.data(67, "AttributeOrderManager.addAttributesToAttributeOrder", 300, "source: id: " + allAttrIds[index] + "  seq primary:" + allAttrPosPrimary[index] + "  seq secondary:" + allAttrPosSecondary[index] + "  repeating: " + attrDetails.isAttributeRepeating(objectId, allAttrIds[index]) + "  name: " + names[index]);
                } else {
                    t.data(67, "AttributeOrderManager.addAttributesToAttributeOrder", 300, "source: id: " + allAttrIds[index] + "  seq:" + allAttrPosPrimary[index] + "  repeating: " + attrDetails.isAttributeRepeating(objectId, allAttrIds[index]) + "  name: " + names[index]);
                }
            }
            if (allAttrPosSecondary != null) {
                if (!(attrDetails.isAttributeRepeating(objectId, allAttrIds[index]) || allAttrPosPrimary[index] == -2 && allAttrPosSecondary[index] == -2)) {
                    attrPair = new AttributePair(allAttrIds[index], allAttrPosPrimary[index], allAttrPosSecondary[index], names[index]);
                    attrPairs.add(attrPair);
                    t.data(67, "AttributeOrderManager.addAttributesToAttributeOrder", 300, "added!");
                }
            } else if (!attrDetails.isAttributeRepeating(objectId, allAttrIds[index]) && allAttrPosPrimary[index] != -2) {
                attrPair = new AttributePair(allAttrIds[index], allAttrPosPrimary[index], names[index]);
                attrPairs.add(attrPair);
                t.data(67, "AttributeOrderManager.addAttributesToAttributeOrder", 300, "added!");
            }
            ++index;
        }
        t.data(67, "AttributeOrderManager.addAttributesToAttributeOrder", 300, "------------------");
        AttributeOrderManager.sortAttributePairs(t, attrPairs, false);
        int i = 0;
        while (i < attrPairs.size()) {
            attrPair = attrPairs.get(i);
            attrPos = attrPair.getAttributePosition(false);
            if (attrPos != -1 && attrPos != -2) {
                attrPair.setAttributePosition(i, false);
            }
            ++i;
        }
        if (allAttrPosSecondary != null) {
            AttributeOrderManager.sortAttributePairs(t, attrPairs, true);
            i = 0;
            while (i < attrPairs.size()) {
                attrPair = attrPairs.get(i);
                attrPos = attrPair.getAttributePosition(true);
                if (attrPos != -1 && attrPos != -2) {
                    attrPair.setAttributePosition(i, true);
                }
                ++i;
            }
        }
        if (allAttrPosSecondary != null) {
            i = 0;
            while (i < attrPairs.size()) {
                attrPair = attrPairs.get(i);
                attrId = attrPair.getAttributeId();
                String attrName = attrPair.getAttributeName();
                int attrPosPrimary = attrPair.getAttributePosition(false);
                int attrPosSecondary = attrPair.getAttributePosition(true);
                AttributeOrderItem attrOrderItem = new AttributeOrderItem(t, attrId, attrName, attrPosPrimary, attrPosSecondary);
                attrOrder.add(t, attrOrderItem);
                if (Trace.isTracing) {
                    t.data(67, "AttributeOrderManager.addAttributesToAttributeOrder", 300, "id: " + attrId + "  name: " + attrName + "  seqP: " + attrPosPrimary + "  seqS: " + attrPosSecondary);
                }
                ++i;
            }
            attrOrder.setDualOrder(t, true);
        } else {
            i = 0;
            while (i < attrPairs.size()) {
                attrPair = attrPairs.get(i);
                attrId = attrPair.getAttributeId();
                String attrName = attrPair.getAttributeName();
                int attrPos2 = attrPair.getAttributePosition(false);
                AttributeOrderItem attrOrderItem = new AttributeOrderItem(t, attrId, attrName, attrPos2);
                attrOrder.add(t, attrOrderItem);
                if (Trace.isTracing) {
                    t.data(67, "AttributeOrderManager.addAttributesToAttributeOrder", 300, "id: " + attrId + "  name: " + attrName + "  seq: " + attrPos2);
                }
                ++i;
            }
            attrOrder.setDualOrder(t, false);
        }
    }

    public ArrayList<AttributeOrder> getAvailableAttributeOrders(Trace t, String orderId) {
        ArrayList<AttributeOrder> array = new ArrayList<AttributeOrder>();
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, orderId);
        if (attrOrderReg != null) {
            ArrayList<AttributeOrder> userOrders = this.getUserDefinedOrders(t, orderId);
            int i = 0;
            while (i < userOrders.size()) {
                AttributeOrder attrOrder = userOrders.get(i);
                this.ensureAttributeNamesLoaded(t, attrOrder);
                array.add(attrOrder);
                ++i;
            }
        }
        return array;
    }

    private static void sortAttributePairs(Trace t, ArrayList<AttributePair> attrPairs, boolean isSecondary) {
        CompareAttributePairs compareAttrPairs = new CompareAttributePairs(isSecondary);
        int count = attrPairs.size();
        AttributePair[] attrPairArray = new AttributePair[count];
        attrPairArray = attrPairs.toArray(attrPairArray);
        Arrays.sort(attrPairArray, compareAttrPairs);
        attrPairs.clear();
        int i = 0;
        while (i < count) {
            attrPairs.add(attrPairArray[i]);
            ++i;
        }
    }

    public boolean addUserDefinedOrder(Trace t, String orderId, AttributeOrder userAttrOrder) {
        boolean result = false;
        AttributeOrderRegistration orderRegistration = this.getOrderRegistration(t, orderId);
        if (orderRegistration != null) {
            result = orderRegistration.addUserDefinedOrder(t, userAttrOrder);
        }
        userAttrOrder.setIconAttrId(t, userAttrOrder.getAttributeOrderItemFromPosition(t, 0, false).getAttributeId());
        return result;
    }

    public boolean removeUserDefinedOrder(Trace t, String orderId, String universalId) {
        boolean result = false;
        AttributeOrderRegistration orderRegistration = this.getOrderRegistration(t, orderId);
        if (orderRegistration != null) {
            result = orderRegistration.removeUserDefinedOrder(t, universalId);
        }
        return result;
    }

    public boolean setUserDefinedOrders(Trace t, String orderId, ArrayList<AttributeOrder> userOrders) {
        boolean result = false;
        AttributeOrderRegistration orderRegistration = this.getOrderRegistration(t, orderId);
        if (orderRegistration != null) {
            result = orderRegistration.setUserDefinedOrders(t, userOrders);
            this.triggerChangedListeners(t, orderId);
        }
        return result;
    }

    public ArrayList<AttributeOrder> getUserDefinedOrders(Trace t, String orderId) {
        ArrayList<AttributeOrder> userDefinedOrders = null;
        AttributeOrderRegistration orderRegistration = this.getOrderRegistration(t, orderId);
        if (orderRegistration != null) {
            userDefinedOrders = orderRegistration.getUserDefinedOrdersArray(t);
            int i = 0;
            while (i < userDefinedOrders.size()) {
                AttributeOrder attrOrder = userDefinedOrders.get(i);
                this.ensureAttributeNamesLoaded(t, attrOrder);
                ++i;
            }
        }
        return userDefinedOrders;
    }

    public ArrayList<AttributeOrder> getUserDefinedOrders(Trace t, AttributeOrderRegistration attrOrderRegistration) {
        ArrayList<AttributeOrder> userDefinedOrders = null;
        userDefinedOrders = attrOrderRegistration.getUserDefinedOrdersArray(t);
        int i = 0;
        while (i < userDefinedOrders.size()) {
            AttributeOrder attrOrder = userDefinedOrders.get(i);
            this.ensureAttributeNamesLoaded(t, attrOrder);
            ++i;
        }
        return userDefinedOrders;
    }

    private AttributeOrder getSelectedAttrOrder(Trace t, String orderId, String instanceId) {
        AttributeOrder attrOrder = null;
        AttributeOrderRegistration orderRegistration = this.getOrderRegistration(t, orderId);
        if (orderRegistration != null) {
            attrOrder = orderRegistration.getSelectedAttrOrder(t, instanceId);
        }
        if (attrOrder != null) {
            this.ensureAttributeNamesLoaded(t, attrOrder);
        }
        return attrOrder;
    }

    public void setSelectedAttrOrder(Trace t, String orderId, String instanceId, String attrOrderUID, boolean triggerListeners, boolean persistSelection) {
        AttributeOrder attrOrder = this.getAttributeOrderFromUID(t, orderId, attrOrderUID);
        if (attrOrder != null) {
            this.setSelectedAttrOrder(t, orderId, instanceId, attrOrder, triggerListeners, persistSelection);
        }
    }

    public void setSelectedAttrOrder(Trace t, String orderId, String instanceId, AttributeOrder attrOrder, boolean triggerListeners, boolean persistSelection) {
        String useInstanceId = AttributeOrderManager.makeValidInstanceId(instanceId);
        AttributeOrderRegistration orderRegistration = this.getOrderRegistration(t, orderId);
        if (orderRegistration != null) {
            orderRegistration.setSelectedAttrOrder(t, useInstanceId, attrOrder);
            Date date = new Date();
            attrOrder.setDateLastSelected(date.getTime());
            if (persistSelection) {
                this.saveAttributeOrders(t, false);
            }
            if (triggerListeners) {
                this.triggerSelectionChangedListeners(t, orderId);
            }
        }
    }

    public boolean addOrderRegistration(Trace t, String orderId, AttributeOrderRegistration orderReg) {
        boolean result = false;
        if (this.getOrderRegistration(t, orderId) == null) {
            this.registrations.put(orderId, orderReg);
            result = true;
        }
        return result;
    }

    public AttributeOrderRegistration getOrderRegistration(Trace t, String orderId) {
        AttributeOrderRegistration orderReg = this.registrations.get(orderId);
        return orderReg;
    }

    public AttributeOrderRegistration getOrderRegistration(Trace t, AttributeOrder attrOrder) {
        AttributeOrderRegistration orderReg = this.registrations.get(attrOrder.getOrderId());
        return orderReg;
    }

    public boolean removeOrderRegistration(Trace t, String orderId) {
        AttributeOrderRegistration value = this.registrations.remove(orderId);
        return value != null;
    }

    public int getIconAttributeId(Trace t, String orderId, String instanceId) {
        int id = -1;
        String useInstanceId = AttributeOrderManager.makeValidInstanceId(instanceId);
        AttributeOrderRegistration orderRegistration = this.getOrderRegistration(t, orderId);
        if (orderRegistration != null) {
            id = orderRegistration.getIconAttributeId(t, useInstanceId);
        }
        return id;
    }

    public void addChangedListener(Trace t, IAttributeOrderChangedListener listener) {
        this.changedListeners.addElement(listener);
    }

    public void removeChangedListener(Trace t, IAttributeOrderChangedListener listener) {
        this.changedListeners.removeElement(listener);
    }

    public void triggerChangedListeners(Trace t, String orderId) {
        AttributeOrderChangedEvent selEvent = new AttributeOrderChangedEvent(this, orderId);
        int i = 0;
        while (i < this.changedListeners.size()) {
            IAttributeOrderChangedListener listener = this.changedListeners.elementAt(i);
            listener.changed(selEvent);
            ++i;
        }
    }

    public void triggerSelectionChangedListeners(Trace t, String orderId) {
        AttributeOrderChangedEvent selEvent = new AttributeOrderChangedEvent(this, orderId);
        int i = 0;
        while (i < this.changedListeners.size()) {
            IAttributeOrderChangedListener listener = this.changedListeners.elementAt(i);
            listener.selectionChanged(selEvent);
            ++i;
        }
    }

    public AttributeOrder getAttributeOrderFromUID(Trace t, String orderId, String attrOrderUID) {
        AttributeOrder attrOrder = null;
        AttributeOrderRegistration orderRegistration = this.getOrderRegistration(t, orderId);
        if (orderRegistration != null) {
            attrOrder = orderRegistration.getAttributeOrderFromUID(t, attrOrderUID);
        }
        if (attrOrder != null) {
            this.ensureAttributeNamesLoaded(t, attrOrder);
        }
        return attrOrder;
    }

    public int getMaxAttributesInOrder(Trace t, String orderid) {
        int count = 0;
        int countPrimary = 0;
        AttributeOrder order = this.getRegisteredDefaultAttributeOrder(t, orderid);
        if (order != null) {
            int i = 0;
            while (i < order.size()) {
                AttributeOrderItem item = order.get(t, i);
                if (item != null && item.getAttributePosition(false) != -2) {
                    ++countPrimary;
                }
                ++i;
            }
        }
        if (countPrimary > count) {
            count = countPrimary;
        }
        if (order != null && order.isDualOrder()) {
            int countSecondary = 0;
            int i = 0;
            while (i < order.size()) {
                AttributeOrderItem item = order.get(t, i);
                if (item != null && item.getAttributePosition(true) != -2) {
                    ++countSecondary;
                }
                ++i;
            }
            if (countSecondary > count) {
                count = countSecondary;
            }
        }
        return count;
    }

    public void instanceDeleted(Trace t, String attrOrderId, String instanceId) {
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, attrOrderId);
        if (attrOrderReg != null) {
            attrOrderReg.removeInstanceFromSelectedAttributeOrders(t, AttributeOrderManager.makeValidInstanceId(instanceId));
            this.saveAttributeOrders(t, false);
        }
    }

    private boolean createStandardAttributeOrder(Trace t, String attrOrderId, String standardOrderName, boolean select) {
        boolean result = false;
        AttributeOrderRegistration attrOrderReg = this.getOrderRegistration(t, attrOrderId);
        if (attrOrderReg != null) {
            AttributeOrder defaultAttrOrder = attrOrderReg.getDefaultOrder();
            AttributeOrder standardAttrOrder = new AttributeOrder(t, defaultAttrOrder);
            standardAttrOrder.setOrderName(t, standardOrderName);
            standardAttrOrder.setDefaultOrder(t, false);
            standardAttrOrder.setStandardOrder(true);
            this.addUserDefinedOrder(t, attrOrderId, standardAttrOrder);
            if (select) {
                this.setSelectedAttrOrder(t, attrOrderId, null, standardAttrOrder, false, false);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttributeOrders(Trace t) {
        Integer n = lock;
        synchronized (n) {
            ArrayList<String> regFilterIds = new ArrayList<String>();
            Enumeration<String> ids = this.registrations.keys();
            while (ids.hasMoreElements()) {
                String key = ids.nextElement();
                regFilterIds.add(key);
                AttributeOrderRegistration attrOrderReg = this.registrations.get(key);
                this.attrOrderPersistence.saveAttributeOrderRegistration(t, attrOrderReg, false);
            }
            this.attrOrderPersistence.saveAttributeOrderRegistrationIds(t, regFilterIds);
            this.attrOrderPersistence.writeAttributeOrderRegistrationInfo(t);
        }
    }

    public void saveAttributeOrders(Trace t, boolean wait) {
        Thread saveThread = new Thread(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                AttributeOrderManager.this.persistAttributeOrders(tr);
            }
        };
        saveThread.setName("IBM MQ save schemes");
        saveThread.start();
        if (wait) {
            try {
                saveThread.join();
            }
            catch (InterruptedException e1) {
                t.data(67, "AttributeOrderManager.saveAttributeOrders", e1.getMessage());
            }
        }
    }

    protected void ensureAttributeNamesLoaded(Trace t, AttributeOrder attrOrder) {
        if (!attrOrder.isNamesLoaded()) {
            IAttributeDetails attrDetails = this.attrDetailClasses.get(attrOrder.getOrderId());
            if (attrDetails != null) {
                ArrayList<AttributeOrderItem> attrOrderItems = attrOrder.getAttributeOrderItems(t);
                int i = 0;
                while (i < attrOrderItems.size()) {
                    AttributeOrderItem attrOrderItem = attrOrderItems.get(i);
                    String name = attrDetails.getAttributeName(attrOrder.getObjectId(), attrOrderItem.getAttributeId());
                    if (name != null) {
                        attrOrderItem.setAttributeText(t, name);
                    }
                    ++i;
                }
                attrOrder.setNamesLoaded(true);
            } else if (Trace.isTracing) {
                t.data(67, "AttributeOrderManager.ensureAttributeNamesLoaded", 900, "unable to load names for AttributeOrder '" + attrOrder.getOrderName(t) + "' - no IAttributeDetails class available");
            }
        }
    }

    public AttributeOrder[] getMostRecentlySelectedAttributeOrders(Trace t, String attrOrderId, int count) {
        AttributeOrder[] attrOrders = new AttributeOrder[count];
        int i = 0;
        while (i < count) {
            attrOrders[i] = null;
            ++i;
        }
        ArrayList<AttributeOrder> availAttributeOrders = this.getAvailableAttributeOrders(t, attrOrderId);
        int size = availAttributeOrders.size();
        AttributeOrder[] attrOrderArray = new AttributeOrder[size];
        attrOrderArray = availAttributeOrders.toArray(attrOrderArray);
        CompareAttributeOrderLastSelectedDates compAttrOrderLastSelDates = new CompareAttributeOrderLastSelectedDates();
        Arrays.sort(attrOrderArray, compAttrOrderLastSelDates);
        int limit = count;
        if (size < limit) {
            limit = size;
        }
        int i2 = 0;
        while (i2 < limit) {
            attrOrders[i2] = attrOrderArray[i2];
            ++i2;
        }
        return attrOrders;
    }

    public boolean addExampleAttributeOrder(Trace t, String exampleId, AttributeOrder attrOrder) {
        boolean result = false;
        if (!this.attrOrderPersistence.isExampleAttributeOrderCreated(t, exampleId)) {
            if (this.addUserDefinedOrder(t, attrOrder.getOrderId(), attrOrder)) {
                this.attrOrderPersistence.addCreatedExampleAttributeOrderId(t, exampleId);
                result = true;
            } else if (Trace.isTracing) {
                t.data(67, "AttributeOrderManager.addExampleAttributeOrder", 900, "Error: failed to add example Attribute Order, orderId='" + attrOrder.getOrderId() + "', exampleId='" + exampleId + "'");
            }
        } else {
            result = true;
        }
        return result;
    }

    public AttributeOrder getAttributeOrderFromName(Trace t, String attrOrderId, String attrOrderName) {
        AttributeOrderRegistration orderRegistration = this.getOrderRegistration(t, attrOrderId);
        AttributeOrder attrOrder = this.getAttributeOrderFromName(t, orderRegistration, attrOrderName);
        return attrOrder;
    }

    public AttributeOrder getAttributeOrderFromName(Trace t, AttributeOrderRegistration orderRegistration, String attrOrderName) {
        AttributeOrder attrOrder = null;
        if (orderRegistration != null) {
            AttributeOrder order2 = orderRegistration.getDefaultOrder();
            if (order2.getOrderName(t).compareTo(attrOrderName) == 0) {
                attrOrder = order2;
            } else {
                ArrayList<AttributeOrder> orders = orderRegistration.getUserDefinedOrdersArray(t);
                for (AttributeOrder order2 : orders) {
                    if (order2.getOrderName(t).compareTo(attrOrderName) != 0) continue;
                    attrOrder = order2;
                    break;
                }
            }
        }
        return attrOrder;
    }

    private void migrateAttributeOrders(Trace t) {
        boolean containsNewAttributes = false;
        boolean backedUpSchemes = false;
        boolean foundNullAttrOrderReg = false;
        ArrayList<String> filterRegIds = this.loadAttributeOrderRegistrationIds(t);
        ArrayList<AttributeOrderRegistration> attrOrderRegs = new ArrayList<AttributeOrderRegistration>();
        int i = 0;
        while (i < filterRegIds.size()) {
            String regAttrOrderId = filterRegIds.get(i);
            AttributeOrderRegistration attrOrderReg = this.loadAttributeOrderRegistration(t, regAttrOrderId);
            if (attrOrderReg != null) {
                AttributeOrder dfltAttrOrder;
                if (regAttrOrderId.compareTo("com.ibm.mq.explorer.orderid.topics") == 0) {
                    dfltAttrOrder = attrOrderReg.getDefaultOrder();
                    if (dfltAttrOrder.getObjectId().compareTo("com.ibm.mq.explorer.topic") != 0) {
                        regAttrOrderId = "com.ibm.mq.explorer.pubsub.orderid.topics";
                        attrOrderReg.setOrderId(regAttrOrderId);
                        attrOrderReg.setObjectId("com.ibm.mq.explorer.pubsub.topic.topic");
                    }
                } else if (regAttrOrderId.compareTo("com.ibm.mq.explorer.orderid.subscriptions") == 0 && (dfltAttrOrder = attrOrderReg.getDefaultOrder()).getObjectId().compareTo("com.ibm.mq.explorer.subscription") != 0) {
                    regAttrOrderId = "com.ibm.mq.explorer.pubsub.orderid.subscriptions";
                    attrOrderReg.setOrderId(regAttrOrderId);
                    attrOrderReg.setObjectId("com.ibm.mq.explorer.pubsub.topic.subscription");
                }
                attrOrderRegs.add(attrOrderReg);
            } else {
                foundNullAttrOrderReg = true;
            }
            ++i;
        }
        if (foundNullAttrOrderReg) {
            String backupFileName = this.attrOrderPersistence.createBackupFile(t);
            this.displayInvalidAttrOrderFileWarning(t, backupFileName);
        }
        DefaultObjectAttributeOrderRegistrations.register(t, this);
        DefineExampleAttributeOrders.create(t, this);
        int j = 0;
        while (j < attrOrderRegs.size()) {
            AttributeOrderRegistration importedAttrOrderReg = (AttributeOrderRegistration)attrOrderRegs.get(j);
            String regAttrOrderId = importedAttrOrderReg.getOrderId();
            if (this.getOrderRegistration(t, regAttrOrderId) == null) {
                this.registrations.put(regAttrOrderId, importedAttrOrderReg);
            } else {
                ArrayList<AttributeOrder> userDefinedOrders = this.getUserDefinedOrders(t, importedAttrOrderReg);
                AttributeOrder fullAttrOrder = importedAttrOrderReg.getFullOrder();
                AttributeOrder dmFullAttrOrder = this.registrations.get(regAttrOrderId).getFullOrder();
                ArrayList<AttributeOrderItem> newAttributeItems = null;
                if (dmFullAttrOrder.size() > fullAttrOrder.size()) {
                    containsNewAttributes = true;
                    newAttributeItems = this.getNewAttributeItems(t, fullAttrOrder, dmFullAttrOrder);
                }
                Hashtable<String, Boolean> maintainSelection = new Hashtable<String, Boolean>();
                AttributeOrderRegistration dmAttrOrderReg = this.getOrderRegistration(t, regAttrOrderId);
                int k = 0;
                while (k < userDefinedOrders.size()) {
                    AttributeOrder userDefinedOrder = userDefinedOrders.get(k);
                    String uid = userDefinedOrder.getKey();
                    AttributeOrder existingAttrOrder = this.getAttributeOrderFromUID(t, regAttrOrderId, uid);
                    boolean addUserDefinedOrder = false;
                    if (!userDefinedOrder.getOrderId().endsWith(".qv")) {
                        if (existingAttrOrder != null) {
                            if (userDefinedOrder.isStandardOrder() && userDefinedOrder.getStandardOrderState() == 1) {
                                addUserDefinedOrder = true;
                            }
                            if (userDefinedOrder.getStandardOrderState() == -1 && !existingAttrOrder.compareOrder(t, userDefinedOrder)) {
                                addUserDefinedOrder = true;
                            }
                        } else {
                            addUserDefinedOrder = true;
                        }
                        if (addUserDefinedOrder) {
                            String newOrderName = userDefinedOrder.getOrderName(t);
                            AttributeOrder orderCheck = this.getAttributeOrderFromName(t, dmAttrOrderReg, newOrderName);
                            if (orderCheck != null && orderCheck != userDefinedOrder) {
                                if (UiPlugin.getMigrationInfo() != null) {
                                    newOrderName = String.valueOf(newOrderName) + " (V" + UiPlugin.getMigrationInfo().getWorkspaceVersionString() + ")";
                                }
                                int count = 1;
                                String validNewOrderName = newOrderName;
                                while (this.getAttributeOrderFromName(t, dmAttrOrderReg, validNewOrderName) != null) {
                                    validNewOrderName = String.valueOf(newOrderName) + "_" + count++;
                                }
                                userDefinedOrder.setOrderName(t, validNewOrderName);
                            }
                            backedUpSchemes = true;
                            maintainSelection.put(userDefinedOrder.getOrderUniversalId(), false);
                            if (userDefinedOrder.getStandardOrderState() == -1) {
                                userDefinedOrder.setStandardOrder(false);
                                userDefinedOrder.setStandardOrderState(1);
                            }
                            if (newAttributeItems != null) {
                                this.addNewAttributeItems(t, userDefinedOrder, newAttributeItems);
                                newAttributeItems = null;
                            }
                            this.addUserDefinedOrder(t, regAttrOrderId, userDefinedOrder);
                        }
                    }
                    ++k;
                }
                AttributeOrderRegistration newAttrOrderReg = this.getOrderRegistration(t, regAttrOrderId);
                Enumeration<String> selection = importedAttrOrderReg.getSelectedOrders(t).keys();
                while (selection.hasMoreElements()) {
                    String attrOrderKey;
                    String instanceId = selection.nextElement();
                    if (newAttrOrderReg.getSelectedAttrOrder(t, instanceId) != null || maintainSelection.get(attrOrderKey = importedAttrOrderReg.getSelectedAttrOrder(t, instanceId).getOrderUniversalId()) != null && !((Boolean)maintainSelection.get(attrOrderKey)).booleanValue()) continue;
                    newAttrOrderReg.addAttributeOrderSelection(t, instanceId, attrOrderKey);
                }
            }
            ++j;
        }
        if (containsNewAttributes) {
            final String msgId = backedUpSchemes ? "AMQ4552" : "AMQ4465";
            final String newAttributeWarning = CommonServices.getSystemMessage((String)msgId);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace t2 = Trace.getDefault();
                    MessageBox.showMessage(t2, UiPlugin.getShell(), newAttributeWarning, 2, new String[]{UiPlugin.getNLSString(t2, "KEY_General", "UI.GENERAL.OK")}, 0, msgId);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeOrderRegistration loadAttributeOrderRegistration(Trace t, String regAttrOrderId) {
        AttributeOrderRegistration attrOrderRegistration = null;
        Integer n = lock;
        synchronized (n) {
            attrOrderRegistration = this.attrOrderPersistence.loadAttributeOrderRegistration(t, regAttrOrderId);
        }
        return attrOrderRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> loadAttributeOrderRegistrationIds(Trace t) {
        ArrayList<String> attrOrderRegistrationIds = null;
        Integer n = lock;
        synchronized (n) {
            attrOrderRegistrationIds = this.attrOrderPersistence.loadAttributeOrderRegistrationIds(t);
        }
        return attrOrderRegistrationIds;
    }

    private ArrayList<AttributeOrderItem> getNewAttributeItems(Trace t, AttributeOrder fullAttrOrder, AttributeOrder dmFullAttrOrder) {
        ArrayList<AttributeOrderItem> newAttributeOrderItems = new ArrayList<AttributeOrderItem>();
        ArrayList<AttributeOrderItem> dmAttributeOrderItems = dmFullAttrOrder.getAttributeOrderItems(t);
        ArrayList<AttributeOrderItem> persistentAttributeOrderItems = fullAttrOrder.getAttributeOrderItems(t);
        ArrayList<Integer> persistentAttributeOrderIds = new ArrayList<Integer>();
        int i = 0;
        while (i < persistentAttributeOrderItems.size()) {
            persistentAttributeOrderIds.add(persistentAttributeOrderItems.get(i).getAttributeId());
            ++i;
        }
        int j = 0;
        while (j < dmAttributeOrderItems.size()) {
            AttributeOrderItem attrOrderItem = dmAttributeOrderItems.get(j);
            if (!persistentAttributeOrderIds.contains(attrOrderItem.getAttributeId())) {
                newAttributeOrderItems.add(attrOrderItem);
            }
            ++j;
        }
        return newAttributeOrderItems;
    }

    private void addNewAttributeItems(Trace t, AttributeOrder userDefinedOrder, ArrayList<AttributeOrderItem> newAttributeItems) {
        int i = 0;
        while (i < newAttributeItems.size()) {
            AttributeOrderItem attrOrderItem = newAttributeItems.get(i);
            if (attrOrderItem.getAttributePosition(false) != -2) {
                newAttributeItems.get(i).setAttributePosition(-1, false);
            }
            if (attrOrderItem.isDualOrder() && attrOrderItem.getAttributePosition(true) != -2) {
                newAttributeItems.get(i).setAttributePosition(-1, true);
            }
            userDefinedOrder.add(t, newAttributeItems.get(i));
            ++i;
        }
    }
}

