/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;

public class AttributeOrderItem
implements Comparable<AttributeOrderItem> {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/AttributeOrderItem.java";
    public static final int WIDTH_PACK = -1;
    public static final int ITEM_NOT_VISIBLE = -1;
    public static final int ITEM_HIDDEN = -2;
    private int attributeId = 0;
    private String attributeName = "";
    private int attributePositionPrimary = -1;
    private int attributePositionSecondary = -1;
    private int width = -1;
    private boolean isDualOrder = false;
    private boolean isForcedNotVisible = false;

    public AttributeOrderItem(Trace t, int attrId, String attrName, int attrPosition) {
        this.attributeId = attrId;
        this.attributeName = attrName == null || attrName.length() == 0 ? "" + attrId : attrName;
        this.attributePositionPrimary = attrPosition;
        this.isDualOrder = false;
    }

    public AttributeOrderItem(Trace t, int attrId, String attrName, int attrPositionPrimary, int attrPositionSecondary) {
        this.attributeId = attrId;
        this.attributeName = attrName == null || attrName.length() == 0 ? "" + attrId : attrName;
        this.attributePositionPrimary = attrPositionPrimary;
        this.attributePositionSecondary = attrPositionSecondary;
        this.isDualOrder = true;
    }

    public AttributeOrderItem(Trace t, AttributeOrderItem attrOrderItem) {
        this.attributeId = attrOrderItem.attributeId;
        this.attributeName = attrOrderItem.attributeName;
        this.attributePositionPrimary = attrOrderItem.attributePositionPrimary;
        this.attributePositionSecondary = attrOrderItem.attributePositionSecondary;
        this.width = attrOrderItem.width;
        this.isDualOrder = attrOrderItem.isDualOrder;
    }

    public int getAttributeId() {
        return this.attributeId;
    }

    public String toString() {
        return this.getAttributeName();
    }

    public boolean isVisible(boolean isSecondary) {
        boolean visible = false;
        visible = isSecondary && this.isDualOrder ? this.attributePositionSecondary != -1 && this.attributePositionSecondary != -2 && !this.isForcedNotVisible : this.attributePositionPrimary != -1 && this.attributePositionPrimary != -2 && !this.isForcedNotVisible;
        return visible;
    }

    public int getAttributePosition(boolean isSecondary) {
        int position = this.attributePositionPrimary;
        if (isSecondary && this.isDualOrder) {
            position = this.attributePositionSecondary;
        }
        if (this.isForcedNotVisible) {
            position = -1;
        }
        return position;
    }

    public void setAttributeId(int attrId) {
        this.attributeId = attrId;
    }

    public void setAttributePosition(int attrPos, boolean isSecondary) {
        if (isSecondary) {
            this.attributePositionSecondary = attrPos;
            this.isDualOrder = true;
        } else {
            this.attributePositionPrimary = attrPos;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int attrWidth) {
        this.width = attrWidth;
    }

    public void setAttributeText(Trace t, String attrName) {
        this.attributeName = attrName == null || attrName.length() == 0 ? "" + this.attributeId : attrName;
        if (Trace.isTracing) {
            t.data(67, "AttributeOrderItem.setAttributeText", 300, "attribute text set to: " + this.attributeName);
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean isDualOrder() {
        return this.isDualOrder;
    }

    public boolean isForcedNotVisible() {
        return this.isForcedNotVisible;
    }

    public void setForcedNotVisible(boolean isNotVisible) {
        this.isForcedNotVisible = isNotVisible;
    }

    @Override
    public int compareTo(AttributeOrderItem o) {
        return this.attributePositionPrimary - o.attributePositionPrimary;
    }
}

