/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.attributeorder;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import java.util.ArrayList;
import java.util.Date;

public class AttributeOrder {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/attributeorder/AttributeOrder.java";
    public static final int NOT_FOUND = -2;
    public static final int STDORDER_UNKNOWN = -1;
    public static final int STDORDER_UNCHANGED = 0;
    public static final int STDORDER_CHANGED = 1;
    private ArrayList<AttributeOrderItem> attrOrderItems = null;
    private String orderId = "";
    private String orderName = "";
    private String orderUniversalId = "";
    private String objectId = "";
    private boolean isDefaultOrder = false;
    private boolean isFullOrder = false;
    private boolean isDualOrder = false;
    private boolean isStandardOrder = false;
    private int standardOrderChanged = 1;
    private String namePrimary = null;
    private String nameSecondary = null;
    private String copyPrimaryToSecondary = null;
    private String copySecondaryToPrimary = null;
    private int iconAttrId = 0;
    private boolean isNamesLoaded = false;
    private long dateLastSelected = 0L;

    public AttributeOrder(Trace t) {
        this.attrOrderItems = new ArrayList();
    }

    public AttributeOrder(Trace t, String ordId, String ordName, String objId, boolean defaultOrder, boolean fullOrder) {
        this.attrOrderItems = new ArrayList();
        this.orderId = ordId;
        this.orderName = AttributeOrder.processOrderName(ordName);
        this.objectId = objId;
        this.isDefaultOrder = defaultOrder;
        this.isFullOrder = fullOrder;
        this.isDualOrder = false;
        this.setUniversalId(t);
    }

    public AttributeOrder(Trace t, AttributeOrder sourceAttrOrder) {
        if (sourceAttrOrder != null) {
            this.orderId = sourceAttrOrder.orderId;
            this.orderName = AttributeOrder.processOrderName(sourceAttrOrder.orderName);
            this.objectId = sourceAttrOrder.objectId;
            if (sourceAttrOrder.attrOrderItems != null) {
                this.attrOrderItems = new ArrayList();
                int i = 0;
                while (i < sourceAttrOrder.attrOrderItems.size()) {
                    AttributeOrderItem attrOrderItem = sourceAttrOrder.get(t, i);
                    this.attrOrderItems.add(new AttributeOrderItem(t, attrOrderItem));
                    ++i;
                }
            }
            this.isDefaultOrder = sourceAttrOrder.isDefaultOrder;
            this.isFullOrder = sourceAttrOrder.isFullOrder;
            this.isDualOrder = sourceAttrOrder.isDualOrder;
            this.namePrimary = sourceAttrOrder.namePrimary;
            this.nameSecondary = sourceAttrOrder.nameSecondary;
            this.copyPrimaryToSecondary = sourceAttrOrder.copyPrimaryToSecondary;
            this.copySecondaryToPrimary = sourceAttrOrder.copySecondaryToPrimary;
            this.iconAttrId = sourceAttrOrder.iconAttrId;
            this.setUniversalId(t);
        } else if (Trace.isTracing) {
            t.data(67, "AttributeOrder.AttributeOrder", 900, "sourceAttrOrder is NULL");
        }
    }

    public void copyFrom(Trace t, AttributeOrder sourceAttrOrder) {
        if (sourceAttrOrder != null) {
            this.orderId = sourceAttrOrder.orderId;
            this.orderName = AttributeOrder.processOrderName(sourceAttrOrder.orderName);
            this.objectId = sourceAttrOrder.objectId;
            if (sourceAttrOrder.attrOrderItems != null) {
                this.attrOrderItems = new ArrayList();
                int i = 0;
                while (i < sourceAttrOrder.attrOrderItems.size()) {
                    AttributeOrderItem attrOrderItem = sourceAttrOrder.get(t, i);
                    this.attrOrderItems.add(new AttributeOrderItem(t, attrOrderItem));
                    ++i;
                }
            }
            this.isDefaultOrder = sourceAttrOrder.isDefaultOrder;
            this.isFullOrder = sourceAttrOrder.isFullOrder;
            this.isDualOrder = sourceAttrOrder.isDualOrder;
            this.namePrimary = sourceAttrOrder.namePrimary;
            this.nameSecondary = sourceAttrOrder.nameSecondary;
            this.copyPrimaryToSecondary = sourceAttrOrder.copyPrimaryToSecondary;
            this.copySecondaryToPrimary = sourceAttrOrder.copySecondaryToPrimary;
            this.iconAttrId = sourceAttrOrder.iconAttrId;
            this.setUniversalId(t);
        } else if (Trace.isTracing) {
            t.data(67, "AttributeOrder.copyFrom", 900, "sourceAttrOrder is NULL");
        }
    }

    public void add(Trace t, AttributeOrderItem attrOrderItem) {
        this.attrOrderItems.add(attrOrderItem);
        if (attrOrderItem.isDualOrder()) {
            this.isDualOrder = true;
        }
    }

    public void remove(Trace t, AttributeOrderItem attrOrderItem) {
        this.attrOrderItems.remove(attrOrderItem);
    }

    public AttributeOrderItem get(Trace t, int index) {
        AttributeOrderItem attrOrderItem = null;
        attrOrderItem = this.attrOrderItems.get(index);
        return attrOrderItem;
    }

    public int size() {
        int size = this.attrOrderItems.size();
        return size;
    }

    public void clear(Trace t) {
        this.attrOrderItems.clear();
    }

    public int getPosition(Trace t, int attributeId, boolean isSecondary) {
        int position = -2;
        int i = 0;
        while (i < this.attrOrderItems.size()) {
            AttributeOrderItem attrOrderItem = this.attrOrderItems.get(i);
            if (attrOrderItem.getAttributeId() == attributeId) {
                position = attrOrderItem.getAttributePosition(isSecondary);
                break;
            }
            ++i;
        }
        return position;
    }

    public int getAttributeId(Trace t, int position, boolean isSecondary) {
        int id = 0;
        int i = 0;
        while (i < this.attrOrderItems.size()) {
            AttributeOrderItem attrOrderItem = this.attrOrderItems.get(i);
            if (attrOrderItem.getAttributePosition(isSecondary) == position) {
                id = attrOrderItem.getAttributeId();
                break;
            }
            ++i;
        }
        return id;
    }

    public AttributeOrderItem getAttributeOrderItemFromPosition(Trace t, int attributePosition, boolean isSecondary) {
        AttributeOrderItem attributeOrderItem = null;
        int i = 0;
        while (i < this.attrOrderItems.size()) {
            AttributeOrderItem attrOrderItem = this.attrOrderItems.get(i);
            if (attrOrderItem.getAttributePosition(isSecondary) == attributePosition) {
                attributeOrderItem = attrOrderItem;
                break;
            }
            ++i;
        }
        return attributeOrderItem;
    }

    public AttributeOrderItem getAttributeOrderItemFromId(Trace t, int attrId) {
        AttributeOrderItem attributeOrderItem = null;
        int i = 0;
        while (i < this.attrOrderItems.size()) {
            AttributeOrderItem attrOrderItem = this.attrOrderItems.get(i);
            if (attrOrderItem.getAttributeId() == attrId) {
                attributeOrderItem = attrOrderItem;
                break;
            }
            ++i;
        }
        return attributeOrderItem;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getOrderName(Trace t) {
        return this.orderName;
    }

    public static String processOrderName(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        return name.replaceAll("\t", "");
    }

    public void setOrderId(String string) {
        this.orderId = string;
    }

    public void setOrderName(Trace t, String name) {
        this.orderName = AttributeOrder.processOrderName(name);
        this.setUniversalId(t);
    }

    public void setStandardOrder(boolean isStdOrder) {
        if (!this.isStandardOrder && isStdOrder) {
            this.standardOrderChanged = 0;
        }
        this.isStandardOrder = isStdOrder;
    }

    public void setStandardOrderState(int orderState) {
        if (orderState == -1 || orderState == 0 || orderState == 1) {
            this.standardOrderChanged = orderState;
        }
    }

    public String toString() {
        Trace t = Trace.getDefault();
        return this.getOrderName(t);
    }

    public boolean isDefaultOrder() {
        return this.isDefaultOrder;
    }

    public boolean isFullOrder() {
        return this.isFullOrder;
    }

    public boolean isDualOrder() {
        return this.isDualOrder;
    }

    public boolean isStandardOrder() {
        return this.isStandardOrder;
    }

    public int getStandardOrderState() {
        return this.standardOrderChanged;
    }

    public void setDefaultOrder(Trace t, boolean defaultOrder) {
        this.isDefaultOrder = defaultOrder;
        if (defaultOrder) {
            this.setUniversalId(t);
        }
    }

    public void setFullOrder(Trace t, boolean fullOrder) {
        this.isFullOrder = fullOrder;
    }

    public void setDualOrder(Trace t, boolean dualOrder) {
        this.isDualOrder = dualOrder;
    }

    public String getOrderUniversalId() {
        return this.orderUniversalId;
    }

    public void setOrderUniversalId(String id) {
        this.orderUniversalId = id;
    }

    public int getNextAvailablePosition(Trace t) {
        int position = -1;
        int i = 0;
        while (i < this.attrOrderItems.size()) {
            AttributeOrderItem attrOrderItem = this.attrOrderItems.get(i);
            int pos = attrOrderItem.getAttributePosition(false);
            if (pos > position) {
                position = pos;
            }
            if (attrOrderItem.isDualOrder() && (pos = attrOrderItem.getAttributePosition(true)) > position) {
                position = pos;
            }
            ++i;
        }
        return ++position;
    }

    public boolean isEmpty(Trace t) {
        boolean result = this.attrOrderItems.isEmpty();
        return result;
    }

    public int compareTo(AttributeOrder attrOrder) {
        return attrOrder.getOrderUniversalId().compareTo(this.getOrderUniversalId());
    }

    public boolean compareOrder(Trace t, AttributeOrder attrOrder) {
        int userOrderSize;
        boolean identical = true;
        int originalOrderSize = this.attrOrderItems.size();
        if (originalOrderSize == (userOrderSize = attrOrder.size())) {
            int i = 0;
            while (i < originalOrderSize) {
                if (this.getAttributeId(t, i, false) != attrOrder.getAttributeId(t, i, false)) {
                    identical = false;
                }
                if (this.getAttributeId(t, i, true) != attrOrder.getAttributeId(t, i, true)) {
                    identical = false;
                }
                ++i;
            }
        } else {
            identical = false;
        }
        return identical;
    }

    public String getKey() {
        return this.orderUniversalId;
    }

    public void resetOrderUniversalId(Trace t) {
        this.setUniversalId(t);
    }

    private void setUniversalId(Trace t) {
        if (this.isDefaultOrder || this.isFullOrder) {
            this.orderUniversalId = this.getOrderName(t);
        } else {
            Date date = new Date();
            this.orderUniversalId = String.valueOf(this.getOrderName(t)) + "_" + date.toString();
        }
    }

    public void setDualOrderNames(Trace t, String primary, String secondary) {
        this.namePrimary = primary;
        this.nameSecondary = secondary;
    }

    public String getDualOrderName(Trace t, boolean isSecondary) {
        String name = this.namePrimary;
        name = isSecondary ? this.nameSecondary : this.namePrimary;
        return name;
    }

    public void setCopyButtonNames(Trace t, String primaryToSecondary, String secondaryToPrimary) {
        this.copyPrimaryToSecondary = primaryToSecondary;
        this.copySecondaryToPrimary = secondaryToPrimary;
    }

    public String getCopyButtonName(Trace t, boolean isSecondaryToPrimary) {
        String name = "";
        name = isSecondaryToPrimary ? this.copySecondaryToPrimary : this.copyPrimaryToSecondary;
        return name;
    }

    public ArrayList<AttributeOrderItem> getAttributeOrderItems(Trace t) {
        return this.attrOrderItems;
    }

    public int getIconAttrId(Trace t) {
        return this.iconAttrId;
    }

    public void setIconAttrId(Trace t, int attrId) {
        this.iconAttrId = attrId;
    }

    public boolean isNamesLoaded() {
        return this.isNamesLoaded;
    }

    public void setNamesLoaded(boolean isLoaded) {
        this.isNamesLoaded = isLoaded;
    }

    public void setObjectId(String objId) {
        this.objectId = objId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public long getDateLastSelected() {
        return this.dateLastSelected;
    }

    public void setDateLastSelected(long date) {
        this.dateLastSelected = date;
    }
}

