/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.apiexits;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.apiexits.ApiExit;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ApiExitEditDlg
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/apiexits/ApiExitEditDlg.java";
    private static final int SEQUENCE_MIN_VALUE = 0;
    private static final int SEQUENCE_MAX_VALUE = Short.MAX_VALUE;
    private static final int MSGTEXT_HEIGHT_HINT = 70;
    private static final int MIN_DIALOG_HORIZONTAL_SIZE_HINT = 450;
    private ApiExit apiExit = null;
    private ArrayList apiExitsArray = null;
    private ArrayList pendingApiExitsArray = null;
    public static final int APIXE_EDIT_OP_ADD = 0;
    public static final int APIXE_EDIT_OP_EDIT_NOT_NAME = 1;
    public static final int APIXE_EDIT_OP_EDIT_INC_NAME = 2;
    public static final int APIXE_EDIT_OP_EDIT_NONE = 3;
    public static final int APIXE_EDIT_OP_OVERRIDE = 4;
    private int dlgMode = 0;
    private boolean showOverrideCheckbox = false;
    private Text textName = null;
    private Text textFunction = null;
    private Text textModule = null;
    private Button buttonBrowse = null;
    private Button checkHasData = null;
    private Text textData = null;
    private Spinner spinnerSequence = null;
    private Button checkOverride = null;
    private boolean isOverride = false;
    private Label labelMsgIcon = null;
    private Label labelMsgText = null;
    private UiQueueManager uiQueueManager = null;
    private Message msgFile = null;
    private Point preferredSize = null;
    protected boolean valid = true;

    public ApiExitEditDlg(Shell parent, int style) {
        super(parent, style);
    }

    public ApiExitEditDlg(Shell parent) {
        this(parent, 0);
    }

    public void setValues(Trace t, ApiExit apiExit_, ArrayList apiExitsArray_, ArrayList pendingApiExitsArray_, int dlgMode_, boolean showOverrideCheckbox_, UiQueueManager uiQueueManager_) {
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_API Exits");
        this.apiExit = apiExit_;
        this.apiExitsArray = apiExitsArray_;
        this.pendingApiExitsArray = pendingApiExitsArray_;
        this.dlgMode = dlgMode_;
        this.showOverrideCheckbox = showOverrideCheckbox_;
        this.uiQueueManager = uiQueueManager_;
    }

    private void browseSelected(Trace t) {
        FileDialog fileDlg = new FileDialog(this.getShell());
        fileDlg.setFileName(this.textModule.getText());
        String[] filterNames = new String[2];
        String platformExtension = CommonServices.PLATFORM_MODULE_EXTENSION;
        if (platformExtension.startsWith(".")) {
            platformExtension = platformExtension.substring(1);
        }
        filterNames[0] = "*." + platformExtension;
        filterNames[1] = "*.*";
        fileDlg.setFilterNames(filterNames);
        String[] filterExtensions = new String[]{"*." + platformExtension, "*.*"};
        fileDlg.setFilterExtensions(filterExtensions);
        String filename = fileDlg.open();
        if (filename != null) {
            this.textModule.setText(filename);
            this.checkIfEnableOK(t);
        }
    }

    private void checkHasDataSelected(Trace t) {
        if (this.checkHasData.getSelection()) {
            UiUtils.makeTextControlReadWrite(t, this.textData);
        } else {
            UiUtils.makeTextControlReadOnly(t, this.textData, false);
        }
        this.checkIfEnableOK(t);
        if (this.checkHasData.getSelection()) {
            this.textData.selectAll();
            this.textData.setFocus();
        }
    }

    private void checkOverrideSelected(Trace t) {
        this.isOverride = this.checkOverride.getSelection();
        if (!this.isOverride) {
            this.textModule.setText(this.apiExit.getModule(t));
            this.textFunction.setText(this.apiExit.getFunction(t));
            this.textData.setText(this.apiExit.getData(t));
            this.spinnerSequence.setSelection(this.apiExit.getSequence(t));
            this.checkHasData.setSelection(this.apiExit.hasData(t));
            UiUtils.makeTextControlReadOnly(t, this.textModule, false);
            UiUtils.makeTextControlReadOnly(t, this.textFunction, false);
            UiUtils.makeTextControlReadOnly(t, this.textData, false);
            this.checkHasData.setEnabled(false);
            this.spinnerSequence.setEnabled(false);
        } else {
            UiUtils.makeTextControlReadWrite(t, this.textModule);
            UiUtils.makeTextControlReadWrite(t, this.textFunction);
            if (this.checkHasData.getSelection()) {
                UiUtils.makeTextControlReadWrite(t, this.textData);
            } else {
                UiUtils.makeTextControlReadOnly(t, this.textData, false);
            }
            this.checkHasData.setEnabled(true);
            this.spinnerSequence.setEnabled(true);
        }
        this.checkIfEnableOK(t);
        this.setDialogTitle(t);
    }

    private void nameValueChanged(Trace t) {
        this.checkIfEnableOK(t);
    }

    private void functionValueChanged(Trace t) {
        this.checkIfEnableOK(t);
    }

    private void moduleValueChanged(Trace t) {
        this.checkIfEnableOK(t);
    }

    private void dataValueChanged(Trace t) {
        this.checkIfEnableOK(t);
    }

    private void sequenceValueChanged(Trace t) {
        this.checkIfEnableOK(t);
    }

    private void checkIfEnableOK(Trace t) {
        this.enableOK(t, this.isEnableOK(t));
    }

    private String getMessageForSequenceAlreadyUsed(Trace t, ApiExit testApiExit) {
        String message = "";
        if (testApiExit.isCommon(t)) {
            message = Message.format((String)this.msgFile.getMessage(t, "UI.APIE.Msg.SeqInUseCommon"), (String)testApiExit.getName(t));
        } else if (testApiExit.isTemplate(t)) {
            message = Message.format((String)this.msgFile.getMessage(t, "UI.APIE.Msg.SeqInUseTemplate"), (String)testApiExit.getName(t));
        } else {
            UiQueueManager testUiQmgr = testApiExit.getOwningUiQueueManager(t);
            message = testApiExit.isOverridesCommon(t) ? (testUiQmgr != null ? Message.format((String)this.msgFile.getMessage(t, "UI.APIE.Msg.SeqInUseOverQMCommon"), (String)testApiExit.getName(t), (String)testUiQmgr.toString()) : Message.format((String)this.msgFile.getMessage(t, "UI.APIE.Msg.SeqInUseOverCommon"), (String)testApiExit.getName(t))) : Message.format((String)this.msgFile.getMessage(t, "UI.APIE.Msg.SeqInUseLocal"), (String)testApiExit.getName(t), (String)testUiQmgr.toString());
        }
        return message;
    }

    private String getMessageForNameAlreadyUsed(Trace t, ApiExit testApiExit) {
        String message = "";
        if (testApiExit.isCommon(t)) {
            message = this.msgFile.getMessage(t, "UI.APIE.Msg.NameInUseCommon");
        } else if (testApiExit.isTemplate(t)) {
            message = this.msgFile.getMessage(t, "UI.APIE.Msg.NameInUseTemplate");
        } else {
            UiQueueManager testUiQmgr = testApiExit.getOwningUiQueueManager(t);
            message = testApiExit.isOverridesCommon(t) ? (testUiQmgr != null ? Message.format((String)this.msgFile.getMessage(t, "UI.APIE.Msg.NameInUseOverQMCommon"), (String)testUiQmgr.toString()) : this.msgFile.getMessage(t, "UI.APIE.Msg.NameInUseOverCommon")) : Message.format((String)this.msgFile.getMessage(t, "UI.APIE.Msg.NameInUseLocal"), (String)testUiQmgr.toString());
        }
        return message;
    }

    private boolean isUnchangedOverride(Trace t) {
        boolean unchangedOverride = false;
        if ((this.dlgMode == 1 || this.dlgMode == 2 || this.dlgMode == 4) && this.isOverride && this.textModule.getText().compareTo(this.apiExit.getModule(t)) == 0 && this.textFunction.getText().compareTo(this.apiExit.getFunction(t)) == 0 && this.checkHasData.getSelection() == this.apiExit.hasData(t) && this.spinnerSequence.getSelection() == this.apiExit.getSequence(t)) {
            if (this.checkHasData.getSelection()) {
                if (this.textData.getText().compareTo(this.apiExit.getData(t)) == 0) {
                    unchangedOverride = true;
                }
            } else {
                unchangedOverride = true;
            }
        }
        return unchangedOverride;
    }

    private String getDialogTitle(Trace t) {
        String title;
        switch (this.dlgMode) {
            case 0: {
                title = this.msgFile.getMessage(t, "UI.APIE.Title.Add");
                break;
            }
            default: {
                title = this.isOverride ? Message.format((String)this.msgFile.getMessage(t, "UI.APIE.Title.Override"), (String)this.apiExit.getName(t), (String)this.uiQueueManager.toString()) : Message.format((String)this.msgFile.getMessage(t, "UI.APIE.Title.Normal"), (String)this.apiExit.getName(t));
            }
        }
        return title;
    }

    private void setDialogTitle(Trace t) {
        String title = this.getDialogTitle(t);
        this.updateTitle(t, title);
    }

    private boolean testIfApiExitOK(Trace t, ArrayList testArray) {
        boolean isOK = true;
        boolean testName = false;
        boolean testSequence = false;
        String message = "";
        if (!this.valid) {
            isOK = false;
            message = this.msgFile.getMessage(t, "UI.APIE.Msg.InvalidName");
        } else {
            int i = 0;
            while (i < testArray.size()) {
                ApiExit testApiExit = (ApiExit)testArray.get(i);
                int disposition = testApiExit.getDisposition();
                if (disposition != 2 && disposition != 5 && !testApiExit.equals(this.apiExit)) {
                    int testType;
                    if (this.dlgMode != 4 && this.dlgMode != 1 && this.dlgMode != 3 && !testApiExit.isOverridesCommon(t) && !this.apiExit.isOverridesCommon(t)) {
                        switch (this.apiExit.getType()) {
                            case 1: {
                                testName = testApiExit.getType() != 2;
                                break;
                            }
                            case 0: {
                                testName = true;
                                break;
                            }
                            case 2: {
                                testType = testApiExit.getType();
                                testName = testType == 0 || testType == 2 && this.uiQueueManager != null && testApiExit.getOwningUiQueueManager(t) == this.uiQueueManager;
                                break;
                            }
                            default: {
                                testName = false;
                            }
                        }
                        if (testName && testApiExit.getName(t).compareToIgnoreCase(this.textName.getText()) == 0) {
                            message = this.getMessageForNameAlreadyUsed(t, testApiExit);
                            isOK = false;
                            break;
                        }
                    }
                    if (testApiExit.getSequence(t) == this.spinnerSequence.getSelection() && ((this.dlgMode == 4 || this.dlgMode == 1 || this.dlgMode == 3) && testApiExit.getName(t).compareToIgnoreCase(this.textName.getText()) != 0 || this.dlgMode != 4 && this.dlgMode != 1 && this.dlgMode != 3)) {
                        switch (this.apiExit.getType()) {
                            case 1: {
                                testSequence = testApiExit.getType() != 2;
                                break;
                            }
                            case 0: {
                                testSequence = true;
                                break;
                            }
                            case 2: {
                                testType = testApiExit.getType();
                                testSequence = testType == 0 || testType == 2 && this.uiQueueManager != null && testApiExit.getOwningUiQueueManager(t) == this.uiQueueManager;
                                break;
                            }
                            default: {
                                testSequence = false;
                            }
                        }
                        if (testSequence) {
                            message = this.getMessageForSequenceAlreadyUsed(t, testApiExit);
                            isOK = false;
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        this.labelMsgText.setText(message);
        this.labelMsgText.setVisible(message.length() > 0);
        this.labelMsgIcon.setVisible(message.length() > 0);
        return isOK;
    }

    @Override
    public String getTitle(Trace t) {
        return this.getDialogTitle(t);
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyAPIXELocal);
    }

    @Override
    public String getHelpId(Trace t) {
        String helpId = null;
        helpId = this.dlgMode == 0 ? "com.ibm.mq.explorer.ui.infopop.UI_AddApiExitDialog" : "com.ibm.mq.explorer.ui.infopop.UI_EditApiExitDialog";
        return helpId;
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return false;
    }

    @Override
    public void packDialog(Trace t) {
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        boolean fEditable;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(this.msgFile.getMessage(t, "UI.APIE.Dialog.Name"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.textName = new Text(composite, 2048);
        this.textName.setText(this.apiExit.getName(t));
        this.textName.setTextLimit(48);
        boolean bl = fEditable = this.dlgMode == 0 || this.dlgMode == 2;
        if (!fEditable) {
            UiUtils.makeTextControlReadOnly(t, this.textName, false);
        }
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.textName.setLayoutData((Object)gridData);
        this.textName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Trace tr = Trace.getDefault();
                ApiExitEditDlg.this.valid = StringValidation.verifyMQObjectName(tr, e);
            }
        });
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                ApiExitEditDlg.this.nameValueChanged(tr);
            }
        });
        Group groupProps = new Group(composite, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        groupProps.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        groupProps.setLayout((Layout)gridLayout);
        label = new Label((Composite)groupProps, 0);
        label.setText(this.msgFile.getMessage(t, "UI.APIE.Dialog.Function"));
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.textFunction = new Text((Composite)groupProps, 2048);
        this.textFunction.setText(this.apiExit.getFunction(t));
        this.textFunction.setTextLimit(128);
        boolean bl2 = fEditable = this.dlgMode != 3;
        if (!fEditable) {
            UiUtils.makeTextControlReadOnly(t, this.textFunction, false);
        }
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        gridData.widthHint = 450;
        this.textFunction.setLayoutData((Object)gridData);
        this.textFunction.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                ApiExitEditDlg.this.functionValueChanged(tr);
            }
        });
        label = new Label((Composite)groupProps, 0);
        label.setText(this.msgFile.getMessage(t, "UI.APIE.Dialog.Module"));
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.textModule = new Text((Composite)groupProps, 2048);
        this.textModule.setText(this.apiExit.getModule(t));
        this.textModule.setTextLimit(259);
        boolean bl3 = fEditable = this.dlgMode != 3;
        if (!fEditable) {
            UiUtils.makeTextControlReadOnly(t, this.textModule, false);
        }
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        gridData.widthHint = 450;
        this.textModule.setLayoutData((Object)gridData);
        this.textModule.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                ApiExitEditDlg.this.moduleValueChanged(tr);
            }
        });
        label = new Label((Composite)groupProps, 0);
        label.setVisible(false);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonBrowse = new Button((Composite)groupProps, 8);
        this.buttonBrowse.setText(this.msgFile.getMessage(t, "UI.APIE.Button.Browse"));
        gridData = new GridData(128);
        this.buttonBrowse.setLayoutData((Object)gridData);
        this.buttonBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ApiExitEditDlg.this.browseSelected(tr);
            }
        });
        boolean hasData = this.apiExit.hasData(t);
        if (this.dlgMode == 0) {
            hasData = false;
        }
        this.checkHasData = new Button((Composite)groupProps, 32);
        this.checkHasData.setText(this.msgFile.getMessage(t, "UI.APIE.Dialog.Data"));
        this.checkHasData.setSelection(hasData);
        this.checkHasData.setEnabled(this.dlgMode != 3);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.checkHasData.setLayoutData((Object)gridData);
        this.checkHasData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                ApiExitEditDlg.this.checkHasDataSelected(tr);
            }
        });
        this.textData = new Text((Composite)groupProps, 2048);
        if (this.apiExit.hasData(t)) {
            this.textData.setText(this.apiExit.getData(t));
        }
        this.textData.setTextLimit(32);
        boolean bl4 = fEditable = this.dlgMode != 3 && this.checkHasData.getSelection();
        if (!fEditable) {
            UiUtils.makeTextControlReadOnly(t, this.textData, false);
        }
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.textData.setLayoutData((Object)gridData);
        this.textData.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                ApiExitEditDlg.this.dataValueChanged(tr);
            }
        });
        label = new Label((Composite)groupProps, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupProps, 0);
        label.setText(this.msgFile.getMessage(t, "UI.APIE.Dialog.SeqNo"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.spinnerSequence = new Spinner((Composite)groupProps, 2048);
        this.spinnerSequence.setMinimum(0);
        this.spinnerSequence.setMaximum(Short.MAX_VALUE);
        UiUtils.limitSpinner(t, this.spinnerSequence);
        this.spinnerSequence.setSelection(this.apiExit.getSequence(t));
        this.spinnerSequence.setEnabled(this.dlgMode != 3);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.spinnerSequence.setLayoutData((Object)gridData);
        this.spinnerSequence.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                ApiExitEditDlg.this.sequenceValueChanged(tr);
            }
        });
        if (this.showOverrideCheckbox) {
            this.checkOverride = new Button((Composite)groupProps, 32);
            this.checkOverride.setText(this.msgFile.getMessage(t, "UI.APIE.Dialog.Override"));
            this.checkOverride.setSelection(this.apiExit.isOverridesCommon(t));
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 4;
            this.checkOverride.setLayoutData((Object)gridData);
            this.checkOverride.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    ApiExitEditDlg.this.checkOverrideSelected(tr);
                }
            });
            if (this.dlgMode == 4) {
                this.isOverride = true;
                this.checkOverride.setSelection(true);
                this.checkOverride.setEnabled(false);
            }
        }
        Composite groupMsg = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 4;
        groupMsg.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        groupMsg.setLayout((Layout)gridLayout);
        this.labelMsgIcon = new Label(groupMsg, 1);
        this.labelMsgIcon.setVisible(false);
        this.labelMsgIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        gridData = new GridData(2);
        this.labelMsgIcon.setLayoutData((Object)gridData);
        this.labelMsgText = new Label(groupMsg, 64);
        this.labelMsgText.setVisible(false);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 70;
        this.labelMsgText.setLayoutData((Object)gridData);
        composite.pack();
        this.preferredSize = composite.getSize();
        this.textName.setFocus();
    }

    @Override
    public boolean okPressed(Trace t) {
        this.apiExit.setName(t, this.textName.getText());
        this.apiExit.setModule(t, this.textModule.getText());
        this.apiExit.setFunction(t, this.textFunction.getText());
        this.apiExit.setSequence(t, this.spinnerSequence.getSelection());
        if (this.checkHasData.getSelection()) {
            this.apiExit.setData(t, this.textData.getText());
        } else {
            this.apiExit.setData(t, null);
        }
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        boolean enableOK = true;
        enableOK = this.textName.getText().equals("") ? false : this.testIfApiExitOK(t, this.apiExitsArray);
        if (enableOK) {
            enableOK = this.testIfApiExitOK(t, this.pendingApiExitsArray);
        }
        if (this.isUnchangedOverride(t)) {
            enableOK = false;
        }
        return enableOK;
    }
}

