/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.apiexits;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;

public class ApiExit
extends RepeatingValueObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/apiexits/ApiExit.java";
    public static final int NUM_ATTRIBUTES = 6;
    public static final int API_EXIT_TYPE_COMMON = 0;
    public static final int API_EXIT_TYPE_TEMPLATE = 1;
    public static final int API_EXIT_TYPE_LOCAL = 2;
    private int type = 0;
    private static final int INDEX_NAME = 0;
    private static final int INDEX_FUNCTION = 2;
    private static final int INDEX_MODULE = 3;
    private static final int INDEX_SEQUENCE = 4;
    private static final int INDEX_DATA = 5;
    private static final int[] universalAttrIds = new int[]{30001, 30002, 30004, 30003, 30005, 30006};
    private static final int[] templateAttrIds = new int[]{10525, 10538, 10526, 10527, 10529, 10528};
    private static final int[] commonAttrIds = new int[]{10520, 10537, 10521, 10522, 10524, 10523};
    private static final int[] localAttrIds = new int[]{10141, 10149, 10142, 10143, 10145, 10144};
    private boolean originallyHadData = false;
    private ApiExit overriddenApiExit = null;
    private ArrayList<ApiExit> overridingApiExits = null;
    private UiQueueManager owningUiQueueManager = null;
    private String stringOverride = null;

    public ApiExit(Trace t, int exitType) {
        super(t);
        this.type = exitType;
        this.overridingApiExits = new ArrayList();
        switch (exitType) {
            case 1: {
                this.setImage(t, Icons.get(Icons.iconkeyAPIXETemplate));
                break;
            }
            case 0: {
                this.setImage(t, Icons.get(Icons.iconkeyAPIXECommon));
                break;
            }
            case 2: {
                this.setImage(t, Icons.get(Icons.iconkeyAPIXELocal));
            }
        }
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_API Exits");
        this.stringOverride = msgFile.getMessage(t, "UI.APIE.Object.Override");
    }

    public boolean isOriginallyHadData() {
        return this.originallyHadData;
    }

    public void setOriginallyHadData(boolean b) {
        this.originallyHadData = b;
    }

    public ApiExit getOverriddenApiExit(Trace t) {
        return this.overriddenApiExit;
    }

    public void setOverriddenApiExit(Trace t, ApiExit exit) {
        this.overriddenApiExit = exit;
    }

    public boolean isOverridesCommon(Trace t) {
        return this.overriddenApiExit != null;
    }

    public boolean isCommon(Trace t) {
        return this.type == 0;
    }

    public boolean isTemplate(Trace t) {
        return this.type == 1;
    }

    public boolean isLocal(Trace t) {
        return this.type == 2;
    }

    public void addOverridingApiExit(Trace t, ApiExit exit) {
        if (!this.overridingApiExits.contains(exit)) {
            this.overridingApiExits.add(exit);
            if (Trace.isTracing) {
                t.data(67, "ApiExit.addOverridingApiExit", 300, "override added");
            }
        }
    }

    public void removeOverridingApiExit(Trace t, ApiExit exit) {
        if (this.overridingApiExits.contains(exit)) {
            this.overridingApiExits.remove(exit);
            if (Trace.isTracing) {
                t.data(67, "ApiExit.removeOverridingApiExit", 300, "override removed");
            }
        }
    }

    public boolean isOverridingApiExit(Trace t, ApiExit exit) {
        boolean result = this.overridingApiExits.contains(exit);
        if (Trace.isTracing) {
            t.data(67, "ApiExit.isOverridingApiExit", 300, "result = " + result);
        }
        return result;
    }

    public boolean isOverridden(Trace t) {
        boolean result;
        boolean bl = result = this.overridingApiExits.size() > 0;
        if (Trace.isTracing) {
            t.data(67, "ApiExit.isOverridden", 300, "result = " + result);
        }
        return result;
    }

    public ArrayList getOverridingApiExits(Trace t) {
        return this.overridingApiExits;
    }

    public UiQueueManager getOwningUiQueueManager(Trace t) {
        return this.owningUiQueueManager;
    }

    public void setOwningUiQueueManager(Trace t, UiQueueManager manager) {
        this.owningUiQueueManager = manager;
    }

    public boolean isOverriddenForQueueManager(Trace t, UiQueueManager uiQmgr) {
        boolean overriddenByQmgr = false;
        if (this.isOverridden(t)) {
            int i = 0;
            while (i < this.overridingApiExits.size()) {
                ApiExit apiExit = this.overridingApiExits.get(i);
                if (apiExit.getOwningUiQueueManager(t).equals(uiQmgr)) {
                    overriddenByQmgr = true;
                    break;
                }
                ++i;
            }
        }
        if (Trace.isTracing) {
            t.data(67, "ApiExit.isOverriddenForQueueManager", 300, "result = " + overriddenByQmgr);
        }
        return overriddenByQmgr;
    }

    public static ApiExit loadApiExit(Trace t, DmObject dmObject, int rptIndex, int exitType, int idName, int idType, int idModule, int idFunction, int idSequence, int idData) {
        ApiExit apiExit = null;
        boolean valid = true;
        String strName = "";
        Attr attrName = null;
        String strType = "";
        Attr attrType = null;
        String strModule = "";
        Attr attrModule = null;
        String strFunction = "";
        Attr attrFunction = null;
        Integer intSequence = null;
        Attr attrSequence = null;
        attrName = dmObject.getAttribute(t, idName, rptIndex);
        if (attrName != null && !attrName.isGroupDefaultValuesUsed(t)) {
            strName = attrName.toString(t);
            if (Trace.isTracing) {
                t.data(67, "ApiExit.loadApiExit", 500, "getAttribute: repeatIndex=" + rptIndex + " attrId=" + idName + " value=" + attrName.toString(t));
            }
        } else {
            valid = false;
        }
        if (valid) {
            attrType = dmObject.getAttribute(t, idType, rptIndex);
            if (attrType != null && !attrType.isGroupDefaultValuesUsed(t)) {
                strType = attrType.toString(t);
                if (Trace.isTracing) {
                    t.data(67, "ApiExit.loadApiExit", 500, "getAttribute: repeatIndex=" + rptIndex + " attrId=" + idType + " value=" + attrType.toString(t));
                }
            } else {
                valid = false;
            }
        }
        if (valid) {
            attrModule = dmObject.getAttribute(t, idModule, rptIndex);
            if (attrModule != null && !attrModule.isGroupDefaultValuesUsed(t)) {
                strModule = attrModule.toString(t);
                if (Trace.isTracing) {
                    t.data(67, "ApiExit.loadApiExit", 500, "getAttribute: repeatIndex=" + rptIndex + " attrId=" + idModule + " value=" + attrModule.toString(t));
                }
            } else {
                valid = false;
            }
        }
        if (valid) {
            attrFunction = dmObject.getAttribute(t, idFunction, rptIndex);
            if (attrFunction != null && !attrFunction.isGroupDefaultValuesUsed(t)) {
                strFunction = attrFunction.toString(t);
                if (Trace.isTracing) {
                    t.data(67, "ApiExit.loadApiExit", 500, "getAttribute: repeatIndex=" + rptIndex + " attrId=" + idFunction + " value=" + attrFunction.toString(t));
                }
            } else {
                valid = false;
            }
        }
        if (valid) {
            attrSequence = dmObject.getAttribute(t, idSequence, rptIndex);
            if (attrSequence != null && !attrSequence.isGroupDefaultValuesUsed(t)) {
                Object objValue = attrSequence.getValue(t);
                if (objValue instanceof Integer) {
                    intSequence = (Integer)objValue;
                    if (Trace.isTracing) {
                        t.data(67, "ApiExit.loadApiExit", 500, "getAttribute: repeatIndex=" + rptIndex + " attrId=" + idSequence + " value=" + attrSequence.toString(t));
                    }
                } else {
                    valid = false;
                }
            } else {
                valid = false;
            }
        }
        if (valid) {
            apiExit = new ApiExit(t, exitType);
            apiExit.setAttribute(t, idName, attrName);
            apiExit.setAttributeValue(t, idName, strName);
            apiExit.setAttribute(t, idType, attrType);
            apiExit.setAttributeValue(t, idType, strType);
            apiExit.setAttribute(t, idModule, attrModule);
            apiExit.setAttributeValue(t, idModule, strModule);
            apiExit.setAttribute(t, idFunction, attrFunction);
            apiExit.setAttributeValue(t, idFunction, strFunction);
            apiExit.setAttribute(t, idSequence, attrSequence);
            apiExit.setAttributeValue(t, idSequence, intSequence);
            apiExit.setRepeatingIndex(rptIndex);
            Attr attrData = dmObject.getAttribute(t, idData, rptIndex);
            if (attrData != null && !attrData.isGroupDefaultValuesUsed(t) && !attrData.isDefaultValueUsed(t)) {
                String strData = attrData.toString(t);
                apiExit.setAttribute(t, idData, attrData);
                apiExit.setAttributeValue(t, idData, strData);
                apiExit.setOriginallyHadData(true);
                if (Trace.isTracing) {
                    t.data(67, "ApiExit.loadApiExit", 500, "getAttribute: repeatIndex=" + rptIndex + " attrId=" + idData + " value=" + attrData.toString(t));
                }
            } else {
                apiExit.setAttribute(t, idData, attrData);
                apiExit.setAttributeValue(t, idData, null);
                apiExit.setOriginallyHadData(false);
            }
            if (Trace.isTracing) {
                t.data(67, "ApiExit.loadApiExit", 500, "-------------------------");
            }
        }
        return apiExit;
    }

    @Override
    public String getName(Trace t) {
        int attrIdName = 0;
        attrIdName = this.type == 1 ? templateAttrIds[0] : (this.type == 0 ? commonAttrIds[0] : localAttrIds[0]);
        String name = (String)super.getAttributeValue(t, ApiExit.universalToActual(t, attrIdName, this.type));
        if (Trace.isTracing) {
            t.data(67, "ApiExit.getName", 300, "name = '" + name + "'");
        }
        return name;
    }

    public int getType() {
        return this.type;
    }

    public static int universalToActual(Trace t, int universalAttrId, int exitType) {
        int actualAttrId = 0;
        int index = -1;
        int i = 0;
        while (i < universalAttrIds.length) {
            if (universalAttrId == universalAttrIds[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            switch (exitType) {
                case 1: {
                    actualAttrId = templateAttrIds[index];
                    break;
                }
                case 0: {
                    actualAttrId = commonAttrIds[index];
                    break;
                }
                case 2: {
                    actualAttrId = localAttrIds[index];
                }
            }
        } else {
            actualAttrId = universalAttrId;
        }
        if (Trace.isTracing) {
            t.data(67, "ApiExit.universalToActual", 300, "mapped " + universalAttrId + " to " + actualAttrId);
        }
        return actualAttrId;
    }

    public static int actualToUniversal(Trace t, int actualAttrId, int exitType) {
        int universalAttrId = 0;
        int[] table = null;
        int index = -1;
        switch (exitType) {
            case 1: {
                table = templateAttrIds;
                break;
            }
            case 0: {
                table = commonAttrIds;
                break;
            }
            case 2: {
                table = localAttrIds;
            }
        }
        if (table != null) {
            int i = 0;
            while (i < table.length) {
                if (actualAttrId == table[i]) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        universalAttrId = index != -1 ? universalAttrIds[index] : actualAttrId;
        if (Trace.isTracing) {
            t.data(67, "ApiExit.actualToUniversal", 300, "mapped " + actualAttrId + " to " + universalAttrId);
        }
        return universalAttrId;
    }

    @Override
    public Object getAttributeValueForTable(Trace t, int attrId) {
        Object value = null;
        if (this.isOverridden(t) && (attrId == 30005 || attrId == 30003 || attrId == 30004 || attrId == 30006)) {
            boolean hideValue = false;
            int i = 0;
            while (i < this.overridingApiExits.size()) {
                ApiExit exit = this.overridingApiExits.get(i);
                if (exit.getDisposition() != 2 && exit.getDisposition() != 5 && exit.getDisposition() != 4) {
                    hideValue = true;
                    break;
                }
                ++i;
            }
            if (!hideValue) {
                value = super.getAttributeValue(t, ApiExit.universalToActual(t, attrId, this.type));
            }
        } else if (this.isOverridesCommon(t)) {
            if (attrId != 30001) {
                value = attrId == 30002 ? this.stringOverride : super.getAttributeValue(t, ApiExit.universalToActual(t, attrId, this.type));
            }
        } else {
            value = super.getAttributeValue(t, ApiExit.universalToActual(t, attrId, this.type));
        }
        return value;
    }

    @Override
    public Object getAttributeValue(Trace t, int attrId) {
        Object value = super.getAttributeValue(t, ApiExit.universalToActual(t, attrId, this.type));
        return value;
    }

    @Override
    public void setAttributeValue(Trace t, int attrId, Object value) {
        super.setAttributeValue(t, ApiExit.universalToActual(t, attrId, this.type), value);
    }

    @Override
    public Attr getAttribute(Trace t, int attrId) {
        Attr attr = super.getAttribute(t, ApiExit.universalToActual(t, attrId, this.type));
        return attr;
    }

    @Override
    public void setAttribute(Trace t, int attrId, Attr attr) {
        super.setAttribute(t, ApiExit.universalToActual(t, attrId, this.type), attr);
    }

    @Override
    public int[] getAttributeIds(Trace t) {
        int[] actualAttrIds = super.getAttributeIds(t);
        int[] univAttrIds = new int[actualAttrIds.length];
        int i = 0;
        while (i < actualAttrIds.length) {
            univAttrIds[i] = ApiExit.actualToUniversal(t, actualAttrIds[i], this.type);
            ++i;
        }
        return univAttrIds;
    }

    public Object getValue(Trace t, int index) {
        int attrId = 0;
        attrId = this.type == 1 ? templateAttrIds[index] : (this.type == 0 ? commonAttrIds[index] : localAttrIds[index]);
        Object value = this.getAttributeValue(t, attrId);
        return value;
    }

    public String getModule(Trace t) {
        Object value = this.getValue(t, 3);
        if (Trace.isTracing) {
            t.data(67, "ApiExit.getModule", 300, "module = '" + value + "'");
        }
        return value.toString();
    }

    public String getFunction(Trace t) {
        Object value = this.getValue(t, 2);
        if (Trace.isTracing) {
            t.data(67, "ApiExit.getFunction", 300, "function = '" + value + "'");
        }
        return value.toString();
    }

    public int getSequence(Trace t) {
        Object value = this.getValue(t, 4);
        if (Trace.isTracing) {
            t.data(67, "ApiExit.getSequence", 300, "sequence = '" + value + "'");
        }
        return (Integer)value;
    }

    public boolean hasData(Trace t) {
        return this.getValue(t, 5) != null;
    }

    public String getData(Trace t) {
        Object value = this.getValue(t, 5);
        if (Trace.isTracing) {
            if (value != null) {
                t.data(67, "ApiExit.getData", 300, "data = '" + value + "'");
            } else {
                t.data(67, "ApiExit.getData", 300, "ApiExit does not have data");
            }
        }
        return (String)value;
    }

    public void setValue(Trace t, int index, Object value) {
        int attrId = 0;
        attrId = this.type == 1 ? templateAttrIds[index] : (this.type == 0 ? commonAttrIds[index] : localAttrIds[index]);
        this.setAttributeValue(t, attrId, value);
    }

    public void setName(Trace t, String string) {
        this.setValue(t, 0, string);
    }

    public void setModule(Trace t, String string) {
        this.setValue(t, 3, string);
    }

    public void setFunction(Trace t, String string) {
        this.setValue(t, 2, string);
    }

    public void setSequence(Trace t, int i) {
        this.setValue(t, 4, i);
    }

    public void setData(Trace t, String string) {
        this.setValue(t, 5, string);
    }

    @Override
    public Image getImage(Trace t) {
        Image image = null;
        if (!this.isOverridesCommon(t)) {
            image = super.getImage(t);
        }
        return image;
    }
}

