/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.apiexits;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeNumber;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.objects.DmMachine;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.apiexits.ApiExit;
import com.ibm.mq.explorer.ui.internal.apiexits.ApiExitEditDlg;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.machine.UiMachine;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesCustomPropertyItemProvider;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesTableCompareColumnItems;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.widgets.Shell;

public class APIExitCustomItemProvider
extends RepeatingValuesCustomPropertyItemProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/apiexits/APIExitCustomItemProvider.java";
    private static final int NEW_SEQUENCE_DELTA = 100;
    private static final int[] supportedIds = new int[]{30001, 30002, 30003, 30004, 30005, 30006};
    private static final int OVERRIDE_BUTTON_ID = 1;
    private static final int[] additionalButtonIds = new int[]{1};
    private Message msgFile = null;
    private ArrayList<RepeatingValueObject> allApiExits = null;
    private int exitType = 1;
    private ArrayList<ApiExit> pendingApiExits = null;
    private ArrayList<ApiExit> addedToPendingApiExits = null;

    public APIExitCustomItemProvider(Trace t, UiMQObject uiMQObject, int type) {
        super(t, uiMQObject);
        this.exitType = type;
        this.addedToPendingApiExits = new ArrayList();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_API Exits");
    }

    @Override
    public String getObjectName(Trace t) {
        return this.msgFile.getMessage(t, "UI.APIE.Object.APIExit");
    }

    @Override
    public String getGroupBoxText(Trace t) {
        String text = null;
        switch (this.exitType) {
            case 1: {
                text = this.msgFile.getMessage(t, "UI.APIE.PropPage.Template");
                break;
            }
            case 0: {
                text = this.msgFile.getMessage(t, "UI.APIE.PropPage.Common");
                break;
            }
            case 2: {
                text = this.msgFile.getMessage(t, "UI.APIE.PropPage.Local");
            }
        }
        return text;
    }

    @Override
    public String getInformationAreaText(Trace t) {
        String text = null;
        switch (this.exitType) {
            case 1: {
                text = this.msgFile.getMessage(t, "UI.APIE.PropPage.SetupTemplate");
                break;
            }
            case 0: {
                text = this.msgFile.getMessage(t, "UI.APIE.PropPage.SetupCommon");
                break;
            }
            case 2: {
                text = this.msgFile.getMessage(t, "UI.APIE.PropPage.SetupLocal");
            }
        }
        return text;
    }

    @Override
    public int[] getAttributeIds(Trace t) {
        return supportedIds;
    }

    @Override
    public boolean isAttributeProcessed(Trace t, int actualAttrId) {
        boolean result = false;
        int universalAttrId = ApiExit.actualToUniversal(t, actualAttrId, this.exitType);
        int i = 0;
        while (i < supportedIds.length) {
            if (universalAttrId == supportedIds[i]) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public ArrayList<RepeatingValueObject> getRepeatingValueObjects(Trace t) {
        UiMachine uiMachine = UiPlugin.getUiMachineObject();
        this.allApiExits = uiMachine.getApiExitsArray(t);
        int i = 0;
        while (i < this.allApiExits.size()) {
            RepeatingValueObject rvObject = this.allApiExits.get(i);
            if (rvObject instanceof ApiExit) {
                ApiExit apiExit = (ApiExit)rvObject;
                int type = apiExit.getType();
                boolean show = false;
                switch (this.exitType) {
                    case 1: {
                        show = type == 1;
                        break;
                    }
                    case 0: {
                        show = type == 0;
                        break;
                    }
                    case 2: {
                        if (type == 0) {
                            show = true;
                            break;
                        }
                        if (type != 2 || apiExit.getOwningUiQueueManager(t) != this.getUiMQObject()) break;
                        show = true;
                    }
                }
                if (!show) {
                    apiExit.setDisposition(4);
                }
            }
            ++i;
        }
        return this.allApiExits;
    }

    @Override
    public RepeatingValueObject createRepeatingValueObject(Trace t) {
        ApiExit apiExit = new ApiExit(t, this.exitType);
        apiExit.setDisposition(1);
        int[] attrIds = this.getAttributeIds(t);
        int i = 0;
        while (i < attrIds.length) {
            AttrType attrType = this.getAttributeType(t, attrIds[i]);
            AttrString attr = null;
            int realAttrId = ApiExit.universalToActual(t, attrIds[i], apiExit.getType());
            switch (attrType.getAttributeType()) {
                case 2: {
                    attr = new AttrString(t, realAttrId, -1, attrType.getDefaultValue(t).toString(), (AttrTypeString)attrType, super.getDmObject());
                    break;
                }
                case 9: {
                    attr = new AttrString(t, realAttrId, -1, attrType.getDefaultValue(t).toString(), (AttrTypeString)attrType, super.getDmObject());
                    break;
                }
                case 1: {
                    Integer intValue = (Integer)((AttrTypeInt)attrType).getDefaultValue(t);
                    attr = new AttrInt(t, realAttrId, -1, intValue.intValue(), (AbstractAttrTypeNumber)((AttrTypeInt)attrType), super.getDmObject());
                    break;
                }
            }
            if (attr != null) {
                apiExit.setAttribute(t, attrIds[i], (Attr)attr);
                apiExit.setAttributeValue(t, attrIds[i], attrType.getDefaultValue(t));
            }
            ++i;
        }
        apiExit.setRepeatingIndex(-1);
        if (this.exitType == 2) {
            apiExit.setOwningUiQueueManager(t, (UiQueueManager)this.getUiMQObject());
        }
        int highest = 0;
        int i2 = 0;
        while (i2 < this.allApiExits.size()) {
            int seqNo;
            ApiExit exit;
            RepeatingValueObject rvObject = this.allApiExits.get(i2);
            if (rvObject instanceof ApiExit && (exit = (ApiExit)rvObject).getDisposition() != 5 && exit.getDisposition() != 2 && (seqNo = exit.getSequence(t)) > highest) {
                highest = seqNo;
            }
            ++i2;
        }
        if (this.pendingApiExits == null) {
            this.pendingApiExits = UiPlugin.getUiMachineObject().getPendingApiExits();
        }
        i2 = 0;
        while (i2 < this.pendingApiExits.size()) {
            int seqNo;
            ApiExit exit = this.pendingApiExits.get(i2);
            if (exit.getDisposition() != 5 && exit.getDisposition() != 2 && (seqNo = exit.getSequence(t)) > highest) {
                highest = seqNo;
            }
            ++i2;
        }
        apiExit.setSequence(t, highest + 100);
        return apiExit;
    }

    @Override
    public String getAttributeName(Trace t, int universalAttrId) {
        int actualAttrId = ApiExit.universalToActual(t, universalAttrId, this.exitType);
        String name = "";
        name = this.exitType == 2 ? DmQueueManager.getAttributeTitle((Trace)t, (int)actualAttrId) : DmMachine.getAttributeTitle((Trace)t, (int)actualAttrId);
        return name;
    }

    @Override
    public AttrType getAttributeType(Trace t, int universalAttrId) {
        int actualAttrId = ApiExit.universalToActual(t, universalAttrId, this.exitType);
        AttrType attrType = null;
        attrType = this.exitType == 2 ? DmQueueManager.getAttributeType((Trace)t, (int)actualAttrId) : DmMachine.getAttributeType((Trace)t, (int)actualAttrId);
        return attrType;
    }

    @Override
    public boolean enableEditButton(Trace t, RepeatingValueObject rvObject) {
        boolean result = false;
        if (rvObject != null && rvObject instanceof ApiExit) {
            ApiExit apiExit = (ApiExit)rvObject;
            result = apiExit.getType() == this.exitType;
        }
        return result;
    }

    @Override
    public boolean enableRemoveButton(Trace t, RepeatingValueObject rvObject) {
        boolean result = false;
        if (rvObject != null && rvObject instanceof ApiExit) {
            ApiExit apiExit = (ApiExit)rvObject;
            result = apiExit.getType() == this.exitType;
        }
        return result;
    }

    @Override
    public int[] getAdditionalButtonIds(Trace t) {
        int[] ids = null;
        if (this.exitType == 2) {
            ids = additionalButtonIds;
        }
        return ids;
    }

    @Override
    public String getAdditionalButtonText(Trace t, int id) {
        String text = null;
        if (id == 1) {
            text = this.msgFile.getMessage(t, "UI.APIE.Button.Override");
        }
        return text;
    }

    @Override
    public boolean enableAdditionalButton(Trace t, int id, RepeatingValueObject rvObject) {
        ApiExit apiExit;
        boolean result = false;
        if (id == 1 && rvObject instanceof ApiExit && (apiExit = (ApiExit)rvObject).isCommon(t) && !apiExit.isOverridden(t)) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean additionalButtonSelected(Trace t, Shell shell, int id, RepeatingValueObject rvObject) {
        boolean result = false;
        if (id == 1 && rvObject instanceof ApiExit) {
            ApiExit selectedApiExit = (ApiExit)rvObject;
            ApiExit newApiExit = (ApiExit)this.createRepeatingValueObject(t);
            int i = 0;
            while (i < supportedIds.length) {
                if (supportedIds[i] != 30002) {
                    Object value = selectedApiExit.getValue(t, i);
                    newApiExit.setValue(t, i, value);
                }
                ++i;
            }
            if (this.pendingApiExits == null) {
                this.pendingApiExits = UiPlugin.getUiMachineObject().getPendingApiExits();
            }
            ApiExitEditDlg editDlg = new ApiExitEditDlg(shell, 0);
            editDlg.setValues(t, newApiExit, this.allApiExits, this.pendingApiExits, 4, true, newApiExit.getOwningUiQueueManager(t));
            editDlg.create(t);
            if (editDlg.open(t)) {
                selectedApiExit.addOverridingApiExit(t, newApiExit);
                newApiExit.setOverriddenApiExit(t, selectedApiExit);
                this.allApiExits.add(newApiExit);
                result = true;
            }
            this.pendingApiExits.add(newApiExit);
            this.addedToPendingApiExits.add(newApiExit);
        }
        return result;
    }

    @Override
    public String getCheckboxText(Trace t) {
        return null;
    }

    @Override
    public boolean enableCheckbox(Trace t) {
        return false;
    }

    @Override
    public boolean checkboxSelected(Trace t, boolean selected) {
        return false;
    }

    @Override
    public boolean isAttributeOptional(Trace t, int attrId) {
        boolean result = false;
        if (attrId == 30006) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isAttributeOriginallyPresent(Trace t, int attrId, RepeatingValueObject object) {
        boolean result = false;
        if (attrId == 30006) {
            result = ((ApiExit)object).isOriginallyHadData();
        }
        return result;
    }

    @Override
    public boolean isCustomEditDialog(Trace t) {
        return true;
    }

    @Override
    public boolean editObject(Trace t, Shell shell, boolean isAdd, RepeatingValueObject object) {
        boolean result = false;
        if (object instanceof ApiExit) {
            ApiExit apiExit = (ApiExit)object;
            int editOp = 3;
            boolean showOverrideCheckbox = false;
            if (isAdd) {
                editOp = 0;
            } else {
                switch (this.exitType) {
                    case 1: {
                        if (!apiExit.isTemplate(t)) break;
                        editOp = 2;
                        break;
                    }
                    case 2: {
                        if (apiExit.isCommon(t)) {
                            if (apiExit.isOverridden(t)) {
                                if (apiExit.isOverriddenForQueueManager(t, (UiQueueManager)this.getUiMQObject())) break;
                                showOverrideCheckbox = true;
                                break;
                            }
                            showOverrideCheckbox = true;
                            break;
                        }
                        if (apiExit.isOverridesCommon(t)) {
                            editOp = 4;
                            showOverrideCheckbox = true;
                            break;
                        }
                        editOp = 2;
                        break;
                    }
                    default: {
                        editOp = apiExit.isOverridden(t) ? 1 : 2;
                    }
                }
            }
            ApiExitEditDlg editDlg = new ApiExitEditDlg(shell, 0);
            if (this.pendingApiExits == null) {
                this.pendingApiExits = UiPlugin.getUiMachineObject().getPendingApiExits();
            }
            editDlg.setValues(t, apiExit, this.allApiExits, this.pendingApiExits, editOp, showOverrideCheckbox, apiExit.getOwningUiQueueManager(t));
            editDlg.create(t);
            result = editDlg.open(t);
            if (result && isAdd) {
                this.pendingApiExits.add(apiExit);
                this.addedToPendingApiExits.add(apiExit);
            }
        }
        return result;
    }

    @Override
    public void objectRemoved(Trace t, RepeatingValueObject rvObject) {
        if (rvObject instanceof ApiExit) {
            ApiExit apiExit = (ApiExit)rvObject;
            if (apiExit.isOverridesCommon(t)) {
                ApiExit commonApiExit = apiExit.getOverriddenApiExit(t);
                commonApiExit.removeOverridingApiExit(t, apiExit);
            }
            if (this.pendingApiExits == null) {
                this.pendingApiExits = UiPlugin.getUiMachineObject().getPendingApiExits();
            }
            if (this.addedToPendingApiExits.contains(apiExit)) {
                this.pendingApiExits.remove(apiExit);
                this.addedToPendingApiExits.remove(apiExit);
            }
        }
    }

    @Override
    public boolean isSortVisibleList(Trace t) {
        return true;
    }

    public ArrayList sortVisibleList(Trace t, ArrayList objects, RepeatingValuesTableCompareColumnItems compareItems) {
        ArrayList<ApiExit> sortedObjects = new ArrayList<ApiExit>();
        ArrayList<ApiExit> sortObjects = new ArrayList<ApiExit>();
        int i = 0;
        while (i < objects.size()) {
            boolean add = true;
            ApiExit apiExit = (ApiExit)objects.get(i);
            if (apiExit.isOverridden(t)) {
                ArrayList overrides = apiExit.getOverridingApiExits(t);
                int j = 0;
                while (j < overrides.size()) {
                    ApiExit overrideApiExit = (ApiExit)overrides.get(j);
                    if (overrideApiExit.getDisposition() != 4 && overrideApiExit.getDisposition() != 5 && overrideApiExit.getDisposition() != 2) {
                        add = false;
                        break;
                    }
                    ++j;
                }
            }
            if (add) {
                sortObjects.add(apiExit);
            }
            ++i;
        }
        int count = sortObjects.size();
        Object[] objArray = new Object[count];
        objArray = sortObjects.toArray(objArray);
        Arrays.sort(objArray, compareItems);
        int i2 = 0;
        while (i2 < objArray.length) {
            ApiExit apiExit = (ApiExit)objArray[i2];
            if (apiExit.isOverridesCommon(t)) {
                ApiExit overriddenApiExit = apiExit.getOverriddenApiExit(t);
                sortedObjects.add(overriddenApiExit);
            }
            sortedObjects.add(apiExit);
            ++i2;
        }
        return sortedObjects;
    }

    @Override
    public boolean hideEditingButtons(Trace t) {
        return false;
    }

    @Override
    public String getAddHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_AddApiExitDialog";
    }

    @Override
    public String getEditHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_EditApiExitDialog";
    }

    @Override
    public void removePendingObjects(Trace t) {
        while (this.addedToPendingApiExits.size() > 0) {
            ApiExit apiExit = this.addedToPendingApiExits.get(0);
            this.pendingApiExits.remove(apiExit);
            this.addedToPendingApiExits.remove(apiExit);
        }
    }

    @Override
    public String getAddText(Trace t) {
        String text = null;
        if (this.exitType == 1) {
            text = this.msgFile.getMessage("UI.APIE.Button.Add");
        }
        return text;
    }

    @Override
    public String getEditText(Trace t) {
        String text = null;
        if (this.exitType == 1) {
            text = this.msgFile.getMessage("UI.APIE.Button.Edit");
        }
        return text;
    }

    @Override
    public String getRemoveText(Trace t) {
        String text = null;
        if (this.exitType == 1) {
            text = this.msgFile.getMessage("UI.APIE.Button.Remove");
        }
        return text;
    }
}

