/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.ConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.ConsoleDialog;
import com.ibm.mq.explorer.ui.internal.console.IConsoleDialogUser;
import com.ibm.mq.explorer.ui.internal.dialogs.TransferQMDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class TransferQMAction
implements IViewActionDelegate,
IConsoleDialogUser {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/actions/TransferQMAction.java";
    private Shell parent;

    public void run(IAction action) {
        TransferQMDialog dialog;
        Trace t = Trace.getDefault();
        if (this.parent == null) {
            this.parent = UiPlugin.getShell();
        }
        if ((dialog = new TransferQMDialog(t, this.parent)).open() == 0) {
            List<String> qmgrs = dialog.getSelectedQueueManagers();
            this.runSetmqmCommand(t, qmgrs);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
    }

    public void runSetmqmCommand(Trace t, List<String> qmgrs) {
        final ConsoleDialog consoleDialog = new ConsoleDialog(t, UiPlugin.getShell(), this);
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        consoleDialog.setTitle(msgFile.getMessage("UI.TransferQM.Action.Title"));
        String instName = CommonServices.getInstallationName((Trace)t);
        final ArrayList<ConsoleCommand> commandList = new ArrayList<ConsoleCommand>();
        for (String qmName : qmgrs) {
            String command = "setmqm -m " + qmName + " -n " + instName;
            if (Trace.isTracing) {
                t.data(67, "TransferQMAction.runSetmqmCommand", 300, "Invoking command: " + command);
            }
            String title = msgFile.getMessage("UI.TransferQM.Action.Progress", qmName);
            ConsoleCommand c = new ConsoleCommand(title, command);
            c.addExitValue(0);
            commandList.add(c);
        }
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace tr = Trace.getDefault();
                consoleDialog.execute(tr, commandList);
            }
        });
    }

    @Override
    public void finished(Trace t, int id, boolean result) {
        if (result) {
            UiPlugin.asyncRefreshAllViews(t, "com.ibm.mq.explorer.queuemanager", true);
        }
    }

    public void setParentShell(Shell shell) {
        this.parent = shell;
    }
}

