/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Shell;

public class MultipleSelectionAction
extends Action {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/actions/MultipleSelectionAction.java";
    private List<IAction> actionList;

    public MultipleSelectionAction(List<IAction> actionList) {
        this.actionList = actionList;
    }

    public void run() {
        for (IAction action : this.actionList) {
            action.run();
        }
    }

    public static void createMultipleSelectionEntries(Trace t, Shell shell, IMenuManager manager, List<TreeNode> treeNodeList) {
        if (!MultipleSelectionAction.isMultipleSelectionApplicable(treeNodeList)) {
            return;
        }
        HashMap<TreeNode, List<IAction>> actionMap = new HashMap<TreeNode, List<IAction>>();
        List<IContributionItem> firstItems = null;
        for (TreeNode treeNode : treeNodeList) {
            List<IContributionItem> items = MultipleSelectionAction.getItemListForTreeNode(shell, treeNode);
            if (firstItems == null) {
                firstItems = items;
            }
            actionMap.put(treeNode, MultipleSelectionAction.getActionListFromItems(items));
        }
        for (IContributionItem item : firstItems) {
            if (item instanceof ActionContributionItem) {
                ActionContributionItem aci = (ActionContributionItem)item;
                IAction action = MultipleSelectionAction.replaceWithMultiOrDisabled(aci.getAction(), treeNodeList, actionMap);
                manager.add((IContributionItem)new ActionContributionItem(action));
                continue;
            }
            if (item instanceof MenuManager) {
                MenuManager submenu = (MenuManager)item;
                MenuManager replacement = new MenuManager(submenu.getMenuText(), submenu.getId());
                IContributionItem[] subitems = submenu.getItems();
                int j = 0;
                while (j < subitems.length) {
                    IContributionItem subItem = subitems[j];
                    if (subItem instanceof ActionContributionItem) {
                        ActionContributionItem aci = (ActionContributionItem)subItem;
                        IAction action = MultipleSelectionAction.replaceWithMultiOrDisabled(aci.getAction(), treeNodeList, actionMap);
                        subItem = new ActionContributionItem(action);
                    }
                    replacement.add(subItem);
                    ++j;
                }
                manager.add((IContributionItem)replacement);
                continue;
            }
            manager.add(item);
        }
    }

    private static boolean isMultipleSelectionApplicable(List<TreeNode> nodes) {
        Class<?> nodeType = null;
        for (TreeNode treeNode : nodes) {
            if (nodeType == null) {
                nodeType = ((Object)((Object)treeNode)).getClass();
                continue;
            }
            if (nodeType == ((Object)((Object)treeNode)).getClass()) continue;
            return false;
        }
        return true;
    }

    private static List<IContributionItem> getItemListForTreeNode(Shell shell, TreeNode node) {
        MenuManager mm = new MenuManager();
        if (node.isContextMenuFromUiObject()) {
            MQExtObject extObj = (MQExtObject)node.getObject();
            if (extObj != null) {
                UiMQObject uiMQObject = (UiMQObject)extObj.getInternalObject();
                uiMQObject.appendToContextMenu(shell, (IMenuManager)mm, node.getTreeNodeId());
            }
        } else {
            node.addCommonChoicesToContextMenu(Trace.getDefault(), shell, (IMenuManager)mm, node.getTreeNodeId());
            node.appendToContextMenu(shell, (IMenuManager)mm);
        }
        return Arrays.asList(mm.getItems());
    }

    private static List<IAction> getActionListFromItems(List<IContributionItem> items) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        for (IContributionItem item : items) {
            if (item instanceof ActionContributionItem) {
                ActionContributionItem aci = (ActionContributionItem)item;
                actions.add(aci.getAction());
                continue;
            }
            if (!(item instanceof MenuManager)) continue;
            MenuManager submenu = (MenuManager)item;
            IContributionItem[] subitems = submenu.getItems();
            int j = 0;
            while (j < subitems.length) {
                IContributionItem subItem = subitems[j];
                if (subItem instanceof ActionContributionItem) {
                    ActionContributionItem aci = (ActionContributionItem)subItem;
                    actions.add(aci.getAction());
                }
                ++j;
            }
        }
        return actions;
    }

    private static List<IAction> getMatchingActions(IAction match, List<TreeNode> treeNodeList, Map<TreeNode, List<IAction>> actionMap) {
        String matchText = match.getText();
        ArrayList<IAction> matchList = new ArrayList<IAction>();
        for (TreeNode node : treeNodeList) {
            List<IAction> actions = actionMap.get((Object)node);
            for (IAction action : actions) {
                if (!action.getText().equals(matchText) || action.getClass() != match.getClass()) continue;
                matchList.add(action);
            }
        }
        return matchList;
    }

    private static IAction replaceWithMultiOrDisabled(IAction action, List<TreeNode> treeNodeList, Map<TreeNode, List<IAction>> actionMap) {
        List<IAction> matchList;
        if (!action.getText().endsWith("...") && action.getStyle() != 2 && action.getStyle() != 8 && (matchList = MultipleSelectionAction.getMatchingActions(action, treeNodeList, actionMap)).size() == actionMap.size()) {
            MultipleSelectionAction multiAction = new MultipleSelectionAction(matchList);
            multiAction.setText(action.getText());
            multiAction.setToolTipText(action.getToolTipText());
            multiAction.setAccelerator(action.getAccelerator());
            multiAction.setActionDefinitionId(action.getActionDefinitionId());
            multiAction.setImageDescriptor(action.getImageDescriptor());
            return multiAction;
        }
        Action disabled = new Action(){};
        disabled.setEnabled(false);
        disabled.setText(action.getText());
        disabled.setToolTipText(action.getToolTipText());
        disabled.setDisabledImageDescriptor(action.getDisabledImageDescriptor());
        return disabled;
    }
}

