/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class DeleteObjectAction
implements IViewActionDelegate {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/actions/DeleteObjectAction.java";
    private IStructuredSelection structuredSelection = null;

    public void run(IAction action) {
        Trace t = Trace.getDefault();
        if (this.structuredSelection != null) {
            DeleteObjectAction.deleteSelectedObjects(t, this.structuredSelection);
        }
    }

    public static void deleteSelectedObjects(Trace t, IStructuredSelection structuredSelection) {
        final List<UiMQObject> nodes = DeleteObjectAction.getObjectsFromSelection(structuredSelection);
        if (nodes.size() > 0) {
            String msg;
            int rc = 1;
            Shell shell = UiPlugin.getShell();
            if (nodes.size() == 1) {
                msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4002", (String)nodes.get(0).toString());
                rc = MessageBox.showDeleteCancelMessage(t, shell, msg, 1, "AMQ4002");
            } else {
                msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4545", (String)("" + nodes.size()));
                rc = MessageBox.showDeleteCancelMessage(t, shell, msg, 1, "AMQ4545");
            }
            if (rc == 0) {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                try {
                    progressService.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            Trace t2 = Trace.getDefault();
                            int total = nodes.size();
                            int count = 1;
                            Message msg = UiPlugin.getUIMessages(t2, "KEY_General");
                            String taskName = msg.getMessage("UI.Delete.Multi.Text");
                            monitor.beginTask(taskName, total);
                            for (UiMQObject uiobj : nodes) {
                                String subtaskName = msg.getMessage(t2, "UI.Delete.Subtask.Text", String.valueOf(count), String.valueOf(total), uiobj.toString());
                                monitor.subTask(subtaskName);
                                ++count;
                                final UiMQObject uimqobj = uiobj;
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        uimqobj.deleteMenuAction(Trace.getDefault());
                                    }
                                });
                                monitor.worked(1);
                                if (monitor.isCanceled()) break;
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    UiPlugin.logException(e);
                }
                catch (InterruptedException e) {
                    UiPlugin.logException(e);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            this.structuredSelection = (IStructuredSelection)selection;
        }
    }

    public void init(IViewPart view) {
    }

    private static List<UiMQObject> getObjectsFromSelection(IStructuredSelection selection) {
        ArrayList<UiMQObject> objects = new ArrayList<UiMQObject>();
        for (Object obj : selection.toList()) {
            UiMQObject uiobj;
            Object intObj;
            Object treeNodeObj;
            MQExtObject mqExt = null;
            if (obj instanceof MQExtObject) {
                mqExt = (MQExtObject)obj;
            } else if (obj instanceof TreeNode && (treeNodeObj = ((TreeNode)((Object)obj)).getObject()) instanceof MQExtObject) {
                mqExt = (MQExtObject)treeNodeObj;
            }
            if (mqExt == null || !((intObj = mqExt.getInternalObject()) instanceof UiMQObject) || !(uiobj = (UiMQObject)intObj).isSupportDelete()) continue;
            objects.add(uiobj);
        }
        return objects;
    }
}

