/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.extensions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.base.ActionFilterManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.navigator.TreeNodeBase;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionFilter;

public abstract class TreeNode
extends TreeNodeBase
implements IActionFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/extensions/TreeNode.java";
    public static final int ADVANCED_COMPLEXITY_THRESHOLD = 6;
    public static final int SIMPLE_COMPLEXITY = 0;
    public static final int QSG_COMPLEXITY = 5;
    public static final int COMPLEX_COMPLEXITY = 10;

    public TreeNode(TreeNode parent, MQExtObject object, String plugin_id) {
        super(parent, object, plugin_id);
        super.setOwningTreeNode(this);
    }

    public abstract String toString();

    public abstract String getId();

    public abstract String getSequence();

    public abstract String getContentPageId();

    public abstract String getHelpId();

    public abstract Image getIcon();

    public abstract int compare(TreeNode var1, TreeNode var2);

    public abstract boolean isContextMenuFromUiObject();

    public void appendToContextMenu(Shell shell, IMenuManager manager) {
    }

    public abstract boolean isAddChildrenWhenExpanded();

    public void removeFromNavigatorView() {
        TreeNode parent = this.getParent();
        parent.removeChildFromNode(this);
    }

    public boolean testAttribute(Object target, String name, String value) {
        boolean result;
        Trace t;
        block41: {
            t = Trace.getDefault();
            result = false;
            String objectName = "";
            Object obj = this.getObject();
            if (obj != null) {
                objectName = obj.toString();
            }
            if (name.compareTo("PluginEnabled") == 0) {
                result = UiPlugin.isPluginEnabled(value);
            } else if (name.compareTo("ObjectNameEquals") == 0) {
                result = objectName.compareTo(value) == 0;
            } else if (name.compareTo("ObjectNameStartsWith") == 0) {
                result = objectName.startsWith(value);
            } else if (name.compareTo("ObjectNameEndsWith") == 0) {
                result = objectName.endsWith(value);
            } else if (name.compareTo("ObjectNameContains") == 0) {
                result = objectName.indexOf(value) != -1;
            } else {
                if (name.compareTo("ObjectNameMatches") == 0) {
                    try {
                        result = objectName.matches(value);
                    }
                    catch (PatternSyntaxException e) {
                        result = false;
                        if (Trace.isTracing) {
                            t.data(67, "TreeNode.testAttribute", 300, "PatternSyntaxException generated:");
                            t.data(67, "TreeNode.testAttribute", 300, e.getMessage());
                        }
                        break block41;
                    }
                }
                if (name.compareTo("TreeNodeId") == 0) {
                    result = this.getTreeNodeId().compareTo(value) == 0;
                } else if (name.compareTo("TreeNodePrefix") == 0) {
                    result = this.getTreeNodeId().startsWith(value);
                } else if (name.compareTo("InstallType") == 0) {
                    int mqInstallType = CommonServices.getMqInstallType();
                    if (value.compareTo("Server") == 0) {
                        result = mqInstallType == 1;
                    } else if (value.compareTo("Client") == 0) {
                        result = mqInstallType == 2;
                    } else if (value.compareTo("Java") == 0) {
                        result = mqInstallType == 3;
                    }
                } else if (name.compareTo("AnyHiddenQM") == 0) {
                    UiQueueManager[] qmArraytest = UiPlugin.getHiddenUiQueueManagers(t);
                    boolean hid = false;
                    if (qmArraytest.length != 0) {
                        hid = true;
                    }
                    result = value.equalsIgnoreCase("true") ? hid : !hid;
                } else {
                    MQExtObject mqExtObject = (MQExtObject)this.getObject();
                    if (mqExtObject != null) {
                        MQQmgrExtObject qmgrExtObject = this.getMQQmgrExtObject(t, mqExtObject);
                        if (qmgrExtObject != null) {
                            UiQueueManager uiQueueManager = (UiQueueManager)qmgrExtObject.getInstanceId();
                            int iResult = uiQueueManager.testQmgrAttribute(t, uiQueueManager, name, value);
                            switch (iResult) {
                                case 1: {
                                    result = true;
                                    break;
                                }
                                case 0: {
                                    result = false;
                                    break;
                                }
                                default: {
                                    if (this.isContextMenuFromUiObject()) {
                                        result = mqExtObject.testAttribute(target, name, value);
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                        } else if (this.isContextMenuFromUiObject()) {
                            result = mqExtObject.testAttribute(target, name, value);
                        }
                    }
                }
            }
        }
        if (!result) {
            if (Trace.isTracing) {
                t.data(67, "TreeNode.testAttribute", 300, "testing external IActionFilters");
            }
            ActionFilterManager filterMan = UiPlugin.getActionFilterManager();
            ArrayList filters = filterMan.getTreeNodeFilters(t);
            for (IActionFilter f : filters) {
                result = f.testAttribute(target, name, value);
                if (result) break;
            }
        }
        return result;
    }

    private MQQmgrExtObject getMQQmgrExtObject(Trace t, MQExtObject mqExtObject) {
        MQQmgrExtObject mqQmgrExtObject = null;
        MQExtObject testObject = mqExtObject;
        do {
            if (!(testObject instanceof MQQmgrExtObject)) continue;
            mqQmgrExtObject = (MQQmgrExtObject)testObject;
            break;
        } while ((testObject = testObject.getParent()) != null);
        if (Trace.isTracing) {
            t.data(67, "TreeNode.getMQQmgrExtObject", 300, "returning " + mqQmgrExtObject);
        }
        return mqQmgrExtObject;
    }

    public static boolean isPluginEnabled(String plugin_id) {
        return UiPlugin.isPluginEnabled(plugin_id);
    }

    @Override
    public void addChildToNode(TreeNode child, int complex) {
        super.addChildToNode(child, complex);
    }

    @Override
    public void removeChildFromNode(TreeNode child) {
        super.removeChildFromNode(child);
    }

    @Override
    public TreeNode getParent() {
        return super.getParent();
    }

    public TreeNode getRealParent() {
        return super.getRealParent(Trace.getDefault());
    }

    @Override
    public void setParent(TreeNode newParent) {
        super.setParent(newParent);
    }

    public TreeNode[] getVisibleChildren() {
        return super.getChildren();
    }

    @Override
    public TreeNode[] getChildren() {
        return super.getRealChildren();
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren();
    }

    @Override
    public Object getObject() {
        return super.getObject();
    }

    @Override
    public void setComplexity(int complex) {
        super.setComplexity(complex);
    }

    @Override
    public int getComplexity() {
        return super.getComplexity();
    }

    public static int compareBySequence(TreeNode child1, TreeNode child2) {
        return TreeNodeBase.compareBySequence(child1, child2);
    }

    public static int compareByName(TreeNode child1, TreeNode child2) {
        return TreeNodeBase.compareByName(child1, child2);
    }

    @Override
    public void setVisible(boolean isVis) {
        super.setVisible(isVis);
    }

    public void setChildrenVisibility(boolean visible) {
        super.setChildrenVisibility(Trace.getDefault(), visible);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public boolean isChildExist(String childId) {
        return super.isChildExist(childId);
    }

    @Override
    public String getTreeNodeId() {
        return super.getTreeNodeId();
    }

    @Override
    public String getPlugin_id() {
        return super.getPlugin_id();
    }

    @Override
    public void setPlugin_id(String string) {
        super.setPlugin_id(string);
    }

    @Override
    public boolean isExpanded() {
        return super.isExpanded();
    }

    @Override
    public boolean isAdvancedTreeNode() {
        return super.isAdvancedTreeNode();
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public void updateItem() {
        super.updateItem();
    }

    @Override
    public File createDragDropFile() {
        return super.createDragDropFile();
    }
}

