/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.extensions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.QueueManagerConnectionException;
import com.ibm.mq.explorer.ui.internal.base.IRemoteQmgrConnection;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.net.URL;
import java.util.Hashtable;

public class QueueManagerConnections {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/extensions/QueueManagerConnections.java";
    public static final String OPTIONS_REFRESH_INTERVAL = "refreshInterval";
    public static final String OPTIONS_AUTORECONNECT = "autoReconnect";
    public static final String OPTIONS_SHOW_DIALOGS_ON_ERROR = "showDialogsOnError";
    public static final String CONN_OPTIONS_SECURITY_EXIT = "channelSecurityExit";
    public static final String CONN_OPTIONS_SECURITY_EXIT_USER_DATA = "channelSecurityExitUserData";
    public static final String CONN_OPTIONS_EXIT_CLASSPATH = "exitClasspath";
    public static final String CONN_OPTIONS_USER_ID = "userID";
    public static final String CONN_OPTIONS_PASSWORD = "password";
    public static final String CONN_OPTIONS_SSL_CIPHER_SUITE = "SSL Cipher Suite";
    public static final String CONN_OPTIONS_SSL_PEER_NAME = "SSL Peer Name";
    public static final String CONN_OPTIONS_SSL_RESET_COUNT = "KeyResetCount";
    public static final String CONN_OPTIONS_SSL_TRUSTED_STORE = "sslTrustedStore";
    public static final String CONN_OPTIONS_SSL_TRUSTED_STORE_PW = "sslTrustedStorePw";
    public static final String CONN_OPTIONS_SSL_PERSONAL_STORE = "sslPersonalStore";
    public static final String CONN_OPTIONS_SSL_PERSONAL_STORE_PW = "sslPersonalStorePw";
    private static final int CONNECTION_TYPE_UNKNOWN = 0;
    private static final int CONNECTION_TYPE_CLIENT = 2;
    private static final int CONNECTION_TYPE_CLIENT_MULTI_INSTANCE = 5;
    private static final int CONNECTION_TYPE_CDT = 4;
    private static final int CONNECTION_TYPE_VIA = 3;
    private int connectionType = 0;
    private String qmgrName = null;
    private URL channelDefTable = null;
    private String connectionName = null;
    private String[] connectionNames = null;
    private String channelName = null;
    private MQQmgrExtObject existingQmgr = null;
    private String targetQmgr = null;
    private String targetQueue = null;
    private Hashtable<String, ?> explorerOptions = null;
    private Hashtable<String, ?> connectionOptions = null;
    private IRemoteQmgrConnection remoteQmgrConnection = null;

    public QueueManagerConnections(String qmName, URL chanDefTable, Hashtable<String, ?> connOptions, Hashtable<String, ?> options) {
        this.connectionType = 4;
        this.qmgrName = qmName;
        this.channelDefTable = chanDefTable;
        this.connectionOptions = connOptions;
        this.explorerOptions = options;
        if (this.remoteQmgrConnection == null) {
            this.remoteQmgrConnection = UiPlugin.getRemoteQmgrConnection();
        }
    }

    public QueueManagerConnections(String qmName, String connName, String chlName, Hashtable<String, ?> connOptions, Hashtable<String, ?> options) {
        this.connectionType = 2;
        this.qmgrName = qmName;
        this.connectionName = connName;
        this.channelName = chlName;
        this.connectionOptions = connOptions;
        this.explorerOptions = options;
        if (this.remoteQmgrConnection == null) {
            this.remoteQmgrConnection = UiPlugin.getRemoteQmgrConnection();
        }
    }

    public QueueManagerConnections(String qmName, String[] connNames, String chlName, Hashtable<String, ?> connOptions, Hashtable<String, ?> options) {
        this.connectionType = 5;
        this.qmgrName = qmName;
        this.channelName = chlName;
        this.connectionOptions = connOptions;
        this.explorerOptions = options;
        this.connectionNames = new String[connNames.length];
        int i = 0;
        while (i < connNames.length) {
            this.connectionNames[i] = connNames[i];
            ++i;
        }
        if (this.remoteQmgrConnection == null) {
            this.remoteQmgrConnection = UiPlugin.getRemoteQmgrConnection();
        }
    }

    public QueueManagerConnections(MQQmgrExtObject existingQM, String targetQ, String targetQM, Hashtable<String, ?> options) {
        this.connectionType = 3;
        this.existingQmgr = existingQM;
        this.targetQueue = targetQ;
        this.targetQmgr = targetQM;
        this.explorerOptions = options;
        if (this.remoteQmgrConnection == null) {
            this.remoteQmgrConnection = UiPlugin.getRemoteQmgrConnection();
        }
    }

    public MQQmgrExtObject connect() throws QueueManagerConnectionException {
        Trace t = Trace.getDefault();
        MQQmgrExtObject mqQmgrExtObject = null;
        if (this.remoteQmgrConnection == null) {
            String msgId = "AMQ4859";
            String msgText = CommonServices.getSystemMessage((String)msgId);
            QueueManagerConnectionException e = new QueueManagerConnectionException(msgText, msgId, 2, 50053);
            if (Trace.isTracing) {
                t.data(67, "QueueManagerConnections.connect", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
                t.data(67, "QueueManagerConnections.connect", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
            }
            throw e;
        }
        switch (this.connectionType) {
            case 4: {
                mqQmgrExtObject = this.remoteQmgrConnection.addRemoteQueueManager(t, this.qmgrName, this.channelDefTable, this.connectionOptions, this.explorerOptions);
                break;
            }
            case 2: {
                mqQmgrExtObject = this.remoteQmgrConnection.addRemoteQueueManager(t, this.qmgrName, this.connectionName, this.channelName, this.connectionOptions, this.explorerOptions);
                break;
            }
            case 3: {
                mqQmgrExtObject = this.remoteQmgrConnection.addRemoteQueueManager(t, this.existingQmgr, this.targetQueue, this.targetQmgr, this.explorerOptions);
                break;
            }
            default: {
                String msgId = "AMQ4859";
                String msgText = CommonServices.getSystemMessage((String)msgId);
                QueueManagerConnectionException e = new QueueManagerConnectionException(msgText, msgId, 2, 50999);
                if (Trace.isTracing) {
                    t.data(67, "QueueManagerConnections.connect", 900, "throwing QueueManagerConnectionException: " + e.getLocalizedMessage());
                    t.data(67, "QueueManagerConnections.connect", 900, "cc = " + e.getCompCode() + "  rc = " + e.getReasonCode());
                }
                throw e;
            }
        }
        return mqQmgrExtObject;
    }

    public static boolean isFIPSEnabled() {
        return UiPlugin.isFIPSEnabled();
    }

    public static MQQmgrExtObject[] getExistingQueueManagers() {
        return UiPlugin.getKnownQueueManagers(Trace.getDefault());
    }

    public static boolean isQueueManagerVisible(MQQmgrExtObject mqQmgrExtObject) {
        return UiPlugin.isQueueManagerVisible(Trace.getDefault(), mqQmgrExtObject);
    }

    public static boolean isQueueManagerConnected(MQQmgrExtObject mqQmgrExtObject) {
        return UiPlugin.isQueueManagerConnected(Trace.getDefault(), mqQmgrExtObject);
    }

    public static boolean isQueueManagerLocal(MQQmgrExtObject mqQmgrExtObject) {
        return UiPlugin.isQueueManagerLocal(Trace.getDefault(), mqQmgrExtObject);
    }

    public static boolean removeRemoteQueueManager(MQQmgrExtObject mqQmgrExtObject) throws QueueManagerConnectionException {
        return UiPlugin.removeRemoteQueueManager(Trace.getDefault(), mqQmgrExtObject);
    }
}

