/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.extensions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.IMQExtObjectChangedListener;
import com.ibm.mq.explorer.ui.extensions.IMQExtObjectDeletedListener;
import com.ibm.mq.explorer.ui.extensions.MQExtObjectChangedEvent;
import com.ibm.mq.explorer.ui.extensions.MQExtObjectDeletedEvent;
import com.ibm.mq.explorer.ui.internal.base.ActionFilterManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.MQExtObjectBase;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import org.eclipse.ui.IActionFilter;

public class MQExtObject
extends MQExtObjectBase {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/extensions/MQExtObject.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String VERSION = "1.0";
    private String objectName = null;
    private String objectId = null;
    private String mqType = null;
    private Object instanceId = null;
    private Object instanceData = null;
    private MQExtObject parent = null;
    private Vector<IMQExtObjectChangedListener> objectChangedListeners = new Vector();
    private Vector<IMQExtObjectDeletedListener> objectDeletedListeners = new Vector();

    public MQExtObject() {
    }

    public MQExtObject(MQExtObject parentObj, Object obj, String type, String objId, String objName) {
        this.objectName = objName;
        this.objectId = objId;
        this.mqType = type;
        this.instanceId = obj;
        this.parent = parentObj;
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (name.compareTo("PluginEnabled") == 0) {
            result = UiPlugin.isPluginEnabled(value);
        } else if (name.compareTo("ObjectNameEquals") == 0) {
            result = this.objectName.compareTo(value) == 0;
        } else if (name.compareTo("ObjectNameStartsWith") == 0) {
            result = this.objectName.startsWith(value);
        } else if (name.compareTo("ObjectNameEndsWith") == 0) {
            result = this.objectName.endsWith(value);
        } else if (name.compareTo("ObjectNameContains") == 0) {
            result = this.objectName.indexOf(value) != -1;
        } else if (name.compareTo("ObjectNameMatches") == 0) {
            try {
                result = this.objectName.matches(value);
            }
            catch (PatternSyntaxException e) {
                result = false;
                if (Trace.isTracing) {
                    t.data(67, "MQExtObject.testAttribute", 300, "PatternSyntaxException generated:");
                    t.data(67, "MQExtObject.testAttribute", 300, e.getMessage());
                }
            }
        } else if (name.compareTo("ObjectType") == 0) {
            result = value.compareTo(this.getMqType()) == 0;
        } else {
            Object obj = this.getInternalObject();
            if (obj instanceof UiMQObject) {
                result = ((UiMQObject)obj).testAttribute(target, name, value);
            }
        }
        if (!result) {
            if (Trace.isTracing) {
                t.data(67, "MQExtObject.testAttribute", 300, "testing external IActionFilters");
            }
            ActionFilterManager filterMan = UiPlugin.getActionFilterManager();
            ArrayList filters = filterMan.getMQExtObjectFilters(t);
            for (IActionFilter f : filters) {
                result = f.testAttribute(target, name, value);
                if (result) break;
            }
        }
        return result;
    }

    public Object getInstanceId() {
        return this.instanceId;
    }

    public Object getInternalObject() {
        return this.instanceId;
    }

    public void setInternalObject(Object object) {
        this.instanceId = object;
    }

    public Object getInternalDataObject() {
        return this.instanceData;
    }

    public void setInternalDataObject(Object object) {
        this.instanceData = object;
    }

    public String getMqType() {
        return this.mqType;
    }

    public void setName(String name) {
        this.objectName = name;
    }

    public String getName() {
        return this.objectName;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public MQExtObject getParent() {
        return this.parent;
    }

    public void objectChanged() {
        MQExtObjectChangedEvent event = new MQExtObjectChangedEvent(this);
        int size = this.objectChangedListeners.size();
        int i = 0;
        while (i < size) {
            IMQExtObjectChangedListener listener = this.objectChangedListeners.elementAt(i);
            listener.mqExtObjectChanged(event);
            ++i;
        }
    }

    public void addObjectChangedListener(IMQExtObjectChangedListener listener) {
        this.objectChangedListeners.addElement(listener);
    }

    public void removeObjectChangedListener(IMQExtObjectChangedListener listener) {
        this.objectChangedListeners.removeElement(listener);
    }

    public int getObjectChangedListenerCount() {
        return this.objectChangedListeners.size();
    }

    public void objectDeleted() {
        MQExtObjectDeletedEvent event = new MQExtObjectDeletedEvent(this);
        int size = this.objectDeletedListeners.size();
        int i = 0;
        while (i < size) {
            IMQExtObjectDeletedListener listener = this.objectDeletedListeners.elementAt(i);
            listener.mqExtObjectDeleted(event);
            ++i;
        }
    }

    public void addObjectDeletedListener(IMQExtObjectDeletedListener listener) {
        this.objectDeletedListeners.addElement(listener);
    }

    public void removeObjectDeletedListener(IMQExtObjectDeletedListener listener) {
        this.objectDeletedListeners.removeElement(listener);
    }

    public int getObjectDeletedListenerCount() {
        return this.objectDeletedListeners.size();
    }

    public String toString() {
        return this.getName();
    }
}

