/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class RASProperties {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/utils/RASProperties.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String DOT = ".";
    public static final String AMQ = "AMQ";
    public static final String TRACE_SUFFIX = "TRC";
    public static final String FFDC_SUFFIX = "FDC";
    public static final String WMQ_JAVA_SUFFIX = "JC";
    public static final String JAVA_LOG_NAME = "AMQJAVA.LOG";
    public static final int MAXIMUM_COUNTER_VALUE = 65535;
    public static final String PROPERTY_NAME = "com.ibm.mq.commonservices";
    public static final String PROPERTY_DIAGID = "com.ibm.mq.commonservices.diagid";
    public static final String PROPERTY_DIAG_MQ = "Diagnostics.MQ";
    public static final String PROPERTY_DIAG_JAVA = "Diagnostics.Java";
    public static final String PROPERTY_DIAG_JAVA_TRACE_DETAIL = "Diagnostics.Java.Trace.Detail";
    public static final String PROPERTY_DIAG_JAVA_TRACE_DEST_FILE = "Diagnostics.Java.Trace.Destination.File";
    public static final String PROPERTY_DIAG_JAVA_TRACE_DEST_CONS = "Diagnostics.Java.Trace.Destination.Console";
    public static final String PROPERTY_DIAG_JAVA_TRACE_DEST_PATH = "Diagnostics.Java.Trace.Destination.Pathname";
    public static final String PROPERTY_DIAG_JAVA_TRACE_FILE_SIZE = "Diagnostics.Java.Trace.File.Size";
    public static final String PROPERTY_DIAG_JAVA_TRACE_FILE_COUNT = "Diagnostics.Java.Trace.File.Count";
    public static final String PROPERTY_DIAG_JAVA_FFDC_DEST_PATH = "Diagnostics.Java.FFDC.Destination.Pathname";
    public static final String PROPERTY_DIAG_JAVA_ERRORS_DEST_FILE = "Diagnostics.Java.Errors.Destination.Filename";
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_DISABLED = "disabled";
    public static final String PROPERTY_TRUE = "true";
    public static final String PROPERTY_FALSE = "false";
    public static final String PROPERTY_SOAP = "soap";
    public static final String PROPERTY_EXPLORER = "explorer";
    public static final String PROPERTY_WMQ_JAVA_CLASSES = "wmqjavaclasses";
    public static final String PROPERTY_COMMONSERVICES = "commonservices";
    public static final String PROPERTY_DATAMODEL = "datamodel";
    public static final String PROPERTY_FTA = "fta";
    public static final String PROPERTY_UI = "ui";
    public static final String PROPERTY_PLUGINS = "plugins";
    public static final String PROPERTY_ALL = "all";
    public static final String PROPERTY_NONE = "<<none>>";
    public static final String PROPERTY_LOW = "low";
    public static final String PROPERTY_MEDIUM = "medium";
    public static final String PROPERTY_HIGH = "high";
    public static final int TRACE_DETAIL_LOW = 500;
    public static final int TRACE_DETAIL_MEDIUM = 400;
    public static final int TRACE_DETAIL_HIGH = Integer.MIN_VALUE;
    private static final int DEFAULT_TRACE_FILE_SIZE = 200000000;
    private static final int DEFAULT_TRACE_FILE_COUNT = 25;
    private boolean diagMQ = false;
    private String diagJava = "<<none>>";
    private boolean diagJavaExplorer = false;
    private boolean diagJavaSoap = false;
    private boolean diagJavaWMQJavaClasses = false;
    private boolean diagJavaCommonServices = false;
    private boolean diagJavaDataModel = false;
    private boolean diagJavaFTA = false;
    private boolean diagJavaUI = false;
    private boolean diagJavaPlugins = false;
    private boolean diagJavaAll = false;
    private int traceDetail = 400;
    private int traceWMQJavaClassesDetail = 3;
    private boolean traceDestFile = false;
    private boolean traceDestConsole = false;
    private File traceDestPathname = null;
    private File ffdcDestPathname = null;
    private File traceFile = null;
    private int traceFileSize = 0;
    private int traceFileCount = 0;
    private File traceWMQFile = null;
    private File ffdcFile = null;
    private File javaLogFile = null;
    private File errorsDestFilename = null;
    private String propFilename = "<<none>>";
    private String diagId = "<<none>>";
    private File propertyFile = null;
    private Properties properties = new Properties();
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private Date filenameDate = new Date();
    private static String workingDir = "";
    private boolean diagSystemErr = false;
    public static final String PROPERTY_SYSTEM_ERR = "com.ibm.msg.client.commonservices.trace.startup";

    static {
        try {
            workingDir = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty("user.dir");
                }
            });
        }
        catch (AccessControlException ace) {
            System.err.println("Failed to query system property: " + ace);
        }
    }

    public RASProperties() {
        String propSysErrValue = "";
        try {
            propSysErrValue = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(RASProperties.PROPERTY_SYSTEM_ERR, RASProperties.PROPERTY_FALSE);
                }
            });
        }
        catch (AccessControlException accessControlException) {}
        if (propSysErrValue.equalsIgnoreCase(PROPERTY_TRUE)) {
            this.diagSystemErr = true;
        }
        try {
            this.propFilename = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(RASProperties.PROPERTY_NAME, RASProperties.PROPERTY_NONE);
                }
            });
        }
        catch (AccessControlException ace) {
            System.err.println("Failed to query system property com.ibm.mq.commonservices: " + ace);
        }
        try {
            this.diagId = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(RASProperties.PROPERTY_DIAGID, RASProperties.PROPERTY_NONE);
                }
            });
        }
        catch (AccessControlException accessControlException) {}
        this.loadDefaultProperties();
        if (!this.propFilename.equals(PROPERTY_NONE)) {
            try {
                this.propertyFile = this.validateFile(this.propFilename, false, false);
                this.loadProperties();
            }
            catch (CommonServicesException commonServicesException) {}
            this.processProperties();
        }
    }

    protected void processProperties() {
        this.parseProperties();
        this.traceFile = this.generateFilename(this.traceDestPathname, TRACE_SUFFIX);
        this.traceWMQFile = this.generateFilename(this.traceDestPathname, "JC.TRC");
        this.ffdcFile = this.generateFilename(this.ffdcDestPathname, FFDC_SUFFIX);
        this.javaLogFile = this.generateLogFilename();
    }

    private void loadProperties() throws CommonServicesException {
        FileInputStream input = null;
        try {
            Object inputTemp = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return new FileInputStream(RASProperties.this.propertyFile.getAbsolutePath());
                    }
                    catch (FileNotFoundException e) {
                        return e;
                    }
                }
            });
            if (inputTemp instanceof FileNotFoundException) {
                throw (FileNotFoundException)inputTemp;
            }
            input = (FileInputStream)inputTemp;
        }
        catch (FileNotFoundException ioe) {
            System.err.println("Error reading " + this.propertyFile.toString() + "\n" + ioe);
            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
        }
        catch (SecurityException se) {
            System.err.println("SecurityException loading " + this.propertyFile.toString() + "\n" + se);
            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
        }
        try {
            Properties temp = new Properties();
            temp.load(input);
            Enumeration<Object> e = temp.keys();
            while (e.hasMoreElements()) {
                final String key = (String)e.nextElement();
                String value = (String)temp.get(key);
                if (value == null) continue;
                String s = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            return System.getProperty(key.trim());
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                });
                if (s == null) {
                    this.properties.setProperty(key.trim(), value.trim());
                    continue;
                }
                this.properties.setProperty(key.trim(), s.trim());
            }
        }
        catch (IOException ioe) {
            System.err.println("Error loading " + this.propertyFile.toString() + "\n" + ioe);
            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Error loading " + this.propertyFile.toString() + "\n" + iae);
            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
        }
    }

    private void parseProperties() {
        String value = (String)this.properties.get(PROPERTY_DIAG_MQ);
        if (value.equalsIgnoreCase(PROPERTY_DISABLED)) {
            this.diagMQ = false;
        }
        if (!(value = (String)this.properties.get(PROPERTY_DIAG_JAVA)).equalsIgnoreCase(PROPERTY_NONE)) {
            this.setDiagJavaValue(value);
        }
        if (!(value = (String)this.properties.get(PROPERTY_DIAG_JAVA_TRACE_DETAIL)).equalsIgnoreCase(PROPERTY_NONE)) {
            this.setTraceDetailValue(value);
        }
        if ((value = (String)this.properties.get(PROPERTY_DIAG_JAVA_TRACE_DEST_FILE)).equalsIgnoreCase(PROPERTY_ENABLED)) {
            this.traceDestFile = true;
        }
        if ((value = (String)this.properties.get(PROPERTY_DIAG_JAVA_TRACE_DEST_CONS)).equalsIgnoreCase(PROPERTY_ENABLED)) {
            this.traceDestConsole = true;
        }
        if (!(value = (String)this.properties.get(PROPERTY_DIAG_JAVA_TRACE_DEST_PATH)).equalsIgnoreCase(PROPERTY_NONE)) {
            try {
                this.traceDestPathname = this.validateFile(value, true, true);
            }
            catch (CommonServicesException commonServicesException) {}
        }
        if (!(value = (String)this.properties.get(PROPERTY_DIAG_JAVA_TRACE_FILE_SIZE)).equalsIgnoreCase(PROPERTY_NONE)) {
            try {
                this.traceFileSize = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.traceFileSize = 200000000;
        }
        if (!(value = (String)this.properties.get(PROPERTY_DIAG_JAVA_TRACE_FILE_COUNT)).equalsIgnoreCase(PROPERTY_NONE)) {
            try {
                this.traceFileCount = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.traceFileCount = 25;
        }
        if (!(value = (String)this.properties.get(PROPERTY_DIAG_JAVA_FFDC_DEST_PATH)).equalsIgnoreCase(PROPERTY_NONE)) {
            try {
                this.ffdcDestPathname = this.validateFile(value, true, true);
            }
            catch (CommonServicesException commonServicesException) {}
        }
        if (!(value = (String)this.properties.get(PROPERTY_DIAG_JAVA_ERRORS_DEST_FILE)).equalsIgnoreCase(PROPERTY_NONE)) {
            try {
                this.errorsDestFilename = this.validateFile(value, false, true);
            }
            catch (CommonServicesException commonServicesException) {}
        }
    }

    private File validateFile(final String name, final boolean checkDir, final boolean checkRW) throws CommonServicesException {
        File fileTemp = null;
        try {
            fileTemp = new File(name);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("NullPointerException - name not defined");
            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
        }
        final File file = fileTemp;
        try {
            Object anyException = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        if (checkDir && !file.isDirectory()) {
                            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
                        }
                        if (!(checkDir || file.isFile() || file.createNewFile())) {
                            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
                        }
                        if (checkRW && !file.canWrite()) {
                            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
                        }
                        if (!checkRW && !file.canRead()) {
                            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
                        }
                    }
                    catch (CommonServicesException cse) {
                        return cse;
                    }
                    catch (IOException ioe) {
                        System.err.println("IOException reading " + name + "\n" + ioe);
                        return new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
                    }
                    return null;
                }
            });
            if (anyException instanceof CommonServicesException) {
                throw (CommonServicesException)anyException;
            }
        }
        catch (SecurityException se) {
            System.err.println("SecurityException reading " + name + "\n" + se);
            throw new CommonServicesException(CommonServices.getSystemMessage("AMQ9999"), "AMQ9999", 50046, 0, 40);
        }
        return file;
    }

    private void setDiagJavaValue(String components) {
        StringTokenizer token = new StringTokenizer(components, ",");
        while (token.hasMoreTokens()) {
            String name = token.nextToken(",").trim();
            if (name.equalsIgnoreCase(PROPERTY_EXPLORER)) {
                this.diagJavaExplorer = true;
                continue;
            }
            if (name.equalsIgnoreCase(PROPERTY_SOAP)) {
                this.diagJavaSoap = true;
                continue;
            }
            if (name.equalsIgnoreCase(PROPERTY_WMQ_JAVA_CLASSES)) {
                this.diagJavaWMQJavaClasses = true;
                continue;
            }
            if (name.equalsIgnoreCase(PROPERTY_COMMONSERVICES)) {
                this.diagJavaCommonServices = true;
                continue;
            }
            if (name.equalsIgnoreCase(PROPERTY_DATAMODEL)) {
                this.diagJavaDataModel = true;
                continue;
            }
            if (name.equalsIgnoreCase(PROPERTY_FTA)) {
                this.diagJavaFTA = true;
                continue;
            }
            if (name.equalsIgnoreCase(PROPERTY_UI)) {
                this.diagJavaUI = true;
                continue;
            }
            if (name.equalsIgnoreCase(PROPERTY_PLUGINS)) {
                this.diagJavaPlugins = true;
                continue;
            }
            if (name.equalsIgnoreCase(PROPERTY_ALL)) {
                this.diagJavaAll = true;
                continue;
            }
            System.err.println("Invalid java component " + name);
        }
        this.diagJava = components;
    }

    private void setTraceDetailValue(String value) {
        if (value.equalsIgnoreCase(PROPERTY_LOW)) {
            this.traceDetail = 500;
            this.traceWMQJavaClassesDetail = 1;
        } else if (value.equalsIgnoreCase(PROPERTY_MEDIUM)) {
            this.traceDetail = 400;
            this.traceWMQJavaClassesDetail = 3;
        } else if (value.equalsIgnoreCase(PROPERTY_HIGH)) {
            this.traceDetail = Integer.MIN_VALUE;
            this.traceWMQJavaClassesDetail = 5;
        }
    }

    private void loadDefaultProperties() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_MQ, System.getProperty(RASProperties.PROPERTY_DIAG_MQ, RASProperties.PROPERTY_ENABLED));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_MQ, RASProperties.PROPERTY_ENABLED);
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA, System.getProperty(RASProperties.PROPERTY_DIAG_JAVA, RASProperties.PROPERTY_NONE));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA, RASProperties.PROPERTY_NONE);
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DEST_FILE, System.getProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DEST_FILE, RASProperties.PROPERTY_DISABLED));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DEST_FILE, RASProperties.PROPERTY_DISABLED);
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DEST_CONS, System.getProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DEST_CONS, RASProperties.PROPERTY_DISABLED));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DEST_CONS, RASProperties.PROPERTY_DISABLED);
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DETAIL, System.getProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DETAIL, RASProperties.PROPERTY_MEDIUM));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DETAIL, RASProperties.PROPERTY_MEDIUM);
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DEST_PATH, System.getProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DEST_PATH, workingDir));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_DEST_PATH, workingDir);
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_FILE_SIZE, System.getProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_FILE_SIZE, Integer.toString(200000000)));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_FILE_SIZE, Integer.toString(200000000));
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_FILE_COUNT, System.getProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_FILE_COUNT, Integer.toString(25)));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_TRACE_FILE_COUNT, Integer.toString(25));
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_FFDC_DEST_PATH, System.getProperty(RASProperties.PROPERTY_DIAG_JAVA_FFDC_DEST_PATH, workingDir));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_FFDC_DEST_PATH, workingDir);
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_ERRORS_DEST_FILE, System.getProperty(RASProperties.PROPERTY_DIAG_JAVA_ERRORS_DEST_FILE, String.valueOf(workingDir) + File.separator + RASProperties.JAVA_LOG_NAME));
                }
                catch (AccessControlException accessControlException) {
                    RASProperties.this.properties.setProperty(RASProperties.PROPERTY_DIAG_JAVA_ERRORS_DEST_FILE, String.valueOf(workingDir) + File.separator + RASProperties.JAVA_LOG_NAME);
                }
                return null;
            }
        });
    }

    public boolean isTracingToFile() {
        return this.traceDestFile;
    }

    public boolean isTracingToConsole() {
        return this.traceDestConsole;
    }

    public boolean isTracingSoap() {
        return this.diagJavaSoap;
    }

    public boolean isTracingExplorer() {
        return this.diagJavaExplorer;
    }

    public boolean isTracingWMQJavaClasses() {
        return this.diagJavaWMQJavaClasses;
    }

    public boolean isTracingToWMQ() {
        return this.diagMQ;
    }

    public boolean isTracingDataModel() {
        return this.diagJavaDataModel;
    }

    public boolean isTracingCommonServices() {
        return this.diagJavaCommonServices;
    }

    public boolean isTracingFTA() {
        return this.diagJavaFTA;
    }

    public boolean isTracingUI() {
        return this.diagJavaUI;
    }

    public boolean isTracingPlugins() {
        return this.diagJavaPlugins;
    }

    public boolean isTracingAll() {
        return this.diagJavaAll;
    }

    public String getJavaTraceComponents() {
        return this.diagJava;
    }

    public int getTraceDetail() {
        return this.traceDetail;
    }

    public int getTraceWMQJavaClassesDetail() {
        return this.traceWMQJavaClassesDetail;
    }

    public String getTracePathname() {
        if (this.traceDestPathname != null) {
            return this.traceDestPathname.toString();
        }
        return null;
    }

    public String getTraceFilename() {
        if (this.traceFile != null) {
            return this.traceFile.toString();
        }
        return null;
    }

    public int getTraceFileSize() {
        return this.traceFileSize;
    }

    public int getTraceFileCount() {
        return this.traceFileCount;
    }

    public String getTraceWMQFilename() {
        if (this.traceWMQFile != null) {
            return this.traceWMQFile.toString();
        }
        return null;
    }

    public String getFFDCPathname() {
        if (this.ffdcDestPathname != null) {
            return this.ffdcDestPathname.toString();
        }
        return null;
    }

    public String getFFDCFilename() {
        if (this.ffdcFile != null) {
            return this.ffdcFile.toString();
        }
        return null;
    }

    public String getErrorsFilename() {
        if (this.errorsDestFilename != null) {
            return this.errorsDestFilename.toString();
        }
        return null;
    }

    public String getJavaLogFilename() {
        if (this.javaLogFile != null) {
            return this.javaLogFile.toString();
        }
        return null;
    }

    public File getJavaLogFile() {
        return this.javaLogFile;
    }

    public String getDiagId() {
        return this.diagId;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPropertyFilename() {
        return this.propFilename;
    }

    public boolean isTracePathnameValid() {
        return this.traceDestPathname != null;
    }

    public boolean isFFDCPathnameValid() {
        return this.ffdcDestPathname != null;
    }

    public boolean isErrorsFilenameValid() {
        return this.errorsDestFilename != null;
    }

    private File generateFilename(File destPathname, String suffix) {
        String filename = null;
        File file = null;
        if (destPathname != null) {
            int counter = 0;
            while (counter < 65535) {
                filename = this.diagId.equals(PROPERTY_NONE) ? String.valueOf(dateFormat.format(this.filenameDate)) + DOT + counter + DOT + suffix : String.valueOf(this.diagId) + DOT + counter + DOT + suffix;
                filename = String.valueOf(destPathname.toString()) + File.separator + AMQ + filename;
                file = new File(filename);
                final File fileTemp = file;
                Boolean fileExists = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            return fileTemp.exists();
                        }
                        catch (AccessControlException accessControlException) {
                            return false;
                        }
                    }
                });
                if (!fileExists.booleanValue()) break;
                ++counter;
            }
        }
        return file;
    }

    private File generateLogFilename() {
        File file = null;
        String filename = null;
        if (this.errorsDestFilename != null) {
            filename = this.errorsDestFilename.toString();
            file = new File(filename);
        } else {
            filename = String.valueOf(workingDir) + File.separator + JAVA_LOG_NAME;
            file = new File(filename);
        }
        return file;
    }

    protected String setProperty(Trace t, String key, String value) {
        Object oldValue = null;
        oldValue = this.properties.setProperty(key, value);
        if (oldValue == null) {
            return null;
        }
        return (String)oldValue;
    }

    public boolean isTracingSystemErr() {
        return this.diagSystemErr;
    }

    public void debug() {
        System.out.println("Property filename  : " + this.propFilename);
        System.out.println("           diag id : " + this.diagId);
        System.out.println("         trace wmq : " + this.diagMQ);
        System.out.println("            detail : " + this.traceDetail);
        System.out.println("    wmqjava detail : " + this.traceWMQJavaClassesDetail);
        System.out.println("              java : " + this.diagJavaWMQJavaClasses);
        System.out.println("              soap : " + this.diagJavaSoap);
        System.out.println("          explorer : " + this.diagJavaExplorer);
        System.out.println("     trace to file : " + this.traceDestFile);
        System.out.println("  trace to console : " + this.traceDestConsole);
        System.out.println("  using trace path : " + this.traceDestPathname + ", " + this.isTracePathnameValid());
        System.out.println("   using FFDC path : " + this.ffdcDestPathname + ", " + this.isFFDCPathnameValid());
        System.out.println(" using errors file : " + this.errorsDestFilename + ", " + this.isErrorsFilenameValid());
        System.out.println("        trace file : " + this.traceFile);
        System.out.println("wmqjava trace file : " + this.traceWMQFile);
        System.out.println("         FFDC file : " + this.ffdcFile);
        System.out.println("     diagSystemErr : " + this.diagSystemErr);
    }
}

