/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.BaseMQInstallationDetails;
import com.ibm.mq.commonservices.internal.utils.BaseMQReturnValue;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;

public class NativeCalls {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/utils/NativeCalls.java";
    private static final int XCSPRA_DELIMIT_1 = 11;
    private static final String SYSTEM_MESSAGE_UNEXPECTED_ERROR = "AMQ4580";
    private static final String SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR = "AMQ4581";
    private static final String SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR = "AMQ4585";
    private static final String SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR = "AMQ4579";
    public static final int lpiCSVR_UNKNOWN = -1;
    public static final int lpiCSVR_RUNNING = 2;
    private static final int COAGETCOMMANDSERVERSTATUS = 1;
    private static final int COAGETQUEUEMANAGERSTATUS = 2;
    private static final int COACHECKAUTHORIZATION = 3;

    protected static String queryValue(Trace t, int option, int key) throws CommonServicesException {
        String value = null;
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_query_value(retval, option, key);
        }
        catch (Exception e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR);
            String text = Message.format(messageText, "wmq_query_value");
            throw new CommonServicesException(t, text, e, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR, 50999, 50999, 30);
        }
        catch (UnsatisfiedLinkError e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR);
            throw new CommonServicesException(t, messageText, e, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR, 50055, 50055, 30);
        }
        if (retval == null) {
            t.FFST(64, "NativeCalls.queryValue", 0, 0, 0, 0, null, null, null);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String text = Message.format(messageText, "wmq_query_value", "(null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50999, 0, 30);
        }
        if (retval.rc != 0) {
            t.FFST(64, "NativeCalls.queryValue", 10, retval.rc, retval.rc2, retval.integer1);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc = " + String.valueOf(retval.rc) + "\"";
            String text = Message.format(messageText, "wmq_query_value", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50999, retval.rc, 30);
        }
        if (retval.rc2 != 0) {
            t.data(64, "NativeCalls.queryValue", 900, "Error getting value for option = " + option + ", key = " + key);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc2 = " + String.valueOf(retval.rc2) + "\"";
            String text = Message.format(messageText, "wmq_query_value", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50999, retval.rc2, 30);
        }
        value = retval.string1;
        return value;
    }

    public static int createAttrs(Trace t, String qmgr, String stanza, String createattrs) throws CommonServicesException {
        int version = 1;
        String fid = "NativeCalls.createAttrs";
        int rc = 50001;
        byte[] createattrsArray = null;
        if (createattrs == null) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR);
            String text = Message.format(messageText, "createAttrs", "createattrs = (null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR, 50001, 50001, 30);
        }
        createattrsArray = createattrs.getBytes();
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_create_attrs(retval, qmgr, stanza, version, createattrsArray);
        }
        catch (Exception e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR);
            String text = Message.format(messageText, "wmq_create_attrs");
            throw new CommonServicesException(t, text, e, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR, 50001, 50001, 30);
        }
        catch (UnsatisfiedLinkError e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR);
            throw new CommonServicesException(t, messageText, e, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR, 50055, 50055, 30);
        }
        if (retval == null) {
            t.FFST(64, fid, 11, 0, 0, 0, null, null, null);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String text = Message.format(messageText, "wmq_create_attrs", "(null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50001, 50001, 30);
        }
        if (retval.rc != 0) {
            t.FFST(64, fid, 12, retval.rc, retval.rc2, retval.integer1);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc = " + String.valueOf(retval.rc) + "\"";
            String text = Message.format(messageText, "wmq_create_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50001, retval.rc, 30);
        }
        if (retval.rc2 != 0) {
            t.data(64, fid, 900, "Error creating config attrs for " + qmgr + ":" + stanza);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc2 = " + String.valueOf(retval.rc2) + "\"";
            String text = Message.format(messageText, "wmq_create_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50001, retval.rc2, 30);
        }
        rc = 0;
        return rc;
    }

    public static String getAttrs(Trace t, String qmgr, String stanza) throws CommonServicesException {
        int version = 1;
        String fid = "NativeCalls.getAttrs";
        String attrs = null;
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_get_attrs(retval, qmgr, stanza, version);
        }
        catch (Exception e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR);
            String text = Message.format(messageText, "wmq_get_attrs");
            throw new CommonServicesException(t, text, e, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR, 50014, 50014, 30);
        }
        catch (UnsatisfiedLinkError e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR);
            throw new CommonServicesException(t, messageText, e, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR, 50055, 50055, 30);
        }
        if (retval == null) {
            t.FFST(64, fid, 2, 0, 0, 0, null, null, null);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String text = Message.format(messageText, "wmq_get_attrs", "(null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50014, 50014, 30);
        }
        if (retval.rc != 0) {
            t.FFST(64, fid, 13, retval.rc, retval.rc2, retval.integer1);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc = " + String.valueOf(retval.rc) + "\"";
            String text = Message.format(messageText, "wmq_get_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50014, retval.rc, 30);
        }
        if (retval.rc2 != 0) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc2 = " + String.valueOf(retval.rc2) + "\"";
            String text = Message.format(messageText, "wmq_get_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50014, retval.rc2, 30);
        }
        attrs = NativeCalls.attrsToString(retval.object1);
        return attrs;
    }

    public static String setAttrs(Trace t, String qmgr, String stanza, String getattrs, String setattrs) throws CommonServicesException {
        int version = 1;
        String fid = "NativeCalls.setAttrs";
        String attrs = null;
        byte[] getAttrsArray = null;
        if (getattrs == null) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR);
            String text = Message.format(messageText, "wmq_set_attrs", "setattrs = (null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR, 50002, 50002, 30);
        }
        getAttrsArray = getattrs.getBytes();
        byte[] setAttrsArray = null;
        if (setattrs == null) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR);
            String text = Message.format(messageText, "wmq_set_attrs", "setattrs = (null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR, 50002, 50002, 30);
        }
        setAttrsArray = setattrs.getBytes();
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_set_attrs(retval, qmgr, stanza, version, getAttrsArray, setAttrsArray);
        }
        catch (Exception e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR);
            String text = Message.format(messageText, "wmq_set_attrs");
            throw new CommonServicesException(t, text, e, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR, 50002, 50002, 30);
        }
        catch (UnsatisfiedLinkError e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR);
            throw new CommonServicesException(t, messageText, e, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR, 50055, 50055, 30);
        }
        if (retval == null) {
            t.FFST(64, fid, 27, 0, 0, 0, null, null, null);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String text = Message.format(messageText, "wmq_set_attrs", "(null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50002, 50002, 30);
        }
        if (retval.rc != 0) {
            t.FFST(64, fid, 14, retval.rc, retval.rc2, retval.integer1);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc = " + String.valueOf(retval.rc) + "\"";
            String text = Message.format(messageText, "wmq_set_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50002, retval.rc, 30);
        }
        if (retval.rc2 != 0) {
            t.data(64, fid, 900, "Error setting config attrs for " + qmgr + ":" + stanza);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc2 = " + String.valueOf(retval.rc2) + "\"";
            String text = Message.format(messageText, "wmq_set_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50002, retval.rc2, 30);
        }
        attrs = NativeCalls.attrsToString(retval.object1);
        return attrs;
    }

    public static String getRepeatingAttrs(Trace t, String qmgr, String stanza, String repeatingattr, String repeatingvalue) throws CommonServicesException {
        int version = 1;
        String fid = "NativeCalls.getRepeatingAttrs";
        String attrs = null;
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_get_repeating_attrs(retval, qmgr, stanza, version, repeatingattr, repeatingvalue);
        }
        catch (Exception e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR);
            String text = Message.format(messageText, "wmq_get_repeating_attrs");
            throw new CommonServicesException(t, text, e, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR, 50014, 50014, 30);
        }
        catch (UnsatisfiedLinkError e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR);
            throw new CommonServicesException(t, messageText, e, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR, 50055, 50055, 30);
        }
        if (retval == null) {
            t.FFST(64, fid, 4, 0, 0, 0, null, null, null);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String text = Message.format(messageText, "wmq_get_repeating_attrs", "(null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50014, 50014, 30);
        }
        if (retval.rc != 0) {
            t.FFST(64, fid, 15, retval.rc, retval.rc2, retval.integer1);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc = " + String.valueOf(retval.rc) + "\"";
            String text = Message.format(messageText, "wmq_get_repeating_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50014, retval.rc, 30);
        }
        if (retval.rc2 != 0) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc2 = " + String.valueOf(retval.rc2) + "\"";
            String text = Message.format(messageText, "wmq_get_repeating_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50014, retval.rc2, 30);
        }
        attrs = NativeCalls.attrsToString(retval.object1);
        return attrs;
    }

    public static String setRepeatingAttrs(Trace t, String qmgr, String stanza, String getattrs, String setattrs) throws CommonServicesException {
        int version = 1;
        String fid = "NativeCalls.setRepeatingAttrs";
        String attrs = null;
        byte[] getAttrsArray = null;
        if (getattrs == null) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR);
            String text = Message.format(messageText, "wmq_set_repeating_attrs", "setattrs = (null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR, 50002, 50002, 30);
        }
        getAttrsArray = getattrs.getBytes();
        byte[] setAttrsArray = null;
        if (setattrs == null) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR);
            String text = Message.format(messageText, "wmq_set_repeating_attrs", "setattrs = (null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR, 50002, 50002, 30);
        }
        setAttrsArray = setattrs.getBytes();
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_set_repeating_attrs(retval, qmgr, stanza, version, getAttrsArray, setAttrsArray);
        }
        catch (Exception e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR);
            String text = Message.format(messageText, "wmq_set_repeating_attrs");
            throw new CommonServicesException(t, text, e, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR, 50002, 50002, 30);
        }
        catch (UnsatisfiedLinkError e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR);
            throw new CommonServicesException(t, messageText, e, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR, 50055, 50055, 30);
        }
        if (retval == null) {
            t.FFST(64, fid, 5, 0, 0, 0, null, null, null);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String text = Message.format(messageText, "wmq_set_repeating_attrs", "(null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50002, 50002, 30);
        }
        if (retval.rc != 0) {
            t.FFST(64, fid, 16, retval.rc, retval.rc2, retval.integer1);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc = " + String.valueOf(retval.rc) + "\"";
            String text = Message.format(messageText, "wmq_set_repeating_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50002, retval.rc, 30);
        }
        if (retval.rc2 != 0) {
            t.data(64, fid, 900, "Error setting repeating  attrs for " + qmgr + ":" + stanza);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc2 = " + String.valueOf(retval.rc2) + "\"";
            String text = Message.format(messageText, "wmq_set_repeating_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50002, retval.rc2, 30);
        }
        attrs = NativeCalls.attrsToString(retval.object1);
        return attrs;
    }

    public static String deleteRepeatingAttrs(Trace t, String qmgr, String stanza, String getattrs) throws CommonServicesException {
        int version = 1;
        String fid = "NativeCalls.deleteRepeatingAttrs";
        String attrs = null;
        byte[] getAttrsArray = null;
        if (getattrs == null) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR);
            String text = Message.format(messageText, "wmq_delete_repeating_attrs", "delattrs = (null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_PARAMETER_CHECK_ERROR, 50003, 50003, 30);
        }
        getAttrsArray = getattrs.getBytes();
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_delete_repeating_attrs(retval, qmgr, stanza, version, getAttrsArray);
        }
        catch (Exception exception) {
            t.FFST(64, fid, 6, 0, 0, 0, null, null, null);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String text = Message.format(messageText, "wmq_delete_repeating_attrs", "(null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50003, 50003, 30);
        }
        catch (UnsatisfiedLinkError e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR);
            throw new CommonServicesException(t, messageText, e, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR, 50055, 50055, 30);
        }
        if (retval == null) {
            t.FFST(64, fid, 17, 0, 0, 0);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String text = Message.format(messageText, "wmq_delete_repeating_attrs", "(null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50003, 50003, 30);
        }
        if (retval.rc2 != 0) {
            t.data(64, fid, 900, "Error deleting config attrs for " + qmgr + ":" + stanza);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc2 = " + String.valueOf(retval.rc2) + "\"";
            String text = Message.format(messageText, "wmq_delete_repeating_attrs", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50003, retval.rc2, 30);
        }
        attrs = NativeCalls.attrsToString(retval.object1);
        return attrs;
    }

    public static int getCommandServesStatus(Trace t, String qmgr) {
        int status = -1;
        String fid = "NativeCalls.getCommandServesStatus";
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_native_call(retval, 1, 0, 0, qmgr, null, null);
            if (retval == null) {
                t.FFST(64, fid, 7, 0, 0, 0, null, null, null);
            } else if (retval.rc != 0) {
                t.FFST(64, fid, 18, retval.rc, retval.rc2, retval.integer1);
            } else {
                switch (retval.rc2) {
                    case 0: {
                        status = retval.integer1;
                        break;
                    }
                    default: {
                        status = -1;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            t.FFST(64, fid, 28, 0, 0, 0, e.getMessage(), null, null);
        }
        catch (UnsatisfiedLinkError e) {
            t.FFST(64, fid, 30, 50055, 0, 0, e.getMessage(), null, null);
        }
        return status;
    }

    public static boolean isQueueManagerRunning(Trace t, String qmgr) {
        boolean isRunning = false;
        String fid = "NativeCalls.isQueueManagerRunning";
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_native_call(retval, 2, 0, 0, qmgr, null, null);
            if (retval == null) {
                t.FFST(64, fid, 8, 0, 0, 0, null, null, null);
            } else if (retval.rc != 0) {
                t.FFST(64, fid, 19, retval.rc, retval.rc2, retval.integer1);
            } else {
                block1 : switch (retval.rc2) {
                    case 0: {
                        switch (retval.integer1) {
                            case 0: 
                            case 13: {
                                isRunning = true;
                                break block1;
                            }
                        }
                        isRunning = false;
                        break;
                    }
                    default: {
                        isRunning = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            t.FFST(64, fid, 29, 0, 0, 0, e.getMessage(), null, null);
        }
        catch (UnsatisfiedLinkError e) {
            t.FFST(64, fid, 31, 50055, 0, 0, e.getMessage(), null, null);
        }
        return isRunning;
    }

    public static boolean isQueueManagerRunningElsewhere(Trace t, String qmgr) {
        boolean isRunningElsewhere = false;
        String fid = "NativeCalls.isQueueManagerRunningElsewhere";
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_native_call(retval, 2, 0, 0, qmgr, null, null);
            if (retval == null) {
                t.FFST(64, fid, 35, 0, 0, 0, null, null, null);
            } else if (retval.rc != 0) {
                t.FFST(64, fid, 36, retval.rc, retval.rc2, retval.integer1);
            } else {
                block1 : switch (retval.rc2) {
                    case 0: {
                        switch (retval.integer1) {
                            case 14: {
                                isRunningElsewhere = true;
                                break block1;
                            }
                        }
                        isRunningElsewhere = false;
                        break;
                    }
                    default: {
                        isRunningElsewhere = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            t.FFST(64, fid, 37, 0, 0, 0, e.getMessage(), null, null);
        }
        catch (UnsatisfiedLinkError e) {
            t.FFST(64, fid, 38, 50055, 0, 0, e.getMessage(), null, null);
        }
        return isRunningElsewhere;
    }

    public static boolean isStandbyQueueManager(Trace t, String qmgr) {
        boolean isStandby = false;
        String fid = "NativeCalls.isStandbyQueueManager";
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_native_call(retval, 2, 0, 0, qmgr, null, null);
            if (retval == null) {
                t.FFST(64, fid, 22, 0, 0, 0, null, null, null);
            } else if (retval.rc != 0) {
                t.FFST(64, fid, 21, retval.rc, retval.rc2, retval.integer1);
            } else {
                block1 : switch (retval.rc2) {
                    case 0: {
                        switch (retval.integer1) {
                            case 13: {
                                isStandby = true;
                                break block1;
                            }
                        }
                        isStandby = false;
                        break;
                    }
                    default: {
                        isStandby = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            t.FFST(64, fid, 23, 0, 0, 0, e.getMessage(), null, null);
        }
        catch (UnsatisfiedLinkError e) {
            t.FFST(64, fid, 32, 50055, 0, 0, e.getMessage(), null, null);
        }
        return isStandby;
    }

    public static int getQueueManagerStatus(Trace t, String qmgr) {
        int status = 10;
        String fid = "NativeCalls.getQueueManagerStatus";
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_native_call(retval, 2, 0, 0, qmgr, null, null);
            if (retval == null) {
                t.FFST(64, fid, 24, 0, 0, 0, null, null, null);
            } else if (retval.rc != 0) {
                t.FFST(64, fid, 25, retval.rc, retval.rc2, retval.integer1);
            } else {
                status = retval.integer1;
            }
        }
        catch (Exception e) {
            t.FFST(64, fid, 26, 0, 0, 0, e.getMessage(), null, null);
        }
        catch (UnsatisfiedLinkError e) {
            t.FFST(64, fid, 33, 50055, 0, 0, e.getMessage(), null, null);
        }
        return status;
    }

    public static BaseMQInstallationDetails[] getInstallationDetails(Trace t) throws CommonServicesException {
        BaseMQInstallationDetails[] installationDetails = null;
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_get_installation_details(retval);
        }
        catch (Exception e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR);
            String text = Message.format(messageText, "wmq_get_installation_details");
            throw new CommonServicesException(t, text, e, SYSTEM_MESSAGE_EXCEPTION_CAUGHT_ERROR, 50999, 50999, 30);
        }
        catch (UnsatisfiedLinkError e) {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR);
            throw new CommonServicesException(t, messageText, e, SYSTEM_MESSAGE_UNSATISFIED_LINK_ERROR, 50055, 50055, 30);
        }
        if (retval == null) {
            t.FFST(64, "NativeCalls.getInstallationDetails", 0, 0, 0, 0, null, null, null);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String text = Message.format(messageText, "wmq_get_installation_details", "(null)");
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50999, 0, 30);
        }
        if (retval.rc != 0) {
            t.FFST(64, "NativeCalls.getInstallationDetails", 10, retval.rc, retval.rc2, retval.integer1);
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc = " + String.valueOf(retval.rc) + "\"";
            String text = Message.format(messageText, "wmq_get_installation_details", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50999, retval.rc, 30);
        }
        if (retval.rc2 == 0) {
            if (retval.object1 != null) {
                installationDetails = (BaseMQInstallationDetails[])retval.object1;
            }
        } else {
            String messageText = CommonServices.getSystemMessage(t, SYSTEM_MESSAGE_UNEXPECTED_ERROR);
            String insert = "\"retval.rc2 = " + String.valueOf(retval.rc2) + "\"";
            String text = Message.format(messageText, "wmq_get_installation_details", insert);
            throw new CommonServicesException(t, text, SYSTEM_MESSAGE_UNEXPECTED_ERROR, 50999, retval.rc2, 30);
        }
        return installationDetails;
    }

    public static boolean isUserAuthorized(Trace t) {
        boolean isAuthorized = false;
        String fid = "NativeCalls.isUserAuthorized";
        BaseMQReturnValue retval = new BaseMQReturnValue();
        try {
            retval = (BaseMQReturnValue)NativeCalls.wmq_native_call(retval, 3, 0, 0, null, null, null);
            if (retval == null) {
                t.FFST(64, fid, 9, 0, 0, 0, null, null, null);
            } else if (retval.rc != 0) {
                t.FFST(64, fid, 20, retval.rc, retval.rc2, retval.integer1);
            } else {
                switch (retval.rc2) {
                    case 0: {
                        isAuthorized = true;
                        break;
                    }
                    default: {
                        isAuthorized = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            t.FFST(64, fid, 3, 0, 0, 0, e.getMessage(), null, null);
        }
        catch (UnsatisfiedLinkError e) {
            t.FFST(64, fid, 34, 50055, 0, 0, e.getMessage(), null, null);
        }
        return isAuthorized;
    }

    public static boolean isTraceEnabled(Trace t, int options) {
        return NativeCalls.wmq_isTraceEnabled(options) != 0;
    }

    private static String attrsToString(Object object) {
        byte[] buffer = (byte[])object;
        String attrs = null;
        if (buffer != null) {
            int length = buffer.length;
            int i = 0;
            while (i < buffer.length) {
                if (buffer[i] == 11) {
                    length = i + 1;
                    break;
                }
                ++i;
            }
            attrs = new String(buffer, 0, length);
        }
        return attrs;
    }

    protected static native int xcsProcInit(int var0);

    protected static native int xcsProcTerm(int var0);

    protected static native int xcsThreadInit(int var0);

    protected static native int xcsThreadTerm(int var0);

    private static native Object wmq_query_value(BaseMQReturnValue var0, int var1, int var2);

    private static native Object wmq_get_attrs(BaseMQReturnValue var0, String var1, String var2, int var3);

    private static native Object wmq_get_repeating_attrs(BaseMQReturnValue var0, String var1, String var2, int var3, String var4, String var5);

    private static native Object wmq_set_attrs(BaseMQReturnValue var0, String var1, String var2, int var3, byte[] var4, byte[] var5);

    private static native Object wmq_create_attrs(BaseMQReturnValue var0, String var1, String var2, int var3, byte[] var4);

    private static native Object wmq_set_repeating_attrs(BaseMQReturnValue var0, String var1, String var2, int var3, byte[] var4, byte[] var5);

    private static native Object wmq_delete_repeating_attrs(BaseMQReturnValue var0, String var1, String var2, int var3, byte[] var4);

    private static native Object wmq_native_call(BaseMQReturnValue var0, int var1, int var2, int var3, String var4, String var5, String var6);

    private static native Object wmq_get_installation_details(BaseMQReturnValue var0);

    private static native int wmq_isTraceEnabled(int var0);

    private NativeCalls() {
    }
}

