/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.ConnectionName;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ConnectionNameList {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/utils/ConnectionNameList.java";
    private ArrayList<ConnectionName> listOfConnNames = new ArrayList();

    public ConnectionNameList(Trace t, String conn) throws NumberFormatException {
        StringTokenizer tok = new StringTokenizer(conn, ",");
        while (tok.hasMoreElements()) {
            String s = tok.nextToken();
            ConnectionName cn = new ConnectionName(t, s);
            this.listOfConnNames.add(cn);
        }
    }

    public ConnectionNameList(Trace t, String[] conn) throws NumberFormatException {
        int i = 0;
        while (i < conn.length) {
            ConnectionName cn = new ConnectionName(t, conn[i]);
            this.listOfConnNames.add(cn);
            ++i;
        }
    }

    public ConnectionNameList(Trace t, ArrayList<String> conn) throws NumberFormatException {
        int i = 0;
        while (i < conn.size()) {
            try {
                ConnectionName cn = new ConnectionName(t, conn.get(i));
                this.listOfConnNames.add(cn);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (ClassCastException e) {
                throw e;
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int size = this.listOfConnNames.size();
        int i = 0;
        while (i < size) {
            stringBuffer.append(this.listOfConnNames.get(i).toString());
            if (size > 1 && i < size - 1) {
                stringBuffer.append(",");
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionNameList) {
            ConnectionNameList cnl = (ConnectionNameList)obj;
            ArrayList<ConnectionName> list = cnl.getListOfConnNames();
            int i = 0;
            while (i < this.listOfConnNames.size()) {
                ConnectionName cn = this.listOfConnNames.get(i);
                if (list.contains(cn)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public ArrayList<ConnectionName> getListOfConnNames() {
        return this.listOfConnNames;
    }

    public int size() {
        return this.listOfConnNames.size();
    }

    public ConnectionName get(int i) {
        if (this.listOfConnNames.size() > 0) {
            return this.listOfConnNames.get(i);
        }
        return null;
    }
}

