/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import com.ibm.mq.commonservices.internal.trace.EventTraceFormatter;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import java.io.File;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventLogger {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/trace/EventLogger.java";
    private Logger logger = null;
    private FileHandler eventFileHandler = null;
    private String eventFilename = null;
    private static final String USER_HOME = System.getProperty("user.home");
    public static final String DM_EVENT_LOGGER_NAME = "com.ibm.mq.explorer.dm.event";
    public static final int DM_EVENT_LOGGER_ID = 1;
    public static final String UI_EVENT_LOGGER_NAME = "com.ibm.mq.explorer.ui.event";
    public static final int UI_EVENT_LOGGER_ID = 2;
    public static String DM_EVENT_FILENAME = "dmEvents.txt";
    public static String UI_EVENT_FILENAME = "uiEvents.txt";

    public EventLogger(Trace t, String id, String fn) {
        File workingDir = CommonServices.getWorkingDir(t);
        this.eventFilename = workingDir != null ? String.valueOf(workingDir.getAbsolutePath()) + File.separatorChar + fn : String.valueOf(USER_HOME) + File.separatorChar + fn;
        EventTraceFormatter formatter = new EventTraceFormatter();
        this.createLogger(t, id, this.eventFilename, formatter);
    }

    public EventLogger(Trace t, String id, String fn, Formatter formatter) {
        this.createLogger(t, id, fn, formatter);
    }

    private void createLogger(Trace t, String id, String fn, Formatter formatter) {
        try {
            this.logger = Logger.getLogger(id);
            if (this.logger == null) {
                if (Trace.isTracing) {
                    t.data(64, "EventLogger.createLogger", 900, "Error intializing JLog logger");
                }
                return;
            }
            this.logger.setLevel(Level.ALL);
            this.logger.setUseParentHandlers(false);
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(64, "EventLogger.createLogger", 900, "Error intializing JLog logger : " + e.toString());
            }
            return;
        }
        if (Trace.isTracing) {
            t.data(64, "EventLogger.createLogger", 300, "Event log name is " + this.eventFilename);
        }
        if (!this.createEventFileHandler(t, fn, formatter)) {
            return;
        }
    }

    private boolean createEventFileHandler(Trace t, String fn, Formatter formatter) {
        try {
            this.eventFileHandler = new FileHandler(fn);
            this.eventFileHandler.setFormatter(formatter);
            this.logger.addHandler(this.eventFileHandler);
            this.logger.setLevel(Level.ALL);
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(64, "EventLogger.createEventFileHandler", 900, "Error intializing event file handler : " + e.toString());
            }
            return false;
        }
        return true;
    }

    public Logger getEventLogger() {
        return this.logger;
    }
}

