/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.monitor;

import com.ibm.mq.commonservices.internal.monitor.ITraceMonitorListener;
import com.ibm.mq.commonservices.internal.trace.Trace;
import java.util.ArrayList;

public class TraceMonitor
extends Thread {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/monitor/TraceMonitor.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String MY_NAME = "IBM MQ Trace Monitor";
    private static boolean closing = false;
    private static int refreshInterval = 10;
    private static TraceMonitor traceMonitor = null;
    private static ArrayList<ITraceMonitorListener> listeners = new ArrayList();

    public TraceMonitor(Trace t, int ri) {
        traceMonitor = this;
        refreshInterval = ri;
        this.setDaemon(true);
        this.setName(MY_NAME);
        this.start();
    }

    @Override
    public void run() {
        boolean last = Trace.queryWMQTrace();
        boolean firstTime = true;
        Trace t = Trace.getDefault();
        while (!closing) {
            block5: {
                try {
                    if (!firstTime) {
                        Thread.sleep(refreshInterval * 1000);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!Trace.isTracing) break block5;
                    t.data(64, "TraceMonitor.run", 300, "IBM MQ Trace Monitor interrupted");
                }
            }
            boolean current = Trace.queryWMQTrace();
            if (closing) break;
            this.notifyListeners(last, current);
            last = current;
            firstTime = false;
        }
        if (Trace.isTracing) {
            t.data(64, "TraceMonitor.run", 300, "IBM MQ Trace Monitor ended");
        }
    }

    public static int getRefreshInterval() {
        return refreshInterval;
    }

    public static void setRefreshInterval(int i) {
        refreshInterval = i;
        traceMonitor.interrupt();
    }

    public void close(Trace t) {
        closing = true;
        traceMonitor.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(boolean last, boolean current) {
        ArrayList<ITraceMonitorListener> arrayList = listeners;
        synchronized (arrayList) {
            if (listeners.size() > 0 && last != current) {
                int i = 0;
                while (i < listeners.size()) {
                    ITraceMonitorListener listener = listeners.get(i);
                    if (current && !last) {
                        listener.enabled();
                    } else if (!current && last) {
                        listener.disabled();
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ITraceMonitorListener tl) {
        ArrayList<ITraceMonitorListener> arrayList = listeners;
        synchronized (arrayList) {
            listeners.add(tl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ITraceMonitorListener tl) {
        ArrayList<ITraceMonitorListener> arrayList = listeners;
        synchronized (arrayList) {
            listeners.remove(tl);
        }
    }
}

