/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.console;

import com.ibm.mq.commonservices.internal.console.ConsoleCommand;
import com.ibm.mq.commonservices.internal.console.ConsoleInputStream;
import com.ibm.mq.commonservices.internal.console.IConsoleCommandListener;
import com.ibm.mq.commonservices.internal.trace.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;

public class ConsoleStdoutReader
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/console/ConsoleStdoutReader.java";
    private ConsoleCommand consoleCommand = null;
    private IConsoleCommandListener listener = null;

    public ConsoleStdoutReader(ConsoleCommand aJob) {
        this.consoleCommand = aJob;
        this.listener = this.consoleCommand.getListener();
        this.setName("WMQ stdout for " + this.consoleCommand.getCommand());
    }

    @Override
    public void run() {
        InputStreamReader isr = null;
        Trace t = Trace.getDefault();
        InputStream is = this.consoleCommand.getProcess().getInputStream();
        isr = new ConsoleInputStream(t, is).getInputStreamReader();
        BufferedReader reader = new BufferedReader(isr);
        try {
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (Trace.isTracing) {
                        t.data(64, "ConsoleStdoutReader.run", "stdout data : " + line);
                    }
                    if (this.listener != null && line.length() > 0) {
                        this.listener.stdout(t, this.consoleCommand.getListenerId(), line);
                    }
                    if (this.isInterrupted()) {
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (InterruptedIOException e) {
                if (Trace.isTracing) {
                    t.data(64, "ConsoleStdoutReader.run", e.toString());
                }
                try {
                    reader.close();
                    isr.close();
                    is.close();
                }
                catch (IOException e2) {
                    String caller = null;
                    if (this.listener != null) {
                        caller = this.listener.toString();
                    }
                    t.FFST(64, "ConsoleStdoutReader.run", 1, 50044, 0, 0, caller, this.consoleCommand.getCommand(), e2.toString());
                }
            }
            catch (Exception e) {
                String caller = null;
                if (this.listener != null) {
                    caller = this.listener.toString();
                }
                t.FFST(64, "ConsoleStdoutReader.run", 0, 50044, 0, 0, caller, this.consoleCommand.getCommand(), e.toString());
                try {
                    reader.close();
                    isr.close();
                    is.close();
                }
                catch (IOException e3) {
                    String caller2 = null;
                    if (this.listener != null) {
                        caller2 = this.listener.toString();
                    }
                    t.FFST(64, "ConsoleStdoutReader.run", 1, 50044, 0, 0, caller2, this.consoleCommand.getCommand(), e3.toString());
                }
            }
        }
        finally {
            try {
                reader.close();
                isr.close();
                is.close();
            }
            catch (IOException e) {
                String caller = null;
                if (this.listener != null) {
                    caller = this.listener.toString();
                }
                t.FFST(64, "ConsoleStdoutReader.run", 1, 50044, 0, 0, caller, this.consoleCommand.getCommand(), e.toString());
            }
        }
    }
}

